/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QuerySplitComponent
implements Comparable<QuerySplitComponent> {
    final Order order;
    final String propertyName;
    final int sortIndex;
    final Query.SortDirection direction;
    List<List<Query.FilterPredicate>> filters = new ArrayList<List<Query.FilterPredicate>>();

    public QuerySplitComponent(String propertyName, List<Query.SortPredicate> sorts) {
        this.propertyName = propertyName;
        for (int i = 0; i < sorts.size(); ++i) {
            if (!sorts.get(i).getPropertyName().equals(propertyName)) continue;
            this.order = Order.SEQUENTIAL;
            this.sortIndex = i;
            this.direction = sorts.get(i).getDirection();
            return;
        }
        this.order = Order.ARBITARY;
        this.sortIndex = -1;
        this.direction = null;
    }

    public Order getOrder() {
        return this.order;
    }

    public void addFilters(Query.FilterPredicate ... filters) {
        this.filters.add(Arrays.asList(filters));
    }

    public List<List<Query.FilterPredicate>> getFilters() {
        return this.filters;
    }

    @Override
    public int compareTo(QuerySplitComponent o) {
        int result = this.order.compareTo(o.order);
        if (result == 0 && this.order == Order.SEQUENTIAL) {
            if (this.sortIndex < o.sortIndex) {
                return -1;
            }
            if (this.sortIndex > o.sortIndex) {
                return 1;
            }
        }
        return result;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public Query.SortDirection getDirection() {
        return this.direction;
    }

    public String toString() {
        String result = "QuerySplitComponent [filters=" + this.filters;
        if (this.direction != null) {
            result = result + ", direction=" + (Object)((Object)this.direction) + ", " + "sortIndex=" + this.sortIndex;
        }
        return result + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order {
        SEQUENTIAL,
        ARBITARY;

    }
}

