/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.MultiQueryComponent;
import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiQueryIterator
implements Iterator<List<Query>> {
    private final MultiQueryBuilder multiQueryBuilder;
    private final List<Integer> componentSubIndex;
    private final Stack<List<Query.FilterPredicate>> filtersStack = new Stack();
    private int componentIndex = 0;
    private int parallelCount = 0;
    boolean moreResults = true;

    public MultiQueryIterator(MultiQueryBuilder multiQueryBuilder) {
        this.componentSubIndex = new ArrayList<Integer>(multiQueryBuilder.components.size());
        for (MultiQueryComponent component : multiQueryBuilder.components) {
            this.componentSubIndex.add(0);
        }
        this.filtersStack.push(multiQueryBuilder.baseQuery.getFilterPredicates());
        this.multiQueryBuilder = multiQueryBuilder;
    }

    private void pushFilters(List<Query.FilterPredicate> componentFilters) {
        List<Query.FilterPredicate> baseFilters = this.filtersStack.peek();
        ArrayList<Query.FilterPredicate> filters = new ArrayList<Query.FilterPredicate>(baseFilters.size() + componentFilters.size());
        filters.addAll(baseFilters);
        filters.addAll(componentFilters);
        this.filtersStack.push(filters);
    }

    private boolean advanceSerialComponents() {
        for (int i = this.multiQueryBuilder.components.size() - 1; i >= 0; --i) {
            boolean isLastFilter;
            MultiQueryComponent component = this.multiQueryBuilder.components.get(i);
            if (component.getOrder() == MultiQueryComponent.Order.PARALLEL) continue;
            boolean bl = isLastFilter = this.componentSubIndex.get(i) + 1 == component.getFilters().size();
            if (isLastFilter) {
                this.componentSubIndex.set(i, 0);
                continue;
            }
            this.componentSubIndex.set(i, this.componentSubIndex.get(i) + 1);
            return true;
        }
        return false;
    }

    private void buildNextResult(List<Query> result, int minIndex) {
        while (this.componentIndex >= minIndex) {
            if (this.componentIndex >= this.multiQueryBuilder.components.size()) {
                result.add(MultiQueryBuilder.cloneQueryWithFilters(this.multiQueryBuilder.baseQuery, this.filtersStack.peek()));
                --this.componentIndex;
                continue;
            }
            MultiQueryComponent component = this.multiQueryBuilder.components.get(this.componentIndex);
            if (component.getOrder() == MultiQueryComponent.Order.PARALLEL) {
                ++this.componentIndex;
                ++this.parallelCount;
                for (List<Query.FilterPredicate> componentFilters : component.getFilters()) {
                    this.pushFilters(componentFilters);
                    this.buildNextResult(result, this.componentIndex);
                    this.filtersStack.pop();
                }
                --this.parallelCount;
                this.componentIndex -= 2;
                continue;
            }
            if (this.filtersStack.size() <= this.componentIndex + 1) {
                this.pushFilters(component.getFilters().get(this.componentSubIndex.get(this.componentIndex)));
                ++this.componentIndex;
                continue;
            }
            this.filtersStack.pop();
            boolean isLastFilter = this.componentSubIndex.get(this.componentIndex) + 1 == component.getFilters().size();
            --this.componentIndex;
            if (this.parallelCount != 0 || isLastFilter) continue;
            break;
        }
        ++this.componentIndex;
    }

    @Override
    public boolean hasNext() {
        return this.moreResults;
    }

    @Override
    public List<Query> next() {
        if (!this.moreResults) {
            throw new NoSuchElementException();
        }
        ArrayList<Query> result = new ArrayList<Query>();
        this.buildNextResult(result, 0);
        this.moreResults = this.advanceSerialComponents();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

