/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.apphosting.api.ApiBasePb;
import com.google.net.rpc.DefaultStubCreationFilter;
import com.google.net.rpc.RPC;
import com.google.net.rpc.RpcCallback;
import com.google.net.rpc.RpcCancelCallback;
import com.google.net.rpc.RpcException;
import com.google.net.rpc.RpcInterface;
import com.google.net.rpc.RpcServerParameters;
import com.google.net.rpc.RpcService;
import com.google.net.rpc.RpcStub;
import com.google.net.rpc.RpcStubFactory;
import com.google.net.rpc.RpcStubParameters;
import com.google.net.rpc.StubCreationFilter;
import com.google.net.rpc.impl.ApplicationHandler;
import com.google.net.rpc.impl.BlockingApplicationHandler;
import com.google.net.rpc.impl.RpcHandlerRegistry;
import com.google.net.rpc.impl.RpcServerConfig;
import com.google.net.rpc3.impl.compatibility.Rpc1CompatibilityStub;
import com.google.net.rpc3.impl.compatibility.Rpc1HandlerRegistry;
import com.google.net.rpc3.server.RpcServer;
import com.google.net.rpc3.server.RpcServiceParameters;
import com.google.net.ssl.SslSecurityLevel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class BlobstoreServicePb {
    private BlobstoreServicePb() {
    }

    public static final class BlobstoreService {
        private static volatile StubCreationFilter stubCreationFilter_ = new DefaultStubCreationFilter();
        private static final RpcStubFactory stubFactory_ = new RpcStubFactory(){

            public RpcStub newRpcStub(RpcStubParameters params) {
                return new SimpleStub(stubCreationFilter_.filterStubParameters("BlobstoreService", params));
            }
        };

        private BlobstoreService() {
        }

        public static void setStubCreationFilter(StubCreationFilter filter) {
            stubCreationFilter_ = filter == null ? new DefaultStubCreationFilter() : filter;
        }

        public static RpcStubFactory stubFactory() {
            return stubFactory_;
        }

        public static BlockingStub newBlockingStub(RpcStubParameters params) {
            return new BlockingStub(stubCreationFilter_.filterStubParameters("BlobstoreService", params));
        }

        public static Stub newStub(RpcStubParameters params) {
            return new Stub(stubCreationFilter_.filterStubParameters("BlobstoreService", params));
        }

        public static ServerConfig exportService(Interface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            BlobstoreService.exportServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportServiceUsingConfig(final Interface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "CreateUploadURL", (ProtocolMessage)new CreateUploadURLRequest(), (ProtocolMessage)new CreateUploadURLResponse(), null, config.CreateUploadURL_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.createUploadURL(rpc, (CreateUploadURLRequest)rpc.internalRequest(), (CreateUploadURLResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "DeleteBlob", (ProtocolMessage)new DeleteBlobRequest(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.DeleteBlob_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.deleteBlob(rpc, (DeleteBlobRequest)rpc.internalRequest(), (ApiBasePb.VoidProto)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "DecodeBlobKey", (ProtocolMessage)new DecodeBlobKeyRequest(), (ProtocolMessage)new DecodeBlobKeyResponse(), null, config.DecodeBlobKey_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.decodeBlobKey(rpc, (DecodeBlobKeyRequest)rpc.internalRequest(), (DecodeBlobKeyResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
        }

        public static RpcService newService(final Interface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return BlobstoreService.exportService(impl, registry);
                }
            };
        }

        public static ServerConfig exportService(Interface service, RpcServer.Builder builder) {
            ServerConfig config = new ServerConfig();
            BlobstoreService.exportServiceUsingConfig(service, builder, config);
            return config;
        }

        public static void exportServiceUsingConfig(Interface service, RpcServer.Builder builder, ServerConfig config) {
            Rpc1HandlerRegistry registry = new Rpc1HandlerRegistry(config.serviceName());
            BlobstoreService.exportServiceUsingConfig(service, (RpcHandlerRegistry)registry, config);
            builder.addService((RpcServiceParameters)registry);
        }

        public static ServerConfig exportBlockingService(BlockingInterface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            BlobstoreService.exportBlockingServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportBlockingServiceUsingConfig(final BlockingInterface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "CreateUploadURL", (ProtocolMessage)new CreateUploadURLRequest(), (ProtocolMessage)new CreateUploadURLResponse(), null, config.CreateUploadURL_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public CreateUploadURLResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.createUploadURL(rpc, (CreateUploadURLRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "DeleteBlob", (ProtocolMessage)new DeleteBlobRequest(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.DeleteBlob_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ApiBasePb.VoidProto handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.deleteBlob(rpc, (DeleteBlobRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "DecodeBlobKey", (ProtocolMessage)new DecodeBlobKeyRequest(), (ProtocolMessage)new DecodeBlobKeyResponse(), null, config.DecodeBlobKey_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public DecodeBlobKeyResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.decodeBlobKey(rpc, (DecodeBlobKeyRequest)rpc.internalRequest());
                }
            });
        }

        public static RpcService newBlockingService(final BlockingInterface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return BlobstoreService.exportBlockingService(impl, registry);
                }
            };
        }

        public static ServerConfig exportBlockingService(BlockingInterface service, RpcServer.Builder builder) {
            ServerConfig config = new ServerConfig();
            BlobstoreService.exportBlockingServiceUsingConfig(service, builder, config);
            return config;
        }

        public static void exportBlockingServiceUsingConfig(BlockingInterface service, RpcServer.Builder builder, ServerConfig config) {
            Rpc1HandlerRegistry registry = new Rpc1HandlerRegistry(config.serviceName());
            BlobstoreService.exportBlockingServiceUsingConfig(service, (RpcHandlerRegistry)registry, config);
            builder.addService((RpcServiceParameters)registry);
        }

        public static void unexport(RpcHandlerRegistry registry) {
            registry.unregisterService("BlobstoreService");
        }

        public static class ServerConfig
        extends RpcServerConfig {
            final RpcServerParameters CreateUploadURL_parameters_ = new RpcServerParameters();
            final RpcServerParameters DeleteBlob_parameters_ = new RpcServerParameters();
            final RpcServerParameters DecodeBlobKey_parameters_ = new RpcServerParameters();

            public ServerConfig() {
                this("BlobstoreService");
            }

            public ServerConfig(String serviceName) {
                super(serviceName);
            }

            public void setRpcRunner(Executor t) {
                this.setRpcRunner_CreateUploadURL(t);
                this.setRpcRunner_DeleteBlob(t);
                this.setRpcRunner_DecodeBlobKey(t);
            }

            public void setRpcRunner_CreateUploadURL(Executor t) {
                this.CreateUploadURL_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_DeleteBlob(Executor t) {
                this.DeleteBlob_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_DecodeBlobKey(Executor t) {
                this.DecodeBlobKey_parameters_.setRpcRunner(t);
            }

            public void setServerLogging_CreateUploadURL(int t) {
                this.CreateUploadURL_parameters_.setServerLogging(t);
            }

            public void setServerLogging_DeleteBlob(int t) {
                this.DeleteBlob_parameters_.setServerLogging(t);
            }

            public void setServerLogging_DecodeBlobKey(int t) {
                this.DecodeBlobKey_parameters_.setServerLogging(t);
            }

            public void setSecurityLevel_CreateUploadURL(SslSecurityLevel t) {
                this.CreateUploadURL_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_DeleteBlob(SslSecurityLevel t) {
                this.DeleteBlob_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_DecodeBlobKey(SslSecurityLevel t) {
                this.DecodeBlobKey_parameters_.setSecurityLevel(t);
            }

            public void setRpcCancelCallback_CreateUploadURL(RpcCancelCallback t) {
                this.CreateUploadURL_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_DeleteBlob(RpcCancelCallback t) {
                this.DeleteBlob_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_DecodeBlobKey(RpcCancelCallback t) {
                this.DecodeBlobKey_parameters_.setRpcCancelCallback(t);
            }
        }

        public static class Stub
        extends BlockingStub
        implements Interface {
            Stub(RpcStubParameters params) {
                super(params);
            }

            public void createUploadURL(RPC rpc, CreateUploadURLRequest req, CreateUploadURLResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.CreateUploadURL_method_, "CreateUploadURL", req, reply, cb, this.CreateUploadURL_parameters_);
            }

            public void deleteBlob(RPC rpc, DeleteBlobRequest req, ApiBasePb.VoidProto reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.DeleteBlob_method_, "DeleteBlob", req, reply, cb, this.DeleteBlob_parameters_);
            }

            public void decodeBlobKey(RPC rpc, DecodeBlobKeyRequest req, DecodeBlobKeyResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.DecodeBlobKey_method_, "DecodeBlobKey", req, reply, cb, this.DecodeBlobKey_parameters_);
            }
        }

        public static interface Interface
        extends RpcInterface {
            public void createUploadURL(RPC var1, CreateUploadURLRequest var2, CreateUploadURLResponse var3, RpcCallback var4);

            public void deleteBlob(RPC var1, DeleteBlobRequest var2, ApiBasePb.VoidProto var3, RpcCallback var4);

            public void decodeBlobKey(RPC var1, DecodeBlobKeyRequest var2, DecodeBlobKeyResponse var3, RpcCallback var4);
        }

        public static class BlockingStub
        extends BaseStub
        implements BlockingInterface {
            BlockingStub(RpcStubParameters params) {
                super(params);
            }

            public CreateUploadURLResponse createUploadURL(RPC rpc, CreateUploadURLRequest req) throws RpcException {
                CreateUploadURLResponse reply = new CreateUploadURLResponse();
                this.startBlockingRpc(rpc, this.CreateUploadURL_method_, "CreateUploadURL", req, reply, this.CreateUploadURL_parameters_);
                return reply;
            }

            public ApiBasePb.VoidProto deleteBlob(RPC rpc, DeleteBlobRequest req) throws RpcException {
                ApiBasePb.VoidProto reply = new ApiBasePb.VoidProto();
                this.startBlockingRpc(rpc, this.DeleteBlob_method_, "DeleteBlob", req, reply, this.DeleteBlob_parameters_);
                return reply;
            }

            public DecodeBlobKeyResponse decodeBlobKey(RPC rpc, DecodeBlobKeyRequest req) throws RpcException {
                DecodeBlobKeyResponse reply = new DecodeBlobKeyResponse();
                this.startBlockingRpc(rpc, this.DecodeBlobKey_method_, "DecodeBlobKey", req, reply, this.DecodeBlobKey_parameters_);
                return reply;
            }
        }

        public static interface BlockingInterface
        extends RpcInterface {
            public CreateUploadURLResponse createUploadURL(RPC var1, CreateUploadURLRequest var2) throws RpcException;

            public ApiBasePb.VoidProto deleteBlob(RPC var1, DeleteBlobRequest var2) throws RpcException;

            public DecodeBlobKeyResponse decodeBlobKey(RPC var1, DecodeBlobKeyRequest var2) throws RpcException;
        }

        private static class BaseStub
        extends Rpc1CompatibilityStub {
            protected final String CreateUploadURL_method_;
            protected final RPC CreateUploadURL_parameters_ = this.newRpcPrototype(Method.CreateUploadURL);
            protected final String DeleteBlob_method_;
            protected final RPC DeleteBlob_parameters_ = this.newRpcPrototype(Method.DeleteBlob);
            protected final String DecodeBlobKey_method_;
            protected final RPC DecodeBlobKey_parameters_ = this.newRpcPrototype(Method.DecodeBlobKey);

            protected BaseStub(RpcStubParameters params) {
                super("BlobstoreService", params, Method.class);
                this.CreateUploadURL_method_ = this.makeFullMethodName("CreateUploadURL");
                this.DeleteBlob_method_ = this.makeFullMethodName("DeleteBlob");
                this.DecodeBlobKey_method_ = this.makeFullMethodName("DecodeBlobKey");
            }
        }

        private static class SimpleStub
        extends Rpc1CompatibilityStub {
            public SimpleStub(RpcStubParameters params) {
                super("BlobstoreService", params, Method.class);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Method {
            CreateUploadURL,
            DeleteBlob,
            DecodeBlobKey;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DecodeBlobKeyResponse
    extends ProtocolMessage<DecodeBlobKeyResponse> {
        private static final long serialVersionUID = 1L;
        private List<byte[]> decoded_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final DecodeBlobKeyResponse IMMUTABLE_DEFAULT_INSTANCE = new DecodeBlobKeyResponse(){
            private static final long serialVersionUID = 1L;

            public DecodeBlobKeyResponse clearDecoded() {
                return this;
            }

            public DecodeBlobKeyResponse setDecodedAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyResponse setDecoded(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyResponse addDecodedAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyResponse addDecoded(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyResponse setDecoded(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyResponse addDecoded(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyResponse mergeFrom(DecodeBlobKeyResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public DecodeBlobKeyResponse freeze() {
                return this;
            }

            public DecodeBlobKeyResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kdecoded = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int decodedSize() {
            return this.decoded_ != null ? this.decoded_.size() : 0;
        }

        public final byte[] getDecodedAsBytes(int i) {
            assert (i >= 0 && i < (this.decoded_ != null ? this.decoded_.size() : 0));
            return this.decoded_.get(i);
        }

        public DecodeBlobKeyResponse clearDecoded() {
            if (this.decoded_ != null) {
                this.decoded_.clear();
            }
            return this;
        }

        public final String getDecoded(int i) {
            return ProtocolSupport.toStringUtf8(this.decoded_.get(i));
        }

        public DecodeBlobKeyResponse setDecodedAsBytes(int i, byte[] v) {
            this.decoded_.set(i, v);
            return this;
        }

        public DecodeBlobKeyResponse setDecoded(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.decoded_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public DecodeBlobKeyResponse addDecodedAsBytes(byte[] v) {
            if (this.decoded_ == null) {
                this.decoded_ = new ArrayList<byte[]>(4);
            }
            this.decoded_.add(v);
            return this;
        }

        public DecodeBlobKeyResponse addDecoded(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.decoded_ == null) {
                this.decoded_ = new ArrayList<byte[]>(4);
            }
            this.decoded_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> decodedIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.decoded_);
        }

        public final List<String> decodeds() {
            return ProtocolSupport.byteArrayToUnicodeList(this.decoded_);
        }

        public final Iterator<byte[]> decodedAsBytesIterator() {
            return this.decoded_ == null ? ProtocolSupport.emptyIterator() : this.decoded_.iterator();
        }

        public final List<byte[]> decodedsAsBytes() {
            return ProtocolSupport.unmodifiableList(this.decoded_);
        }

        public final List<byte[]> mutableDecodedsAsBytes() {
            if (this.decoded_ == null) {
                this.decoded_ = new ArrayList<byte[]>(4);
            }
            return this.decoded_;
        }

        public final String getDecoded(int i, Charset cs) {
            return ProtocolSupport.toString(this.decoded_.get(i), cs);
        }

        public DecodeBlobKeyResponse setDecoded(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.decoded_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public DecodeBlobKeyResponse addDecoded(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.decoded_ == null) {
                this.decoded_ = new ArrayList<byte[]>(4);
            }
            this.decoded_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> decodedIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.decoded_, cs);
        }

        public final List<String> decodeds(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.decoded_, cs);
        }

        @Override
        public DecodeBlobKeyResponse mergeFrom(DecodeBlobKeyResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.decoded_ != null && that.decoded_.size() > 0) {
                if (this.decoded_ == null) {
                    this.decoded_ = new ArrayList<byte[]>(that.decoded_);
                } else {
                    this.decoded_.addAll(that.decoded_);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(DecodeBlobKeyResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(DecodeBlobKeyResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(DecodeBlobKeyResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            int n = this.decoded_ != null ? this.decoded_.size() : 0;
            if (n != (that.decoded_ != null ? that.decoded_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Arrays.equals(this.decoded_.get(i), that.decoded_.get(i))) continue;
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof DecodeBlobKeyResponse && this.equals((DecodeBlobKeyResponse)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = 1458060640;
            hash *= 31;
            int n2 = n = this.decoded_ != null ? this.decoded_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + Arrays.hashCode(this.decoded_.get(i));
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.decoded_ != null ? this.decoded_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.decoded_.get(i).length);
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.decoded_ != null ? this.decoded_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.decoded_.get(i).length;
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.decoded_ != null) {
                this.decoded_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public DecodeBlobKeyResponse newInstance() {
            return new DecodeBlobKeyResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.decoded_ != null ? this.decoded_.size() : 0;
            for (int i = 0; i < m; ++i) {
                byte[] v = this.decoded_.get(i);
                sink.putByte((byte)10);
                sink.putPrefixedData(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        this.addDecodedAsBytes(source.getPrefixedData());
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public DecodeBlobKeyResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public DecodeBlobKeyResponse freeze() {
            this.decoded_ = ProtocolSupport.freezeStrings(this.decoded_);
            return this;
        }

        @Override
        public DecodeBlobKeyResponse unfreeze() {
            this.decoded_ = ProtocolSupport.unfreezeStrings(this.decoded_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenStrings(this.decoded_);
        }

        static {
            DecodeBlobKeyResponse.text[0] = "ErrorCode";
            DecodeBlobKeyResponse.text[1] = "decoded";
            types = new int[2];
            Arrays.fill(types, 6);
            DecodeBlobKeyResponse.types[0] = 0;
            DecodeBlobKeyResponse.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(DecodeBlobKeyResponse.class, "Z0apphosting/api/blobstore/blobstore_service.proto\n apphosting.DecodeBlobKeyResponse\u0013\u001a\u0007decoded \u0001(\u00020\t8\u0003\u0014", new ProtocolType.FieldType("decoded", "decoded", 1, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DecodeBlobKeyRequest
    extends ProtocolMessage<DecodeBlobKeyRequest> {
        private static final long serialVersionUID = 1L;
        private List<byte[]> blob_key_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final DecodeBlobKeyRequest IMMUTABLE_DEFAULT_INSTANCE = new DecodeBlobKeyRequest(){
            private static final long serialVersionUID = 1L;

            public DecodeBlobKeyRequest clearBlobKey() {
                return this;
            }

            public DecodeBlobKeyRequest setBlobKeyAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyRequest setBlobKey(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyRequest addBlobKeyAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyRequest addBlobKey(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyRequest setBlobKey(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyRequest addBlobKey(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DecodeBlobKeyRequest mergeFrom(DecodeBlobKeyRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public DecodeBlobKeyRequest freeze() {
                return this;
            }

            public DecodeBlobKeyRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kblob_key = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int blobKeySize() {
            return this.blob_key_ != null ? this.blob_key_.size() : 0;
        }

        public final byte[] getBlobKeyAsBytes(int i) {
            assert (i >= 0 && i < (this.blob_key_ != null ? this.blob_key_.size() : 0));
            return this.blob_key_.get(i);
        }

        public DecodeBlobKeyRequest clearBlobKey() {
            if (this.blob_key_ != null) {
                this.blob_key_.clear();
            }
            return this;
        }

        public final String getBlobKey(int i) {
            return ProtocolSupport.toStringUtf8(this.blob_key_.get(i));
        }

        public DecodeBlobKeyRequest setBlobKeyAsBytes(int i, byte[] v) {
            this.blob_key_.set(i, v);
            return this;
        }

        public DecodeBlobKeyRequest setBlobKey(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.blob_key_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public DecodeBlobKeyRequest addBlobKeyAsBytes(byte[] v) {
            if (this.blob_key_ == null) {
                this.blob_key_ = new ArrayList<byte[]>(4);
            }
            this.blob_key_.add(v);
            return this;
        }

        public DecodeBlobKeyRequest addBlobKey(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.blob_key_ == null) {
                this.blob_key_ = new ArrayList<byte[]>(4);
            }
            this.blob_key_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> blobKeyIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.blob_key_);
        }

        public final List<String> blobKeys() {
            return ProtocolSupport.byteArrayToUnicodeList(this.blob_key_);
        }

        public final Iterator<byte[]> blobKeyAsBytesIterator() {
            return this.blob_key_ == null ? ProtocolSupport.emptyIterator() : this.blob_key_.iterator();
        }

        public final List<byte[]> blobKeysAsBytes() {
            return ProtocolSupport.unmodifiableList(this.blob_key_);
        }

        public final List<byte[]> mutableBlobKeysAsBytes() {
            if (this.blob_key_ == null) {
                this.blob_key_ = new ArrayList<byte[]>(4);
            }
            return this.blob_key_;
        }

        public final String getBlobKey(int i, Charset cs) {
            return ProtocolSupport.toString(this.blob_key_.get(i), cs);
        }

        public DecodeBlobKeyRequest setBlobKey(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.blob_key_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public DecodeBlobKeyRequest addBlobKey(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.blob_key_ == null) {
                this.blob_key_ = new ArrayList<byte[]>(4);
            }
            this.blob_key_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> blobKeyIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.blob_key_, cs);
        }

        public final List<String> blobKeys(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.blob_key_, cs);
        }

        @Override
        public DecodeBlobKeyRequest mergeFrom(DecodeBlobKeyRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.blob_key_ != null && that.blob_key_.size() > 0) {
                if (this.blob_key_ == null) {
                    this.blob_key_ = new ArrayList<byte[]>(that.blob_key_);
                } else {
                    this.blob_key_.addAll(that.blob_key_);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(DecodeBlobKeyRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(DecodeBlobKeyRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(DecodeBlobKeyRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            int n = this.blob_key_ != null ? this.blob_key_.size() : 0;
            if (n != (that.blob_key_ != null ? that.blob_key_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Arrays.equals(this.blob_key_.get(i), that.blob_key_.get(i))) continue;
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof DecodeBlobKeyRequest && this.equals((DecodeBlobKeyRequest)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = 1684786824;
            hash *= 31;
            int n2 = n = this.blob_key_ != null ? this.blob_key_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + Arrays.hashCode(this.blob_key_.get(i));
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.blob_key_ != null ? this.blob_key_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.blob_key_.get(i).length);
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.blob_key_ != null ? this.blob_key_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.blob_key_.get(i).length;
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.blob_key_ != null) {
                this.blob_key_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public DecodeBlobKeyRequest newInstance() {
            return new DecodeBlobKeyRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.blob_key_ != null ? this.blob_key_.size() : 0;
            for (int i = 0; i < m; ++i) {
                byte[] v = this.blob_key_.get(i);
                sink.putByte((byte)10);
                sink.putPrefixedData(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        this.addBlobKeyAsBytes(source.getPrefixedData());
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public DecodeBlobKeyRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public DecodeBlobKeyRequest freeze() {
            this.blob_key_ = ProtocolSupport.freezeStrings(this.blob_key_);
            return this;
        }

        @Override
        public DecodeBlobKeyRequest unfreeze() {
            this.blob_key_ = ProtocolSupport.unfreezeStrings(this.blob_key_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenStrings(this.blob_key_);
        }

        static {
            DecodeBlobKeyRequest.text[0] = "ErrorCode";
            DecodeBlobKeyRequest.text[1] = "blob_key";
            types = new int[2];
            Arrays.fill(types, 6);
            DecodeBlobKeyRequest.types[0] = 0;
            DecodeBlobKeyRequest.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(DecodeBlobKeyRequest.class, "Z0apphosting/api/blobstore/blobstore_service.proto\n\u001fapphosting.DecodeBlobKeyRequest\u0013\u001a\bblob_key \u0001(\u00020\t8\u0003\u0014", new ProtocolType.FieldType("blob_key", "blob_key", 1, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteBlobRequest
    extends ProtocolMessage<DeleteBlobRequest> {
        private static final long serialVersionUID = 1L;
        private List<byte[]> blob_key_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final DeleteBlobRequest IMMUTABLE_DEFAULT_INSTANCE = new DeleteBlobRequest(){
            private static final long serialVersionUID = 1L;

            public DeleteBlobRequest clearBlobKey() {
                return this;
            }

            public DeleteBlobRequest setBlobKeyAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DeleteBlobRequest setBlobKey(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DeleteBlobRequest addBlobKeyAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DeleteBlobRequest addBlobKey(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DeleteBlobRequest setBlobKey(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DeleteBlobRequest addBlobKey(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DeleteBlobRequest mergeFrom(DeleteBlobRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public DeleteBlobRequest freeze() {
                return this;
            }

            public DeleteBlobRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kblob_key = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int blobKeySize() {
            return this.blob_key_ != null ? this.blob_key_.size() : 0;
        }

        public final byte[] getBlobKeyAsBytes(int i) {
            assert (i >= 0 && i < (this.blob_key_ != null ? this.blob_key_.size() : 0));
            return this.blob_key_.get(i);
        }

        public DeleteBlobRequest clearBlobKey() {
            if (this.blob_key_ != null) {
                this.blob_key_.clear();
            }
            return this;
        }

        public final String getBlobKey(int i) {
            return ProtocolSupport.toStringUtf8(this.blob_key_.get(i));
        }

        public DeleteBlobRequest setBlobKeyAsBytes(int i, byte[] v) {
            this.blob_key_.set(i, v);
            return this;
        }

        public DeleteBlobRequest setBlobKey(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.blob_key_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public DeleteBlobRequest addBlobKeyAsBytes(byte[] v) {
            if (this.blob_key_ == null) {
                this.blob_key_ = new ArrayList<byte[]>(4);
            }
            this.blob_key_.add(v);
            return this;
        }

        public DeleteBlobRequest addBlobKey(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.blob_key_ == null) {
                this.blob_key_ = new ArrayList<byte[]>(4);
            }
            this.blob_key_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> blobKeyIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.blob_key_);
        }

        public final List<String> blobKeys() {
            return ProtocolSupport.byteArrayToUnicodeList(this.blob_key_);
        }

        public final Iterator<byte[]> blobKeyAsBytesIterator() {
            return this.blob_key_ == null ? ProtocolSupport.emptyIterator() : this.blob_key_.iterator();
        }

        public final List<byte[]> blobKeysAsBytes() {
            return ProtocolSupport.unmodifiableList(this.blob_key_);
        }

        public final List<byte[]> mutableBlobKeysAsBytes() {
            if (this.blob_key_ == null) {
                this.blob_key_ = new ArrayList<byte[]>(4);
            }
            return this.blob_key_;
        }

        public final String getBlobKey(int i, Charset cs) {
            return ProtocolSupport.toString(this.blob_key_.get(i), cs);
        }

        public DeleteBlobRequest setBlobKey(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.blob_key_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public DeleteBlobRequest addBlobKey(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.blob_key_ == null) {
                this.blob_key_ = new ArrayList<byte[]>(4);
            }
            this.blob_key_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> blobKeyIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.blob_key_, cs);
        }

        public final List<String> blobKeys(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.blob_key_, cs);
        }

        @Override
        public DeleteBlobRequest mergeFrom(DeleteBlobRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.blob_key_ != null && that.blob_key_.size() > 0) {
                if (this.blob_key_ == null) {
                    this.blob_key_ = new ArrayList<byte[]>(that.blob_key_);
                } else {
                    this.blob_key_.addAll(that.blob_key_);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(DeleteBlobRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(DeleteBlobRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(DeleteBlobRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            int n = this.blob_key_ != null ? this.blob_key_.size() : 0;
            if (n != (that.blob_key_ != null ? that.blob_key_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Arrays.equals(this.blob_key_.get(i), that.blob_key_.get(i))) continue;
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof DeleteBlobRequest && this.equals((DeleteBlobRequest)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -1446063869;
            hash *= 31;
            int n2 = n = this.blob_key_ != null ? this.blob_key_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + Arrays.hashCode(this.blob_key_.get(i));
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.blob_key_ != null ? this.blob_key_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.blob_key_.get(i).length);
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.blob_key_ != null ? this.blob_key_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.blob_key_.get(i).length;
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.blob_key_ != null) {
                this.blob_key_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public DeleteBlobRequest newInstance() {
            return new DeleteBlobRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.blob_key_ != null ? this.blob_key_.size() : 0;
            for (int i = 0; i < m; ++i) {
                byte[] v = this.blob_key_.get(i);
                sink.putByte((byte)10);
                sink.putPrefixedData(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        this.addBlobKeyAsBytes(source.getPrefixedData());
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public DeleteBlobRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public DeleteBlobRequest freeze() {
            this.blob_key_ = ProtocolSupport.freezeStrings(this.blob_key_);
            return this;
        }

        @Override
        public DeleteBlobRequest unfreeze() {
            this.blob_key_ = ProtocolSupport.unfreezeStrings(this.blob_key_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenStrings(this.blob_key_);
        }

        static {
            DeleteBlobRequest.text[0] = "ErrorCode";
            DeleteBlobRequest.text[1] = "blob_key";
            types = new int[2];
            Arrays.fill(types, 6);
            DeleteBlobRequest.types[0] = 0;
            DeleteBlobRequest.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(DeleteBlobRequest.class, "Z0apphosting/api/blobstore/blobstore_service.proto\n\u001capphosting.DeleteBlobRequest\u0013\u001a\bblob_key \u0001(\u00020\t8\u0003\u0014", new ProtocolType.FieldType("blob_key", "blob_key", 1, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateUploadURLResponse
    extends ProtocolMessage<CreateUploadURLResponse> {
        private static final long serialVersionUID = 1L;
        private byte[] url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final CreateUploadURLResponse IMMUTABLE_DEFAULT_INSTANCE = new CreateUploadURLResponse(){
            private static final long serialVersionUID = 1L;

            public CreateUploadURLResponse clearUrl() {
                return this;
            }

            public CreateUploadURLResponse setUrlAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public CreateUploadURLResponse setUrl(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public CreateUploadURLResponse setUrl(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public CreateUploadURLResponse mergeFrom(CreateUploadURLResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public CreateUploadURLResponse freeze() {
                return this;
            }

            public CreateUploadURLResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kurl = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getUrlAsBytes() {
            return this.url_;
        }

        public final boolean hasUrl() {
            return (this.optional_0_ & 1) != 0;
        }

        public CreateUploadURLResponse clearUrl() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public CreateUploadURLResponse setUrlAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.url_ = x;
            return this;
        }

        public final String getUrl() {
            return ProtocolSupport.toStringUtf8(this.url_);
        }

        public CreateUploadURLResponse setUrl(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.url_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getUrl(Charset cs) {
            return ProtocolSupport.toString(this.url_, cs);
        }

        public CreateUploadURLResponse setUrl(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.url_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public CreateUploadURLResponse mergeFrom(CreateUploadURLResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.url_ = that.url_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(CreateUploadURLResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(CreateUploadURLResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(CreateUploadURLResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.url_, that.url_)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof CreateUploadURLResponse && this.equals((CreateUploadURLResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = -1494753975;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.url_) : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) == 1;
        }

        @Override
        public int encodingSize() {
            int n = 1 + Protocol.stringSize(this.url_.length);
            int this_t0 = this.optional_0_;
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 6 + this.url_.length;
            int this_t0 = this.optional_0_;
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public CreateUploadURLResponse newInstance() {
            return new CreateUploadURLResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.url_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        this.url_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public CreateUploadURLResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public CreateUploadURLResponse freeze() {
            this.url_ = ProtocolSupport.freezeString(this.url_);
            return this;
        }

        static {
            CreateUploadURLResponse.text[0] = "ErrorCode";
            CreateUploadURLResponse.text[1] = "url";
            types = new int[2];
            Arrays.fill(types, 6);
            CreateUploadURLResponse.types[0] = 0;
            CreateUploadURLResponse.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(CreateUploadURLResponse.class, "Z0apphosting/api/blobstore/blobstore_service.proto\n\"apphosting.CreateUploadURLResponse\u0013\u001a\u0003url \u0001(\u00020\t8\u0002\u0014", new ProtocolType.FieldType("url", "url", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateUploadURLRequest
    extends ProtocolMessage<CreateUploadURLRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] success_path_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final CreateUploadURLRequest IMMUTABLE_DEFAULT_INSTANCE = new CreateUploadURLRequest(){
            private static final long serialVersionUID = 1L;

            public CreateUploadURLRequest clearSuccessPath() {
                return this;
            }

            public CreateUploadURLRequest setSuccessPathAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public CreateUploadURLRequest setSuccessPath(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public CreateUploadURLRequest setSuccessPath(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public CreateUploadURLRequest mergeFrom(CreateUploadURLRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public CreateUploadURLRequest freeze() {
                return this;
            }

            public CreateUploadURLRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int ksuccess_path = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getSuccessPathAsBytes() {
            return this.success_path_;
        }

        public final boolean hasSuccessPath() {
            return (this.optional_0_ & 1) != 0;
        }

        public CreateUploadURLRequest clearSuccessPath() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.success_path_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public CreateUploadURLRequest setSuccessPathAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.success_path_ = x;
            return this;
        }

        public final String getSuccessPath() {
            return ProtocolSupport.toStringUtf8(this.success_path_);
        }

        public CreateUploadURLRequest setSuccessPath(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.success_path_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getSuccessPath(Charset cs) {
            return ProtocolSupport.toString(this.success_path_, cs);
        }

        public CreateUploadURLRequest setSuccessPath(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.success_path_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public CreateUploadURLRequest mergeFrom(CreateUploadURLRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.success_path_ = that.success_path_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(CreateUploadURLRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(CreateUploadURLRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(CreateUploadURLRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.success_path_, that.success_path_)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof CreateUploadURLRequest && this.equals((CreateUploadURLRequest)that);
        }

        @Override
        public int hashCode() {
            int hash = -1914397838;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.success_path_) : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) == 1;
        }

        @Override
        public int encodingSize() {
            int n = 1 + Protocol.stringSize(this.success_path_.length);
            int this_t0 = this.optional_0_;
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 6 + this.success_path_.length;
            int this_t0 = this.optional_0_;
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.success_path_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public CreateUploadURLRequest newInstance() {
            return new CreateUploadURLRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.success_path_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        this.success_path_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public CreateUploadURLRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public CreateUploadURLRequest freeze() {
            this.success_path_ = ProtocolSupport.freezeString(this.success_path_);
            return this;
        }

        static {
            CreateUploadURLRequest.text[0] = "ErrorCode";
            CreateUploadURLRequest.text[1] = "success_path";
            types = new int[2];
            Arrays.fill(types, 6);
            CreateUploadURLRequest.types[0] = 0;
            CreateUploadURLRequest.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(CreateUploadURLRequest.class, "Z0apphosting/api/blobstore/blobstore_service.proto\n!apphosting.CreateUploadURLRequest\u0013\u001a\fsuccess_path \u0001(\u00020\t8\u0002\u0014", new ProtocolType.FieldType("success_path", "success_path", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BlobstoreServiceError
    extends ProtocolMessage<BlobstoreServiceError> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final BlobstoreServiceError IMMUTABLE_DEFAULT_INSTANCE = new BlobstoreServiceError(){
            private static final long serialVersionUID = 1L;

            public BlobstoreServiceError mergeFrom(BlobstoreServiceError that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public BlobstoreServiceError freeze() {
                return this;
            }

            public BlobstoreServiceError unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public BlobstoreServiceError mergeFrom(BlobstoreServiceError that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(BlobstoreServiceError that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(BlobstoreServiceError that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(BlobstoreServiceError that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof BlobstoreServiceError && this.equals((BlobstoreServiceError)that);
        }

        @Override
        public int hashCode() {
            int hash = -562054251;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public BlobstoreServiceError newInstance() {
            return new BlobstoreServiceError();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block3;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public BlobstoreServiceError getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        static {
            BlobstoreServiceError.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            BlobstoreServiceError.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(BlobstoreServiceError.class, "Z0apphosting/api/blobstore/blobstore_service.proto\n apphosting.BlobstoreServiceErrorsz\tErrorCode\u008b\u0001\u0092\u0001\u0002OK\u0098\u0001\u0000\u008c\u0001\u008b\u0001\u0092\u0001\u000eINTERNAL_ERROR\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\fURL_TOO_LONG\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0011PERMISSION_DENIED\u0098\u0001\u0003\u008c\u0001t", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ErrorCode implements ProtocolMessageEnum
        {
            OK(0),
            INTERNAL_ERROR(1),
            URL_TOO_LONG(2),
            PERMISSION_DENIED(3);

            public static final ErrorCode ErrorCode_MIN;
            public static final ErrorCode ErrorCode_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static ErrorCode valueOf(int value) {
                switch (value) {
                    case 0: {
                        return OK;
                    }
                    case 1: {
                        return INTERNAL_ERROR;
                    }
                    case 2: {
                        return URL_TOO_LONG;
                    }
                    case 3: {
                        return PERMISSION_DENIED;
                    }
                }
                return null;
            }

            private ErrorCode(int v) {
                this.value = v;
            }

            static {
                ErrorCode_MIN = OK;
                ErrorCode_MAX = PERMISSION_DENIED;
            }
        }
    }
}

