/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.processor;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;

public final class Options {
    private static final double javaVersion = Options.getJavaVersion();
    public static final String DEBUG = "debug";
    public static final String JAVA_VERSION = "java.version";
    public static final String MODEL_PACKAGE = "model.package";
    public static final String META_PACKAGE = "meta.package";
    public static final String SHARED_PACKAGE = "shared.package";
    public static final String SERVER_PACKAGE = "server.package";

    private static double getJavaVersion() {
        return Double.valueOf(System.getProperty("java.specification.version"));
    }

    public static boolean isDebugEnabled(AnnotationProcessorEnvironment env) {
        String debug = (String)env.getOptions().get(DEBUG);
        if (debug == null) {
            return false;
        }
        return Boolean.valueOf(debug);
    }

    public static double getJavaVersion(AnnotationProcessorEnvironment env) {
        String version = (String)env.getOptions().get(JAVA_VERSION);
        if (version != null) {
            try {
                return Double.valueOf(version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return javaVersion;
    }

    public static String getModelPackage(AnnotationProcessorEnvironment env) {
        String modelPackage = (String)env.getOptions().get(MODEL_PACKAGE);
        return modelPackage != null ? modelPackage : "model";
    }

    public static String getMetaPackage(AnnotationProcessorEnvironment env) {
        String metaPackage = (String)env.getOptions().get(META_PACKAGE);
        return metaPackage != null ? metaPackage : "meta";
    }

    public static String getSharedPackage(AnnotationProcessorEnvironment env) {
        String sharedPackage = (String)env.getOptions().get(SHARED_PACKAGE);
        return sharedPackage != null ? sharedPackage : "shared";
    }

    public static String getServerPackage(AnnotationProcessorEnvironment env) {
        String serverPackage = (String)env.getOptions().get(SERVER_PACKAGE);
        return serverPackage != null ? serverPackage : "server";
    }
}

