/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.desc;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.SimpleTypeVisitor;
import com.sun.mirror.util.TypeVisitor;
import java.util.Collection;
import java.util.List;
import org.slim3.gen.datastore.ArrayType;
import org.slim3.gen.datastore.CollectionType;
import org.slim3.gen.datastore.CoreReferenceType;
import org.slim3.gen.datastore.DataType;
import org.slim3.gen.datastore.DataTypeFactory;
import org.slim3.gen.datastore.InverseModelRefType;
import org.slim3.gen.datastore.ModelRefType;
import org.slim3.gen.datastore.OtherReferenceType;
import org.slim3.gen.desc.AttributeMetaDesc;
import org.slim3.gen.message.MessageCode;
import org.slim3.gen.processor.ValidationException;
import org.slim3.gen.util.AnnotationMirrorUtil;
import org.slim3.gen.util.DeclarationUtil;
import org.slim3.gen.util.StringUtil;
import org.slim3.gen.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeMetaDescFactory {
    protected final AnnotationProcessorEnvironment env;

    public AttributeMetaDescFactory(AnnotationProcessorEnvironment env) {
        if (env == null) {
            throw new NullPointerException("The env parameter is null.");
        }
        this.env = env;
    }

    public AttributeMetaDesc createAttributeMetaDesc(ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, List<MethodDeclaration> methodDeclarations) {
        String value;
        if (fieldDeclaration == null) {
            throw new NullPointerException("The fieldDeclaration parameter is null.");
        }
        if (methodDeclarations == null) {
            throw new NullPointerException("The methodDeclarations parameter is null.");
        }
        String name = fieldDeclaration.getSimpleName();
        AnnotationMirror attribute = DeclarationUtil.getAnnotationMirror(this.env, (Declaration)fieldDeclaration, "org.slim3.datastore.Attribute");
        if (attribute != null && (value = (String)AnnotationMirrorUtil.getElementValue(attribute, "name")) != null && value.length() > 0) {
            name = value;
        }
        DataTypeFactory dataTypeFactory = this.creaetDataTypeFactory();
        DataType dataType = dataTypeFactory.createDataType((Declaration)fieldDeclaration, fieldDeclaration.getType());
        AttributeMetaDesc attributeMetaDesc = new AttributeMetaDesc(name, fieldDeclaration.getSimpleName(), dataType);
        this.handleField(attributeMetaDesc, classDeclaration, fieldDeclaration, attribute);
        this.handleMethod(attributeMetaDesc, classDeclaration, fieldDeclaration, methodDeclarations);
        return attributeMetaDesc;
    }

    protected void handleField(AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, AnnotationMirror attribute) {
        if (AnnotationMirrorUtil.getElementValue(attribute, "primaryKey") == Boolean.TRUE) {
            this.handlePrimaryKey(attributeMetaDesc, classDeclaration, fieldDeclaration, attribute);
        }
        if (AnnotationMirrorUtil.getElementValue(attribute, "version") == Boolean.TRUE) {
            this.handleVersion(attributeMetaDesc, classDeclaration, fieldDeclaration, attribute);
        }
        if (AnnotationMirrorUtil.getElementValue(attribute, "lob") == Boolean.TRUE) {
            this.handleLob(attributeMetaDesc, classDeclaration, fieldDeclaration, attribute);
        }
        if (AnnotationMirrorUtil.getElementValue(attribute, "unindexed") == Boolean.TRUE) {
            this.handleUnindexed(attributeMetaDesc, classDeclaration, fieldDeclaration, attribute);
        }
        if (AnnotationMirrorUtil.getElementValue(attribute, "persistent") == Boolean.FALSE) {
            this.handleNotPersistent(attributeMetaDesc, fieldDeclaration);
        }
        if (attributeMetaDesc.isPersistent()) {
            DataType dataType = attributeMetaDesc.getDataType();
            if (dataType instanceof InverseModelRefType) {
                if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                    throw new ValidationException(MessageCode.SLIM3GEN1035, this.env, fieldDeclaration.getPosition(), new Object[0]);
                }
                throw new ValidationException(MessageCode.SLIM3GEN1036, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
            }
            if (!attributeMetaDesc.isLob()) {
                if (dataType instanceof OtherReferenceType) {
                    this.throwExceptionForNonCoreType(classDeclaration, fieldDeclaration, attribute);
                }
                if (dataType instanceof CollectionType && ((CollectionType)CollectionType.class.cast(dataType)).getElementType() instanceof OtherReferenceType) {
                    this.throwExceptionForNonCoreType(classDeclaration, fieldDeclaration, attribute);
                }
                if (dataType instanceof ArrayType) {
                    this.throwExceptionForNonCoreType(classDeclaration, fieldDeclaration, attribute);
                }
            }
        }
        if (attributeMetaDesc.getDataType() instanceof ModelRefType) {
            this.validateModelRefTypeArgument(attributeMetaDesc, classDeclaration, fieldDeclaration);
        }
    }

    protected void handleNotPersistent(AttributeMetaDesc attributeMetaDesc, FieldDeclaration fieldDeclaration) {
        attributeMetaDesc.setPersistent(false);
    }

    protected void handlePrimaryKey(AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, AnnotationMirror attribute) {
        if (AnnotationMirrorUtil.getElementValue(attribute, "version") == Boolean.TRUE) {
            this.throwExceptionForConflictedElements(classDeclaration, fieldDeclaration, attribute, "primaryKey", "version");
        }
        if (AnnotationMirrorUtil.getElementValue(attribute, "lob") == Boolean.TRUE) {
            this.throwExceptionForConflictedElements(classDeclaration, fieldDeclaration, attribute, "primaryKey", "lob");
        }
        if (AnnotationMirrorUtil.getElementValue(attribute, "unindexed") == Boolean.TRUE) {
            this.throwExceptionForConflictedElements(classDeclaration, fieldDeclaration, attribute, "primaryKey", "unindexed");
        }
        if (AnnotationMirrorUtil.getElementValue(attribute, "persistent") == Boolean.FALSE) {
            this.throwExceptionForConflictedElements(classDeclaration, fieldDeclaration, attribute, "primaryKey", "persistent = false");
        }
        if (!"com.google.appengine.api.datastore.Key".equals(attributeMetaDesc.getDataType().getClassName())) {
            if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                throw new ValidationException(MessageCode.SLIM3GEN1007, this.env, fieldDeclaration.getPosition(), new Object[0]);
            }
            throw new ValidationException(MessageCode.SLIM3GEN1029, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
        }
        attributeMetaDesc.setPrimaryKey(true);
    }

    protected void handleVersion(AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, AnnotationMirror attribute) {
        String className;
        if (AnnotationMirrorUtil.getElementValue(attribute, "lob") == Boolean.TRUE) {
            this.throwExceptionForConflictedElements(classDeclaration, fieldDeclaration, attribute, "version", "lob");
        }
        if (AnnotationMirrorUtil.getElementValue(attribute, "persistent") == Boolean.FALSE) {
            this.throwExceptionForConflictedElements(classDeclaration, fieldDeclaration, attribute, "version", "persistent = false");
        }
        if (!"java.lang.Long".equals(className = attributeMetaDesc.getDataType().getClassName()) && !"long".equals(className)) {
            if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                throw new ValidationException(MessageCode.SLIM3GEN1008, this.env, fieldDeclaration.getPosition(), new Object[0]);
            }
            throw new ValidationException(MessageCode.SLIM3GEN1030, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
        }
        attributeMetaDesc.setVersion(true);
    }

    protected void handleLob(AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, AnnotationMirror attribute) {
        DataType dataType;
        if (AnnotationMirrorUtil.getElementValue(attribute, "persistent") == Boolean.FALSE) {
            this.throwExceptionForConflictedElements(classDeclaration, fieldDeclaration, attribute, "lob", "persistent = false");
        }
        if (AnnotationMirrorUtil.getElementValue(attribute, "unindexed") == Boolean.FALSE) {
            this.throwExceptionForConflictedElements(classDeclaration, fieldDeclaration, attribute, "lob", "unindexed = false");
        }
        if ((dataType = attributeMetaDesc.getDataType()) instanceof CoreReferenceType && !"java.lang.String".equals(dataType.getClassName())) {
            this.throwExceptionForLobUnsupportedType(classDeclaration, fieldDeclaration, attribute);
        }
        if (dataType instanceof ModelRefType) {
            this.throwExceptionForLobUnsupportedType(classDeclaration, fieldDeclaration, attribute);
        }
        if (dataType instanceof CollectionType && ((CollectionType)CollectionType.class.cast(dataType)).getElementType() instanceof CoreReferenceType) {
            this.throwExceptionForLobUnsupportedType(classDeclaration, fieldDeclaration, attribute);
        }
        attributeMetaDesc.setLob(true);
    }

    protected void handleUnindexed(AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, AnnotationMirror attribute) {
        if (AnnotationMirrorUtil.getElementValue(attribute, "persistent") == Boolean.FALSE) {
            this.throwExceptionForConflictedElements(classDeclaration, fieldDeclaration, attribute, "unindexed", "persistent = false");
        }
        attributeMetaDesc.setUnindexed(true);
    }

    protected void validateModelRefTypeArgument(AttributeMetaDesc attributeMetaDesc, final ClassDeclaration classDeclaration, final FieldDeclaration fieldDeclaration) {
        fieldDeclaration.getType().accept((TypeVisitor)new SimpleTypeVisitor(){

            public void visitClassType(ClassType classType) {
                ClassType superclassType;
                if ("org.slim3.datastore.ModelRef".equals(classType.getDeclaration().getQualifiedName())) {
                    AnnotationMirror annotationMirror;
                    TypeDeclaration typeDeclaration;
                    Collection typeArgs = classType.getActualTypeArguments();
                    if (typeArgs.isEmpty()) {
                        if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                            throw new ValidationException(MessageCode.SLIM3GEN1033, AttributeMetaDescFactory.this.env, fieldDeclaration.getPosition(), new Object[0]);
                        }
                        throw new ValidationException(MessageCode.SLIM3GEN1034, AttributeMetaDescFactory.this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
                    }
                    DeclaredType declaredType = TypeUtil.toDeclaredType((TypeMirror)typeArgs.iterator().next());
                    if (declaredType == null) {
                        AttributeMetaDescFactory.this.throwExceptionForModelRefTypeArgument(classDeclaration, fieldDeclaration);
                    }
                    if ((typeDeclaration = declaredType.getDeclaration()) == null) {
                        AttributeMetaDescFactory.this.throwExceptionForModelRefTypeArgument(classDeclaration, fieldDeclaration);
                    }
                    if ((annotationMirror = DeclarationUtil.getAnnotationMirror(AttributeMetaDescFactory.this.env, (Declaration)typeDeclaration, "org.slim3.datastore.Model")) == null) {
                        AttributeMetaDescFactory.this.throwExceptionForModelRefTypeArgument(classDeclaration, fieldDeclaration);
                    }
                }
                if ((superclassType = classType.getSuperclass()) != null) {
                    superclassType.accept((TypeVisitor)this);
                }
            }
        });
    }

    protected void handleMethod(AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, List<MethodDeclaration> methodDeclarations) {
        MethodDeclaration readMethodDeclaration = null;
        MethodDeclaration wirteMethodDeclaration = null;
        for (MethodDeclaration m : methodDeclarations) {
            if (this.isReadMethod(m, attributeMetaDesc, fieldDeclaration)) {
                readMethodDeclaration = m;
                attributeMetaDesc.setReadMethodName(m.getSimpleName());
                if (attributeMetaDesc.getWriteMethodName() == null) continue;
                break;
            }
            if (!this.isWriteMethod(m, attributeMetaDesc, fieldDeclaration)) continue;
            wirteMethodDeclaration = m;
            attributeMetaDesc.setWriteMethodName(m.getSimpleName());
            if (attributeMetaDesc.getReadMethodName() == null) continue;
            break;
        }
        DataType dataType = attributeMetaDesc.getDataType();
        if (attributeMetaDesc.isPersistent()) {
            if (dataType instanceof ModelRefType) {
                this.validateReadMethodOnly(attributeMetaDesc, (ModelRefType)dataType, classDeclaration, fieldDeclaration, readMethodDeclaration, wirteMethodDeclaration);
            } else {
                this.validateReadAndWriteMethods(attributeMetaDesc, classDeclaration, fieldDeclaration, readMethodDeclaration, wirteMethodDeclaration);
            }
        }
        if (dataType instanceof InverseModelRefType) {
            this.validateReadMethodOnly(attributeMetaDesc, (InverseModelRefType)dataType, classDeclaration, fieldDeclaration, readMethodDeclaration, wirteMethodDeclaration);
        }
    }

    protected void validateReadAndWriteMethods(AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, MethodDeclaration readMethodDeclaration, MethodDeclaration writeMethodDeclaration) {
        if (readMethodDeclaration == null) {
            if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                throw new ValidationException(MessageCode.SLIM3GEN1011, this.env, fieldDeclaration.getPosition(), new Object[0]);
            }
            throw new ValidationException(MessageCode.SLIM3GEN1024, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
        }
        if (writeMethodDeclaration == null) {
            if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                throw new ValidationException(MessageCode.SLIM3GEN1012, this.env, fieldDeclaration.getPosition(), new Object[0]);
            }
            throw new ValidationException(MessageCode.SLIM3GEN1025, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
        }
    }

    protected void validateReadMethodOnly(AttributeMetaDesc attributeMetaDesc, ModelRefType modelRefType, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, MethodDeclaration readMethodDeclaration, MethodDeclaration writeMethodDeclaration) {
        if (readMethodDeclaration == null) {
            if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                throw new ValidationException(MessageCode.SLIM3GEN1011, this.env, fieldDeclaration.getPosition(), new Object[0]);
            }
            throw new ValidationException(MessageCode.SLIM3GEN1024, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
        }
        if (writeMethodDeclaration != null) {
            String fieldDefinition = String.format("%1$s %2$s = new %1$s(%3$s.class);", fieldDeclaration.getType(), fieldDeclaration.getSimpleName(), modelRefType.getReferenceModelClassName());
            if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                throw new ValidationException(MessageCode.SLIM3GEN1041, this.env, writeMethodDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDefinition);
            }
            throw new ValidationException(MessageCode.SLIM3GEN1042, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName(), fieldDefinition);
        }
    }

    protected void validateReadMethodOnly(AttributeMetaDesc attributeMetaDesc, InverseModelRefType inverseModelRefType, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, MethodDeclaration readMethodDeclaration, MethodDeclaration writeMethodDeclaration) {
        if (readMethodDeclaration == null) {
            if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                throw new ValidationException(MessageCode.SLIM3GEN1011, this.env, fieldDeclaration.getPosition(), new Object[0]);
            }
            throw new ValidationException(MessageCode.SLIM3GEN1024, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
        }
        if (writeMethodDeclaration != null) {
            String fieldDefinition = String.format("%1$s %2$s = new %1$s(%3$s.class, \"xxx\", this);", fieldDeclaration.getType(), fieldDeclaration.getSimpleName(), inverseModelRefType.getReferenceModelClassName());
            if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                throw new ValidationException(MessageCode.SLIM3GEN1039, this.env, writeMethodDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDefinition, classDeclaration.getSimpleName(), inverseModelRefType.getReferenceModelClassName());
            }
            throw new ValidationException(MessageCode.SLIM3GEN1040, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName(), fieldDefinition, classDeclaration.getSimpleName(), inverseModelRefType.getReferenceModelClassName());
        }
    }

    protected boolean isReadMethod(MethodDeclaration m, AttributeMetaDesc attributeMetaDesc, FieldDeclaration fieldDeclaration) {
        String propertyName = null;
        if (m.getSimpleName().startsWith("get")) {
            propertyName = StringUtil.decapitalize(m.getSimpleName().substring(3));
        } else if (m.getSimpleName().startsWith("is")) {
            if (!TypeUtil.isPrimitive(m.getReturnType(), PrimitiveType.Kind.BOOLEAN)) {
                return false;
            }
            propertyName = StringUtil.decapitalize(m.getSimpleName().substring(2));
        } else {
            return false;
        }
        if (!propertyName.equals(fieldDeclaration.getSimpleName()) || TypeUtil.isVoid(m.getReturnType()) || m.getParameters().size() != 0) {
            return false;
        }
        return m.getReturnType().equals(fieldDeclaration.getType());
    }

    protected boolean isWriteMethod(MethodDeclaration m, AttributeMetaDesc attributeMetaDesc, FieldDeclaration fieldDeclaration) {
        if (!m.getSimpleName().startsWith("set")) {
            return false;
        }
        String propertyName = StringUtil.decapitalize(m.getSimpleName().substring(3));
        if (!propertyName.equals(fieldDeclaration.getSimpleName()) || !TypeUtil.isVoid(m.getReturnType()) || m.getParameters().size() != 1) {
            return false;
        }
        TypeMirror parameterTypeMirror = ((ParameterDeclaration)m.getParameters().iterator().next()).getType();
        return parameterTypeMirror.equals(fieldDeclaration.getType());
    }

    protected DataTypeFactory creaetDataTypeFactory() {
        return new DataTypeFactory(this.env);
    }

    protected void throwExceptionForNonCoreType(ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, AnnotationMirror attribute) {
        if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
            throw new ValidationException(MessageCode.SLIM3GEN1005, this.env, fieldDeclaration.getPosition(), new Object[0]);
        }
        throw new ValidationException(MessageCode.SLIM3GEN1026, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
    }

    protected void throwExceptionForConflictedElements(ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, AnnotationMirror attribute, String element1, String element2) {
        if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
            throw new ValidationException(MessageCode.SLIM3GEN1021, this.env, attribute.getPosition(), element1, element2);
        }
        throw new ValidationException(MessageCode.SLIM3GEN1027, this.env, classDeclaration.getPosition(), element1, element2, fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
    }

    protected void throwExceptionForLobUnsupportedType(ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, AnnotationMirror attribute) {
        if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
            throw new ValidationException(MessageCode.SLIM3GEN1009, this.env, fieldDeclaration.getPosition(), new Object[0]);
        }
        throw new ValidationException(MessageCode.SLIM3GEN1028, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
    }

    protected void throwExceptionForModelRefTypeArgument(ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration) {
        if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
            throw new ValidationException(MessageCode.SLIM3GEN1031, this.env, fieldDeclaration.getPosition(), new Object[0]);
        }
        throw new ValidationException(MessageCode.SLIM3GEN1032, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
    }
}

