package org.pulpdust.lesserpad;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import android.app.Activity;
import android.app.SearchManager;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.text.Editable;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;

public class libLesserPad {
	final String TAG = "libLesserPad";
	final static int FILE_NEW = 0;
	final static int FILE_OPEN = 1;
	final static String LPAD_EDIT = "org.pulpdust.lesserpad.EDIT";
	final static String LPAD_NEW = "org.pulpdust.lesserpad.NEW";
	final static String DA_LAUNCH = "org.pulpdust.da.action.LAUNCH";
	final static String DA_EX_TEXT = "org.pulpdust.da.extra.TEXT";
	final static String DA_EX_THEME = "org.pulpdust.da.extra.THEME";
	final static String DA_EX_RETURN = "org.pulpdust.da.extra.RETURN";

    public void listDir(File path, ArrayAdapter<String> adirs, List<String> dirs, Spinner ebox, 
    		Activity av, String action){
    	adirs.clear();
    	File base = path.getParentFile();
    	String cur = path.getName();
    	String list[] = base.list();
    	Arrays.sort(list);
    	for(int index = 0 ; index < list.length; index++){
    		File who = new File(base, list[index]);
    		if (who.isDirectory() && !list[index].matches("^\\.{1}.+$")){
    			adirs.add(list[index]);
    		}
    	}
    	int pos = dirs.indexOf(cur);
    	if (ebox != null){
    		ebox.setSelection(pos);
    	}
    	if (Build.VERSION.SDK_INT >= 11 && av != null){
    		if ((action != null && !action.equals(Intent.ACTION_EDIT) && !action.equals(Intent.ACTION_VIEW)) 
    				|| (action == null) 
    				|| (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT <= 13)){
    			forHoneycomb.setSelection(av, pos);
    		}
    	}
    }

    public void goSearch(Context context, EditText etxt){
		Intent gosearch = new Intent();
		String forsearch = getSelection(false, etxt);
		gosearch.setAction(Intent.ACTION_SEARCH);
		gosearch.putExtra(SearchManager.QUERY, forsearch);
		gosearch.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
		context.startActivity(gosearch);
    }
    public String getSelection(boolean deletion, EditText etxt){
		Editable edit = etxt.getEditableText();
		int start = etxt.getSelectionStart();
		int end = etxt.getSelectionEnd();
		char select[] = new char[Math.max( start, end ) - Math.min( start, end )];
		edit.getChars(Math.min( start, end ), Math.max( start, end ), select, 0);
		if (deletion){
			edit.delete(Math.min( start, end ), Math.max( start, end ));
		}
    	return String.valueOf(select);
    }
    public Intent daLaunch(Activity av, EditText etxt, int look){
		int start = etxt.getSelectionStart();
		int end = etxt.getSelectionEnd();
    	SharedPreferences props = av.getPreferences(Context.MODE_PRIVATE);
    	SharedPreferences.Editor pedit = props.edit();
    	pedit.putInt("select_start", start);
    	pedit.putInt("select_end", end);
    	pedit.commit();
		Intent dal = new Intent(DA_LAUNCH);
		dal.putExtra(DA_EX_TEXT, getSelection(false, etxt));
		dal.putExtra(DA_EX_THEME, look);
    	return dal;
    }
    public boolean isIntentAvailable(Context context, String action) {
        final PackageManager packageManager = context.getPackageManager();
        final Intent intent = new Intent(action);
        List<ResolveInfo> list =
                packageManager.queryIntentActivities(intent,
                        PackageManager.MATCH_DEFAULT_ONLY);
        return list.size() > 0;
    }
}
