package org.pulpdust.lesserpad;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.ActionBar.OnNavigationListener;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.SpinnerAdapter;
import android.app.Activity;

@TargetApi(11)
public class forHoneycomb {
	public static void setEditText(EditText etxt, final Context context){
		etxt.setCustomSelectionActionModeCallback(new ActionMode.Callback() {

			@Override
			public boolean onActionItemClicked(ActionMode am, MenuItem mi) {
				// TODO Auto-generated method stub
				int id = mi.getItemId();
				switch (id){
				case R.id.menu_search:
					LesserPadActivity.goSearch(context);
					return true;
				}
				return false;
			}

			@SuppressLint("AlwaysShowAction")
			@Override
			public boolean onCreateActionMode(ActionMode am, Menu m) {
				// TODO Auto-generated method stub
				m.removeItem(android.R.id.selectAll);
//				m.removeItem(android.R.id.paste);
//				m.removeItem(android.R.id.cut);
//				m.removeItem(android.R.id.copy);
//				MenuItem mix = m.add(0, R.id.menu_cut, 0, R.string.menu_cut);
//				mix.setIcon(R.drawable.ic_menu_cut);
//				mix.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS);
//				MenuItem mic = m.add(0, R.id.menu_copy, 0, R.string.menu_copy);
//				mic.setIcon(R.drawable.ic_menu_copy);
//				mic.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS);
				MenuItem mis = m.add(0, R.id.menu_search, 0, R.string.menu_search);
				mis.setIcon(android.R.drawable.ic_menu_search);
				mis.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS);
				return true;
			}

			@Override
			public void onDestroyActionMode(ActionMode am) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public boolean onPrepareActionMode(ActionMode am, Menu m) {
				// TODO Auto-generated method stub
				return false;
			}
			
		});
	}
	public static void setActionBar(final Activity av, final int mode, ArrayAdapter<String> adirs){
		ActionBar ab = av.getActionBar();
		ab.setNavigationMode(ActionBar.NAVIGATION_MODE_LIST);
		SpinnerAdapter sa = adirs;
//		SpinnerAdapter sa;
//		if (mode == 0) sa = LesserPadActivity.adirs;
//		else sa = LesserPadListActivity.adirs;
		ab.setListNavigationCallbacks(sa, new OnNavigationListener(){

			@Override
			public boolean onNavigationItemSelected(int pos,
					long id) {
				// TODO Auto-generated method stub
				if (mode == 0){
					LesserPadActivity.doMove(av.getApplicationContext(), pos);
				} else if (mode == 1){
					LesserPadListActivity.doChange(pos);
				}
				return false;
			}
			
		});
	}
	public static void setSelection(Activity av, int pos){
		ActionBar ab = av.getActionBar();
		ab.setSelectedNavigationItem(pos);
	}
	public static void setText(Activity av, CharSequence text){
		ActionBar ab = av.getActionBar();
		ab.setTitle(text);
	}
	public static void doCopy(Context c, CharSequence text){
		ClipboardManager cm = (ClipboardManager) c.getSystemService(Context.CLIPBOARD_SERVICE);
		ClipData cd = ClipData.newPlainText("plain text", text);
		cm.setPrimaryClip(cd);
	}
	public static CharSequence getCopy(Context c){
		CharSequence text = "";
		ClipboardManager cm = (ClipboardManager) c.getSystemService(Context.CLIPBOARD_SERVICE);
		ClipData cd = cm.getPrimaryClip();
		if (cd != null){
			ClipData.Item ci = cd.getItemAt(0);
			text = ci.coerceToText(c);
		}
		return text;
	}

}
