/*
   This file is provided under the LGPL license ver 2.1.
   Written by Katsumi.
   http://hp.vector.co.jp/authors/VA016157/
   kmorimatsu@users.sourceforge.jp
*/

#include "compiler.h"
#include "api.h"

char* music_function(){
	call_lib_code(LIB_MUSICFUNC);
	return 0;
}

char* read_function(){
	call_lib_code(LIB_READ);
	return 0;
}

char* gosub_function(){
	char* err;
	char b;
	int opos,spos,stack;
	// Check if garbage collection has been done.
	if (g_temp_area_used) return ERR_GOSUB_ASH;
	opos=g_objpos;
	spos=g_srcpos;
	err=gosub_statement();
	if (err) return err;
	next_position();
	// If there is no 2nd argument, return.
	if (g_source[g_srcpos]!=',') return 0;

	// There is (at least) 2nd argument.
	// Rewind object and construct argument-creating routine.
	g_objpos=opos;
	stack=4;
	g_object[g_objpos++]=0x27BD0000;           // addiu       sp,sp,-xx
	do {
		g_srcpos++;
		stack+=4;
		err=get_value();
		if (err) return err;
		check_obj_space(1);
		g_object[g_objpos++]=0xAFA20000|stack; // sw          v0,xx(sp)
		next_position();
	} while(g_source[g_srcpos]==',');
	check_obj_space(2);
	g_object[g_objpos++]=0xAFB50004;           // sw          s5,4(sp)
	g_object[g_objpos++]=0x03A0A821;           // addu        s5,sp,zero
	g_object[opos]|=((0-stack)&0xFFFF);        // addiu       sp,sp,-xx (See above)
	// Rewind source and construct GOSUB routine again.
	opos=spos;
	spos=g_srcpos;
	g_srcpos=opos;
	err=gosub_statement();
	if (err) return err;
	// Remove stack
	check_obj_space(2);
	g_object[g_objpos++]=0x8FB50004;           // lw          s5,4(sp)
	g_object[g_objpos++]=0x27BD0000|stack;     // addiu       sp,sp,xx
	// All done, go back to wright source position
	g_srcpos=spos;
	return 0;
}
char* strncmp_function(){
	char* err;
	err=get_string();
	if (err) return err;
	check_obj_space(2);
	g_object[g_objpos++]=0x27BDFFF8; // addiu       sp,sp,-8
	g_object[g_objpos++]=0xAFA20008; // sw          v0,8(sp)
	if (g_source[g_srcpos]!=',') return ERR_SYNTAX;
	g_srcpos++;
	err=get_string();
	if (err) return err;
	check_obj_space(1);
	g_object[g_objpos++]=0xAFA20004; // sw          v0,4(sp)
	if (g_source[g_srcpos]!=',') return ERR_SYNTAX;
	g_srcpos++;
	err=get_value();
	if (err) return err;
	check_obj_space(3);
	g_object[g_objpos++]=0x8FA40008; // lw          a0,8(sp)
	g_object[g_objpos++]=0x8FA50004; // lw          a1,4(sp)
	g_object[g_objpos++]=0x27BD0008; // addiu       sp,sp,8
	call_lib_code(LIB_STRNCMP);
	return 0;
}
char* len_function(){
	char* err;
	err=get_string();
	if (err) return err;
	check_obj_space(5);
	g_object[g_objpos++]=0x2443FFFF; // addiu       v1,v0,-1
	                                 // loop:
	g_object[g_objpos++]=0x80640001; // lb          a0,1(v1)
	g_object[g_objpos++]=0x1480FFFE; // bne         a0,zero,loop
	g_object[g_objpos++]=0x24630001; // addiu       v1,v1,1
	g_object[g_objpos++]=0x00621023; // subu        v0,v1,v0
	return 0;
}

char* asc_function(){
	char* err;
	err=get_string();
	if (err) return err;
	check_obj_space(1);
	g_object[g_objpos++]=0x90420000; // lbu         v0,0(v0)
	return 0;
}

char* val_function(){
	char* err;
	err=get_string();
	if (err) return err;
	call_lib_code(LIB_VAL);
	return 0;	
}

char* peek_function(){
	char* err;
	err=get_value();
	if (err) return err;
	check_obj_space(1);
	g_object[g_objpos++]=0x90420000; // lbu         v0,0(v0)
	return 0;
}

char* sgn_function(){
	char* err;
	err=get_value();
	if (err) return err;
	check_obj_space(5);
	g_object[g_objpos++]=0x10400004; // beq         v0,zero,end
	g_object[g_objpos++]=0x24030001; // addiu       v1,zero,1
	g_object[g_objpos++]=0x1C400002; // bgtz        v0,end
	g_object[g_objpos++]=0x00601021; // addu        v0,v1,zero
	g_object[g_objpos++]=0x00031023; // subu        v0,zero,v1
	                                 // end:
	return 0;
}

char* abs_function(){
	char* err;
	err=get_value();
	if (err) return err;
	check_obj_space(3);
	g_object[g_objpos++]=0x00021FC3; //sra         v1,v0,0x1f
	g_object[g_objpos++]=0x00621026; //xor         v0,v1,v0
	g_object[g_objpos++]=0x00431023; //subu        v0,v0,v1
	return 0;
}

char* not_function(){
	char* err;
	err=get_value();
	if (err) return err;
	check_obj_space(1);
	g_object[g_objpos++]=0x2C420001; //sltiu       v0,v0,1
	return 0;
}

char* rnd_function(){
	call_lib_code(LIB_RND);
	return 0;
}


char* chr_function(void){
	char* err;
	err=get_value();
	if (err) return err;
	call_lib_code(LIB_CHR);
	return 0;
}
char* hex_function(void){
	char* err;
	err=get_value();
	if (err) return err;
	if (g_source[g_srcpos]==',') {
		// Second argument found.
		// Get is as $a0.
		g_srcpos++;
		check_obj_space(2);
		g_object[g_objpos++]=0x27BDFFFC; //addiu       sp,sp,-4
		g_object[g_objpos++]=0xAFA20004; //sw          v0,4(sp)
		err=get_value();
		if (err) return err;
		check_obj_space(3);
		g_object[g_objpos++]=0x00022021; //a0,zero,v0
		g_object[g_objpos++]=0x8FA20004; //lw          v0,4(sp)
		g_object[g_objpos++]=0x27BD0004; //addiu       sp,sp,4
	} else {
		// Second argument not found.
		// Set $a0 to 0.
		check_obj_space(1);
		g_object[g_objpos++]=0x24040000; //addiu       a0,zero,0
	}
	call_lib_code(LIB_HEX);
	return 0;
}

char* dec_function(void){
	char* err;
	err=get_value();
	if (err) return err;
	call_lib_code(LIB_DEC);
	return 0;
}

char* keys_function(void){
	char* err;
	next_position();
	if (g_source[g_srcpos]==')') {
		check_obj_space(1);
		g_object[g_objpos++]=0x3402003F; //ori         v0,zero,0x3f
	} else {
		err=get_value();
		if (err) return err;
	}	
	call_lib_code(LIB_KEYS);
	return 0;
}

char* tvram_function(void){
	char* err;
	int i;
	next_position();
	if (g_source[g_srcpos]==')') {
		i=(int)(&TVRAM[0]);
		i-=g_gp;
		check_obj_space(1);
		g_object[g_objpos++]=0x27820000|(i&0x0000FFFF);       // addiu       v0,gp,xxxx
	} else {
		err=get_value();
		if (err) return err;
		i=(int)(&TVRAM[0]);
		i-=g_gp;
		check_obj_space(3);
		g_object[g_objpos++]=0x27830000|(i&0x0000FFFF);       // addiu       v1,gp,xxxx
		g_object[g_objpos++]=0x00621821;                      // addu        v1,v1,v0
		g_object[g_objpos++]=0x90620000;                      // lbu         v0,0(v1)
	}	
	return 0;
}

char* drawcount_function(void){
	call_lib_code(LIB_DRAWCOUNT);
	return 0;
}

char* input_function(void){
	call_lib_code(LIB_INPUT);
	return 0;
}

char* inkey_function(void){
	char* err;
	next_position();
	if (g_source[g_srcpos]==')') {
		check_obj_space(1);
		g_object[g_objpos++]=0x34020000; //ori         v0,zero,0x00
	} else {
		err=get_value();
		if (err) return err;
	}	
	call_lib_code(LIB_INKEY);
	return 0;
}

char* args_function(void){
	char* err;
	int i;
	err=get_value();
	if (err) return err;
	i=g_object[g_objpos-1];
	if ((i>>16)==0x3402) {
		// Previous object is "ori v0,zero,xxxx".
		i&=0xffff;
		i=(i+1)<<2;
		g_object[g_objpos-1]=0x8EA20000|i; //   lw          v0,xx(s5)
	} else {
		check_obj_space(3);
		g_object[g_objpos++]=0x00021080;   //   sll         v0,v0,0x2
		g_object[g_objpos++]=0x02A21021;   //   addu        v0,s5,v0
		g_object[g_objpos++]=0x8C420004;   //   lw          v0,4(v0)
	}
	return 0;	
}

char* str_function(void){
	char* err;
	if (!strncmp(g_source+g_srcpos,"CHR$(",5)) {
		g_srcpos+=5;
		err=chr_function();
	} else if (!strncmp(g_source+g_srcpos,"HEX$(" ,5)) {
		g_srcpos+=5;
		err=hex_function();
	} else if (!strncmp(g_source+g_srcpos,"DEC$(" ,5)) {
		g_srcpos+=5;
		err=dec_function();
	} else if (!strncmp(g_source+g_srcpos,"INPUT$(" ,7)) {
		g_srcpos+=7;
		err=input_function();
	} else {
		return ERR_SYNTAX;
	}
	if (err) return err;
	if (g_source[g_srcpos]!=')') return ERR_SYNTAX;
	g_srcpos++;
	return 0;
}

char* function(void){
	char* err;
	if (!strncmp(g_source+g_srcpos,"NOT(",4)) {
		g_srcpos+=4;
		err=not_function();
	} else if (!strncmp(g_source+g_srcpos,"DRAWCOUNT(" ,10)) {
		g_srcpos+=10;
		err=drawcount_function();
	} else if (!strncmp(g_source+g_srcpos,"MUSIC(" ,6)) {
		g_srcpos+=6;
		err=music_function();
	} else if (!strncmp(g_source+g_srcpos,"TVRAM(" ,6)) {
		g_srcpos+=6;
		err=tvram_function();
	} else if (!strncmp(g_source+g_srcpos,"KEYS(" ,5)) {
		g_srcpos+=5;
		err=keys_function();
	} else if (!strncmp(g_source+g_srcpos,"READ(" ,5)) {
		g_srcpos+=5;
		err=read_function();
	} else if (!strncmp(g_source+g_srcpos,"GOSUB(" ,6)) {
		g_srcpos+=6;
		err=gosub_function();
	} else if (!strncmp(g_source+g_srcpos,"STRNCMP(" ,8)) {
		g_srcpos+=8;
		err=strncmp_function();
	} else if (!strncmp(g_source+g_srcpos,"PEEK(" ,5)) {
		g_srcpos+=5;
		err=peek_function();
	} else if (!strncmp(g_source+g_srcpos,"LEN(" ,4)) {
		g_srcpos+=4;
		err=len_function();
	} else if (!strncmp(g_source+g_srcpos,"ASC(" ,4)) {
		g_srcpos+=4;
		err=asc_function();
	} else if (!strncmp(g_source+g_srcpos,"SGN(" ,4)) {
		g_srcpos+=4;
		err=sgn_function();
	} else if (!strncmp(g_source+g_srcpos,"ABS(" ,4)) {
		g_srcpos+=4;
		err=abs_function();
	} else if (!strncmp(g_source+g_srcpos,"RND(" ,4)) {
		g_srcpos+=4;
		err=rnd_function();
	} else if (!strncmp(g_source+g_srcpos,"VAL(" ,4)) {
		g_srcpos+=4;
		err=val_function();
	} else if (!strncmp(g_source+g_srcpos,"INKEY(" ,6)) {
		g_srcpos+=6;
		err=inkey_function();
	} else if (!strncmp(g_source+g_srcpos,"ARGS(" ,5)) {
		g_srcpos+=5;
		err=args_function();
	} else {
		return ERR_SYNTAX;
	}
	if (err) return err;
	if (g_source[g_srcpos]!=')') return ERR_SYNTAX;
	g_srcpos++;
	return err;
}
