/*
   This file is provided under the LGPL license ver 2.1.
   Written by K.Tanaka
   http://www.ze.em-net.ne.jp/~kenken/index.html
*/

// main.c
// KM-BASIC Js for PIC32MX150F128B / PIC32MX250F128B by K.Tanaka

// pVXe
// ps2keyboard.X.a : PS/2L[{[h̓VXeCu
// lib_colortext32.a : J[rfIMo̓VXeCui30~27eLXgŁj
// libsdfsio.a F SDJ[hANZXpCu

#define SYSVER1 "Nauplia"
#define SYSVER2 "0.85"
#define BASVER "1.1"
#define INIFILE "NAUPLIA.INI" // ݒt@C
#define HEXFILE "NAUPLIA.HEX" // sHEXt@Cƈvꍇ̓GfB^N

#include <xc.h>
#include "api.h"
#include "compiler.h"
#include "editor.h"
#include "keyinput.h"

//OtNX^ with PLL (16{)
#pragma config PMDL1WAY = OFF, IOL1WAY = OFF
#pragma config FPLLIDIV = DIV_1, FPLLMUL = MUL_16, FPLLODIV = DIV_1
#pragma config FNOSC = PRIPLL, FSOSCEN = OFF, POSCMOD = XT, OSCIOFNC = OFF
#pragma config FPBDIV = DIV_1, FWDTEN = OFF, JTAGEN = OFF, ICESEL = ICS_PGx1

#define mBMXSetRAMKernProgOffset(offset)	(BMXDKPBA = (offset))
#define mBMXSetRAMUserDataOffset(offset)	(BMXDUDBA = (offset))
#define mBMXSetRAMUserProgOffset(offset)	(BMXDUPBA = (offset))

#define FILENAME_FLASH_ADDRESS 0x9D005800

// INIt@CwL[[hi8ȓj
const char InitKeywords[][9]={
	"106KEY","101KEY","NUMLOCK","CAPSLOCK","SCRLLOCK"
};

void freadline(char *s,FSFILE *fp){
// t@C1sǂݍ݁AzsɕԂ
// ő8܂ŁB9ȏ̏ꍇ
// #܂0x20ȉ̃R[hꍇAȍ~͖
// s:9oCgȏ̔z
// fp:t@C|C^
	int n;
	char c,*p;
	n=0;
	p=s;
	*p=0;
	while(n<=8){
		if(FSfread(p,1,1,fp)==0 || *p=='\n'){
			*p=0;
			return;
		}
		if(*p=='#'){
			*p=0;
			break;
		}
		if(*p<=' '){
			if(n>0){
				*p=0;
				break;
			}
			continue;
		}
		p++;
		n++;
	}
	if(n>8) *s=0; //9ȏ̏̕ꍇ͖
	//ȍ~͖̕
	while(FSfread(&c,1,1,fp) && c!='\n') ;
}
int searchinittext(char *s){
// InitKeywordsz̒當sTAʒuꍇԖڂԂ
// Ȃꍇ-1Ԃ
	int i;
	char *p1;
	const char *p2;
	for(i=0;i<sizeof(InitKeywords)/sizeof(InitKeywords[0]);i++){
		p1=s;
		p2=InitKeywords[i];
		while(*p1==*p2){
			if(*p1==0) return i;
			p1++;
			p2++;
		}
	}
	return -1;
}
void readinifile(void){
	FSFILE *fp;
	char inittext[9];

	fp=FSfopen(INIFILE,"READ");
	if(fp==NULL) return;
	printstr("Initialize File Found\n");
	lockkey=0; //INIt@C݂ꍇALock֘AL[INIt@Cɏ]
	while(1){
		if(FSfeof(fp)) break;
		freadline(inittext,fp);
		switch(searchinittext(inittext)){
			case 0:
				keytype=0;//{L[{[h
				break;
			case 1:
				keytype=1;//pL[{[h
				break;
			case 2:
				lockkey|=2;//Num Lock
				break;
			case 3:
				lockkey|=4;//CAPS Lock
				break;
			case 4:
				lockkey|=1;//Scroll Lock
				break;
		}
	}
	FSfclose(fp);
}
int main(void){
	char *appname,*s;

	/* |[g̏ݒ */
	TRISA = 0x0000; // PORTASďo
	ANSELA = 0x0000; // SăfW^
	TRISB = KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// {^ڑ|[g͐ݒ
	ANSELB = 0x0000; // SăfW^
	CNPUBSET=KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// vAbvݒ
	ODCB = 0x0300;	//RB8,RB9̓I[vhC

	// Ӌ@\s蓖
	SDI2R=2; //RPA4:SDI2
	RPB5R=4; //RPB5:SDO2

	// Make RAM executable. See also "char RAM[RAMSIZE]" in globalvars.c
	mBMXSetRAMKernProgOffset(0x8000-RAMSIZE);
	mBMXSetRAMUserDataOffset(0x8000);
	mBMXSetRAMUserProgOffset(0x8000);

	ps2mode(); //RA1IiPS/2L}Nj
	init_composite(); // rfINAA荞ݏAJ[rfIo͊Jn
	setcursor(0,0,COLOR_NORMALTEXT);

	printstr("PIC32MX Video Game System\n");
	printstr(" Ver "SYSVER1" "SYSVER2" by KENKEN\n");
	printstr("KM-BASIC for MIPS\n");
	printstr(" Ver "BASVER" by Katsumi\n\n");
	//SDJ[ht@CVXe
	while(1){
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Init File System...");
		// Initialize the File System
		if(FSInit()) break; //t@CVXeAOKȂ甲
		//G[̏ꍇ蒼
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("\nFile System Error\n");
		printstr("Insert Correct Card\n");
		printstr("And Reset\n");
		while(1) asm("wait");
	}
	printstr("OK\n");
	lockkey=2; // NumLockL[I
	keytype=0; // {L[{[h
	readinifile(); //INIt@Cǂݍ
	printstr("Init PS/2...");
	if(ps2init()){ //PS/2
		//L[{[hȂꍇ
		printstr("Keyboard Not Found\n");
	}
	else printstr("OK\n");

	wait60thsec(60); //1b҂

	// sHEXt@CHEXFILEƈvꍇ̓GfB^N
	appname=(char*)FILENAME_FLASH_ADDRESS;
	s=HEXFILE;
	while(*s++==*appname++) if(*s==0) texteditor(); //eLXgGfB^[Ăяo

	// sHEXt@Ću.HEXvu.BASvɒuBASt@Cs
	appname=(char*)FILENAME_FLASH_ADDRESS;
	s=tempfile;
	while(*appname!='.') *s++=*appname++;
	appname=".BAS";
	while(*appname!=0) *s++=*appname++;
	*s=0;
	// buttonmode(); //{^L
	g_disable_break=1; // BreakL[
	runbasic(tempfile,0);
	while(1) asm("wait");
}
