/*
   This file is provided under the LGPL license ver 2.1.
   Written by K.Tanaka & Katsumi
   http://www.ze.em-net.ne.jp/~kenken/index.html
   http://hp.vector.co.jp/authors/VA016157/
*/

#include <xc.h>
#include "compiler.h"

/*
	Library functions follow
*/

void lib_out(int pos, int val){
	// pos must be between 0 and 15
	if (pos<0 || 15<pos) return;
	// Set output vale
	if (val) {
		LATBSET=1<<pos;
	} else {
		LATBCLR=1<<pos;
	}
	// Enable output
	TRISBCLR=1<<pos;
	// Disable pulldown
	CNPUBCLR=1<<pos;
}

void lib_out8h(int val){
	// Set output vale
	LATB=(LATB&0x00FF)|((val&0xff)<<8);
	// Enable output
	TRISBCLR=0xFF00;
	// Disable pulldown
	CNPUBCLR=0xFF00;
}

void lib_out8l(int val){
	// Set output vale
	LATB=(LATB&0xFF00)|(val&0xff);
	// Enable output
	TRISBCLR=0x00FF;
	// Disable pulldown
	CNPUBCLR=0x00FF;
}

int lib_out16(int val){
	// Set output vale
	LATB=(val&0xFFFF);
	// Enable output
	TRISBCLR=0xFFFF;
	// Disable pulldown
	CNPUBCLR=0xFFFF;
}

int lib_in(int pos){
	// pos must be between 0 and 15
	if (pos<0 || 15<pos) return 0;
	// Enable pulldown
	CNPUBSET=1<<pos;
	// Enable input
	TRISBSET=1<<pos;
	// Read value and return
	return (PORTB&(1<<pos)) ? 1:0;
}

int lib_in8h(){
	// Enable pulldown
	CNPUBSET=0xFF00;
	// Enable input
	TRISBSET=0xFF00;
	// Read value and return
	return (PORTB&0xFF00)>>8;
}

int lib_in8l(){
	// Enable pulldown
	CNPUBSET=0x00FF;
	// Enable input
	TRISBSET=0x00FF;
	// Read value and return
	return PORTB&0x00FF;
}

int lib_in16(){
	// Enable pulldown
	CNPUBSET=0xFFFF;
	// Enable input
	TRISBSET=0xFFFF;
	// Read value and return
	return PORTB&0xFFFF;
}

int lib_analog(int pos){

}

/*
	Statements and functions implementations follow
*/

// Local prototyping
char* param2_statement(enum libs lib);

char* out_statement(){
	return param2_statement(LIB_SYSTEM | EXTRA_OUT);
}
char* out8h_statement(){
	char* err;
	err=get_value();
	if (err) return err;
	call_lib_code(LIB_SYSTEM | EXTRA_OUT8H);
	return 0;
}
char* out8l_statement(){
	char* err;
	err=get_value();
	if (err) return err;
	call_lib_code(LIB_SYSTEM | EXTRA_OUT8L);
	return 0;
}
char* out16_statement(){
	char* err;
	err=get_value();
	if (err) return err;
	call_lib_code(LIB_SYSTEM | EXTRA_OUT16);
	return 0;
}
char* in_function(){
	char* err;
	err=get_value();
	if (err) return err;
	call_lib_code(LIB_SYSTEM | EXTRA_IN);
	return 0;
}
char* in8h_function(){
	call_lib_code(LIB_SYSTEM | EXTRA_IN8H);
	return 0;
}
char* in8l_function(){
	call_lib_code(LIB_SYSTEM | EXTRA_IN8L);
	return 0;
}
char* in16_function(){
	call_lib_code(LIB_SYSTEM | EXTRA_IN16);
	return 0;
}
char* analog_function(){
	char* err;
	err=get_value();
	if (err) return err;
	call_lib_code(LIB_SYSTEM | EXTRA_ANALOG);
	return 0;
}
