/*
   This file is provided under the LGPL license ver 2.1.
   Written by K.Tanaka
   http://www.ze.em-net.ne.jp/~kenken/index.html
*/

#include <xc.h>
#include "api.h"
#include "editor.h"
#include "keyinput.h"
#include "compiler.h"

struct _TBUF{
//Nt̃eLXgobt@
	struct _TBUF *prev;//Oւ̃NBNULL̏ꍇ擪܂͋
	struct _TBUF *next;//ւ̃NBNULL̏ꍇŌ
	unsigned short n;//݂̎gpoCg
	unsigned char Buf[TBUFSIZE];//obt@
} ;
typedef struct _TBUF _tbuf;

//_tbuf TextBuffer[TBUFMAXLINE]; //eLXgobt@
_tbuf *TextBuffer; //͔̂zRAM[]̒Ɋmۂ

_tbuf *TBufstart; //eLXgobt@̐擪ʒu
_tbuf *cursorbp; //݂̃J[\ʒũeLXgobt@
unsigned short cursorix; //݂̃J[\ʒũeLXgobt@擪̈ʒu
_tbuf *disptopbp; //ݕ\ʍ̃eLXgobt@
unsigned short disptopix; //ݕ\ʍ̃eLXgobt@擪̈ʒu
int num; //݃obt@Ɋi[Ă镶
int cx,cy; //J[\W
int cx2; //㉺ړ̉J[\XW
_tbuf *cursorbp1; //͈͑ĨJ[\X^[gʒũeLXgobt@A͈͑I[hłȂꍇNULL
unsigned short cursorix1; //͈͑ĨJ[\X^[gʒũeLXgobt@擪̈ʒu
int cx1,cy1; //͈͑ĨJ[\X^[gW

// J[\֘Aʒüꎞp
_tbuf *cursorbp_t;
unsigned short cursorix_t;
_tbuf *disptopbp_t;
unsigned short disptopix_t;
int cx_t,cy_t;

//unsigned char clipboard[EDITWIDTHX*EDITWIDTHY]; //Nbv{[hAőTCY͕ҏWʗ̈Ɠ
unsigned char *clipboard; //͔̂zRAM[]̒Ɋmۂ

int clipsize; //݃Nbv{[hɊi[Ă镶
int edited; //ۑɕύXꂽ\tO

//unsigned char filebuf[FILEBUFSIZE]; //t@CANZXpobt@
unsigned char *filebuf; //͔̂zRAM[]̒Ɋmۂ

unsigned char currentfile[13],tempfile[13]; //ҏW̃t@CAꎞt@C

//unsigned char filenames[MAXFILENUM][13]; //[h̃t@Cꗗobt@
unsigned char (*filenames)[13]; //͔̂zRAM[]̒Ɋmۂ

void wait60thsec(unsigned short n){
	// 60nbEFCgirfIʂ̍ŉsMo͏I܂ő҂j
	drawcount=0;
	while(drawcount<n) asm("wait");
}

unsigned int bpixtopos(_tbuf *bp,unsigned int ix){
// eLXgobt@̈ʒueLXgŜ̐擪牽ڂԂ
// bp:eLXgobt@|C^
// ix:bp->Buf̐擪̕
	unsigned int pos;
	_tbuf *sbp;
	pos=0;
	sbp=TBufstart;
	while(sbp!=bp){
		pos+=sbp->n;
		sbp=sbp->next;
		if(sbp==NULL) return 0; //G[
	}
	return pos+ix;
}
_tbuf * postobpix(int pos,unsigned short *pix){
// eLXgŜ̐擪posڂ̃eLXgobt@̈ʒuԂ
// ߂l@eLXgobt@|C^
// *pixi߂ljF߂leLXgobt@̐擪̈ʒui|C^nj
	_tbuf *bp;
	bp=TBufstart;
	while(pos >= bp->n){
		if(bp->next==NULL) break; //S̍Ō̏ꍇ
		pos-=bp->n;
		bp=bp->next;
	}
	if(pos > bp->n){
		// I[o[G[̏ꍇ擪Ԃ
		*pix=0;
		return TBufstart;
	}
	*pix=pos;
	return bp;
}
_tbuf * linetobpix(int line,unsigned short *pix){
// eLXgŜ̐擪linesڂ̃eLXgobt@̈ʒuԂ
// ߂l@eLXgobt@|C^
// *pixi߂ljF߂leLXgobt@̐擪̈ʒui|C^nj
	_tbuf *bp;
	int ix;
	bp=TBufstart;
	ix=0;
	while(line>1){
		while(1){
			if(ix>=bp->n){
				bp=bp->next;
				ix=0;
				continue;
			}
			if(bp->Buf[ix++] == '\n') break;
		}
		line--;
	}
	*pix=ix;
	return bp;
}

_tbuf * newTBuf(_tbuf *prev){
// VeLXgobt@1s𐶐
// prev:}̍siprev̌ɒǉj
// ߂l@obt@ւ̃|C^AłȂꍇNULL
	_tbuf *bp,*next;

	//obt@̐擪󂫂T[`
	bp=TextBuffer;
	while(1){
		if(bp->prev==NULL && bp!=TBufstart) break;
		bp++;
		if(bp>=TextBuffer+TBUFMAXLINE) return NULL;//Ō܂ŋ󂫂Ȃ
	}
	next=prev->next;
	//s}
	bp->prev=prev;
	bp->next=next;
	prev->next=bp;
	if(next!=NULL) next->prev=bp;
	bp->n=0;
	return bp;
}

_tbuf * deleteTBuf(_tbuf *bp){
// eLXgobt@̍폜
// bp:폜s̃|C^
// ߂l@폜O̎̃obt@ւ̃|C^AȂꍇNULL
	unsigned short a,b;
	_tbuf *prev,*next;
	prev=bp->prev;
	next=bp->next;
	if(prev==NULL){
		//擪s̏ꍇ
		if(next==NULL) return next; //Ō1s̏ꍇ͍폜Ȃ
		TBufstart=next; //̍s擪sݒ
	}
	else prev->next=next; //OɃNiŏIsȂNULLRs[j
	if(next!=NULL) next->prev=prev; //ΎOɃN
	bp->prev=NULL; //󂫃tOݒ
	return next;
}

int insertchar(_tbuf *bp,unsigned int ix,unsigned char c){
//eLXgobt@bp̐擪ixoCg̈ʒuc}
//߂l@F0As܂͗eʃI[o[F-1A󂫂͂Ȃ̂ɎsF1
	unsigned char *p;

	if(ix > bp->n) return -1; //sw
	if(num >= TBUFMAXSIZE) return -1; //obt@eʃI[o[
	if(bp->n < TBUFSIZE){
		//C1oCg}\//
		for(p=bp->Buf + bp->n ; p > bp->Buf+ix ; p--) *p=*(p-1);
		*p=c;
		bp->n++;
		num++; //obt@gp
//		if(bp->n >= TBUFSIZE && bp->next==NULL) newTBuf(bp); //obt@ςɂȂVɃobt@
		return 0;
	}
	//Cӂꍇ
	if(bp->next==NULL || bp->next->n >=TBUFSIZE){
		// ŏIs܂͎̃Cobt@ςs}
		if(newTBuf(bp)==NULL){
			// Cobt@}s
			return 1;
		}
	}
	if(ix==TBUFSIZE){
		insertchar(bp->next,0,c);
		return 0;
	}
	p=bp->Buf + TBUFSIZE-1;
	insertchar(bp->next,0,*p); //̍s̐擪1}iK󂫂j
	for( ; p > bp->Buf+ix ; p--) *p=*(p-1);
	*p=c;
	return 0;
}

int overwritechar(_tbuf *bp,unsigned int ix,unsigned char c){
//eLXgobt@bp̐擪ixoCg̈ʒucŏ㏑
//߂l@F0As܂͗eʃI[o[F-1A󂫂͂Ȃ̂ɎsF1

	//݂̃obt@ʒu̕I[܂͉s̏ꍇA}[h
	if(ix > bp->n) return -1; //sw
	while(ix >= bp->n){
		if(bp->next==NULL){
			//eLXgS̍Ō̏ꍇ͑}
			return insertchar(bp,ix,c);
		}
		bp=bp->next;
		ix=0;
	}
	if(bp->Buf[ix]=='\n') return insertchar(bp,ix,c);
	else bp->Buf[ix]=c;
	return 0;
}

void deletechar(_tbuf *bp,unsigned int ix){
//eLXgobt@bp̐擪koCg̈ʒu1oCg폜
	unsigned char *p;

	if(ix > bp->n) return; //sw
	if(ix !=bp->n){
		//obt@̍Ō̕łȂꍇ
		for(p=bp->Buf+ix ; p< bp->Buf + bp->n-1 ; p++) *p=*(p+1);
		bp->n--;
		num--; //obt@gp
		return;
	}
	//sobt@݂̌̍Ō̏ꍇi폜镶Ȃꍇj
	if(bp->next==NULL) return; //Ŝ̍Ō̏ꍇAȂ
	deletechar(bp->next,0); //̍s̐擪폜
}
int gabagecollect1(void){
//fЉꂽeLXgobt@̌Ԃ𖄂߂Kx[WRNV
//J[\̑Oƌ낻ꂼTčŏ1oCĝݎ{
//߂l 1oCgłړꍇF1AȂꍇF0

	_tbuf *bp;
	int f=0;
	unsigned char *p,*p2;

	//J[\obt@̐擪ɂꍇAÕobt@̍ŌɕύX
	//iOɋ󂫂ȂꍇƐ擪obt@̏ꍇj
	while(cursorix==0 && cursorbp->prev!=NULL && cursorbp->prev->n <TBUFSIZE){
		cursorbp=cursorbp->prev;
		cursorix=cursorbp->n;
	}
	//ʍʒuobt@̐擪ɂꍇAÕobt@̍ŌɕύX
	//i擪obt@̏ꍇj
	while(disptopix==0 && disptopbp->prev!=NULL){
		disptopbp=disptopbp->prev;
		disptopix=disptopbp->n;
	}
	//J[\̂obt@ȊŐobt@Sč폜
	bp=TBufstart;
	while(bp!=NULL){
		if(bp->n == 0 && bp!=cursorbp) bp=deleteTBuf(bp); //󂫃obt@폜
		else bp=bp->next;
	}

	//J[\ʒuO̖܂ĂȂobt@擪T[`
	bp=TBufstart;
	while(bp->n >= TBUFSIZE){
		if(bp==cursorbp) break;
		bp=bp->next;
	}
	if(bp!=cursorbp){
		//ŏɌ󂫏ꏊɎ̃obt@1oCgړ
		bp->Buf[bp->n++] = bp->next->Buf[0];
		bp=bp->next;
		p=bp->Buf;
		p2=p+bp->n-1;
		for( ; p<p2 ; p++) *p=*(p+1);
		bp->n--;
		f=1;
		if(bp == disptopbp) disptopix--;
		if(bp == cursorbp) cursorix--;
//		else if(bp->n == 0) deleteTBuf(bp);
	}
	if(cursorbp->next ==NULL) return f; //J[\ʒuŏIobt@ȂI
	//J[\ʒu̎̃obt@疄܂ĂȂobt@T[`
	bp=cursorbp;
	do{
		bp=bp->next;
		if(bp->next ==NULL) return f; //ŏIobt@ɓBȂI
	} while(bp->n >=TBUFSIZE);

	//ŏɌ󂫏ꏊɎ̃obt@1oCgړ
	bp->Buf[bp->n++] = bp->next->Buf[0];
	bp=bp->next;
	p=bp->Buf;
	p2=p+bp->n-1;
	for( ; p<p2 ; p++) *p=*(p+1);
	bp->n--;
	f=1;
	if(bp->n == 0) deleteTBuf(bp);
	return f;
}
void gabagecollect2(void){
// ωȂȂ܂1oCg̃Kx[WRNVĂяo
	while(gabagecollect1()) ;
}
void inittextbuf(void){
// eLXgobt@̏
	_tbuf *bp;
	for(bp=TextBuffer;bp<TextBuffer+TBUFMAXLINE;bp++) bp->prev=NULL; //gpobt@
	TBufstart=TextBuffer; //N̐擪ݒ
	TBufstart->next=NULL;
	TBufstart->n=0;
	num=0; //obt@gp
	edited=0; //ҏWς݃tONA
}
void redraw(){
//ʂ̍ĕ`
	unsigned char *vp;
	_tbuf *bp,*bp1,*bp2;
	int ix,ix1,ix2;
	int x,y;
	unsigned char ch,cl;

	vp=TVRAM;
	bp=disptopbp;
	ix=disptopix;
	cl=COLOR_NORMALTEXT;
	if(cursorbp1==NULL){
		//͈͑I[hłȂꍇ
		bp1=NULL;
		bp2=NULL;
	}
	else{
		//͈͑I[h̏ꍇAJnʒuƏȊO㔻f
		//bp1,ix1JnʒuAbp2,ix2Iʒuɐݒ
		if(cy<cy1 || (cy==cy1 && cx<cx1)){
			bp1=cursorbp;
			ix1=cursorix;
			bp2=cursorbp1;
			ix2=cursorix1;
		}
		else{
			bp1=cursorbp1;
			ix1=cursorix1;
			bp2=cursorbp;
			ix2=cursorix;
		}
	}
	for(y=0;y<EDITWIDTHY;y++){
		if(bp==NULL) break;
		for(x=0;x<EDITWIDTHX;x++){
			//ʒu܂ŃT[`
			while(ix>=bp->n){
				if(bp==bp1 && ix==ix1) cl=COLOR_AREASELECTTEXT;
				if(bp==bp2 && ix==ix2) cl=COLOR_NORMALTEXT;
				bp=bp->next;
				ix=0;
				if(bp==NULL) break;
			}
			if(bp==NULL) break; //obt@ŏI
			if(bp==bp1 && ix==ix1) cl=COLOR_AREASELECTTEXT;
			if(bp==bp2 && ix==ix2) cl=COLOR_NORMALTEXT;
			ch=bp->Buf[ix++];
			if(ch=='\n') break;
			*(vp+ATTROFFSET)=cl;
			*vp++=ch;
		}
		//sуobt@ŏIȍ~̉E\
		for(;x<EDITWIDTHX;x++){
			*(vp+ATTROFFSET)=0;
			*vp++=0;
		}
	}
	//obt@ŏIȍ~̉\
	for(;y<EDITWIDTHY;y++){
		for(x=0;x<EDITWIDTHX;x++){
			*(vp+ATTROFFSET)=0;
			*vp++=0;
		}
	}
}

void cursor_left(void){
//J[\1OɈړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cy ʏ̃J[\ʒu
//cx2 cxƓ
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int i;
	int x;

	//obt@̃J[\ʒu1OɈړ
	if(cursorix!=0) cursorix--;
	else while(1) {
		//1Õobt@̍ŌɈړAobt@͔΂
		if(cursorbp->prev==NULL) return; //eLXgS̐擪Ȃ̂ňړȂ
		cursorbp=cursorbp->prev;
		if(cursorbp->n >0){
			cursorix=cursorbp->n-1;//obt@Ō
			break;
		}
	}

	//J[\щʍʒu̍XV
	if(cx>0){
		//[łȂ΃J[\P1ɈړďI
		cx--;
		cx2=cx;
		return;
	}
	if(cy>0){
		//[[ł͂Ȃꍇ
		if(cursorbp->Buf[cursorix]!='\n'){
			// ړ悪sR[hłȂꍇAJ[\1̍s̉E[Ɉړ
			cx=EDITWIDTHX-1;
			cx2=cx;
			cy--;
			return;
		}
		//ʍʒuŌXWT[`
		bp=disptopbp;
		ix=disptopix;
		x=0;
		while(ix!=cursorix || bp!=cursorbp){
			if(bp->n==0){
				//obt@̏ꍇ
				bp=bp->next;
				ix=0;
				continue;
			}
			if(bp->Buf[ix++]=='\n' || x>=EDITWIDTHX-1) x=0;
			else x++;
			if(ix >= bp->n){
				bp=bp->next;
				ix=0;
			}
		}
		cx=x;
		cx2=cx;
		cy--;
		return;
	}

	//[[̏ꍇ
	if(cursorbp->Buf[cursorix]!='\n'){
		// ړ悪sR[hłȂꍇAJ[\͉E[Ɉړ
		// ʍʒu͉ʉOɈړ
		cx=EDITWIDTHX-1;
		cx2=cx;
	}
	else{
		//ړ悪sR[h̏ꍇ
		//sis̎̕܂̓obt@擪jƌ݈ʒu̕
		//ʉŊ]肪J[\XW
		bp=cursorbp;
		ix=cursorix;
		i=0;
		while(1){
			if(ix==0){
				if(bp->prev==NULL) break;
				bp=bp->prev;
				ix=bp->n;
				continue;
			}
			ix--;
			if(bp->Buf[ix]=='\n') break;
			i++;
		}
		cx=i % EDITWIDTHX;
		cx2=cx;
	}
	//ʍʒu݈͌ʒuXWƂ
	bp=cursorbp;
	ix=cursorix;
	x=cx;
	while(x>0){
		if(ix==0){
			bp=bp->prev;
			ix=bp->n;
			continue;
		}
		ix--;
		x--;
	}
	disptopbp=bp;
	disptopix=ix;
}
void cursor_right(void){
//J[\1Ɉړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cy ʏ̃J[\ʒu
//cx2 cxƓ
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int i;
	int x;
	unsigned char c;

	if(cursorix >= cursorbp->n){
		//obt@Ō̏ꍇA̐擪Ɉړ
		bp=cursorbp;
		while(1) {
			//obt@͔΂
			if(bp->next==NULL) return; //eLXgS̍ŌȂ̂ňړȂ
			bp=bp->next;
			if(bp->n >0) break;
		}
		cursorbp=bp;
		cursorix=0;//obt@擪
	}
	c=cursorbp->Buf[cursorix++]; //obt@̃J[\ʒũR[hǂ1Ɉړ
	if(c!='\n' && cx<EDITWIDTHX-1){
		//J[\ʒusłE[łȂꍇP1EɈړďI
		cx++;
		cx2=cx;
		return;
	}
	cx=0; //J[\E[Ɉړ
	cx2=cx;
	if(cy<EDITWIDTHY-1){
		//[łȂ΃J[\sɈړďI
		cy++;
		return;
	}
	//[̏ꍇ
	//ʍʒuXV
	//sR[h܂͉ʉ܂ŃT[`
	bp=disptopbp;
	ix=disptopix;
	x=0;
	while(x<EDITWIDTHX){
		if(ix >= bp->n){
			bp=bp->next;
			ix=0;
			continue;
		}
		if(bp->Buf[ix++]=='\n') break;
		x++;
	}
	disptopbp=bp;
	disptopix=ix;
}
void cursor_up(void){
//J[\1Ɉړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cy ʏ̃J[\ʒu
//cx2 ړOcxƓ
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int i;
	int x;
	unsigned char c;

	//ʕOɖ߂Ƃ낪obt@J[\̈ړ
	//rŉsR[hΕʂ̎iŌ
	bp=cursorbp;
	ix=cursorix;
	i=cx2-cx;
	while(i<EDITWIDTHX){
		if(ix==0){
			if(bp->prev==NULL) return; //obt@擪܂ŃT[`ړȂ
			bp=bp->prev;
			ix=bp->n;
			continue;
		}
		ix--;
		if(bp->Buf[ix]=='\n') break;
		i++;
	}
	cursorbp=bp;
	cursorix=ix;
	//ʕ̊ԂɉsR[hȂꍇ
	if(i==EDITWIDTHX){
		cx=cx2;
		//ʏ[łȂ΃J[\1ɈړďI
		if(cy>0){
			cy--;
			return;
		}
		//ʏ[̏ꍇAJ[\ʒuXW߂Ƃ낪ʍʒu
		x=cx;
		while(x>0){
			if(ix==0){
				bp=bp->prev;
				ix=bp->n;
				continue;
			}
			ix--;
			x--;
		}
		disptopbp=bp;
		disptopix=ix;
		return;
	}
	//sꍇ
	//sis̎̕܂̓obt@擪jƌ݈ʒu̕
	//ʉŊ]߂
	i=0;
	while(1){
		if(ix==0){
			if(bp->prev==NULL) break;
			bp=bp->prev;
			ix=bp->n;
			continue;
		}
		ix--;
		if(bp->Buf[ix]=='\n') break;
		i++;
	}
	x=i % EDITWIDTHX; //subN̍ŏIs̉E[
	bp=cursorbp;
	ix=cursorix;
	//obt@̃J[\ʒu͉subN̍ŏIsE[J[\XW߂
	//ŏIsE[̂قꍇȀꏊobt@̃J[\ʒuƂ
	while(x>cx2){
		if(ix==0){
			bp=bp->prev;
			ix=bp->n;
			continue;
		}
		ix--;
		x--;
	}
	cursorbp=bp;
	cursorix=ix;
	cx=x; //cx2܂͉subNŏIsE[
	if(cy>0){
		//ʏ[łȂ΃J[\1ɈړďI
		cy--;
		return;
	}
	//ʏ[̏ꍇ
	//ʍʒu݈͌ʒuXWƂ
	while(x>0){
		if(ix==0){
			bp=bp->prev;
			ix=bp->n;
			continue;
		}
		ix--;
		x--;
	}
	disptopbp=bp;
	disptopix=ix;
}
void cursor_down(void){
//J[\1Ɉړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cy ʏ̃J[\ʒu
//cx2 ړOcxƓ
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int x;
	unsigned char c;

	//s̐擪T[`
	//J[\ʒuʉE[܂ł̊ԂɉsR[hΎ̕擪
	bp=cursorbp;
	ix=cursorix;
	x=cx;
	while(x<EDITWIDTHX){
		if(ix>=bp->n){
			if(bp->next==NULL) return; //obt@Ō܂ŃT[`ړȂ
			bp=bp->next;
			ix=0;
			continue;
		}
		c=bp->Buf[ix];
		ix++;
		x++;
		if(c=='\n') break;
	}
	//s擪cx2ɃT[`
	x=0;
	while(x<cx2){
		if(ix>=bp->n){
			if(bp->next==NULL) break; //obt@Ō̏ꍇɈړ
			bp=bp->next;
			ix=0;
			continue;
		}
		if(bp->Buf[ix]=='\n') break; //sR[h̏ꍇɈړ
		ix++;
		x++;
	}
	cursorbp=bp;
	cursorix=ix;
	cx=x;
	//ʉ[łȂ΃J[\1ɈړďI
	if(cy<EDITWIDTHY-1){
		cy++;
		return;
	}
	//[̏ꍇ
	//ʍʒuXV
	//sR[h܂͉ʉ܂ŃT[`
	bp=disptopbp;
	ix=disptopix;
	x=0;
	while(x<EDITWIDTHX){
		if(ix >= bp->n){
			bp=bp->next;
			ix=0;
			continue;
		}
		if(bp->Buf[ix++]=='\n') break;
		x++;
	}
	disptopbp=bp;
	disptopix=ix;
}
void cursor_home(void){
//J[\s擪Ɉړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cx2 0
//cy ύXȂ
//disptopbp,disptopix ʍ̃obt@̈ʒuiύXȂj

	//J[\XWOɈړ
	while(cx>0){
		if(cursorix==0){
			//obt@͔΂
			cursorbp=cursorbp->prev;
			cursorix=cursorbp->n;
			continue;
		}
		cursorix--;
		cx--;
	}
	cx2=0;
}
void cursor_end(void){
//J[\sɈړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cx2 s
//cy ύXȂ
//disptopbp,disptopix ʍ̃obt@̈ʒuiύXȂj

	//J[\XWʕɈړ
	//sR[h܂̓obt@ŏI΂Ɉړ
	while(cx<EDITWIDTHX-1){
		if(cursorix>=cursorbp->n){
			//obt@͔΂
			if(cursorbp->next==NULL) break;
			cursorbp=cursorbp->next;
			cursorix=0;
			continue;
		}
		if(cursorbp->Buf[cursorix]=='\n') break;
		cursorix++;
		cx++;
	}
	cx2=cx;
}
void cursor_pageup(void){
//PageUpL[
//ŏsŉsɂȂ܂ŃXN[
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cx2
//cy
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int i;
	int cy_old;

	cy_old=cy;
	while(cy>0) cursor_up(); // cy==0ɂȂ܂ŃJ[\Ɉړ
	for(i=0;i<EDITWIDTHY-1;i++){
		//ʍs-1sJ[\Ɉړ
		bp=disptopbp;
		ix=disptopix;
		cursor_up();
		if(bp==disptopbp && ix==disptopix) break; //ŏsňړłȂꍇ
	}
	//YW܂ŃJ[\ɈړA1sȂꍇ͍ŏsɗ܂
	if(i>0) while(cy<cy_old) cursor_down();
}
void cursor_pagedown(void){
//PageDownL[
//ŉsŏsɂȂ܂ŃXN[
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cx2
//cy
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int i;
	int y;
	int cy_old;

	cy_old=cy;
	while(cy<EDITWIDTHY-1){
		// cy==EDITWIDTH-1ɂȂ܂ŃJ[\Ɉړ
		y=cy;
		cursor_down();
		if(y==cy) break;// obt@ŉsňړłȂꍇ
	}
	for(i=0;i<EDITWIDTHY-1;i++){
		//ʍs-1sJ[\Ɉړ
		bp=disptopbp;
		ix=disptopix;
		cursor_down();
		if(bp==disptopbp && ix==disptopix) break; //ŉsňړłȂꍇ
	}
	//[炳ɈړsAJ[\ɈړA1sȂꍇ͍ŉsɗ܂
	if(i>0) while(cy>cy_old) cursor_up();
}
void cursor_top(void){
//J[\eLXgobt@̐擪Ɉړ
	cursorbp=TBufstart;
	cursorix=0;
	cursorbp1=NULL; //͈͑I[h
	disptopbp=cursorbp;
	disptopix=cursorix;
	cx=0;
	cx2=0;
	cy=0;
}

int countarea(void){
//eLXgobt@̎w͈͂̕JEg
//͈͂(cursorbp,cursorix)(cursorbp1,cursorix1)Ŏw
//둤̈O̕܂łJEg
	_tbuf *bp1,*bp2;
	int ix1,ix2;
	int n;

	//͈͑I[h̏ꍇAJnʒuƏȊO㔻f
	//bp1,ix1JnʒuAbp2,ix2Iʒuɐݒ
	if(cy<cy1 || (cy==cy1 && cx<cx1)){
		bp1=cursorbp;
		ix1=cursorix;
		bp2=cursorbp1;
		ix2=cursorix1;
	}
	else{
		bp1=cursorbp1;
		ix1=cursorix1;
		bp2=cursorbp;
		ix2=cursorix;
	}
	n=0;
	while(1){
		if(bp1==bp2 && ix1==ix2) return n;
		if(ix1 < bp1->n){
			n++;
			ix1++;
		}
		else{
			bp1=bp1->next;
			ix1=0;
		}
	}
}
void deletearea(void){
//eLXgobt@̎w͈͂폜
//͈͂(cursorbp,cursorix)(cursorbp1,cursorix1)Ŏw
//둤̈O̕܂ł폜
//폜̃J[\ʒu͑I͈͂̐擪ɂA͈͑I[h

	_tbuf *bp;
	int ix;
	int n;

	n=countarea(); //I͈͂̕JEg

	//͈͑I̊JnʒuƏIʒȗO𔻒făJ[\Jnʒuɐݒ
	if(cy>cy1 || (cy==cy1 && cx>cx1)){
		cursorbp=cursorbp1;
		cursorix=cursorix1;
		cx=cx1;
		cy=cy1;
	}
	cx2=cx;
	cursorbp1=NULL; //͈͑I[h

	//bp,ixJnʒuɐݒ
	bp=cursorbp;
	ix=cursorix;

	//I͈͂ŏ̃obt@̍Ō܂łꍇ
	if(n>=(bp->n - ix)){
		n -= bp->n - ix; //폜
		num-=bp->n - ix; //obt@gpʂ
		bp->n=ix; //ixȍ~폜
		bp=bp->next;
		if(bp==NULL) return;
		ix=0;
	}
	//̃obt@ȍ~AI͈͂̏Iʒu܂܂Ȃobt@͍폜
	while(n>=bp->n){
		n-=bp->n; //폜
		num-=bp->n; //obt@gpʂ
		bp=deleteTBuf(bp); //obt@폜Ď̃obt@ɐi
		if(bp==NULL) return;
	}
	//I͈͂̏Iʒu܂ޏꍇA1폜
	while(n>0){
		deletechar(bp,ix); //obt@1폜inum͊֐1j
		n--;
	}
}
void clipcopy(void){
// I͈͂Nbv{[hɃRs[
	_tbuf *bp1,*bp2;
	int ix1,ix2;
	char *ps,*pd;

	//͈͑I[h̏ꍇAJnʒuƏȊO㔻f
	//bp1,ix1JnʒuAbp2,ix2Iʒuɐݒ
	if(cy<cy1 || (cy==cy1 && cx<cx1)){
		bp1=cursorbp;
		ix1=cursorix;
		bp2=cursorbp1;
		ix2=cursorix1;
	}
	else{
		bp1=cursorbp1;
		ix1=cursorix1;
		bp2=cursorbp;
		ix2=cursorix;
	}
	ps=bp1->Buf+ix1;
	pd=clipboard;
	clipsize=0;
	while(bp1!=bp2 || ix1!=ix2){
		if(ix1 < bp1->n){
			*pd++=*ps++;
			clipsize++;
			ix1++;
		}
		else{
			bp1=bp1->next;
			ps=bp1->Buf;
			ix1=0;
		}
	}
}
void clippaste(void){
// Nbv{[h\t
	int n,i;
	unsigned char *p;

	p=clipboard;
	for(n=clipsize;n>0;n--){
		i=insertchar(cursorbp,cursorix,*p);
		if(i>0){
			//obt@󂫂̂ɑ}s̏ꍇ
			gabagecollect2(); //S̃Kx[WRNV
			i=insertchar(cursorbp,cursorix,*p);//eLXgobt@ɂP}
		}
		if(i!=0) return;//}s
		cursor_right();//ʏAobt@̃J[\ʒu1Ɉړ
		p++;
	}
}
void set_areamode(){
//͈͑I[hJñJ[\JnʒuO[oϐݒ
	cursorbp1=cursorbp;
	cursorix1=cursorix;
	cx1=cx;
	cy1=cy;
}
void save_cursor(void){
//J[\֘AO[oϐꎞ
	cursorbp_t=cursorbp;
	cursorix_t=cursorix;
	disptopbp_t=disptopbp;
	disptopix_t=disptopix;
	cx_t=cx;
	cy_t=cy;
}
void restore_cursor(void){
//J[\֘AO[oϐꎞꏊ߂
	cursorbp=cursorbp_t;
	cursorix=cursorix_t;
	disptopbp=disptopbp_t;
	disptopix=disptopix_t;
	cx=cx_t;
	cy=cy_t;
}

int savetextfile(char *filename){
// eLXgobt@eLXgt@Cɏ
// ݐ0AsŃG[R[hijԂ
	FSFILE *fp;
	_tbuf *bp;
	int ix,n,i,er;
	unsigned char *ps,*pd;
	er=0;//G[R[h
	i=-1;
	fp=FSfopen(filename,"WRITE");
	if(fp==NULL) return ERR_CANTFILEOPEN;
	bp=TBufstart;
	ix=0;
	ps=bp->Buf;
	do{
		pd=filebuf;
		n=0;
		while(n<FILEBUFSIZE-1){
		//sR[h2oCgɂȂ邱Ƃlăobt@TCY-1܂łƂ
			while(ix>=bp->n){
				bp=bp->next;
				if(bp==NULL){
					break;
				}
				ix=0;
				ps=bp->Buf;
			}
			if(bp==NULL) break;
			if(*ps=='\n'){
				*pd++='\r'; //sR[h0A0D 0Aɂ
				n++;
			}
			*pd++=*ps++;
			ix++;
			n++;
		}
		if(n>0) i=FSfwrite(filebuf,1,n,fp);
		if(i!=n) er=ERR_CANTWRITEFILE;
	} while(bp!=NULL && er==0);
	FSfclose(fp);
	return er;
}
int loadtextfile(char *filename){
// eLXgt@CeLXgobt@ɓǂݍ
// ǂݍݐ0AsŃG[R[hijԂ
	FSFILE *fp;
	_tbuf *bp;
	int ix,n,i,er;
	unsigned char *ps,*pd;
	er=0;//G[R[h
	fp=FSfopen(filename,"READ");
	if(fp==NULL) return ERR_CANTFILEOPEN;
	inittextbuf();
	bp=TextBuffer;
	ix=0;
	pd=bp->Buf;
	do{
		n=FSfread(filebuf,1,FILEBUFSIZE,fp);
		ps=filebuf;
		for(i=0;i<n;i++){
			if(ix>=TBUFSIZE){
				bp->n=TBUFSIZE;
				bp=newTBuf(bp);
				if(bp==NULL){
					er=ERR_FILETOOBIG;
					break;
				}
				ix=0;
				pd=bp->Buf;
			}
			if(*ps=='\r') ps++; //sR[h0D 0A0AɂiP0Dj
			else{
				*pd++=*ps++;
				ix++;
				num++;//obt@
				if(num>TBUFMAXSIZE){
					er=ERR_FILETOOBIG;
					break;
				}
			}
		}
	} while(n==FILEBUFSIZE && er==0);
	if(bp!=NULL) bp->n=ix;//Ō̃obt@̕
	FSfclose(fp);
	if(er) inittextbuf();//G[̏ꍇobt@NA
	return er;
}
void save_as(void){
// ݂̃eLXgobt@̓et@CtSDJ[hɕۑ
// t@C̓O[oϐcurrentfile[]
// t@C̓L[{[hύX\
// ꍇcurrentfileXV

	int er;
	unsigned char vk;
	unsigned char *ps,*pd;
	cls();
	setcursor(0,0,COLOR_NORMALTEXT);
	printstr("Save To SD Card\n");

	//currentfiletempfileɃRs[
	ps=currentfile;
	pd=tempfile;
	while(*ps!=0) *pd++=*ps++;
	*pd=0;

	while(1){
		printstr("File Name + [Enter] / [ESC]\n");
		if(lineinput(tempfile,8+1+3)<0) return; //ESCL[ꂽ
		if(tempfile[0]==0) continue; //NULL̏ꍇ
		printstr("Writing...\n");
		er=savetextfile(tempfile); //t@CۑAer:G[R[h
		if(er==0){
			printstr("OK");
			FSremove(TEMPFILENAME); //sɐꎞt@C폜
			//tempfilecurrentfileɃRs[ďI
			ps=tempfile;
			pd=currentfile;
			while(*ps!=0) *pd++=*ps++;
			*pd=0;
			edited=0; //ҏWς݃tONA
			wait60thsec(60);//1b҂
			return;
		}
		setcursorcolor(COLOR_ERRORTEXT);
		if(er==ERR_CANTFILEOPEN) printstr("Bad File Name or File Error\n");
		else printstr("Cannot Write\n");
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Retry:[Enter] / Quit:[ESC]\n");
		while(1){
			inputchar(); //1͑҂
			vk=vkey & 0xff;
			if(vk==VK_RETURN || vk==VK_SEPARATOR) break;
			if(vk==VK_ESCAPE) return;
		}
	}
}

int selectfile(void){
// SDJ[ht@CIēǂݍ
// currenfile[]Ƀt@CL
// Ώۃt@Cgq BASTXT
// ߂l@0Fǂݍ݂s@-1Fǂݍ݂Ȃ
	unsigned int filenum,top,f;
	int er;
	unsigned char *ps,*pd;
	unsigned char x,y;
	unsigned char vk;
	SearchRec sr;

	//t@C̈ꗗSDJ[hǂݏo
	cls();
	if(edited){
		//ŏIۑɕҏWς݂̏ꍇAۑ̊mF
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Save Editing File?\n");
		printstr("Save:[Enter] / Not Save:[ESC]\n");
		while(1){
			inputchar(); //1L[͑҂
			vk=vkey & 0xff;
			if(vk==VK_RETURN || vk==VK_SEPARATOR){
				save_as();
				break;
			}
			else if(vk==VK_ESCAPE) break;
		}
	}
	filenum=0;
	while(1){
		//gq BASt@C̃T[`
		if(FindFirst("*.BAS",ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_ARCHIVE,&sr)==0){
			do{
				//filenames[]Ƀt@C̈ꗗǂݍ
				ps=sr.filename;
				pd=filenames[filenum];
				while(*ps!=0) *pd++=*ps++;
				*pd=0;
				filenum++;
			}
			while(!FindNext(&sr) && filenum<MAXFILENUM);
		}
		//gq TXTt@C̃T[`
		if(FindFirst("*.TXT",ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_ARCHIVE,&sr)==0){
			do{
				//filenames[]Ƀt@C̈ꗗǂݍ
				ps=sr.filename;
				pd=filenames[filenum];
				while(*ps!=0) *pd++=*ps++;
				*pd=0;
				filenum++;
			}
			while(!FindNext(&sr) && filenum<MAXFILENUM);
		}
		if(filenum>0) break;
		setcursorcolor(COLOR_ERRORTEXT);
		printstr(".BAS or .TXT File Not Found\n");
		printstr("Retry:[Enter] / Quit:[ESC]\n");
		while(1){
			inputchar(); //1L[͑҂
			vk=vkey & 0xff;
			if(vk==VK_RETURN || vk==VK_SEPARATOR) break;
			if(vk==VK_ESCAPE) return -1;
		}
	}

	//t@Cꗗʂɕ\
	cls();
	setcursor(0,0,4);
	printstr("Select File + [Enter] / [ESC]\n");
	for(f=0;f<filenum;f++){
		x=(f&1)*15+1;
		y=f/2+1;
		if(y>=WIDTH_Y-1) break;
		setcursor(x,y,COLOR_NORMALTEXT);
		printstr(filenames[f]);
	}

	//t@C̑I
	top=0;//ʈԐ擪̃t@Cԍ
	f=0;//ݑI𒆂̃t@Cԍ
	setcursor(0,1,5);
	printchar(0x1c); // Right Arrow
	cursor--;
	while(1){
		inputchar();
		vk=vkey & 0xff;
		if(vk==0) continue;
		printchar(' ');
		setcursor(0,WIDTH_Y-1,COLOR_NORMALTEXT);
		for(x=0;x<WIDTH_X-1;x++) printchar(' '); //ŉs̃Xe[^X\
		switch(vk){
			case VK_UP:
			case VK_NUMPAD8:
				//L[
				if(f>=2){
					f-=2;
					if(f<top){
						//ʍŏ㕔̏ꍇAɃXN[čŏ㕔Ƀt@C2\
						setcursor(WIDTH_X-1,WIDTH_Y-2,COLOR_NORMALTEXT);
						while(cursor>=TVRAM+WIDTH_X*2){
							*cursor=*(cursor-WIDTH_X);
							*(cursor+ATTROFFSET)=*(cursor+ATTROFFSET-WIDTH_X);
							cursor--;
						}
						while(cursor>=TVRAM+WIDTH_X) *cursor--=' ';
						top-=2;
						setcursor(1,1,COLOR_NORMALTEXT);
						printstr(filenames[top]);
						setcursor(16,1,COLOR_NORMALTEXT);
						printstr(filenames[top+1]);
					}
				}
				break;
			case VK_DOWN:
			case VK_NUMPAD2:
				//L[
				if(f+2<filenum){
					f+=2;
					if(f-top>=(WIDTH_Y-2)*2){
						//ʍŉ̏ꍇAɃXN[čŉɃt@C1or2\
						setcursor(0,1,COLOR_NORMALTEXT);
						while(cursor<TVRAM+WIDTH_X*(WIDTH_Y-2)){
							*cursor=*(cursor+WIDTH_X);
							*(cursor+ATTROFFSET)=*(cursor+ATTROFFSET+WIDTH_X);
							cursor++;
						}
						while(cursor<TVRAM+WIDTH_X*(WIDTH_Y-1)) *cursor++=' ';
						top+=2;
						setcursor(1,WIDTH_Y-2,COLOR_NORMALTEXT);
						printstr(filenames[f&0xfffe]);
						if((f|1)<filenum){
							setcursor(16,WIDTH_Y-2,COLOR_NORMALTEXT);
							printstr(filenames[f|1]);
						}
					}
				}
				break;
			case VK_LEFT:
			case VK_NUMPAD4:
				//L[
				if(f&1) f--;
				break;
			case VK_RIGHT:
			case VK_NUMPAD6:
				//EL[
				if((f&1)==0 && f+1<filenum) f++;
				break;
			case VK_RETURN: //EnterL[
			case VK_SEPARATOR: //eL[Enter
				//t@CBǂݍŏI
				er=loadtextfile(filenames[f]); //eLXgobt@Ƀt@Cǂݍ
				if(er==0){
					//currenfile[]ϐɃt@CRs[ďI
					ps=filenames[f];
					pd=currentfile;
					while(*ps!=0) *pd++=*ps++;
					*pd=0;
					return 0;
				}
				setcursor(0,WIDTH_Y-1,COLOR_ERRORTEXT);
				if(er==ERR_CANTFILEOPEN) printstr("Cannot Open File");
				else if(er=ERR_FILETOOBIG) printstr("File Too Big");
				break;
			case VK_ESCAPE:
				//ESCL[At@Cǂݍ݂I
				return -1;
		}
		setcursor((f&1)*15,(f-top)/2+1,5);
		printchar(0x1c);// Right Arrow
		cursor--;
	}
}
void newtext(void){
// VKeLXg쐬
	unsigned char vk;
	if(edited){
		//ŏIۑɕҏWς݂̏ꍇAۑ̊mF
		cls();
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Save Editing File?\n");
		printstr("Save:[Enter] / Not Save:[ESC]\n");
		while(1){
			inputchar(); //1L[͑҂
			vk=vkey & 0xff;
			if(vk==VK_RETURN || vk==VK_SEPARATOR){
				save_as();
				break;
			}
			else if(vk==VK_ESCAPE) break;
		}
	}
	inittextbuf(); //eLXgobt@
	cursor_top(); //J[\eLXgobt@̐擪ɐݒ
	currentfile[0]=0; //ƒt@CNA
}
void run(void){
//KM-BASICRpCs
	int er,er2;
	unsigned char vk;
	unsigned int disptoppos,cursorpos;
	int i;
	_tbuf *bp;
	unsigned short ix;

	cls();
	setcursor(0,0,COLOR_NORMALTEXT);
	while(1){
		er=savetextfile(TEMPFILENAME); //ꎞt@CɕۑAer:G[R[h
		if(er==0) break;
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("Cannot Write To SD Card\n");
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Retry:[Enter] / Quit:[ESC]\n");
		while(1){
			inputchar(); //1͑҂
			vk=vkey & 0xff;
			if(vk==VK_RETURN || vk==VK_SEPARATOR) break;
			if(vk==VK_ESCAPE) return;
		}
	}

	//J[\ʒuAʕ\ʒu̕ۑ
	disptoppos=bpixtopos(disptopbp,disptopix);
	cursorpos=bpixtopos(cursorbp,cursorix);
	// Enable Break key
	g_disable_break=0;
	//KM-BASICs
	er2=runbasic(TEMPFILENAME);

	setcursorcolor(COLOR_NORMALTEXT);
	printstr("\nHit Any Key\n");
	do ps2readkey(); //L[obt@ɂȂ܂œǂݏo
	while(vkey!=0);
	ps2mode(); //L[{[hL
	inputchar(); //1͑҂
	init_composite(); //pbĝ߉ʏ
	while(1){
		er=loadtextfile(TEMPFILENAME); //ꎞt@C߂
		if(er==0) break;
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("Cannot Load From SD Card\n");
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Hit Any Key to Retry\n");
		inputchar(); //1͑҂
	}
	if(er2<=0){
		//I܂̓t@CG[܂̓NG[̏ꍇ
		//J[\̈ʒuɐݒ
		disptopbp=postobpix(disptoppos,&disptopix);
		cursorbp=postobpix(cursorpos,&cursorix);
	}
	else{
		//RpCG[̏ꍇ
		//J[\G[sŉʃgbvɈړ
		disptopbp=linetobpix(er2,&disptopix);
		cursorbp=disptopbp;
		cursorix=disptopix;
		cx=0;
		cx2=0;
		cy=0;
		//ɂȂ悤XN[
		for(i=0;i<EDITWIDTHY/2;i++){
			//ʍsJ[\Ɉړ
			bp=disptopbp;
			ix=disptopix;
			cursor_up();
			if(bp==disptopbp && ix==disptopix) break; //ŏsňړłȂꍇ
		}
		for(;i>0;i--) cursor_down(); //YW܂ŃJ[\Ɉړ
	}
	cursorbp1=NULL; //͈͑I[h
	clipsize=0; //Nbv{[hNA
	FSremove(TEMPFILENAME); //ꎞt@C폜
}
void displaybottomline(void){
//GfB^[ʍŉs̕\
	setcursor(0,WIDTH_Y-1,COLOR_BOTTOMLINE);
//	printstr("F1:LOAD F2:SAVE   F5:RUN ");
	printstr("LOAD|SAVE|    |NEW |RUN  ");
	setcursorcolor(COLOR_ERRORTEXT);
	printnum2(TBUFMAXSIZE-num,5);
}
void normal_code_process(unsigned char k){
// ʏ핶͏
// k:͂ꂽR[h
	int i;

	edited=1; //ҏWς݃tO
	if(insertmode || k=='\n' || cursorbp1!=NULL){ //}[h
		if(cursorbp1!=NULL) deletearea();//I͈͂폜
		i=insertchar(cursorbp,cursorix,k);//eLXgobt@ɂP}
		if(i>0){
			//obt@󂫂̂ɑ}s̏ꍇ
			gabagecollect2(); //S̃Kx[WRNV
			i=insertchar(cursorbp,cursorix,k);//eLXgobt@ɂP}
		}
		if(i==0) cursor_right();//ʏAobt@̃J[\ʒu1Ɉړ
	}
	else{ //㏑[h
		i=overwritechar(cursorbp,cursorix,k);//eLXgobt@ɂP㏑
		if(i>0){
			//obt@󂫂̂ɏ㏑i}js̏ꍇ
			//isobt@Ōł͑}j
			gabagecollect2(); //S̃Kx[WRNV
			i=overwritechar(cursorbp,cursorix,k);//eLXgobt@ɂP㏑
		}
		if(i==0) cursor_right();//ʏAobt@̃J[\ʒu1Ɉړ
	}
}
void control_code_process(unsigned char k,unsigned char sh){
// 䕶͏
// k:䕶̉zL[R[h
// sh:Vtg֘AL[

	save_cursor(); //J[\֘AϐޔiJ[\ړłȂꍇ߂߁j
	switch(k){
		case VK_LEFT:
		case VK_NUMPAD4:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD4) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			if(sh & CHK_CTRL){
				//CTRL{Home
				cursor_home();
				break;
			}
			cursor_left();
			if(cursorbp1!=NULL && (disptopbp!=disptopbp_t || disptopix!=disptopix_t)){
				//͈͑I[hŉʃXN[ꍇ
				if(cy1<EDITWIDTHY-1) cy1++; //͈̓X^[gʒuXN[
				else restore_cursor(); //J[\ʒu߂iʔ͈͊O͈̔͑I֎~j
			}
			break;
		case VK_RIGHT:
		case VK_NUMPAD6:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD6) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			if(sh & CHK_CTRL){
				//CTRL{EEnd
				cursor_end();
				break;
			}
			cursor_right();
			if(cursorbp1!=NULL && (disptopbp!=disptopbp_t || disptopix!=disptopix_t)){
				//͈͑I[hŉʃXN[ꍇ
				if(cy1>0) cy1--; //͈̓X^[gʒuXN[
				else restore_cursor(); //J[\ʒu߂iʔ͈͊O͈̔͑I֎~j
			}
			break;
		case VK_UP:
		case VK_NUMPAD8:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD8) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			cursor_up();
			if(cursorbp1!=NULL && (disptopbp!=disptopbp_t || disptopix!=disptopix_t)){
				//͈͑I[hŉʃXN[ꍇ
				if(cy1<EDITWIDTHY-1) cy1++; //͈̓X^[gʒuXN[
				else restore_cursor(); //J[\ʒu߂iʔ͈͊O͈̔͑I֎~j
			}
			break;
		case VK_DOWN:
		case VK_NUMPAD2:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD2) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			cursor_down();
			if(cursorbp1!=NULL && (disptopbp!=disptopbp_t || disptopix!=disptopix_t)){
				//͈͑I[hŉʃXN[ꍇ
				if(cy1>0) cy1--; //͈̓X^[gʒuXN[
				else restore_cursor(); //J[\ʒu߂iʔ͈͊O͈̔͑I֎~j
			}
			break;
		case VK_HOME:
		case VK_NUMPAD7:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD7) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			cursor_home();
			break;
		case VK_END:
		case VK_NUMPAD1:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD1) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			cursor_end();
			break;
		case VK_PRIOR: // PageUpL[
		case VK_NUMPAD9:
			 //Vtg{PageUp͖iNumLock{Vtg{u9vj
			if((sh & CHK_SHIFT) && ((k!=VK_NUMPAD9) || ((sh & CHK_NUMLK)==0))) break;
			cursorbp1=NULL; //͈͑I[h
			cursor_pageup();
			break;
		case VK_NEXT: // PageDownL[
		case VK_NUMPAD3:
			 //Vtg{PageDown͖iNumLock{Vtg{u3vj
			if((sh & CHK_SHIFT) && ((k!=VK_NUMPAD3) || ((sh & CHK_NUMLK)==0))) break;
			cursorbp1=NULL; //͈͑I[h
			cursor_pagedown();
			break;
		case VK_DELETE: //DeleteL[
		case VK_DECIMAL: //eL[́u.v
			edited=1; //ҏWς݃tO
			if(cursorbp1!=NULL) deletearea();//I͈͂폜
			else deletechar(cursorbp,cursorix);
			break;
		case VK_BACK: //BackSpaceL[
			edited=1; //ҏWς݃tO
			if(cursorbp1!=NULL){
				deletearea();//I͈͂폜
				break;
			}
			if(cursorix==0 && cursorbp->prev==NULL) break; //obt@擪ł͖
			cursor_left();
			deletechar(cursorbp,cursorix);
			break;
		case VK_INSERT:
		case VK_NUMPAD0:
			insertmode^=1; //}[hA㏑[h؂ւ
			break;
		case 'C':
			//CTRL+CANbv{[hɃRs[
			if(cursorbp1!=NULL && (sh & CHK_CTRL)) clipcopy();
			break;
		case 'X':
			//CTRL+XANbv{[hɐ؂
			if(cursorbp1!=NULL && (sh & CHK_CTRL)){
				clipcopy();
				deletearea(); //I͈͂̍폜
				edited=1; //ҏWς݃tO
			}
			break;
		case 'V':
			//CTRL+VANbv{[h\t
			if((sh & CHK_CTRL)==0) break;
			if(clipsize==0) break;
			edited=1; //ҏWς݃tO
			if(cursorbp1!=NULL){
				//͈͑IĂ鎞͍폜Ă\t
				if(num-countarea()+clipsize<=TBUFMAXSIZE){ //obt@󂫗eʃ`FbN
					deletearea();//I͈͂폜
					clippaste();//Nbv{[h\t
				}
			}
			else{
				if(num+clipsize<=TBUFMAXSIZE){ //obt@󂫗eʃ`FbN
					clippaste();//Nbv{[h\t
				}
			}
			break;
		case 'S':
			//CTRL+SASDJ[hɕۑ
			if((sh & CHK_CTRL)==0) break;
		case VK_F2: //F2L[
			save_as(); //t@Ctĕۑ
			break;
		case 'O':
			//CTRL+OAt@Cǂݍ
			if((sh & CHK_CTRL)==0) break;
		case VK_F1: //F1L[
			//F1L[At@Cǂݍ
			if(selectfile()==0){ //t@CIēǂݍ
				//ǂݍ݂sꍇAJ[\ʒu擪
				cursor_top();
			}
			break;
		case 'N':
			//CTRL+NAVK쐬
			if((sh & CHK_CTRL)==0) break;
		case VK_F4: //F4L[
			newtext(); //VK쐬
			break;
		case VK_F5: //F5L[
			run(); //BASICvOs
			break;
	}
}
void texteditor(void){
//eLXgGfB^[{
	unsigned char k1,k2,k3,sh;

	TextBuffer=(_tbuf *)RAM;
	clipboard=(unsigned char *)TextBuffer+sizeof(_tbuf)*TBUFMAXLINE;
	filebuf=clipboard+EDITWIDTHX*EDITWIDTHY;
	filenames=(unsigned char (*)[])(filebuf+FILEBUFSIZE);

	inittextbuf(); //eLXgobt@
	currentfile[0]=0; //ƒt@CNA
	if(loadtextfile(TEMPFILENAME)==0) edited=1; //sꎞt@Cꍇ͓ǂݍ
	cursor_top(); //J[\eLXgobt@̐擪Ɉړ
	insertmode=1; //0:㏑A1:}
	clipsize=0; //Nbv{[hNA
	blinktimer=0; //J[\_Ń^C}[NA

	while(1){
		redraw();//ʍĕ`
		displaybottomline(); //ʍŉsɃt@NVL[@\\
		setcursor(cx,cy,COLOR_NORMALTEXT);
		getcursorchar(); //J[\ʒu̕ޔiJ[\_ŗpj
		while(1){
			//L[͑҂[v
			wait60thsec(1);  //601bEFCg
			blinkcursorchar(); //J[\_ł
			k1=ps2readkey(); //L[obt@ǂݍ݁Ak1:ʏ핶͂̏ꍇASCIIR[h
			if(vkey) break;  //L[ꂽꍇ[v甲
			if(cursorbp1==NULL) gabagecollect1(); //1oCgKx[WRNVi͈͑I͂Ȃj
		}
		resetcursorchar(); //J[\̕\ɖ߂
		k2=(unsigned char)vkey; //k2:zL[R[h
		sh=vkey>>8;             //sh:Vtg֘AL[
		if(k2==VK_RETURN || k2==VK_SEPARATOR) k1='\n'; //Enter͒Pɉs͂Ƃ
		if(k1) normal_code_process(k1); //ʏ핶͂ꂽꍇ
		else control_code_process(k2,sh); //䕶͂ꂽꍇ
		if(cursorbp1!=NULL && cx==cx1 && cy==cy1) cursorbp1=NULL;//I͈͂̊JnƏIdȂ͈͑I[h
 	}
}
