/*
   This file is provided under the LGPL license ver 2.1.
   Written by Katsumi.
   http://hp.vector.co.jp/authors/VA016157/
   kmorimatsu@users.sourceforge.jp
*/

#include <xc.h>
#include "api.h"
#include "compiler.h"

// Clock settings
// SYSCLK = 57272720 hz, PBCLK = 57272720 hz.

// Primary oscillator setting, XT for 3.58 MHz (between 3 and 10)
// This setting can be also used for external oscillator input
#pragma config POSCMOD = XT

// Primary Osc with PLL
#pragma config FNOSC = PRIPLL
// Div 1 to make 3.58 MHz
#pragma config FPLLIDIV = DIV_1
// Mul 16 to make 57 MHz
#pragma config FPLLMUL = MUL_16
// Div 1 to make 57 MHz
#pragma config FPLLODIV = DIV_1
#pragma config FPBDIV = DIV_1

// MISC disabled
#pragma config FCKSM = CSDCMD
#pragma config IESO = OFF
#pragma config FSOSCEN = OFF
#pragma config OSCIOFNC = OFF
#pragma config JTAGEN = OFF
#pragma config DEBUG = OFF
#pragma config PMDL1WAY = OFF
#pragma config IOL1WAY = OFF

#pragma ICESEL = ICS_PGx1

/* Prototypes */
char* init_file(char* buff);
char* compile_file();

char* printdec(int num){
	char str[11];
	int i;
	if (num<0) {
		printchar('-');
		num=0-num;
	}
	for(i=10;0<i;i--){
		if (num==0 && i<10) break;
		str[i]='0'+rem10_32(num);
		num=div10_32(num);
	}
	for(i++;i<11;i++) {
		printchar(str[i]);
	}
}

#define mBMXSetRAMKernProgOffset(offset)	(BMXDKPBA = (offset))
#define mBMXSetRAMUserDataOffset(offset)	(BMXDUDBA = (offset))
#define mBMXSetRAMUserProgOffset(offset)	(BMXDUPBA = (offset))

int main(){
	int i;
	char* buff;
	char* err;
	// Initialization
	// Make RAM executable. See also "char RAM[RAMSIZE]" in globalvars.c
	mBMXSetRAMKernProgOffset(0x8000-RAMSIZE);
	mBMXSetRAMUserDataOffset(0x8000);
	mBMXSetRAMUserProgOffset(0x8000);
	// Set grobal pointer
	g_gp=get_gp();
	// Set source positions
	buff=(char*)&(RAM[RAMSIZE-512]);
	g_source=(char*)(&buff[0]);
	g_srcpos=0;
	// Set object positions
	g_object=(int*)(&RAM[0]);
	g_objpos=0;
	g_objmax=g_object+RAMSIZE-512; // Buffer area excluded.
	// Initialize SD card file system
	err=init_file(buff);
	// Initialize screen
	TRISBCLR=0x1F;
	init_composite();
	clearscreen();
	start_composite();
	setcursor(0,0,7);
	printstr("BASIC KM-1110\n");
	for(i=0;i<4800000;i++){asm volatile("nop");}
	// Initialize music
	init_music();
	// Initialize PS/2 keyboard
	LATAbits.LATA1=1;
	ps2init();	

	// Check errors when opening file
	if (err) {
		printstr(err);
		while(1);
	}

	printstr("Compiling...");

	// Compile the file
	err=compile_file();
	if (err) {
		printstr(err);
		if (0<=g_srcpos) {
			// Compile error
			printstr("\nAround: '");
			for(i=0;i<5;i++){
				printchar(g_source[g_srcpos-2+i]);
			}
			printstr("' in line ");
			printdec(g_line);
			printstr("\n");
			for(i=g_srcpos;0x20<=g_source[i];i++);
			g_source[i]=0x00;
			for(i=g_srcpos;0x20<=g_source[i];i--);
			printstr(g_source+i);
		} else {
			// Link error
			printstr(resolve_label(g_label));
		}
		while(1){ asm volatile("nop"); }
	}
	printstr("done\n");
	for(i=0;i<4800000;i++){asm volatile("nop");}

	// Assign memory
	set_free_area((void*)(g_object+g_objpos),(void*)(&RAM[RAMSIZE]));
	// Execute program
	// Start program from the beginning of RAM.
	// Work area (used for A-Z values) is next to the object code area.
	start_program((void*)(&(RAM[0])),(void*)(&g_var_mem[0]));
	printstr("\nOK\n");

	while(1){ asm volatile("nop"); }
}
