/*
   This file is provided under the LGPL license ver 2.1.
   Written by K.Tanaka & Katsumi
   http://www.ze.em-net.ne.jp/~kenken/index.html
   http://hp.vector.co.jp/authors/VA016157/
*/

// main.c
// MachiKania BASIC System Ver Zoea
// KM-BASIC Js for PIC32MX170F256B / PIC32MX270F256B by K.Tanaka
// LCDo̓o[WieXgj by K.Tanaka

// pVXe
// libsdfsio.a F SDJ[hANZXpCu

#include <xc.h>
#include "api.h"
#include "compiler.h"
#include "editor.h"
#include "keyinput.h"
#include "main.h"

#define mBMXSetRAMKernProgOffset(offset)	(BMXDKPBA = (offset))
#define mBMXSetRAMUserDataOffset(offset)	(BMXDUDBA = (offset))
#define mBMXSetRAMUserProgOffset(offset)	(BMXDUPBA = (offset))

// INIt@CwL[[hi8ȓj
const char InitKeywords[][9]={
	"106KEY","101KEY","NUMLOCK","CAPSLOCK","SCRLLOCK"
};

void freadline(char *s,FSFILE *fp){
// t@C1sǂݍ݁AzsɕԂ
// ő8܂ŁB9ȏ̏ꍇ
// #܂0x20ȉ̃R[hꍇAȍ~͖
// s:9oCgȏ̔z
// fp:t@C|C^
	int n;
	char c,*p;
	n=0;
	p=s;
	*p=0;
	while(n<=8){
		if(FSfread(p,1,1,fp)==0 || *p=='\n'){
			*p=0;
			return;
		}
		if(*p=='#'){
			*p=0;
			break;
		}
		if(*p<=' '){
			if(n>0){
				*p=0;
				break;
			}
			continue;
		}
		p++;
		n++;
	}
	if(n>8) *s=0; //9ȏ̏̕ꍇ͖
	//ȍ~͖̕
	while(FSfread(&c,1,1,fp) && c!='\n') ;
}
int searchinittext(char *s){
// InitKeywordsz̒當sTAʒuꍇԖڂԂ
// Ȃꍇ-1Ԃ
	int i;
	char *p1;
	const char *p2;
	for(i=0;i<sizeof(InitKeywords)/sizeof(InitKeywords[0]);i++){
		p1=s;
		p2=InitKeywords[i];
		while(*p1==*p2){
			if(*p1==0) return i;
			p1++;
			p2++;
		}
	}
	return -1;
}
void readinifile(void){
	FSFILE *fp;
	char inittext[9];

	fp=FSfopen(INIFILE,"r");
	if(fp==NULL) return;
	printstr("Initialization File Found\n");
//	lockkey=0; //INIt@C݂ꍇALock֘AL[INIt@Cɏ]
	while(1){
		if(FSfeof(fp)) break;
		freadline(inittext,fp);
		switch(searchinittext(inittext)){
			case 0:
//				keytype=0;//{L[{[h
				break;
			case 1:
//				keytype=1;//pL[{[h
				break;
			case 2:
//				lockkey|=2;//Num Lock
				break;
			case 3:
//				lockkey|=4;//CAPS Lock
				break;
			case 4:
//				lockkey|=1;//Scroll Lock
				break;
		}
	}
	FSfclose(fp);
}

void printhex8(unsigned char d){
	printchar("0123456789ABCDEF"[d>>4]);
	printchar("0123456789ABCDEF"[d&0x0f]);	
}

void printhex16(unsigned short d){
	printhex8(d>>8);
	printhex8(d&0x00ff);
}

void printhex32(unsigned int d){
	printhex16(d>>16);
	printhex16(d&0x0000ffff);
}

int main(void){
	char *appname,*s;

	if(DEVCFG1 & 0x8000){
		// Set Clock switching enabled and reset
		NVMWriteWord(&DEVCFG1,DEVCFG1 & 0xffff7fff);
		SoftReset();
	}

	/* |[g̏ݒ */
	TRISA = 0x0000; // PORTASďo
	ANSELA = 0x0000; // SăfW^
	TRISB = 0x0000; // PORTBSďói{^ǂݍݎ̂ݓ͂ɐ؂ւj
	ANSELB = 0x0000; // SăfW^
	KEY_DS;
	LCD_CS_LO;

	// Ӌ@\s蓖
	SDI2R=2; //RPA4:SDI2
	RPA1R=4; //RPA1:SDO2

	// Make RAM executable. See also "char RAM[RAMSIZE]" in globalvars.c
	mBMXSetRAMKernProgOffset(PIC32MX_RAMSIZE-RAMSIZE);
	mBMXSetRAMUserDataOffset(PIC32MX_RAMSIZE);
	mBMXSetRAMUserProgOffset(PIC32MX_RAMSIZE);

	INTEnableSystemMultiVectoredInt();
	IPC2bits.T2IP = 4;			// 荞݃x4
	IFS0bits.T2IF = 0;
	IEC0bits.T2IE = 1;			// ^C}2荞ݗL
	PR2=3125;				// 601b
	T2CON = 0x8070;				// vXP[1:256A^C}2Jn

	init_textgraph();// pbgݒALCDNA
	setcursor(0,0,COLOR_NORMALTEXT);
	keystatus=0;

	// Show blue screen if exception before soft reset.
	blue_screen();

	printstr("MachiKania BASIC System\n");
	printstr(" Ver "SYSVER1" "SYSVER2" by KENKEN\n");
	printstr("BASIC Compiler "BASVER"\n");
	printstr(" by Katsumi\n\n");
	//SDJ[ht@CVXe
	setcursorcolor(COLOR_NORMALTEXT);
	printstr("Init File System...");
	// Initialize the File System
	if(FSInit()==FALSE){ //t@CVXe
		//G[̏ꍇ~
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("\nFile System Error\n");
		printstr("Insert Correct Card\n");
		printstr("And Reset\n");
		while(1) asm("wait");
	}
	printstr("OK\n");
	readinifile(); //INIt@Cǂݍ

	wait60thsec(60); //1b҂

	// sHEXt@CHEXFILEƈvꍇ̓GfB^N
	appname=(char*)FILENAME_FLASH_ADDRESS;
	s=HEXFILE;
	while(*s++==*appname++) if(*s==0) texteditor(); //eLXgGfB^[Ăяo

	// sHEXt@Ću.HEXvu.BASvɒuBASt@Cs
	appname=(char*)FILENAME_FLASH_ADDRESS;
	s=tempfile;
	while(*appname!='.') *s++=*appname++;
	appname=".BAS";
	while(*appname!=0) *s++=*appname++;
	*s=0;
	// buttonmode(); //{^L
	g_disable_break=1; // BreakL[
	runbasic(tempfile,0);
	while(1) asm(WAIT);
}
