// nauplia.c
// KM-BASIC 統合開発実行環境 for PIC32MX150F128B / PIC32MX250F128B by K.Tanaka

// 利用システム
// ps2keyboard.X.a : PS/2キーボード入力システムライブラリ
// lib_colortext32.a : カラービデオ信号出力システムライブラリ（30×27テキスト版）
// libsdfsio.a ： SDカードアクセス用ライブラリ

#include <xc.h>
#include "api.h"
#include "compiler.h"
#include "editor.h"
#include "keyinput.h"

//外付けクリスタル with PLL (16倍)
#pragma config PMDL1WAY = OFF, IOL1WAY = OFF
#pragma config FPLLIDIV = DIV_1, FPLLMUL = MUL_16, FPLLODIV = DIV_1
#pragma config FNOSC = PRIPLL, FSOSCEN = OFF, POSCMOD = XT, OSCIOFNC = OFF
#pragma config FPBDIV = DIV_1, FWDTEN = OFF, JTAGEN = OFF, ICESEL = ICS_PGx1

#define mBMXSetRAMKernProgOffset(offset)	(BMXDKPBA = (offset))
#define mBMXSetRAMUserDataOffset(offset)	(BMXDUDBA = (offset))
#define mBMXSetRAMUserProgOffset(offset)	(BMXDUPBA = (offset))


int main(void){
	/* ポートの初期設定 */
	TRISA = 0x0000; // PORTA全て出力
	ANSELA = 0x0000; // 全てデジタル
	TRISB = KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// ボタン接続ポート入力設定
	ANSELB = 0x0000; // 全てデジタル
	CNPUBSET=KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// プルアップ設定
	ODCB = 0x0300;	//RB8,RB9はオープンドレイン

    // 周辺機能ピン割り当て
	SDI2R=2; //RPA4:SDI2
	RPB5R=4; //RPB5:SDO2

	// Make RAM executable. See also "char RAM[RAMSIZE]" in globalvars.c
	mBMXSetRAMKernProgOffset(0x8000-RAMSIZE);
	mBMXSetRAMUserDataOffset(0x8000);
	mBMXSetRAMUserProgOffset(0x8000);

	ps2mode(); //RA1オン（PS/2有効化マクロ）
	init_composite(); // ビデオメモリクリア、割り込み初期化、カラービデオ出力開始
	setcursor(0,0,COLOR_NORMALTEXT);

	printstr("                              ");
	printstr("PIC32MX Video Game System\n");
	printstr(" Version Nauplia 1.0 by KENKEN");
	printstr("KM-BASIC for MIPS by Katsumi\n");
	printstr(" Version 1.1\n\n");
	printstr("Init PS/2...");
	if(ps2init()){ //PS/2初期化
		//エラーの場合ストップ
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("\nPS/2 Error\n");
		printstr("Power Off and Check Keyboard\n");
		while(1) asm("wait"); //無限ループ
	}
	printstr("OK\n");

	//SDカードファイルシステム初期化
	while(1){
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Init File System...");
		// Initialize the File System
		if(FSInit()) break; //ファイルシステム初期化、OKなら抜ける
		//エラーの場合やり直し
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("\nFile System Error\n");
		printstr("Insert Correct Card\n");
		printstr("And Hit Any Key\n");
		inputchar(); //1文字キー入力待ち
	}
	printstr("OK\n");
	wait60thsec(60); //1秒待ち

	texteditor(); //テキストエディター本体呼び出し
}
