/*
   This file is provided under the LGPL license ver 2.1.
   Written by Katsumi.
   http://hp.vector.co.jp/authors/VA016157/
   kmorimatsu@users.sourceforge.jp
*/

#include <xc.h>
#include "api.h"
#include "compiler.h"
#include "editor.h"

FSFILE* g_fhandle;
char* g_fbuff;

//#define FILENAME_FLASH_ADDRESS 0x9D005800

char* init_file(char* buff){
/*
	int i,j;
	char* appname;
	char fname[15];

 	// Init microcontroller
	TRISAbits.TRISA4=1; // Input
	ANSELACLR=1<<4;     // Digital
	TRISAbits.TRISA0=0; // Output
	TRISBbits.TRISB5=0; // Output
	SDI2R=2;            // RPA4:SDI2
	RPB5R=4;            // RPB5:SDO2
	CNPUASET=0x0010;    // Pullup RA4
	// Connect to SD card
	if (!FSInit()) {
		return "SD card cannot be initialized.";
	}
	// Determine application names
	appname=(char*)FILENAME_FLASH_ADDRESS;
	for(i=0;(fname[i]=appname[i])!='.';i++){
		if (appname[i]<'0' || '_'<appname[i]) {
			i=0;
			break;
		}
	}
	if (i==0) {
		appname="BASIC.TXT";
	} else {
		for(j=0;(fname[++i]="TXT"[j]);j++);
		appname=&fname[0];
	}
*/
	// Open file
//	g_fhandle=FSfopen(appname,"r");
	g_fhandle=FSfopen(TEMPFILENAME,"r");
	if (!g_fhandle) {
		return "Source file cannot be opened.";
	}
	g_fbuff=buff;
	g_line=0;
	g_fileline=0;
	return 0;
}

char* compile_file(){
	int i,size;
	int in_string;
	char* err;
	
	in_string=0;

	// Read first 512 bytes (all uppercase).
	size=FSfread((void*)&g_fbuff[0],1,512,g_fhandle);
	for(i=0;i<512;i++){
		if ('a'<=g_fbuff[i] && g_fbuff[i]<='z' && !in_string) g_fbuff[i]+='A'-'a';
		if (g_fbuff[i]=='"') in_string=1-in_string;
		if (g_fbuff[i]==0x0a || g_fbuff[i]==0x0d) in_string=0;
	}
	while (size==512) {
		while(g_srcpos<256){
			err=compile_line();
			if (err) return err;
		}
		// Shift buffer and source position 256 bytes.
		for(i=0;i<256;i++) g_fbuff[i]=g_fbuff[i+256];
		g_srcpos-=256;
		// Read next 256 line (all uppercase).
		size=256+FSfread((void*)&g_fbuff[256],1,256,g_fhandle);
		for(i=256;i<512;i++){
			if ('a'<=g_fbuff[i] && g_fbuff[i]<='z' && !in_string) g_fbuff[i]+='A'-'a';
			if (g_fbuff[i]=='"') in_string=1-in_string;
			if (g_fbuff[i]==0x0a || g_fbuff[i]==0x0d) in_string=0;
		}
	}
	// Null charcter at the end
	g_source[size]=0x00;
	// Compile last few lines.
	while(g_srcpos<size-1){
		err=compile_line();
		if (err) return err;
	}
	// Add "END" statement.
	g_source="END\n";
	g_srcpos=0;
	err=compile_line();
	if (err) return err;
	// Link
	g_srcpos=-1;
	err=link();
	if (err) return err;
	// No error occured
	return 0;
}

