package com.mxmobiling.kitting;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.xml.serializer.OutputPropertiesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
/**
 * 旧Verです。使用していません。
 */
class WebClipGUIVer2 extends JFrame implements ActionListener {

	private static final long serialVersionUID = 1L;

	private String lastDirPath = "lib/lastdir.txt";

	private String displayName = ""; // プロファイル名
	private String description = ""; // プロファイルの説明
	private Boolean deleteProfile = false; // プロファイル削除可否

	private JCheckBox inputClipChk;
	private JCheckBox webClipChk;
	private JCheckBox smsmClipChk;
	private JCheckBox gmailChk;

	private JTextField profileNameText;
	private JTextField profileDescriptionText;
	private JTextField profileSaveText;

	private static final String APPTITLE = "作業用構成プロファイル作成ツール　Ver 2.1.1";
	private JTextField inputClipText;
	private JTextField webClipText;
	private JTextField smsmCompanyCodeText;
	private JTextField smsmAuthCodeText;
	private JTextField gmailAddressText;
	private JTextField gmailPasswordText;
	private JTextField fileNameText;

	public static void main(String args[]) {
		WebClipGUIVer2 frame = new WebClipGUIVer2(APPTITLE);
		frame.setVisible(true);
		frame.setResizable(false);
		frame.setLocationRelativeTo(null);
	}

	WebClipGUIVer2(String title) {
		setTitle(title);
		setSize(700, 550);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// アイコンファイルの読み込み
		String iconFileName = "img/icon.png";
		URL iconUrl = this.getClass().getClassLoader()
				.getResource(iconFileName);

		Image icon = (iconUrl != null) ? new ImageIcon(iconUrl).getImage()
				: new ImageIcon(iconFileName).getImage();
		setIconImage(icon);

		/* ---------- ↓アプリタイトル名ラベル↓ ---------- */
		getContentPane().setLayout(null);

		JLabel appTitleLabel = new JLabel(APPTITLE);
		appTitleLabel.setBounds(35, 23, 430, 36);
		appTitleLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.BOLD, 20));
		getContentPane().add(appTitleLabel);

		JLabel label = new JLabel("※＝必須パラメータ");
		label.setBounds(341, 69, 120, 13);
		getContentPane().add(label);

		/* ---------- ↑アプリタイトル名ラベル↑ ---------- */

		/* ---------- ↓メニューバー↓ ---------- */

		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);

		JMenu files = new JMenu("ファイル");
		menuBar.add(files);
		JMenuItem open = new JMenuItem("開く");
		open.setActionCommand("開く");
		files.add(open);
		JMenuItem overwriteSave = new JMenuItem("上書き保存");
		overwriteSave.setActionCommand("上書き保存");
		files.add(overwriteSave);
		JMenuItem saveAs = new JMenuItem("名前をつけて保存");
		saveAs.setActionCommand("名前をつけて保存");
		files.add(saveAs);
		JMenuItem quit = new JMenuItem("終了");
		quit.setActionCommand("終了");
		files.add(quit);

		/* ---------- ↑メニューバー↑ ---------- */

		/* ---------- ↓作成プロファイルチェックボックス↓ ---------- */

		@SuppressWarnings("unused")
		Container contentPane = getContentPane();

		JPanel createProfileLabel = new JPanel();
		createProfileLabel.setBounds(507, 10, 165, 123);
		createProfileLabel.setBorder(new TitledBorder(new EtchedBorder(),
				"作成プロファイル"));
		getContentPane().add(createProfileLabel);
		createProfileLabel.setLayout(null);

		inputClipChk = new JCheckBox("入力支援Webクリップ");
		inputClipChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 10));
		inputClipChk.setBounds(8, 22, 138, 21);
		createProfileLabel.add(inputClipChk);

		webClipChk = new JCheckBox("Webサイトショートカット");
		webClipChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 10));
		webClipChk.setBounds(8, 45, 138, 21);
		createProfileLabel.add(webClipChk);

		smsmClipChk = new JCheckBox("SMSM用JavaScript");
		smsmClipChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 10));
		smsmClipChk.setBounds(8, 68, 138, 21);
		createProfileLabel.add(smsmClipChk);

		gmailChk = new JCheckBox("作業用Gmailアドレス");
		gmailChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 10));
		gmailChk.setBounds(8, 91, 138, 21);
		createProfileLabel.add(gmailChk);

		/* ---------- ↑作成プロファイルチェックボックス↑ ---------- */

		/* ---------- ↓作成プロファイルタブ↓ ---------- */

		JTabbedPane tabLayout = new JTabbedPane(JTabbedPane.TOP);
		tabLayout.setBounds(12, 143, 660, 123);
		getContentPane().add(tabLayout);

		JPanel inputClipPanel = new JPanel();
		tabLayout.addTab("入力支援", null, inputClipPanel, null);
		inputClipPanel.setBackground(Color.WHITE);
		inputClipPanel.setLayout(null);

		JLabel inputClipLabel = new JLabel("※CSV読み込み先");
		inputClipLabel.setBounds(12, 10, 110, 30);
		inputClipPanel.add(inputClipLabel);

		inputClipText = new JTextField(50);
		inputClipText.setBounds(134, 11, 430, 30);
		inputClipPanel.add(inputClipText);

		JButton inputClipBtn = new JButton("参照");
		inputClipBtn.setActionCommand("入力支援CSV");
		inputClipBtn.setBounds(578, 10, 65, 30);
		inputClipPanel.add(inputClipBtn);

		JPanel webClipPanel = new JPanel();
		tabLayout.addTab("Webサイト", null, webClipPanel, null);
		webClipPanel.setBackground(Color.WHITE);
		webClipPanel.setLayout(null);

		JLabel webClipLabel = new JLabel("※CSV読み込み先");
		webClipLabel.setBounds(12, 10, 110, 30);
		webClipPanel.add(webClipLabel);

		webClipText = new JTextField(50);
		webClipText.setBounds(134, 11, 430, 30);
		webClipPanel.add(webClipText);

		JButton webClipBtn = new JButton("参照");
		webClipBtn.setActionCommand("WebクリップCSV");
		webClipBtn.setBounds(578, 10, 65, 30);
		webClipPanel.add(webClipBtn);

		JPanel smsmPanel = new JPanel();
		tabLayout.addTab("SMSM", null, smsmPanel, null);
		smsmPanel.setBackground(Color.WHITE);
		smsmPanel.setLayout(null);

		JLabel smsmCompanyCodeLabel = new JLabel("※企業コード");
		smsmCompanyCodeLabel.setBounds(12, 10, 100, 30);
		smsmPanel.add(smsmCompanyCodeLabel);

		JLabel smsmAuthCodeLabel = new JLabel("※認証コード");
		smsmAuthCodeLabel.setBounds(12, 50, 100, 30);
		smsmPanel.add(smsmAuthCodeLabel);

		smsmCompanyCodeText = new JTextField(50);
		smsmCompanyCodeText.setBounds(124, 11, 507, 30);
		smsmPanel.add(smsmCompanyCodeText);

		smsmAuthCodeText = new JTextField(50);
		smsmAuthCodeText.setBounds(124, 51, 507, 30);
		smsmPanel.add(smsmAuthCodeText);

		JPanel gmailPanel = new JPanel();
		tabLayout.addTab("作業用Gmail", null, gmailPanel, null);
		gmailPanel.setBackground(Color.WHITE);
		gmailPanel.setLayout(null);

		JLabel gmailAddressLabel = new JLabel("※Gmailアドレス");
		gmailAddressLabel.setBounds(12, 10, 100, 30);
		gmailPanel.add(gmailAddressLabel);

		JLabel gmailPasswordLabel = new JLabel("パスワード");
		gmailPasswordLabel.setBounds(12, 50, 100, 30);
		gmailPanel.add(gmailPasswordLabel);

		gmailAddressText = new JTextField(50);
		gmailAddressText.setBounds(124, 11, 507, 30);
		gmailPanel.add(gmailAddressText);

		gmailPasswordText = new JTextField(50);
		gmailPasswordText.setBounds(124, 51, 507, 30);
		gmailPanel.add(gmailPasswordText);

		/* ---------- ↑作成プロファイルタブ↑ ---------- */

		/* ---------- ↓プロファイル基本情報↓ ---------- */

		JLabel fileNameLabel = new JLabel("※ファイル名");
		fileNameLabel.setBounds(11, 276, 140, 30);
		getContentPane().add(fileNameLabel);
		fileNameText = new JTextField(50);
		fileNameText.setBounds(146, 276, 526, 30);
		getContentPane().add(fileNameText);

		JLabel profileNameLabel = new JLabel("プロファイル名");
		profileNameLabel.setBounds(11, 315, 140, 30);
		getContentPane().add(profileNameLabel);
		profileNameText = new JTextField(50);
		profileNameText.setBounds(146, 316, 526, 30);
		getContentPane().add(profileNameText);

		JLabel profileDescriptionLabel = new JLabel("プロファイルの説明");
		profileDescriptionLabel.setBounds(11, 355, 140, 30);
		getContentPane().add(profileDescriptionLabel);
		profileDescriptionText = new JTextField(50);
		profileDescriptionText.setBounds(146, 356, 526, 30);
		getContentPane().add(profileDescriptionText);

		JLabel profileSaveLabel = new JLabel("※プロファイル保存先");
		profileSaveLabel.setBounds(11, 396, 140, 30);
		getContentPane().add(profileSaveLabel);
		profileSaveText = new JTextField(43);
		profileSaveText.setBounds(146, 397, 450, 30);
		getContentPane().add(profileSaveText);

		JButton profileSaveBtn = new JButton("参照");
		profileSaveBtn.setBounds(606, 396, 65, 30);
		getContentPane().add(profileSaveBtn);
		profileSaveBtn.setActionCommand("プロファイル保存先");

		JButton profileCreateBtn = new JButton("プロファイル作成");
		profileCreateBtn.setBounds(68, 450, 553, 30);
		getContentPane().add(profileCreateBtn);
		profileCreateBtn.setActionCommand("プロファイル作成");

		/* ---------- ↑プロファイル基本情報↑ ---------- */

		// ボタン押下時のリスナー
		open.addActionListener(this); // メニューの開くボタン
		overwriteSave.addActionListener(this); // メニューの上書き保存ボタン
		saveAs.addActionListener(this); // メニューの名前をつけて保存ボタン
		quit.addActionListener(this); // メニューの終了ボタン
		inputClipBtn.addActionListener(this); // 入力支援クリップCSV参照ボタン
		webClipBtn.addActionListener(this); // WebクリップCSV参照ボタン
		profileSaveBtn.addActionListener(this); // プロファイル保存先フォルダ参照ボタン
		profileCreateBtn.addActionListener(this); // プロファイル作成ボタン
	}

	// 最後に使ったパスを格納
	String lastOpenOrSavePath = "";

	public void actionPerformed(ActionEvent e) {
		String str = e.getActionCommand();

		File file = null;
		JFileChooser filechooser = new JFileChooser();

		// カレントディレクトリを最後に開いたフォルダとし、
		// テキストファイルに記録されているパスを読み込む
		try {
			FileReader in = new FileReader(lastDirPath);
			BufferedReader br = new BufferedReader(in);
			String line;
			while ((line = br.readLine()) != null) {
				File currentDir = new File(line);
				filechooser.setCurrentDirectory(currentDir);
			}
			br.close();
			in.close();
		} catch (IOException err) {
			System.out.println(err);
		}

		// メニュー内のボタンクリック時の動作
		if (str.equals("開く")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"workprofファイル(*.workprof)", "workprof");
			filechooser.addChoosableFileFilter(filter);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				// 読み込むパラメータの準備
				List<String> workfile = WorkProfOpen(file.getPath());

				// 入力支援CSVのパスをセットする
				inputClipChk.setSelected(Boolean.valueOf(workfile.get(0)));
				webClipChk.setSelected(Boolean.valueOf(workfile.get(1)));
				smsmClipChk.setSelected(Boolean.valueOf(workfile.get(2)));
				gmailChk.setSelected(Boolean.valueOf(workfile.get(3)));
				inputClipText.setText(workfile.get(4));
				webClipText.setText(workfile.get(5));
				smsmCompanyCodeText.setText(workfile.get(6));
				smsmAuthCodeText.setText(workfile.get(7));
				gmailAddressText.setText(workfile.get(8));
				gmailPasswordText.setText(workfile.get(9));
				fileNameText.setText(workfile.get(10));
				profileNameText.setText(workfile.get(11));
				profileDescriptionText.setText(workfile.get(12));
				profileSaveText.setText(workfile.get(13));

				// 最後に開いたフォルダを更新
				CurrentDir(file.getParent());

				// 最後に開いたファイルを更新
				lastOpenOrSavePath = file.getPath();
			}
		} else if (str.equals("上書き保存") && !lastOpenOrSavePath.equals("")) {
			// 書き出すパラメータの準備
			ArrayList<String> workfile = new ArrayList<String>();

			workfile.add(String.valueOf(inputClipChk.isSelected()));
			workfile.add(String.valueOf(webClipChk.isSelected()));
			workfile.add(String.valueOf(smsmClipChk.isSelected()));
			workfile.add(String.valueOf(gmailChk.isSelected()));
			workfile.add(inputClipText.getText());
			workfile.add(webClipText.getText());
			workfile.add(smsmCompanyCodeText.getText());
			workfile.add(smsmAuthCodeText.getText());
			workfile.add(gmailAddressText.getText());
			workfile.add(gmailPasswordText.getText());
			workfile.add(fileNameText.getText());
			workfile.add(profileNameText.getText());
			workfile.add(profileDescriptionText.getText());
			workfile.add(profileSaveText.getText());

			// ファイルの保存
			WorkProfSave(lastOpenOrSavePath, workfile);
		} else if (str.equals("名前をつけて保存")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"workprofファイル(*.workprof)", "workprof");
			filechooser.addChoosableFileFilter(filter);
			int selected = filechooser.showSaveDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				// 書き出すパラメータの準備
				ArrayList<String> workfile = new ArrayList<String>();

				workfile.add(String.valueOf(inputClipChk.isSelected()));
				workfile.add(String.valueOf(webClipChk.isSelected()));
				workfile.add(String.valueOf(smsmClipChk.isSelected()));
				workfile.add(String.valueOf(gmailChk.isSelected()));
				workfile.add(inputClipText.getText());
				workfile.add(webClipText.getText());
				workfile.add(smsmCompanyCodeText.getText());
				workfile.add(smsmAuthCodeText.getText());
				workfile.add(gmailAddressText.getText());
				workfile.add(gmailPasswordText.getText());
				workfile.add(fileNameText.getText());
				workfile.add(profileNameText.getText());
				workfile.add(profileDescriptionText.getText());
				workfile.add(profileSaveText.getText());

				// ファイルの保存
				WorkProfSave(file.getPath() + ".workprof", workfile);

				// 最後に開いたフォルダを更新
				CurrentDir(file.getParent());

				// 最後に保存したファイルを更新
				lastOpenOrSavePath = file.getPath() + ".workprof";
			}
		} else if (str.equals("終了")) {
			System.exit(0);
		}

		// メニュー以外のボタンクリック時の動作
		if (str.equals("入力支援CSV")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"CSVファイル(*.csv)", "csv");
			filechooser.addChoosableFileFilter(filter);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				// 入力支援CSVのパスをセットする
				inputClipText.setText(file.getPath());

				// 最後に開いたフォルダを更新
				CurrentDir(file.getPath());
			}
		} else if (str.equals("WebクリップCSV")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"CSVファイル(*.csv)", "csv");
			filechooser.addChoosableFileFilter(filter);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				// WebサイトCSVのパスをセットする
				webClipText.setText(file.getPath());

				// 最後に開いたフォルダを更新
				CurrentDir(file.getPath());
			}
		} else if (str.equals("プロファイル保存先")) {
			filechooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				// プロファイル保存先のパスをセットする
				profileSaveText.setText(file.getPath());

				// 最後に開いたフォルダを更新
				CurrentDir(file.getPath());
			}
		} else if (str.equals("プロファイル作成")) {
			/* ---------- エラー処理（入力漏れ等）ここから ---------- */

			// どのチェックボックスも選択されていない場合
			if (!inputClipChk.isSelected() && !webClipChk.isSelected()
					&& !smsmClipChk.isSelected() && !gmailChk.isSelected()) {
				JLabel error = new JLabel("作成プロファイルが選択されていません");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// 入力支援の必須パラメータ未入力の場合
			if (inputClipChk.isSelected() && inputClipText.getText().equals("")) {
				JLabel error = new JLabel("入力支援の必須パラメータが未入力です");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// Webサイトの必須パラメータ未入力の場合
			if (webClipChk.isSelected() && webClipText.getText().equals("")) {
				JLabel error = new JLabel("Webサイトの必須パラメータが未入力です");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// SMSMクリップの必須パラメータ未入力の場合
			if (smsmClipChk.isSelected()
					&& (smsmCompanyCodeText.getText().equals("") || smsmAuthCodeText
							.getText().equals(""))) {
				JLabel error = new JLabel("SMSMの必須パラメータが未入力です");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// 作業用Gmailアドレスの必須パラメータ未入力の場合
			if (gmailChk.isSelected()
					&& (gmailAddressText.getText().equals(""))) {
				JLabel error = new JLabel("作業用Gmailの必須パラメータが未入力です");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// ファイル名、プロファイル保存先が未指定の場合
			if (fileNameText.getText().equals("")
					|| profileSaveText.getText().equals("")) {
				JLabel error = new JLabel("【ファイル名】と【プロファイル保存先】を指定してください");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			/* ---------- エラー処理（入力漏れ等）ここまで ---------- */

			// プロファイル生成
			try {
				wepclipProfileCreate();
				JLabel label = new JLabel("プロファイル作成完了！！");
				JOptionPane.showMessageDialog(this, label);
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			} catch (FileNotFoundException e1) {
				// おかしなパラメータが入力されている場合
				JLabel error = new JLabel("存在しないフォルダが指定されています。");
				JOptionPane.showMessageDialog(this, error);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			} catch (TransformerException e1) {
				e1.printStackTrace();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}
	}

	// 構成プロファイル生成
	private void wepclipProfileCreate() throws ParserConfigurationException,
			IOException, InterruptedException, TransformerException {

		// インスタンスの生成
		Common common = new Common();
		WebClip webClip = new WebClip();
		Email email = new Email();

		// 入力支援ブランク用画像の読み込み
		String imgName1 = "img/icon1.png";

		// 入力支援本体用画像の読み込み
		String imgName2 = "img/icon2.png";

		String[] iconImages = { imgName1, imgName2 };

		// SMSM用JavaScript画像
		String smsmImg = "img/smsm.png";

		// ファイル名反映
		String fileName = fileNameText.getText();

		// 構成プロファイルの吐き出し先
		String exportFileName = profileSaveText.getText() + "\\" + fileName
				+ ".mobileconfig";

		/* ----- 構成プロファイルを生成する ----- */

		// DOM Documentのインスタンスを生成するBuilderクラスの
		// インスタンスを取得する
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		// ビルダーからDOMを取得する
		Document document = builder.newDocument();

		// root(plist)タグ
		Element plist = document.createElement("plist");
		plist.setAttribute("version", "1.0");
		document.appendChild(plist);

		// dictタグ
		Element dict = document.createElement("dict");
		plist.appendChild(dict);

		// plistタグのパラメータ
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer();
		transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		transformer.setOutputProperty(
				OutputPropertiesFactory.S_KEY_INDENT_AMOUNT, "2");
		transformer.setOutputProperty(OutputKeys.METHOD, "xml");
		transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
		transformer.setOutputProperty(OutputKeys.DOCTYPE_PUBLIC,
				"-//Apple//DTD PLIST 1.0//EN");
		transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM,
				"http://www.apple.com/DTDs/PropertyList-1.0.dtd");

		/* ------ 以下、構成プロファイルの中身 ------------ */

		/*
		 * PayloadContent
		 *
		 * ペイロードされるパラメータ
		 */
		Element PayloadContentKey = document.createElement("key");
		dict.appendChild(PayloadContentKey);

		Text PayloadContentParam = document.createTextNode("PayloadContent");
		PayloadContentKey.appendChild(PayloadContentParam);

		Element PayloadContentArray = document.createElement("array");
		dict.appendChild(PayloadContentArray);

		/* ---------- 入力支援Webクリップ設定パラメータここから ---------- */

		// 入力支援Webクリップが選択されている場合、実行
		if (inputClipChk.isSelected()) {
			// 入力支援Webクリップは必ず二つセットになるので、2回ループ
			for (int i = 1; i < 3; i++) {
				Element PayloadContentDict = document.createElement("dict");
				PayloadContentArray.appendChild(PayloadContentDict);

				webClip.WebcilpIsRemovable(PayloadContentDict, document, true);

				String label = "入力支援" + String.valueOf(i);
				webClip.WebclipLabel(PayloadContentDict, document,
						WebClip.STRING, label);

				webClip.WebclipIcon(PayloadContentDict, document, "data",
						iconImages[i - 1]);

				String webDescription = "入力支援Webクリップ" + String.valueOf(i);
				common.PayloadDescription(PayloadContentDict, document,
						Common.STRING, webDescription);

				String webDisplayName = "InputWebClip";
				common.PayloadDisplayName(PayloadContentDict, document,
						Common.STRING, webDisplayName);

				common.PayloadIdentifier(PayloadContentDict, document,
						Common.STRING,
						"jp.kddi.workprof.webclip" + String.valueOf(i));

				String webCompanyName = "";
				common.PayloadOrganization(PayloadContentDict, document,
						Common.STRING, webCompanyName);

				common.PayloadType(PayloadContentDict, document, Common.STRING,
						"com.apple.webClip.managed");

				common.PayloadUUID(PayloadContentDict, document, Common.STRING);

				common.PayloadVersion(PayloadContentDict, document,
						Common.INTEGER, "1");

				// 入力支援JavaScript生成
				String URL = JavascriptCreate(inputClipText.getText());

				// 1回目がブランククリップ、2回目がJavaScript本体
				if (i == 1) {
					webClip.WebclipURL(PayloadContentDict, document,
							WebClip.STRING, "about:blank");
				} else {
					webClip.WebclipURL(PayloadContentDict, document,
							WebClip.STRING, URL);
				}
			}
		}

		/* ---------- 入力支援Webクリップ設定パラメータここまで ---------- */

		/* ---------- Webクリップ設定パラメータここから ---------- */

		// Webクリップが選択されている場合、実行
		if (webClipChk.isSelected()) {

			// カウンタ
			int i = 1;

			// Webクリップはパラメータ数に応じてループ回数変更
			try {
				File csv = new File(webClipText.getText()); // CSVデータファイル

				BufferedReader br = new BufferedReader(new FileReader(csv));

				// 1行目（ヘッダ行）を読み飛ばす
				br.readLine();

				// 最終行まで読み込む
				String line = "";
				while ((line = br.readLine()) != null) {
					Element PayloadContentDict = document.createElement("dict");
					PayloadContentArray.appendChild(PayloadContentDict);

					webClip.WebcilpIsRemovable(PayloadContentDict, document,
							true);

					// webClip.WebclipIcon(PayloadContentDict, document, "data",
					// iconImages[i - 1]);

					String webDescription = "Webクリップ" + String.valueOf(i);
					common.PayloadDescription(PayloadContentDict, document,
							Common.STRING, webDescription);

					String webDisplayName = "WebClip";
					common.PayloadDisplayName(PayloadContentDict, document,
							Common.STRING, webDisplayName);

					common.PayloadIdentifier(PayloadContentDict, document,
							Common.STRING,
							"jp.kddi.workprof.webclip" + String.valueOf(i));

					String webCompanyName = "";
					common.PayloadOrganization(PayloadContentDict, document,
							Common.STRING, webCompanyName);

					common.PayloadType(PayloadContentDict, document,
							Common.STRING, "com.apple.webClip.managed");

					common.PayloadUUID(PayloadContentDict, document,
							Common.STRING);

					common.PayloadVersion(PayloadContentDict, document,
							Common.INTEGER, "1");

					// 1行をデータの要素に分割
					StringTokenizer st = new StringTokenizer(line, ",");
					while (st.hasMoreTokens()) {
						// 1行の各要素（表示名とURL）を読み込む
						// 表示名
						webClip.WebclipLabel(PayloadContentDict, document,
								WebClip.STRING, st.nextToken());

						// URL
						webClip.WebclipURL(PayloadContentDict, document,
								WebClip.STRING, st.nextToken());
					}
					i++;
				}
				br.close();

			} catch (FileNotFoundException e) {
				// Fileオブジェクト生成時の例外捕捉
				e.printStackTrace();
			} catch (IOException e) {
				// BufferedReaderオブジェクトのクローズ時の例外捕捉
				e.printStackTrace();
			}
		}

		/* ---------- Webクリップ設定パラメータここまで ---------- */

		/* ---------- SMSMクリップ設定パラメータここから ---------- */

		// SMSMクリップが選択されている場合、実行
		if (smsmClipChk.isSelected()) {
			// SMSMクリップは必ず１つになるので、ループなし
			Element PayloadContentDict = document.createElement("dict");
			PayloadContentArray.appendChild(PayloadContentDict);

			webClip.WebcilpIsRemovable(PayloadContentDict, document, true);

			String label = "SMSM";
			webClip.WebclipLabel(PayloadContentDict, document, WebClip.STRING,
					label);

			webClip.WebclipIcon(PayloadContentDict, document, "data", smsmImg);

			String webDescription = "SMSMクリップ";
			common.PayloadDescription(PayloadContentDict, document,
					Common.STRING, webDescription);

			String webDisplayName = "SMSMWebClip";
			common.PayloadDisplayName(PayloadContentDict, document,
					Common.STRING, webDisplayName);

			common.PayloadIdentifier(PayloadContentDict, document,
					Common.STRING, "jp.kddi.workprof.webclip");

			String webCompanyName = "";
			common.PayloadOrganization(PayloadContentDict, document,
					Common.STRING, webCompanyName);

			common.PayloadType(PayloadContentDict, document, Common.STRING,
					"com.apple.webClip.managed");

			common.PayloadUUID(PayloadContentDict, document, Common.STRING);

			common.PayloadVersion(PayloadContentDict, document, Common.INTEGER,
					"1");

			// smsmCompanyCodeText = 企業コード
			// smsmAuthCodeText = 認証コード
			String smsmURL = "javascript:document.write('<body><form action=\""
					+ "https://ausl.smartmanager.jp/setup/ios"
					+ "\" method=\"POST\"><input name=\"ios_customer[code]\" value=\""
					+ smsmCompanyCodeText.getText()
					+ "\"><input name=\"ios_customer[certification_code]\" value=\""
					+ smsmAuthCodeText.getText()
					+ "\"></form><script type=\"text/javascript\">document.forms[0].submit();</script></body>');";

			// 禁止文字の置き換え
			smsmURL = smsmURL.replace("<", "%3C");
			smsmURL = smsmURL.replace(">", "%3E");
			smsmURL = smsmURL.replace("\"", "%22");
			smsmURL = smsmURL.replace("[", "%5B");
			smsmURL = smsmURL.replace("]", "%5D");
			smsmURL = smsmURL.replace("{", "%7B");
			smsmURL = smsmURL.replace("}", "%7D");
			smsmURL = smsmURL.replace(" ", "%20");
			smsmURL = smsmURL.replace("?", "%3F");

			// 生成したJavaScriptをセット
			webClip.WebclipURL(PayloadContentDict, document, WebClip.STRING,
					smsmURL);

		}

		/* ---------- SMSMクリップ設定パラメータここまで ---------- */

		/* ---------- 作業用Gmailアドレス設定パラメータここから ---------- */

		// 作業用Gmailアドレスが選択されている場合、実行
		if (gmailChk.isSelected()) {
			// 作業用Gmailアドレスは必ず１つになるので、ループなし
			Element PayloadContentDict = document.createElement("dict");
			PayloadContentArray.appendChild(PayloadContentDict);

			email.EmailAccountDescription(PayloadContentDict, document,
					Email.STRING, "作業用Gmailアドレス");

			// 作業用Gmailアドレスセット
			email.EmailAccountName(PayloadContentDict, document, Email.STRING,
					gmailAddressText.getText());

			// とりあえず「IMAP」で固定
			email.EmailAccountType(PayloadContentDict, document, Email.STRING,
					"EmailTypeIMAP");

			// 作業用Gmailアドレスセット
			email.EmailAddress(PayloadContentDict, document, Email.STRING,
					gmailAddressText.getText());

			// とりあえず「EmailAuthPassword」で固定
			email.IncomingMailServerAuthentication(PayloadContentDict,
					document, Email.STRING, "EmailAuthPassword");

			// とりあえず「imap.gmail.com」で固定
			email.IncomingMailServerHostName(PayloadContentDict, document,
					Email.STRING, "imap.gmail.com");

			// とりあえず「/」で固定
			email.IncomingMailServerIMAPPathPrefix(PayloadContentDict,
					document, Email.STRING, "/");

			// とりあえず「993」で固定
			email.IncomingMailServerPortNumber(PayloadContentDict, document,
					Email.INTEGER, "993");

			// とりあえず「true」で固定
			email.IncomingMailServerUseSSL(PayloadContentDict, document, true);

			// 作業用Gmailアドレスセット
			email.IncomingMailServerUsername(PayloadContentDict, document,
					Email.STRING, gmailAddressText.getText());

			// 作業用Gmailアドレスのパスワードセット
			email.IncomingPassword(PayloadContentDict, document, Email.STRING,
					gmailPasswordText.getText());

			// とりあえず「EmailAuthPassword」で固定
			email.OutgoingMailServerAuthentication(PayloadContentDict,
					document, Email.STRING, "EmailAuthPassword");

			// とりあえず「smtp.gmail.com」で固定
			email.OutgoingMailServerHostName(PayloadContentDict, document,
					Email.STRING, "smtp.gmail.com");

			// とりあえず「587」で固定
			email.OutgoingMailServerPortNumber(PayloadContentDict, document,
					Email.STRING, "587");

			// とりあえず「true」で固定
			email.OutgoingMailServerUseSSL(PayloadContentDict, document, true);

			// 作業用Gmailアドレスセット
			email.OutgoingMailServerUsername(PayloadContentDict, document,
					Email.STRING, gmailAddressText.getText());

			// とりあえず「true」で固定
			email.OutgoingPasswordSameAsIncomingPassword(PayloadContentDict,
					document, true);

			common.PayloadDescription(PayloadContentDict, document,
					Common.STRING, "Configures email account.");

			common.PayloadDisplayName(PayloadContentDict, document,
					Common.STRING, "作業用Gmailアドレス");

			common.PayloadIdentifier(PayloadContentDict, document,
					Common.STRING, "jp.kddi.workprof.email");

			common.PayloadOrganization(PayloadContentDict, document,
					Common.STRING, "");

			common.PayloadType(PayloadContentDict, document, Common.STRING,
					"com.apple.mail.managed");

			common.PayloadUUID(PayloadContentDict, document, Common.STRING);

			common.PayloadVersion(PayloadContentDict, document, Common.INTEGER,
					"1");

			// とりあえず、「false」で固定
			email.EmailPreventAppSheet(PayloadContentDict, document, false);

			// とりあえず、「false」で固定
			email.EmailPreventMove(PayloadContentDict, document, false);

			// とりあえず、「false」で固定
			email.EmailSMIMEEnabled(PayloadContentDict, document, false);

			// とりあえず、「false」で固定
			email.disableMailRecentsSyncing(PayloadContentDict, document, false);
		}

		/* ---------- 作業用Gmailアドレス設定パラメータここまで ---------- */

		description = profileDescriptionText.getText();
		common.PayloadDescription(dict, document, Common.STRING, description);

		displayName = profileNameText.getText();
		// プロファイル名がついていない場合は自動的に名前をつける
		if (displayName.equals("")) {
			displayName = "WebClip";
		}
		common.PayloadDisplayName(dict, document, Common.STRING, displayName);

		common.PayloadIdentifier(dict, document, Common.STRING,
				"jp.kddi.workprof");

		common.PayloadOrganization(dict, document, Common.STRING, "");

		common.PayloadRemovalDisallowed(dict, document, deleteProfile);

		common.PayloadType(dict, document, Common.STRING, "Configuration");

		common.PayloadUUID(dict, document, Common.STRING);

		common.PayloadVersion(dict, document, Common.INTEGER, "1");

		/* ------ 以上、構成プロファイルの中身 ------------ */

		DOMSource source = new DOMSource(document);
		File newXML = new File(exportFileName);
		FileOutputStream os = new FileOutputStream(newXML);
		StreamResult result = new StreamResult(os);
		transformer.transform(source, result);
		os.close();
	}

	// CSVを読み込み、入力支援Javascript生成
	public String JavascriptCreate(String fileName) throws IOException {
		Pattern pattern = Pattern.compile(",");
		List<String> header = new ArrayList<String>(); // 1行目をラベルに使用するため、配列に格納する準備
		File csv = new File(fileName); // CSVデータファイル
		BufferedReader br = new BufferedReader(new FileReader(csv));

		// CSV行数カウント
		int csvLines = 0;

		// テキスト番号(id)振り
		int count = 1;

		// 1行のデータ数カウント
		int dataConut = 0;

		String top = "";
		String middle = "";
		String bottom = "";

		String search = "";

		String label = "";

		String html = "";

		top = "javascript:document.open();document.write('<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\"><title>InputWebClip</title><script type=\"text/javascript\">function search(){var searchKey = document.getElementById(\"searchText\").value;";
		middle = "}</script></head><body><form><label>%E6%A4%9C%E7%B4%A2</label><br><input type =\"text\" value =\"\" id =\"searchText\"><input type =\"button\" value =\"push\" onclick =\"search();\"><HR>";
		bottom = "</form></body>');document.close();";

		// 最終行まで読み込む
		String line = "";

		// 1行目を読み込む
		line = br.readLine();

		// 文字列の分割(split「-1」を指定で空白も読み込む)
		String[] strs1 = pattern.split(line, -1);

		// リストへの代入
		// 1列目（電話番号列のラベルは必要ない）を読み飛ばす
		// 2列目以降を読み込み
		for (int i = 1; i < strs1.length; i++) {
			// 1つのヘッダを取得
			String ftmp = strs1[i];

			// そのままURLエンコードをかけると、半角スペースが「+」になるため、事前に変換
			ftmp = ftmp.replace(" ", "%20");

			// 日本語対応のため、取り込む文字列をURLエンコード
			ftmp = URLEncoder.encode(ftmp, "UTF-8");

			// 上記「%20」をURLエンコードするため、「%2520」となるため、「%2520」を「%20」に事後に変換
			ftmp = ftmp.replace("%2520", "%20");

			header.add(ftmp);
		}

		// 2行目以降を最終行まで1行ずつ読んでいく
		while ((line = br.readLine()) != null) {

			// 文字列の分割(split「-1」を指定で空白も読み込む)
			String[] strs2 = pattern.split(line, -1);

			// 1行のパラメータをjavascriptへ直接書き込む
			String tmp1 = strs2[0];

			// そのままURLエンコードをかけると、半角スペースが「+」になるため、事前に変換
			tmp1 = tmp1.replace(" ", "%20");

			// 日本語対応のため、取り込む文字列をURLエンコード
			tmp1 = URLEncoder.encode(tmp1, "UTF-8");

			// 上記「%20」をURLエンコードするため、「%2520」となるため、「%2520」を「%20」に事後に変換
			tmp1 = tmp1.replace("%2520", "%20");

			// はじめに1列目を読み込んでおく（検索キー）
			if (csvLines == 0) {
				search += "if(searchKey == \"" + tmp1 + "\"){";
			} else {
				search += "else if(searchKey == \"" + tmp1 + "\"){";
			}

			// 2列目以降を読み込む
			for (int i = 1; i < strs2.length; i++) {
				// 1行のパラメータをjavascriptへ直接書き込む
				String tmp2 = strs2[i];

				// そのままURLエンコードをかけると、半角スペースが「+」になるため、事前に変換
				tmp2 = tmp2.replace(" ", "%20");

				// 日本語対応のため、取り込む文字列をURLエンコード
				tmp2 = URLEncoder.encode(tmp2, "UTF-8");

				// 上記「%20」をURLエンコードするため、「%2520」となるため、「%2520」を「%20」に事後に変換
				tmp2 = tmp2.replace("%2520", "%20");

				search += "document.getElementById(\"text" + count
						+ "\").value=\"" + tmp2 + "\";";
				count++;
			}
			search += "}";
			// 1列完了するごとにインクリメント（行数カウント）
			csvLines++;

			// データ数算出
			dataConut = count - 1;

			// 次の行で1からカウントするためクリア
			count = 1;
		}

		// else文で検索キーに含まれないものの場合削除
		search += "else{";
		for (int i = 0; i < dataConut; i++) {
			search += "document.getElementById(\"text" + (i + 1)
					+ "\").value=\"\";";
		}
		search += "}";
		br.close();

		// ラベルの作成
		for (int i = 0; i < dataConut; i++) {
			label += "<label>"
					+ (i + 1)
					+ "%ef%bc%9a" // URLエンコードで「：」を変換したもの
					+ header.get(i)
					+ "</label><br><input type =\"text\" value =\"\" id =\"text"
					+ (i + 1) + "\"><br>";
		}

		// 生成したすべての文字列を1つの文字列とする
		html = top + search + middle + label + bottom;

		// 禁止文字の置き換え
		html = html.replace("<", "%3C");
		html = html.replace(">", "%3E");
		html = html.replace("\"", "%22");
		html = html.replace("[", "%5B");
		html = html.replace("]", "%5D");
		html = html.replace("{", "%7B");
		html = html.replace("}", "%7D");
		html = html.replace(" ", "%20");
		html = html.replace("?", "%3F");

		return html;
	}

	// 作業用ファイルを書き出すためのメソッド
	public void WorkProfSave(String workProfPath, ArrayList<String> workfile) {
		try {
			// 出力先を作成する
			FileWriter fw = new FileWriter(workProfPath, false);
			PrintWriter pw = new PrintWriter(new BufferedWriter(fw));

			// CSVファイルに書き出す内容を指定する

			// 1行目・作成プロファイル
			pw.print(workfile.get(0));
			pw.print(",");
			pw.print(workfile.get(1));
			pw.print(",");
			pw.print(workfile.get(2));
			pw.print(",");
			pw.print(workfile.get(3));
			pw.println();

			// 2行目・タブ
			pw.print(workfile.get(4));
			pw.print(",");
			pw.print(workfile.get(5));
			pw.print(",");
			pw.print(workfile.get(6));
			pw.print(",");
			pw.print(workfile.get(7));
			pw.print(",");
			pw.print(workfile.get(8));
			pw.print(",");
			pw.print(workfile.get(9));
			pw.println();

			// 3行目・その他情報
			pw.print(workfile.get(10));
			pw.print(",");
			pw.print(workfile.get(11));
			pw.print(",");
			pw.print(workfile.get(12));
			pw.print(",");
			pw.print(workfile.get(13));
			pw.println();

			// ファイルに書き出す
			pw.close();

		} catch (IOException ex) {
			// 例外時処理
			ex.printStackTrace();
		}
	}

	// 作業ファイルを読み込むためのメソッド
	public List<String> WorkProfOpen(String workProfPath) {
		Pattern pattern = Pattern.compile(",");
		List<String> workfile = new ArrayList<String>();

		try {
			File csv = new File(workProfPath); // CSVデータファイル
			BufferedReader br = new BufferedReader(new FileReader(csv));

			// 最終行まで読み込む
			String line = "";

			while ((line = br.readLine()) != null) {

				// 文字列の分割(split「-1」を指定で空白も読み込む)
				String[] strs = pattern.split(line, -1);

				// リストへの代入
				for (int i = 0; i < strs.length; i++) {
					// データの格納
					workfile.add(strs[i]);
				}

			}
			br.close();

		} catch (IOException e) {
			e.printStackTrace();
		}
		return workfile;
	}

	// ファイル選択で最後に開いたフォルダを表示するためのメソッド
	public void CurrentDir(String currentDir) {
		try {
			File file = new File(lastDirPath);

			if (checkBeforeWritefile(file)) {
				PrintWriter pw = new PrintWriter(new BufferedWriter(
						new FileWriter(file)));

				pw.println(currentDir);

				pw.close();
			} else {
				System.out.println("ファイルに書き込めません");
			}
		} catch (IOException e) {
			System.out.println(e);
		}
	}

	private static boolean checkBeforeWritefile(File file) {
		if (file.exists()) {
			if (file.isFile() && file.canWrite()) {
				return true;
			}
		}

		return false;
	}
}