package com.mxmobiling.kitting;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Exchange {

	public static final String STRING = "string";
	public static final String INTEGER = "integer";

	public Exchange() {
	}

	/*
	 * EmailAddress
	 * 
	 * ExchangeのEメールアドレス
	 */
	public void ExchangeEmailAddress(Element PayloadContentDict,
			Document document, String valueType, String emailAddress) {
		Element EmailAddressKey = document.createElement("key");
		PayloadContentDict.appendChild(EmailAddressKey);

		Text EmailAddressKeyParam = document.createTextNode("EmailAddress");
		EmailAddressKey.appendChild(EmailAddressKeyParam);

		Element EmailAddressString = document.createElement(valueType);
		PayloadContentDict.appendChild(EmailAddressString);

		Text EmailAddressStringParam = document.createTextNode(emailAddress);
		EmailAddressString.appendChild(EmailAddressStringParam);
	}

	/*
	 * Host
	 * 
	 * Exchangeのホスト
	 */
	public void ExchangeHost(Element PayloadContentDict, Document document,
			String valueType, String host) {
		Element HostKey = document.createElement("key");
		PayloadContentDict.appendChild(HostKey);

		Text HostKeyParam = document.createTextNode("Host");
		HostKey.appendChild(HostKeyParam);

		Element HostString = document.createElement(valueType);
		PayloadContentDict.appendChild(HostString);

		Text HostStringParam = document.createTextNode(host);
		HostString.appendChild(HostStringParam);
	}

	/*
	 * MailNumberOfPastDaysToSync
	 * 
	 * なぞのパラメータ
	 */
	public void ExchangeMailNumberOfPastDaysToSync(Element PayloadContentDict,
			Document document, String valueType, String mailDays) {
		Element MailNumberOfPastDaysToSyncKey = document.createElement("key");
		PayloadContentDict.appendChild(MailNumberOfPastDaysToSyncKey);

		Text MailNumberOfPastDaysToSyncKeyParam = document
				.createTextNode("MailNumberOfPastDaysToSync");
		MailNumberOfPastDaysToSyncKey
				.appendChild(MailNumberOfPastDaysToSyncKeyParam);

		Element MailNumberOfPastDaysToSyncInteger = document
				.createElement(valueType);
		PayloadContentDict.appendChild(MailNumberOfPastDaysToSyncInteger);

		Text MailNumberOfPastDaysToSyncIntegerParam;
		// パラメータの有無に応じてプロファイルのパラメータの変更
		if (mailDays.equals("")) {
			MailNumberOfPastDaysToSyncIntegerParam = document
					.createTextNode(String.valueOf("3"));
		} else {
			MailNumberOfPastDaysToSyncIntegerParam = document
					.createTextNode(mailDays);
		}
		MailNumberOfPastDaysToSyncInteger
				.appendChild(MailNumberOfPastDaysToSyncIntegerParam);
	}

	/*
	 * Password
	 * 
	 * Exchangeアカウントのパスワード
	 */
	public void ExchangePassword(Element PayloadContentDict, Document document,
			String valueType, String password) {
		Element PasswordKey = document.createElement("key");
		PayloadContentDict.appendChild(PasswordKey);

		Text PasswordKeyParam = document.createTextNode("Password");
		PasswordKey.appendChild(PasswordKeyParam);

		Element PasswordString = document.createElement(valueType);
		PayloadContentDict.appendChild(PasswordString);

		Text PasswordStringParam = document.createTextNode(password);
		PasswordString.appendChild(PasswordStringParam);
	}

	/*
	 * PreventAppSheet
	 * 
	 * Exchangeメールを他社製メールアプリで使用できないようにする
	 */
	public void ExchangePreventAppSheet(Element PayloadContentDict,
			Document document, String appSheet) {
		Element PreventAppSheetKey = document.createElement("key");
		PayloadContentDict.appendChild(PreventAppSheetKey);

		Text PreventAppSheetParam = document.createTextNode("PreventAppSheet");
		PreventAppSheetKey.appendChild(PreventAppSheetParam);

		Element PreventAppSheetParamString;
		// デフォルトが「false」なので、未入力の場合「false」とする
		if (appSheet.equals("")) {
			PreventAppSheetParamString = document.createElement("false");
		} else {
			PreventAppSheetParamString = document.createElement(appSheet);
		}

		PayloadContentDict.appendChild(PreventAppSheetParamString);
	}

	/*
	 * PreventMove
	 * 
	 * Exchangeメールを他のフォルダへ移動できないようにする
	 */
	public void ExchangePreventMove(Element PayloadContentDict,
			Document document, String move) {
		Element PreventMoveKey = document.createElement("key");
		PayloadContentDict.appendChild(PreventMoveKey);

		Text PreventMoveKeyParam = document.createTextNode("PreventMove");
		PreventMoveKey.appendChild(PreventMoveKeyParam);

		Element PreventMoveString;
		// デフォルトが「false」なので、未入力の場合「false」とする
		if (move.equals("")) {
			PreventMoveString = document.createElement("false");
		} else {
			PreventMoveString = document.createElement(move);
		}
		PayloadContentDict.appendChild(PreventMoveString);
	}

	/*
	 * SMIMEEnabled
	 * 
	 * ExchangeメールのS/MIME対応可否
	 */
	public void ExchangeSMIMEEnabled(Element PayloadContentDict,
			Document document, String smime) {
		Element SMIMEEnabledKey = document.createElement("key");
		PayloadContentDict.appendChild(SMIMEEnabledKey);

		Text SMIMEEnabledKeyParam = document.createTextNode("SMIMEEnabled");
		SMIMEEnabledKey.appendChild(SMIMEEnabledKeyParam);

		Element SMIMEEnabledString;
		// デフォルトが「false」なので、未入力の場合「false」とする
		if (smime.equals("")) {
			SMIMEEnabledString = document.createElement("false");
		} else {
			SMIMEEnabledString = document.createElement(smime);
		}
		PayloadContentDict.appendChild(SMIMEEnabledString);
	}

	/*
	 * SSL
	 * 
	 * ExchangeメールのSSL利用可否
	 */
	public void ExchangeSSL(Element PayloadContentDict, Document document,
			String ssl) {
		Element SSLKey = document.createElement("key");
		PayloadContentDict.appendChild(SSLKey);

		Text SSLKeyParam = document.createTextNode("SSL");
		SSLKey.appendChild(SSLKeyParam);

		Element SSLString;
		// trueがデフォルトなので、未入力の場合は「true」
		if (ssl.equals("")) {
			SSLString = document.createElement("true");
		} else {
			SSLString = document.createElement(ssl);
		}
		PayloadContentDict.appendChild(SSLString);
	}

	/*
	 * UserName
	 * 
	 * Exchangeメールのユーザー名
	 */
	public void ExchangeUserName(Element PayloadContentDict, Document document,
			String valueType, String domain, String userName) {
		Element UserNameKey = document.createElement("key");
		PayloadContentDict.appendChild(UserNameKey);

		Text UserNameKeyParam = document.createTextNode("UserName");
		UserNameKey.appendChild(UserNameKeyParam);

		Element UserNameKeyString = document.createElement(valueType);
		PayloadContentDict.appendChild(UserNameKeyString);

		Text UserNameKeyStringParam;
		// ドメイン名の有無に応じてプロファイルのパラメータの変更
		if (domain.equals("")) {
			UserNameKeyStringParam = document.createTextNode(userName);
		} else {
			UserNameKeyStringParam = document.createTextNode(domain + "\\"
					+ userName);
		}
		UserNameKeyString.appendChild(UserNameKeyStringParam);
	}

	/*
	 * disableMailRecentsSyncing
	 * 
	 * 最近使用したExchangeメールのアドレス帳同期の許可
	 */
	public void ExchangeDisableMailRecentsSyncing(Element PayloadContentDict,
			Document document, String mailSyncing) {
		Element DisableMailRecentsSyncingKey = document.createElement("key");
		PayloadContentDict.appendChild(DisableMailRecentsSyncingKey);

		Text DisableMailRecentsSyncingKeyParam = document
				.createTextNode("disableMailRecentsSyncing");
		DisableMailRecentsSyncingKey
				.appendChild(DisableMailRecentsSyncingKeyParam);

		Element DisableMailRecentsSyncingKeyString;
		// デフォルトが「false」なので、未入力の場合「false」とする
		if (mailSyncing.equals("")) {
			DisableMailRecentsSyncingKeyString = document
					.createElement("false");
		} else {
			DisableMailRecentsSyncingKeyString = document
					.createElement(mailSyncing);
		}
		PayloadContentDict.appendChild(DisableMailRecentsSyncingKeyString);
	}
}
