// main.c
// KM-BASIC Js for PIC32MX150F128B / PIC32MX250F128B by K.Tanaka

// pVXe
// ps2keyboard.X.a : PS/2L[{[h̓VXeCu
// lib_colortext32.a : J[rfIMo̓VXeCui30~27eLXgŁj
// libsdfsio.a F SDJ[hANZXpCu

#define SYSVER1 "Nauplia"
#define SYSVER2 "0.8"
#define BASVER "1.1"

#include <xc.h>
#include "api.h"
#include "compiler.h"
#include "editor.h"
#include "keyinput.h"

//OtNX^ with PLL (16{)
#pragma config PMDL1WAY = OFF, IOL1WAY = OFF
#pragma config FPLLIDIV = DIV_1, FPLLMUL = MUL_16, FPLLODIV = DIV_1
#pragma config FNOSC = PRIPLL, FSOSCEN = OFF, POSCMOD = XT, OSCIOFNC = OFF
#pragma config FPBDIV = DIV_1, FWDTEN = OFF, JTAGEN = OFF, ICESEL = ICS_PGx1

#define mBMXSetRAMKernProgOffset(offset)	(BMXDKPBA = (offset))
#define mBMXSetRAMUserDataOffset(offset)	(BMXDUDBA = (offset))
#define mBMXSetRAMUserProgOffset(offset)	(BMXDUPBA = (offset))

#define FILENAME_FLASH_ADDRESS 0x9D005800

int main(void){
	char *appname,*s;

	/* |[g̏ݒ */
	TRISA = 0x0000; // PORTASďo
	ANSELA = 0x0000; // SăfW^
	TRISB = KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// {^ڑ|[g͐ݒ
	ANSELB = 0x0000; // SăfW^
	CNPUBSET=KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// vAbvݒ
	ODCB = 0x0300;	//RB8,RB9̓I[vhC

    // Ӌ@\s蓖
	SDI2R=2; //RPA4:SDI2
	RPB5R=4; //RPB5:SDO2

	// Make RAM executable. See also "char RAM[RAMSIZE]" in globalvars.c
	mBMXSetRAMKernProgOffset(0x8000-RAMSIZE);
	mBMXSetRAMUserDataOffset(0x8000);
	mBMXSetRAMUserProgOffset(0x8000);

	ps2mode(); //RA1IiPS/2L}Nj
	init_composite(); // rfINAA荞ݏAJ[rfIo͊Jn
	setcursor(0,0,COLOR_NORMALTEXT);

//	printstr("                              ");
	printstr("PIC32MX Video Game System\n");
	printstr(" Version "SYSVER1" "SYSVER2" by KENKEN");
	printstr("KM-BASIC for MIPS by Katsumi\n");
	printstr(" Version "BASVER"\n\n");
	printstr("Init PS/2...");
	if(ps2init()){ //PS/2
		//L[{[hȂꍇ
		printstr("Keyboard Not Found\n");
//		setcursorcolor(COLOR_ERRORTEXT);
//		printstr("\nPS/2 Error\n");
//		printstr("Power Off and Check Keyboard\n");
//		while(1) asm("wait"); //[v
	}
	else printstr("OK\n");

	//SDJ[ht@CVXe
	while(1){
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Init File System...");
		// Initialize the File System
		if(FSInit()) break; //t@CVXeAOKȂ甲
		//G[̏ꍇ蒼
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("\nFile System Error\n");
		printstr("Insert Correct Card\n");
		printstr("And Hit Any Key\n");
		inputchar(); //1L[͑҂
	}
	printstr("OK\n");
	wait60thsec(60); //1b҂

	// sHEXt@CuNAUPLIA.HEXv̏ꍇ̓GfB^N
	appname=(char*)FILENAME_FLASH_ADDRESS;
	s="NAUPLIA.HEX";
	while(*s++==*appname++) if(*s==0) texteditor(); //eLXgGfB^[Ăяo

	// sHEXt@Ću.HEXvu.BASvɒuBASt@Cs
	appname=(char*)FILENAME_FLASH_ADDRESS;
	s=tempfile;
	while(*appname!='.') *s++=*appname++;
	appname=".BAS";
	while(*appname!=0) *s++=*appname++;
	*s=0;
	runbasic(tempfile);
	while(1) asm("nop");
}
