// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.jmex.wani;
import java.io.IOException;
import com.jme3.export.OutputCapsule;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;

public class WaniRefItem extends WaniItem
{//{{{
	public WaniRefItem()
	{//{{{
	}//}}}
	public final static String KEY="key";
	String key;
	WaniItem targetItem = null;
	public String getKey()
	{//{{{
		return key;
	}//}}}
	public void setKey( String value_ )
	{//{{{
		key = value_;
	}//}}}
	WaniItem getTargetItem()
	{//{{{
		if( targetItem == null ){
			WaniControl ctrl_ = getControl();
			WaniItem item_ = ctrl_.getItem( key );
			targetItem = item_.cloneForControl( ctrl_ );
			targetItem.superItem = this;
		}
		return targetItem;
	}//}}}
	@Override
	public void start()
	{//{{{
		getTargetItem().start();
	}//}}}
	@Override
	public void startLoop()
	{//{{{
		getTargetItem().startLoop();
	}//}}}
	@Override
	public void reset( boolean rewind_ )
	{//{{{
		getTargetItem().reset( rewind_ );
	}//}}}
	@Override
	public boolean isCompleted()
	{//{{{
		return getTargetItem().isCompleted();
	}//}}}
	@Override
	public void write(JmeExporter ex_) throws IOException
	{//{{{
		super.write( ex_ );
		OutputCapsule oc_ = ex_.getCapsule(this);
		oc_.write( key, KEY, null );
	}//}}}
	@Override
	public void read(JmeImporter im_) throws IOException
	{//{{{
		super.read( im_ );
		InputCapsule in_ = im_.getCapsule(this);
		key = in_.readString( KEY, null );
	}//}}}
	@Override
	public void notifyDone( WaniItem item_ )
	{//{{{
		if( superItem == null ){
			control.notifyDone( this );
		}
		else{
			superItem.notifyDone( this );
		}
	}//}}}
	@Override
	public WaniItem cloneForControl( WaniControl ctrl_ )
	{//{{{
		WaniRefItem clone_ = new WaniRefItem();
		clone_.setSpeed( speed );
		clone_.setControl( ctrl_ );
		clone_.setKey( key );
		return clone_;
	}//}}}
}//}}}
