// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.jmex.wani;
import java.util.ArrayList;
import java.io.IOException;
import com.jme3.export.OutputCapsule;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;

public abstract class WaniList extends WaniItem
{//{{{
	public final static String ITEMS="items";
	ArrayList<WaniItem> subList = new ArrayList<WaniItem>();
	public void setControlAll( WaniControl value_ )
	{//{{{
		setControl( value_ );
		for( WaniItem item_ : subList ){
			if( item_ instanceof WaniList ){
				WaniList ls_ = (WaniList)item_;
				ls_.setControlAll( value_ );
			}
			else{
				item_.setControl( value_ );
			}
		}
	}//}}}
	public WaniItem getSubItem( int index_ )
	{//{{{
		return subList.get( index_ );
	}//}}}
	public int getSubItemCount()
	{//{{{
		return subList.size();
	}//}}}
	public void addSubItem( WaniItem... itemLs_ )
	{//{{{
		for( WaniItem item_ : itemLs_ ){
			item_.superItem = this;
			item_.setControl( getControl() );
			subList.add( item_ );
		}
	}//}}}
	@Override
	public void write(JmeExporter ex_) throws IOException
	{//{{{
		super.write( ex_ );
		OutputCapsule oc_ = ex_.getCapsule(this);
		oc_.writeSavableArrayList( subList, ITEMS, null );
	}//}}}
	@Override
	public void read(JmeImporter im_) throws IOException
	{//{{{
		super.read( im_ );
		InputCapsule in_ = im_.getCapsule(this);
		subList = in_.readSavableArrayList( ITEMS, null );
	}//}}}
}//}}}
