// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.jmex.wani;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.LoopMode;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.InputCapsule;
import java.io.IOException;

public class WaniCoreItem extends WaniItem implements AnimEventListener
{//{{{
	boolean completed = false;
	int channelIndex = -1;

	boolean coreListener = false;
	String coreControlName;
	float time = INVALID_FLOAT;
	String anim = null;
	float blendTime = INVALID_FLOAT;
	//LoopMode loopMode = null;

	public static final String ANIMCONTROL_NAME="anim-control-name";
	public static final String TIME="time";
	public static final String ANIM="anim";
	public static final String BLEND_TIME="blend-time";
	//public static final String LOOP_MODE="loop-mode";

	public float getTime()
	{//{{{
		if( time < 0 ){
			return 0f;
		}
		return time;
	}//}}}
	public void setTime( float value_ )
	{//{{{
		time = value_;
	}//}}}
	/*
	public LoopMode getLoopMode()
	{//{{{
		if( loopMode == null ){
			return LoopMode.DontLoop;
		}
		return loopMode;
	}//}}}
	public void setLoopMode( LoopMode value_ )
	{//{{{
		loopMode = value_;
	}//}}}
	*/
	public String getCoreControlName()
	{//{{{
		return coreControlName;
	}//}}}
	public void setCoreControlName( String value_ )
	{//{{{
		coreControlName = value_;
	}//}}}
	public String getAnim()
	{//{{{
		return anim;
	}//}}}
	public void setAnim( String value_ )
	{//{{{
		anim = value_;
	}//}}}
	public float getBlendTime()
	{//{{{
		return blendTime;
	}//}}}
	public void setBlendTime( float value_ )
	{//{{{
		blendTime = value_;
	}//}}}

	@Override
	public void start()
	{//{{{
		start( false );
	}//}}}
	@Override
	public void startLoop()
	{//{{{
		start( true );
	}//}}}

	void start( boolean loop_ )
	{//{{{
		completed = false;
		WaniChannelManager cm_ = getControl().getChannelManager( coreControlName );
		channelIndex = cm_.createChannel( this );
		AnimControl ct_ = cm_.getCoreControl();
		if( !coreListener ){
			ct_.addListener( this );
			coreListener = true;
		}

		AnimChannel ch_ = cm_.getChannel( channelIndex );
		assert( anim != null );
		if( blendTime < 0 ){
			ch_.setAnim( anim );
		}
		else{
			ch_.setAnim( anim, blendTime );
		}
		ch_.setSpeed( getTotalSpeed() );
		ch_.setTime( getTime() );
		if( loop_ ){
			ch_.setLoopMode( LoopMode.Loop );
		}
		else{
			ch_.setLoopMode( LoopMode.DontLoop );
		}
	}//}}}
	@Override
	public void reset( boolean rewind_ )
	{//{{{
		WaniChannelManager cm_ = getControl().getChannelManager( coreControlName );
		AnimChannel ch_ = cm_.getChannel( channelIndex );
		AnimControl coreCt_ = ch_.getControl();
		if( coreListener ){
			coreCt_.removeListener( this );
			coreListener = false;
		}
		ch_.reset( rewind_ );
	}//}}}
	@Override
	public boolean isCompleted()
	{//{{{
		return completed;
	}//}}}
	@Override
	public void write(JmeExporter ex_) throws IOException
	{//{{{
		super.write( ex_ );
		OutputCapsule oc_ = ex_.getCapsule(this);
		oc_.write( speed, SPEED, INVALID_FLOAT );
		oc_.write( time, TIME, INVALID_FLOAT );
		oc_.write( blendTime, BLEND_TIME, INVALID_FLOAT );
		oc_.write( anim, ANIM, null );
		oc_.write( coreControlName, ANIMCONTROL_NAME, null );
		/*
		if( loopMode != null ){
			oc_.write( loopMode.toString(), LOOP_MODE, null );
		}
		*/
	}//}}}
	@Override
	public void read(JmeImporter im_) throws IOException
	{//{{{
		super.read( im_ );
		InputCapsule in_ = im_.getCapsule(this);
		speed = in_.readFloat( SPEED, INVALID_FLOAT );
		time = in_.readFloat( TIME, INVALID_FLOAT );
		blendTime = in_.readFloat( BLEND_TIME, INVALID_FLOAT );
		anim = in_.readString( ANIM, null );
		coreControlName = in_.readString( ANIMCONTROL_NAME, null );
		/*{
			loopMode = null;
			String str1_ = in_.readString( LOOP_MODE, null );
			if( str1_ != null ){
				String str2_ = str1_.toLowerCase();
				for( LoopMode v_ : LoopMode.values() ){
					if( str2_.equals( v_.toString().toLowerCase() ) ){
						loopMode = v_;
						break;
					}
				}
				if( loopMode == null ){
					throw new IOException( LOOP_MODE + " value is invalid: " + str1_ );
				}
			}
		}*/
	}//}}}
	@Override
	public WaniItem cloneForControl( WaniControl ctrl_ )
	{//{{{
		WaniCoreItem clone_ = new WaniCoreItem();
		clone_.setControl( ctrl_ );
		clone_.setSpeed( speed );
		clone_.setTime( time );
		//clone_.setLoopMode( loopMode );
		clone_.setCoreControlName( coreControlName );
		clone_.setAnim( anim );
		clone_.setBlendTime( blendTime );
		return clone_;
	}//}}}
	public void onAnimCycleDone(AnimControl coreControl_, AnimChannel ch_, String animName_)
	{//{{{
		WaniChannelManager cm_ = getControl().getChannelManager( coreControlName );
		if( coreControl_ != cm_.getCoreControl() ){
			return;
		}
		if( ch_ != cm_.getChannel( channelIndex ) ){
			return;
		}
		if( ch_.getLoopMode() != LoopMode.DontLoop ){
			return;
		}
		completed = true;
		if( coreListener ){
			coreControl_.removeListener( this );
			coreListener = false;
		}
		cm_.disposeChannel( channelIndex );
		if( superItem == null ){
			control.notifyDone( this );
		}
		else{
			superItem.notifyDone( this );
		}
	}//}}}
	public void onAnimChange(AnimControl control, AnimChannel channel, String animName)
	{//{{{
	}//}}}
}//}}}
