// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.jmex.wani;
import com.jme3.scene.Spatial;
import com.jme3.scene.Node;
import com.jme3.export.Savable;
import com.jme3.export.OutputCapsule;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.animation.AnimControl;
import java.util.ArrayList;
import java.io.IOException;
import mn.jp.kekkouyakan.functional.IKyAction0;
import mn.jp.kekkouyakan.jme3.scene.KySceneUtil;
import java.util.HashMap;
import java.util.Map;

public class WaniControl extends AbstractControl implements Cloneable, Savable
{//{{{
	HashMap<String, WaniChannelManager> namedChannelManagerMap = new HashMap<String, WaniChannelManager>();

	public final static String ITEMS="items";
	public final static String DEFS="defs";
	Map<String, WaniItem> namedItemMap = new HashMap<String, WaniItem>();
	ArrayList<String> rewindReqList = new ArrayList<String>();
	ArrayList<String> resetReqList = new ArrayList<String>();
	ArrayList<String> startReqList = new ArrayList<String>();
	ArrayList<String> startLoopReqList = new ArrayList<String>();
	ArrayList<WaniDef> defList = new ArrayList<WaniDef>();
	ArrayList<IWaniEventListener> listenerList = new ArrayList<IWaniEventListener>();

	public WaniChannelManager getChannelManager( String name_ )
	{//{{{
		return namedChannelManagerMap.get( name_ );
	}//}}}
	public String[] getAnimNames()
	{//{{{
		return namedItemMap.keySet().toArray( new String[0] );
	}//}}}
	public WaniItem getItem( String label_ )
	{//{{{
		return namedItemMap.get( label_ );
	}//}}}
	public void start( String label_ )
	{//{{{
		synchronized( startReqList ){
			startReqList.add( label_ );
		}
	}//}}}
	public void startLoop( String label_ )
	{//{{{
		synchronized( startLoopReqList ){
			startLoopReqList.add( label_ );
		}
	}//}}}
	public void reset( String label_ )
	{//{{{
		reset( label_, true );
	}//}}}
	public void reset( String label_, boolean rewind_ )
	{//{{{
		if( rewind_ ){
			synchronized( rewindReqList ){
				rewindReqList.add( label_ );
			}
		}
		else{
			synchronized( resetReqList ){
				resetReqList.add( label_ );
			}
		}
	}//}}}
	public void registerItem( String name_, WaniItem item_ )
	{//{{{
		namedItemMap.put( name_, item_ );
	}//}}}
	@Override
	public void setSpatial(Spatial sp0_)
	{//{{{
		super.setSpatial(sp0_);
		namedChannelManagerMap.clear();
		for( Spatial sp_ : KySceneUtil.findSpatials( sp0_ ) ){
			String name_ = sp_.getName();
			if( name_ == null ){
				continue;
			}
			AnimControl ct_ = sp_.getControl( AnimControl.class );
			if( ct_ == null ){
				continue;
			}
			if( namedChannelManagerMap.get( name_ ) != null ){
				throw new Error();
			}
			namedChannelManagerMap.put( name_, new WaniChannelManager(ct_) );
		}
		for( WaniDef def_ : defList ){
			WaniChannelManager cm_ = namedChannelManagerMap.get( def_.getAnimControlName() );
			AnimControl ctrl_ = cm_.getCoreControl();
			String prefix_ = def_.getPrefix();
			for( String anim_ : ctrl_.getAnimationNames() ){
				WaniCoreItem item_ = new WaniCoreItem();
				item_.setControl( this );
				item_.setCoreControlName( def_.getAnimControlName() );
				item_.setAnim( anim_ );
				namedItemMap.put( prefix_ + anim_, item_ );
			}
		}
	}//}}}
	@Override
	public void write(JmeExporter ex_) throws IOException
	{//{{{
		super.write(ex_);
		OutputCapsule oc_ = ex_.getCapsule(this);
		oc_.writeSavableArrayList(
			defList,
			DEFS,
			null
		);
		oc_.writeStringSavableMap(
			namedItemMap,
			ITEMS,
			null
		);
	}//}}}
	@Override
	public void read(JmeImporter im_) throws IOException
	{//{{{
		super.read(im_);
		InputCapsule in_ = im_.getCapsule(this);
		defList = in_.readSavableArrayList( DEFS, defList );
		namedItemMap = (Map<String, WaniItem>)in_.readStringSavableMap(
			ITEMS, null
		);
	}//}}}
	@Override
	public Control cloneForSpatial(Spatial sp_)
	{//{{{
		WaniControl ctrl_ = new WaniControl();
		ctrl_.setSpatial( sp_ );
		ctrl_.defList = defList;
		if( namedItemMap != null ){
			for( String key_ : namedItemMap.keySet() ){
				WaniItem item1_ = namedItemMap.get( key_ );
				WaniItem item2_ = item1_.cloneForControl( ctrl_ );
				ctrl_.registerItem( key_, item2_ );
			}
		}
		return ctrl_;
	}//}}}
	@Override
	protected void controlRender(RenderManager rm, ViewPort vp)
	{//{{{
	}//}}}
	@Override
	protected void controlUpdate(float tpf)
	{//{{{
		synchronized( startReqList ){
			for( String label_ : startReqList ){
				namedItemMap.get( label_ ).start();
			}
			startReqList.clear();
		}
		synchronized( startLoopReqList ){
			for( String label_ : startLoopReqList ){
				namedItemMap.get( label_ ).startLoop();
			}
			startLoopReqList.clear();
		}
		synchronized( resetReqList ){
			for( String label_ : resetReqList ){
				namedItemMap.get( label_ ).reset( false );
			}
			resetReqList.clear();
		}
		synchronized( rewindReqList ){
			for( String label_ : rewindReqList ){
				namedItemMap.get( label_ ).reset( true );
			}
			rewindReqList.clear();
		}
	}//}}}
	void notifyDone( WaniItem item_ )
	{//{{{
		for( IWaniEventListener lis_ : listenerList ){
			lis_.onWaniCycleDone( this, item_ );
		}
	}//}}}
	public String getAnimName( WaniItem item_ )
	{//{{{
		for( String str_ : namedItemMap.keySet() ){
			if( namedItemMap.get( str_ ) == item_ ){
				return str_;
			}
		}
		return null;
	}//}}}
	public void addListener( IWaniEventListener lis_ )
	{//{{{
		if( listenerList.contains( lis_ ) ){
			return;
		}
		listenerList.add( lis_ );
	}//}}}
	public void removeListener( IWaniEventListener lis_ )
	{//{{{
		listenerList.remove( lis_ );
	}//}}}
	public void reset()
	{//{{{
		startReqList.clear();
		startLoopReqList.clear();
		resetReqList.clear();
		rewindReqList.clear();
		for( String k_ : namedChannelManagerMap.keySet() ){
			namedChannelManagerMap.get( k_ ).reset();
		}
	}//}}}
}//}}}
