// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.jme3.scene;

import com.jme3.scene.*;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetManager;
import com.jme3.asset.ModelKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.util.SafeArrayList;
import java.io.IOException;
import java.util.*;
import java.util.Map.Entry;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BinaryLinkNode extends Node
{//{{{
	String xmlName;
	String binaryName;
	static final String XML="xml";
	static final String BINARY="binary";

	public BinaryLinkNode()
	{//{{{
	}//}}}
	public BinaryLinkNode(String xmlKey_, String binKey_)
	{//{{{
		this(xmlKey_, xmlKey_, binKey_);
	}//}}}
	public BinaryLinkNode(String name_, String xmlKey_, String binaryKey_)
	{//{{{
		super(name_);
		xmlName = xmlKey_;
		binaryName = binaryKey_;
	}//}}}
	@Override
	public void read(JmeImporter e_) throws IOException
	{//{{{
		super.read(e_);
		InputCapsule capsule_ = e_.getCapsule(this);
		BinaryImporter importer_ = BinaryImporter.getInstance();
		AssetManager loaderManager = e_.getAssetManager();
		ModelKey modelKey_ = null;
		xmlName = capsule_.readString( XML, null );
		binaryName = capsule_.readString( BINARY, null );
		modelKey_ = new ModelKey( binaryName );
		AssetInfo info_ = loaderManager.locateAsset(modelKey_);
		Spatial child_ = null;
		if (info_ != null) {
			child_ = (Spatial) importer_.load(info_);
		}
		if (child_ != null) {
			attachChild( child_ );
		} else {
			Logger.getLogger(this.getClass().getName())
				.log(Level.WARNING, "Cannot locate {0} for asset link node", 
				new Object[]{ modelKey_ }
			);
		}
	}//}}}
	@Override
	public void write(JmeExporter e_) throws IOException
	{//{{{
		SafeArrayList<Spatial> childs_ = children;
		children = new SafeArrayList<Spatial>(Spatial.class);
		super.write(e_);
		OutputCapsule capsule_ = e_.getCapsule(this);
		capsule_.write( XML, xmlName, null );
		capsule_.write( BINARY, binaryName, null );
		children = childs_;
	}//}}}
}//}}}
