#!/bin/sh
# -----------------------------------------------------------------------------
#
# logmsg.sh
#
  APPNAME="%PACKAGE%" APPVERSION="%VERSION%"
#
# A ChangeLog --> SCM log message extraction and formatting utility.
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2013, 2015, 2018, 2019, MinGW.org Project
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
# Save the effective command name, for use in diagnostic messages.
#
  cmd=`basename "$0" .sh` cmd_version=${APPVERSION-"%VERSION%"}
  COPYRIGHT_YEARS="2013, 2015, 2018, 2019"

# Establish the paths for application support files and extensions.
#
  approotdir=`dirname "$0"`
  test "x`basename "$approotdir"`" = xbin && approotdir=`dirname "$approotdir"`
  libexecdir=${libexecdir-"$approotdir/libexec"}/$APPNAME/$APPVERSION

# Implement the module/plugin loader; (note that the "die" function here
# is a simplified fall-back implementation, to handle any failure to load
# a required module, before a more comprehensive implementation has been
# sourced)...
#
  require(){ load "$@" || die "$1 '$2' not found"; }
  load(){ test -f "$libexecdir/${1}s/$2.sh" && . "$libexecdir/${1}s/$2.sh"; }
  die(){ echo >&2 "$error_colour$cmd: *** FATAL *** $@$unbold"; exit 2; }

  require module dmh
  require module optdefn

  optchk_getopt_long_only=true

  optdefine full
  opteval_full(){ style=full; }

  optdefine summary
  opteval_summary(){ style=summary; }

  optdefine V version
  opteval_version(){ require module licence short; }

  optdefine licence; optalias license=licence
  opteval_licence(){ require module licence full; }

  optdefine user
  opteval_user(){ format_option=report_user_identity; }
  report_user_identity(){ echo `sed 1q $1 | awk '{ $1 = ""; print }'`; }

  while optchk "$@"
  do shift $argshift; test "x${optmatch}x" = "x--x" && break; done

  find_logfile(){
    local curdir=`pwd`
    until test -f `try_logfile $curdir/$1`
    do test x"$curdir" = x"/" && die 1 "log file '$1' not found"
       curdir=`dirname $curdir`
    done
    test -f `try_logfile $curdir/$1` && try_logfile $curdir/$1
  }

  try_logfile(){
    test -d $1 && echo $1/ChangeLog || echo $1
  }

  format_logmsg(){ /usr/bin/awk '
    BEGIN {
      phase = 0;
      if( style != "full" ){
	style = "summary";
	summary = "";
      }
    }

    function summarize(){
      gsub( "^\t", (phase > 0) ? " " : "" );
      summary = summary $0;
      phase = 1;
    }

    function format_all(){
      gsub( "^\t", "" );
      if( phase == 2 ) printf "\n";
      phase = 1;
      print;
    }

    /^[ \t]*$/{
      if( phase > 0 ){
	if( style == "summary" ){
	  print summary;
	  exit;
	}
	phase = 2;
      }
    }

    /^[12][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]/{
      if( phase > 0 ) exit;
      $0 = "";
    }

    /[^ \t]/{
      if( style == "summary" ) summarize();
      else format_all();
    }' "$@"
  }

  test x"$1"x = x-x || {
    argv=`find_logfile ${1-ChangeLog}` || exit $?
    set -- $argv
  }

  eval ${format_option-"format_logmsg style=${style-summary}"} $1
#
# $RCSfile$: end of file
