.nr HY 0
.TH GIT\-QFINISH 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qfinish \- move applied patches into repository history
.
.
.SH SYNOPSIS
.B git\ qfinish\c
.RI \ < patch >\  \fB... \ [< patch\-range >\ [< patch >]]\  \fB...
.br
.B git\ qfinish\c
.RI \ < patch\-range >\  \fB... \ [< patch >\ [< patch\-range >]]\  \fB...
.br
.B git\ qfinish \-\-applied
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qfinish
command finishes a specified applied patch,
or a specified sequence of applied patches,
releases it from
.B Git\-MQ
control,
and moves it into committed repository history.
.
.LP
If the
.B \-\-applied
option is specified,
the sequence of patches to be released is considered to represent
the entire sequence of all applied patches;
otherwise,
at least one
.RI < patch >,
or
.RI < patch\-range >
argument
.I must
be specified,
and the aggregate of all such arguments
.I must
represent a contiguous sequence of applied patches,
starting at the base of the applied patch stack.
.
.LP
Finished patches are removed from the
.B Git\-MQ
series,
and the corresponding patch files are deleted from the
.B Git\-MQ
patch directory.
.
.
.SH OPTIONS
.TP 4n
.BR \-a ,\  \-\-applied
Select all currently applied patches,
and move them into committed repository history.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qfinish
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qfinish
command exhibits fundamentally the same behaviour as its
.B hg\ qfinish
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qapplied (1),
.BR git\-qseries (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
