# git-mq-cache-check.sh
# ------------------------------------------------------------------------------
#
# Supplementary shell script fragment; invoked via "mq_require", it checks
# for the presence of any staged, but uncommitted changes.
#
# ------------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2019, Keith Marshall
#
#
# This file is part of the Git-MQ program suite.
#
# The Git-MQ program suite is free software: you can redistribute it
# and/or modify it under the terms of the GNU General Public Licence
# as published by the Free Software Foundation, either version 3 of
# the Licence, or (at your option) any later version.
#
# The Git-MQ program suite is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public Licence for more details.
#
# You should have received a copy of the GNU General Public Licence
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# ------------------------------------------------------------------------------
#
# The preferred command for checking cache state is "git diff-index";
# it requires a tree-ish object reference, but we cannot guarantee that
# even HEAD is suitable, so generate a fall-back if necessary.
#
  local mq_ref; mq_ref=`git rev-parse --quiet --verify "${1-HEAD}"` ||
    mq_ref=`git hash-object -t tree /dev/null`

# Refresh the index, then run "git diff-index" to verify that it is
# clean; simply fall through, returning the resultant status from the
# encapsulating "mq_require" call.
#
  git update-index -q --ignore-submodules --refresh
  git diff-index --quiet --cached --ignore-submodules $mq_ref
#
# ------------------------------------------------------------------------------
# $RCSfile$: end of file
