#
# Table structure for table `mob_skill_db_re`
#

DROP TABLE IF EXISTS `mob_skill_db_re`;
CREATE TABLE IF NOT EXISTS `mob_skill_db_re` (
  `MOB_ID` smallint(6) NOT NULL,
  `INFO` text NOT NULL,
  `STATE` text NOT NULL,
  `SKILL_ID` smallint(6) NOT NULL,
  `SKILL_LV` tinyint(4) NOT NULL,
  `RATE` smallint(4) NOT NULL,
  `CASTTIME` mediumint(9) NOT NULL,
  `DELAY` int(9) NOT NULL,
  `CANCELABLE` text NOT NULL,
  `TARGET` text NOT NULL,
  `CONDITION` text NOT NULL,
  `CONDITION_VALUE` text,
  `VAL1` mediumint(9) DEFAULT NULL,
  `VAL2` mediumint(9) DEFAULT NULL,
  `VAL3` mediumint(9) DEFAULT NULL,
  `VAL4` mediumint(9) DEFAULT NULL,
  `VAL5` mediumint(9) DEFAULT NULL,
  `EMOTION` text,
  `CHAT` text
) ENGINE=MyISAM;

# Mob Skill Database
# Based on Aegis Episode 11.3
#
# Structure of Database:
#REPLACE INTO `mob_skill_db_re` VALUES ( MobID,'Dummy value (info only)','State',SkillID,SkillLv,Rate,CastTime,Delay,'Cancelable','Target','Condition type','Condition value',val1,val2,val3,val4,val5,'Emotion','Chat');
#
# RATE: the chance of the skill being casted when the condition is fulfilled (10000 = 100%).
# DELAY: the time (in milliseconds) before attempting to recast the same skill.
#
# STATE:
#	any (except dead) / idle (in standby) / walk (in movement) / dead (on killed) /
#	loot /attack / angry (like attack, except player has not attacked mob yet) /
#	chase (following target, after being attacked) / follow (following target,
#	without being attacked) / anytarget (attack+angry+chase+follow)
#
# TARGET:
#	target (current target) / self / friend / master / randomtarget (any enemy within skill's range)
#
#	The following are for ground-skills, a random target tile is selected from the specified area:
#	    around1 (3x3 area around self) / around2 (5x5 area around self) /
#	    around3 (7x7 area around self) / around4 (9x9 area around self) /
#	    around5 (3x3 area around target) / around6 (5x5 area around target) /
#	    around7 (7x7 area around target) / around8 (9x9 area around target) /
#	    around = around4
#
# CONDITION:
#	always			Unconditional (no condition value).
#	onspawn			When mob spawns/respawns (no condition value).
#	myhpltmaxrate		When mob's HP drops to the specified %.
#	myhpinrate		When mob's HP is in a certain % range (condition value = lower bound, val1 = upper bound).
#	mystatuson		If mob has the specified abnormality in status.
#	mystatusoff		If mob has ended the specified abnormality in status.
#	friendhpltmaxrate	When mob's friend's HP drops to the specified %.
#	friendhpinrate		When mob's friend's HP is in a certain % range (condition value = lower bound, val1 = upper bound).
#	friendstatuson		If friend has the specified abnormality in status.
#	friendstatusoff		If friend has ended the specified abnormality in status.
#	attackpcgt		When attack PCs become greater than specified number.
#	attackpcge		When attack PCs become greater than or equal to the specified number.
#	slavelt			When number of slaves is less than the original specified number.
#	slavele			When number of slaves is less than or equal to the original specified number.
#	closedattacked		When close range melee attacked (no condition value).
#	longrangeattacked	When long range attacked, ex. bows, guns, ranged skills (no condition value).
#	skillused		When the specified skill is used on the mob.
#	afterskill		After mob casts the specified skill.
#	casttargeted		When a target is in cast range (no condition value).
#	rudeattacked		When mob is rude attacked (no condition value).
#
#	Status abnormalities specified through the statuson/statusoff system:
#	    anybad (any type of state change) / stone / freeze / stun / sleep /
#	    poison / curse / silence / confusion / blind / hiding / sight (unhidden)
#
# Note: if a negative MobID is provided, the skill will be treated as 'global':
#	-1: added for all boss types.
#	-2: added for all normal types.
#	-3: added for all mobs.

REPLACE INTO `mob_skill_db_re` VALUES (1001,'Scorpion@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1001,'Scorpion@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1002,'Poring@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1002,'Poring@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1004,'Hornet@NPC_PIERCINGATT','attack',158,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1004,'Hornet@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1005,'Familiar@NPC_BLINDATTACK','attack',177,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1005,'Familiar@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1005,'Familiar@NPC_BLINDATTACK','angry',177,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1005,'Familiar@NPC_DARKNESSATTACK','angry',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1007,'Fabre@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1007,'Fabre@NPC_METAMORPHOSIS','idle',193,1,10,2000,5000,'no','self','always','0',1008,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1008,'Pupa@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1008,'Pupa@NPC_METAMORPHOSIS','idle',193,1,10,2000,5000,'no','self','always','0',1018,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1009,'Condor@BS_ADRENALINE','attack',111,1,500,1500,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1009,'Condor@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',5,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1009,'Condor@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1010,'Willow@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1010,'Willow@NPC_TELEKINESISATTACK','attack',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1010,'Willow@NPC_TELEKINESISATTACK','chase',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1011,'Chonchon@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1011,'Chonchon@NPC_RUN','attack',354,1,10000,0,3000,'no','self','always','0',NULL,0x81,NULL,NULL,NULL,'26',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1011,'Chonchon@NPC_RUN','chase',354,1,10000,0,3000,'no','self','always','0',NULL,0x81,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1012,'Roda Frog@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1013,'Wolf@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1013,'Wolf@NPC_PROVOCATION','chase',194,1,200,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1014,'Spore@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',1,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1014,'Spore@NPC_PROVOCATION','chase',194,1,200,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1014,'Spore@NPC_SLEEPATTACK','attack',182,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1014,'Spore@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1015,'Zombie@NPC_POISON','attack',176,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1015,'Zombie@NPC_POISON','angry',176,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1015,'Zombie@NPC_UNDEADATTACK','attack',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1015,'Zombie@NPC_UNDEADATTACK','angry',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1016,'Archer Skeleton@AC_DOUBLE','attack',46,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1016,'Archer Skeleton@NPC_UNDEADATTACK','attack',347,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1016,'Archer Skeleton@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1018,'Creamy@AL_TELEPORT','attack',26,1,500,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1018,'Creamy@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1018,'Creamy@NPC_SLEEPATTACK','attack',182,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1018,'Creamy@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1019,'Peco Peco@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1019,'Peco Peco@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1019,'Peco Peco@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1019,'Peco Peco@NPC_PROVOCATION','chase',194,1,200,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1020,'Mandragora@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1023,'Orc Warrior@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1023,'Orc Warrior@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1023,'Orc Warrior@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1023,'Orc Warrior@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',32,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1023,'Orc Warrior@NPC_SMOKING','idle',195,1,500,0,36000000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1023,'Orc Warrior@NPC_EMOTION','follow',197,1,2000,0,5000,'yes','self','always','0',27,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1023,'Orc Warrior@NPC_GROUNDATTACK','angry',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1023,'Orc Warrior@NPC_EMOTION','follow',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1024,'Worm Tail@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1025,'Snake@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1025,'Snake@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1026,'Munak@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1026,'Munak@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',1,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1026,'Munak@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1026,'Munak@NPC_EMOTION','follow',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1026,'Munak@NPC_STUNATTACK','angry',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1028,'Skeleton Soldier@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1028,'Skeleton Soldier@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1028,'Skeleton Soldier@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1028,'Skeleton Soldier@NPC_EMOTION','follow',197,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1028,'Skeleton Soldier@NPC_UNDEADATTACK','attack',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1028,'Skeleton Soldier@NPC_UNDEADATTACK','angry',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1029,'Isis@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1029,'Isis@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1029,'Isis@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1029,'Isis@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1030,'Anacondaq@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1030,'Anacondaq@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1031,'Poporing@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1031,'Poporing@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1031,'Poporing@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1032,'Verit@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1032,'Verit@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1032,'Verit@NPC_PROVOCATION','chase',194,1,200,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1033,'Elder Willow@MG_FIREBOLT','attack',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1033,'Elder Willow@MG_FIREBOLT','chase',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1033,'Elder Willow@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1033,'Elder Willow@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1033,'Elder Willow@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1034,'Thara Frog@NPC_WATERATTACK','attack',184,3,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1035,'Hunter Fly@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1035,'Hunter Fly@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1035,'Hunter Fly@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1035,'Hunter Fly@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1035,'Hunter Fly@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1035,'Hunter Fly@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1035,'Hunter Fly@NPC_BLOODDRAIN','angry',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1035,'Hunter Fly@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1035,'Hunter Fly@NPC_EMOTION','follow',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1035,'Hunter Fly@NPC_WINDATTACK','angry',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1036,'Ghoul@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1036,'Ghoul@NPC_POISON','angry',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1037,'Side Winder@KN_PIERCE','attack',56,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1037,'Side Winder@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1037,'Side Winder@NPC_POISONATTACK','attack',188,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_POWERUP','attack',349,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@AS_VENOMDUST','attack',140,5,2000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@AS_VENOMDUST','attack',140,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@MG_STONECURSE','attack',16,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@ASC_METEORASSAULT','attack',406,10,10000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_CURSEATTACK','attack',181,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_CURSEATTACK','chase',181,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_DARKBREATH','attack',202,5,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_DARKBREATH','chase',202,5,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_POISONATTACK','attack',188,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1522,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1522,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_SUMMONSLAVE','idle',196,7,10000,0,0,'no','self','onspawn','0',1029,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@SM_BASH','attack',5,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_DARKTHUNDER','chase',341,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@NPC_DARKTHUNDER','chase',341,10,10000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1038,'Osiris@WZ_QUAGMIRE','chase',92,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@MO_BODYRELOCATION','chase',264,1,2000,200,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_DARKSTRIKE','chase',340,10,2000,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@KN_BRANDISHSPEAR','attack',57,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_EARTHQUAKE','chase',653,5,10000,2000,30000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_EARTHQUAKE','attack',653,5,10000,2000,30000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_HELLJUDGEMENT','chase',662,5,10000,800,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_HELLJUDGEMENT','attack',662,5,10000,800,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_DARKBREATH','attack',202,5,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_SUMMONSLAVE','attack',196,6,10000,700,10000,'no','self','slavele','3',1431,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_SUMMONSLAVE','idle',196,6,10000,700,10000,'no','self','slavele','3',1431,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@NPC_SUMMONSLAVE','idle',196,4,10000,0,0,'no','self','onspawn','0',1101,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@WZ_VERMILION','attack',85,21,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@WZ_VERMILION','chase',85,21,5000,500,2000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@WZ_VERMILION','chase',85,21,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1039,'Baphomet@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1040,'Golem@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1040,'Golem@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1040,'Golem@CR_AUTOGUARD','attack',249,2,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1040,'Golem@CR_AUTOGUARD','chase',249,2,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1041,'Mummy@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1041,'Mummy@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1041,'Mummy@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1041,'Mummy@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1041,'Mummy@NPC_EMOTION','follow',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1041,'Mummy@NPC_UNDEADATTACK','attack',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1042,'Steel Chonchon@NPC_SILENCEATTACK','attack',178,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1042,'Steel Chonchon@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1044,'Obeaune@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1044,'Obeaune@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1044,'Obeaune@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1044,'Obeaune@PR_LEXDIVINA','attack',76,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1044,'Obeaune@PR_LEXDIVINA','chase',76,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1045,'Marc@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1045,'Marc@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1045,'Marc@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1045,'Marc@NPC_WATERATTACK','attack',184,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1045,'Marc@NPC_EMOTION','follow',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1045,'Marc@NPC_STUNATTACK','angry',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1045,'Marc@NPC_WATERATTACK','angry',184,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@AL_HEAL','attack',28,11,10000,0,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@AL_HEAL','attack',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@AL_HEAL','chase',28,11,10000,0,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@AL_HEAL','chase',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@LK_SPIRALPIERCE','attack',397,5,10000,1000,10000,'no','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@KN_TWOHANDQUICKEN','attack',60,30,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@BS_HAMMERFALL','attack',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@BS_HAMMERFALL','chase',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@NPC_CRITICALSLASH','attack',170,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@CR_AUTOGUARD','attack',249,10,2000,500,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@CR_AUTOGUARD','chase',249,10,2000,500,300000,'no','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@AL_DECAGI','attack',30,48,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@AL_DECAGI','chase',30,48,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@NPC_SUMMONSLAVE','attack',196,1,10000,700,10000,'no','self','slavele','3',1427,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@NPC_SUMMONSLAVE','idle',196,1,10000,700,10000,'no','self','slavele','3',1427,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1046,'Doppelganger@BS_HAMMERFALL','chase',110,10,10000,0,5000,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1047,'PecoPeco Egg@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1047,'PecoPeco Egg@NPC_METAMORPHOSIS','idle',193,1,10,2000,5000,'no','self','always','0',1049,1050,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1048,'Thief Bug Egg@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1048,'Thief Bug Egg@NPC_METAMORPHOSIS','idle',193,4,10,2000,5000,'no','self','always','0',1051,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1049,'Picky@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1049,'Picky@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1050,'Shell Picky@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1050,'Shell Picky@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1051,'Thief Bug Larva@NPC_AGIUP','loot',350,1,1000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1051,'Thief Bug Larva@NPC_AGIUP','idle',350,1,0,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1052,'Rocker@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1052,'Rocker@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1053,'Thief Bug Female@NPC_AGIUP','loot',350,1,1000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1053,'Thief Bug Female@NPC_AGIUP','idle',350,1,0,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1054,'Thief Bug Male@NPC_AGIUP','loot',350,1,1000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1054,'Thief Bug Male@NPC_AGIUP','idle',350,1,0,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1055,'Muka@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1055,'Muka@NPC_PIERCINGATT','attack',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1055,'Muka@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1056,'Smokie@AL_HEAL','idle',28,5,10000,0,5000,'yes','self','mystatuson','hiding',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1056,'Smokie@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1056,'Smokie@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1056,'Smokie@NPC_PROVOCATION','chase',194,1,200,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1056,'Smokie@TF_HIDING','attack',51,1,500,500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1057,'Yoyo@AM_POTIONPITCHER','idle',231,1,500,1500,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1057,'Yoyo@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1057,'Yoyo@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1057,'Yoyo@NPC_PROVOCATION','chase',194,1,200,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1057,'Yoyo@SM_PROVOKE','chase',6,10,500,600,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1057,'Yoyo@TF_THROWSTONE','chase',152,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1058,'Metaller@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1058,'Metaller@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1058,'Metaller@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1058,'Metaller@NPC_SILENCEATTACK','chase',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@AL_HEAL','attack',28,11,10000,0,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@AL_HEAL','attack',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@AL_HEAL','chase',28,11,10000,0,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@AL_HEAL','chase',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@AL_PNEUMA','attack',25,1,2000,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@AL_PNEUMA','chase',25,1,2000,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_WIDESILENCE','chase',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_WIDESILENCE','attack',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_GUIDEDATTACK','chase',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_SILENCEATTACK','attack',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_SILENCEATTACK','chase',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_SILENCEATTACK','chase',178,5,10000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1604,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1604,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_SUMMONSLAVE','idle',196,4,10000,0,0,'no','self','onspawn','0',1156,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@NPC_STOP','attack',342,1,2000,0,15000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@WZ_JUPITEL','attack',84,28,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1059,'Mistress@WZ_JUPITEL','chase',84,28,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1060,'Bigfoot@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1060,'Bigfoot@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1060,'Bigfoot@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1060,'Bigfoot@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1060,'Bigfoot@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1061,'Nightmare@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1061,'Nightmare@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1061,'Nightmare@NPC_MENTALBREAKER','attack',159,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1061,'Nightmare@NPC_TELEKINESISATTACK','attack',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1062,'Santa Poring@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1062,'Santa Poring@NPC_HOLYATTACK','attack',189,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1063,'Lunatic@NPC_RUN','attack',354,1,10000,0,3000,'no','self','always','0',NULL,0x81,NULL,NULL,NULL,'26',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1063,'Lunatic@NPC_RUN','chase',354,1,10000,0,3000,'no','self','always','0',NULL,0x81,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1064,'Megalodon@NPC_CHANGETELEKINESIS','attack',169,1,500,2000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1064,'Megalodon@NPC_UNDEADATTACK','attack',347,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@MG_FROSTDIVER','attack',15,9,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@MG_FROSTDIVER','chase',15,9,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@MG_LIGHTNINGBOLT','attack',20,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@MG_LIGHTNINGBOLT','chase',20,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',32,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@SA_DISPELL','attack',289,5,0,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@SA_DISPELL','chase',289,5,0,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@WZ_WATERBALL','attack',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@MG_FROSTDIVER','angry',15,9,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@MG_FROSTDIVER','follow',15,9,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@MG_LIGHTNINGBOLT','angry',20,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@MG_LIGHTNINGBOLT','follow',20,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@NPC_WATERATTACK','angry',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@SA_DISPELL','angry',289,5,0,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@SA_DISPELL','follow',289,5,0,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1065,'Strouf@WZ_WATERBALL','angry',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1066,'Vadon@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1066,'Vadon@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1066,'Vadon@CR_AUTOGUARD','chase',249,2,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1066,'Vadon@CR_AUTOGUARD','attack',249,2,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1067,'Cornutus@NPC_KEEPING','attack',201,1,2000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1067,'Cornutus@NPC_WATERATTACK','attack',184,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1067,'Cornutus@CR_AUTOGUARD','attack',249,2,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1067,'Cornutus@CR_AUTOGUARD','chase',249,2,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1068,'Hydra@NPC_WATERATTACK','attack',184,2,500,500,5000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1069,'Swordfish@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1069,'Swordfish@WZ_WATERBALL','attack',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1069,'Swordfish@WZ_WATERBALL','chase',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1069,'Swordfish@NPC_WATERATTACK','angry',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1069,'Swordfish@WZ_WATERBALL','angry',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1069,'Swordfish@WZ_WATERBALL','follow',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1070,'Kukre@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',0,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1070,'Kukre@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1071,'Pirate Skeleton@SM_BASH','attack',5,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1071,'Pirate Skeleton@SM_BASH','angry',5,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1071,'Pirate Skeleton@NPC_UNDEADATTACK','attack',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1072,'Kaho@MG_FIREBOLT','attack',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1072,'Kaho@MG_FIREBOLT','chase',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1072,'Kaho@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1072,'Kaho@MG_FIREBOLT','angry',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1072,'Kaho@MG_FIREBOLT','follow',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1072,'Kaho@NPC_FIREATTACK','angry',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1073,'Crab@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1074,'Shellfish@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1076,'Skeleton@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',1,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1076,'Skeleton@NPC_UNDEADATTACK','attack',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1077,'Poison Spore@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1077,'Poison Spore@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1077,'Poison Spore@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1077,'Poison Spore@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',1,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1077,'Poison Spore@NPC_POISON','angry',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1077,'Poison Spore@NPC_POISONATTACK','angry',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1077,'Poison Spore@NPC_EMOTION','follow',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@HP_ASSUMPTIO','idle',361,5,10000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@HP_ASSUMPTIO','attack',361,5,10000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@CR_REFLECTSHIELD','attack',252,10,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@CR_REFLECTSHIELD','chase',252,10,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@MC_MAMMONITE','attack',42,22,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@SM_MAGNUM','attack',7,25,2000,0,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@MG_FIREBALL','chase',17,44,2000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@NPC_SUMMONSLAVE','attack',196,10,10000,700,10000,'no','self','slavele','5',1608,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@NPC_SUMMONSLAVE','idle',196,10,10000,700,10000,'no','self','slavele','5',1608,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@NPC_SUMMONSLAVE','idle',196,10,10000,0,0,'no','self','onspawn','0',1054,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@TF_HIDING','attack',51,1,1000,0,5000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1086,'Golden Thief Bug@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','mystatuson','hiding',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@AL_DECAGI','chase',30,48,2000,0,300000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@NPC_ARMORBRAKE','attack',344,10,2000,500,300000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@NPC_ARMORBRAKE','chase',344,10,2000,500,300000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@NPC_POWERUP','attack',349,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@LK_SPIRALPIERCE','attack',397,5,1500,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@KN_TWOHANDQUICKEN','attack',60,30,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@MG_THUNDERSTORM','attack',21,20,2000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@MG_THUNDERSTORM','chase',21,20,10000,1500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@NPC_GROUNDATTACK','attack',185,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@CR_AUTOGUARD','attack',249,10,2000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@NPC_SUMMONSLAVE','attack',196,8,10000,700,10000,'no','self','slavele','3',1439,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@NPC_SUMMONSLAVE','idle',196,8,10000,700,10000,'no','self','slavele','3',1439,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1087,'Orc Hero@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1088,'Vocal@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1088,'Vocal@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1088,'Vocal@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1088,'Vocal@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1088,'Vocal@NPC_SILENCEATTACK','chase',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1088,'Vocal@NPC_SUMMONSLAVE','attack',196,5,10000,2000,60000,'no','self','slavele','3',1052,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1088,'Vocal@NPC_SUMMONSLAVE','idle',196,5,10000,2000,60000,'no','self','slavele','3',1052,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1088,'Vocal@NPC_SUMMONSLAVE','idle',196,8,10000,0,0,'no','self','onspawn','0',1052,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1089,'Toad@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1089,'Toad@NPC_SUMMONSLAVE','attack',196,5,10000,2000,60000,'no','self','slavele','3',1012,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1089,'Toad@NPC_SUMMONSLAVE','idle',196,6,10000,0,0,'no','self','onspawn','0',1012,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1089,'Toad@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1090,'Mastering@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1090,'Mastering@NPC_SUMMONSLAVE','attack',196,5,10000,2000,60000,'no','self','slavele','3',1002,1113,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1090,'Mastering@NPC_SUMMONSLAVE','idle',196,5,10000,2000,60000,'no','self','slavele','3',1002,1113,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1090,'Mastering@NPC_SUMMONSLAVE','idle',196,10,10000,0,0,'no','self','onspawn','0',1002,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1090,'Mastering@NPC_WATERATTACK','attack',184,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1091,'Dragon Fly@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1091,'Dragon Fly@NPC_SILENCEATTACK','attack',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1091,'Dragon Fly@NPC_SILENCEATTACK','chase',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1091,'Dragon Fly@NPC_SUMMONSLAVE','attack',196,5,10000,2000,60000,'no','self','slavele','0',1011,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1091,'Dragon Fly@NPC_SUMMONSLAVE','idle',196,5,10000,2000,60000,'no','self','slavele','0',1011,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1091,'Dragon Fly@NPC_SUMMONSLAVE','idle',196,8,10000,0,0,'no','self','onspawn','0',1011,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1091,'Dragon Fly@NPC_WINDATTACK','attack',187,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1092,'Vagabond Wolf@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1092,'Vagabond Wolf@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1092,'Vagabond Wolf@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',27,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1092,'Vagabond Wolf@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1092,'Vagabond Wolf@NPC_SUMMONSLAVE','attack',196,5,10000,2000,60000,'no','self','slavele','3',1013,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1092,'Vagabond Wolf@NPC_SUMMONSLAVE','idle',196,5,10000,2000,60000,'no','self','slavele','3',1013,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1092,'Vagabond Wolf@NPC_SUMMONSLAVE','idle',196,5,10000,0,0,'no','self','onspawn','0',1013,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1093,'Eclipse@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1093,'Eclipse@NPC_LICK','attack',206,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1093,'Eclipse@NPC_SUMMONSLAVE','idle',196,5,10000,2000,60000,'no','self','slavele','3',1063,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1093,'Eclipse@NPC_SUMMONSLAVE','idle',196,8,10000,0,0,'no','self','onspawn','0',1063,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1094,'Ambernite@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1094,'Ambernite@NPC_KEEPING','attack',201,1,2000,0,5000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1094,'Ambernite@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1095,'Andre@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1095,'Andre@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@AL_HEAL','attack',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@AL_HEAL','attack',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@AL_HEAL','chase',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@AL_HEAL','chase',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@MG_SAFETYWALL','attack',12,5,1000,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@NPC_HOLYATTACK','attack',189,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@NPC_HOLYATTACK','chase',189,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@NPC_SUMMONSLAVE','attack',196,5,10000,2000,60000,'no','self','slavele','3',1031,1062,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@NPC_SUMMONSLAVE','idle',196,5,10000,2000,60000,'no','self','slavele','3',1031,1062,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@NPC_SUMMONSLAVE','idle',196,3,10000,0,0,'no','self','onspawn','0',1031,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@SA_REVERSEORCISH','chase',294,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1096,'Angeling@SA_REVERSEORCISH','attack',294,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1097,'Ant Egg@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1097,'Ant Egg@NPC_METAMORPHOSIS','idle',193,1,10,2000,5000,'no','self','always','0',1095,1105,1160,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@NPC_CURSEATTACK','chase',181,1,1000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@NPC_CRITICALWOUND','attack',673,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@NPC_DARKSTRIKE','chase',340,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@NPC_DARKSTRIKE','attack',340,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@MG_FIREWALL','chase',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@NPC_BLINDATTACK','chase',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@NPC_MAGICALATTACK','attack',192,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@NPC_UNDEADATTACK','attack',347,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@NPC_DARKBREATH','attack',202,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@WZ_JUPITEL','attack',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@WZ_JUPITEL','chase',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@MG_THUNDERSTORM','attack',21,5,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@MG_THUNDERSTORM','chase',21,5,1000,1500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@AL_HEAL','attack',28,5,5000,500,5000,'yes','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@AL_HEAL','idle',28,5,10000,500,5000,'yes','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@AL_HEAL','chase',28,5,10000,500,5000,'yes','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1098,'Anubis@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1099,'Argiope@AS_VENOMDUST','attack',140,1,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1099,'Argiope@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1099,'Argiope@NPC_POISONATTACK','attack',188,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1099,'Argiope@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1099,'Argiope@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1100,'Argos@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1100,'Argos@PF_SPIDERWEB','idle',405,1,3000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1100,'Argos@PF_SPIDERWEB','attack',405,1,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1100,'Argos@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1101,'Baphomet Jr.@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1101,'Baphomet Jr.@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1101,'Baphomet Jr.@SA_DISPELL','attack',289,1,0,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1101,'Baphomet Jr.@NPC_DARKNESSATTACK','attack',190,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1101,'Baphomet Jr.@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1101,'Baphomet Jr.@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1101,'Baphomet Jr.@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1101,'Baphomet Jr.@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1101,'Baphomet Jr.@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1102,'Bathory@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1102,'Bathory@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',30,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1102,'Bathory@NPC_ENERGYDRAIN','attack',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1102,'Bathory@NPC_ENERGYDRAIN','chase',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1102,'Bathory@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1102,'Bathory@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1103,'Caramel@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1103,'Caramel@NPC_PIERCINGATT','attack',158,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1104,'Coco@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1104,'Coco@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1104,'Coco@TF_THROWSTONE','chase',152,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1105,'Deniro@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1105,'Deniro@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1106,'Desert Wolf@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1106,'Desert Wolf@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1106,'Desert Wolf@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1106,'Desert Wolf@TF_SPRINKLESAND','attack',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1107,'Baby Desert Wolf@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1107,'Baby Desert Wolf@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1108,'Deviace@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1108,'Deviace@WZ_WATERBALL','attack',86,4,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1108,'Deviace@WZ_WATERBALL','chase',86,4,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1108,'Deviace@NPC_EMOTION_ON','attack',474,1,10000,0,30000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1108,'Deviace@NPC_EMOTION','idle',197,1,200,0,30000,'yes','self','always','0',9,0x91,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1109,'Deviruchi@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1109,'Deviruchi@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1109,'Deviruchi@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1109,'Deviruchi@NPC_ENERGYDRAIN','attack',200,1,500,0,5000,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1109,'Deviruchi@NPC_ENERGYDRAIN','chase',200,1,500,0,5000,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1109,'Deviruchi@NPC_DARKTHUNDER','attack',341,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1109,'Deviruchi@NPC_DARKTHUNDER','chase',341,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1110,'Dokebi@BS_ADRENALINE','attack',111,1,500,1500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1110,'Dokebi@BS_ADRENALINE','chase',111,1,500,1500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1110,'Dokebi@MC_MAMMONITE','attack',42,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1110,'Dokebi@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1110,'Dokebi@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1111,'Drainliar@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1111,'Drainliar@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1111,'Drainliar@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@AL_DECAGI','chase',30,48,2000,0,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_ARMORBRAKE','attack',344,10,2000,0,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@BS_MAXIMIZE','attack',114,1,500,0,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@BS_MAXIMIZE','chase',114,1,500,0,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_AGIUP','attack',350,10,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_GUIDEDATTACK','chase',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1566,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1566,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_SUMMONSLAVE','idle',196,4,10000,0,0,'no','self','onspawn','0',1192,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_WATERATTACK','attack',184,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_WATERATTACK','chase',184,5,2000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@NPC_WATERATTACK','chase',184,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@WZ_WATERBALL','attack',86,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1112,'Drake@WZ_WATERBALL','chase',86,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1113,'Drops@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1113,'Drops@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1114,'Dustiness@NPC_BLINDATTACK','attack',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1114,'Dustiness@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1114,'Dustiness@NPC_SLEEPATTACK','attack',182,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1114,'Dustiness@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@MG_FIREBALL','chase',17,44,4000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@MG_FIREBALL','chase',17,44,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@NPC_BLEEDING','attack',660,5,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@AM_DEMONSTRATION','attack',229,5,2000,0,2000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@AM_DEMONSTRATION','chase',229,5,2000,0,2000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@NPC_SUMMONSLAVE','attack',196,8,10000,700,10000,'no','self','slavele','3',1603,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@NPC_SUMMONSLAVE','idle',196,8,10000,700,10000,'no','self','slavele','3',1603,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@NPC_SUMMONSLAVE','idle',196,5,10000,0,0,'no','self','onspawn','0',1060,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@SM_MAGNUM','attack',7,25,3000,0,2000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1115,'Eddga@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1116,'Eggyra@NPC_BLINDATTACK','attack',177,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1116,'Eggyra@NPC_TELEKINESISATTACK','attack',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1116,'Eggyra@CR_AUTOGUARD','attack',249,2,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1116,'Eggyra@CR_AUTOGUARD','chase',249,2,2000,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1117,'Evil Druid@NPC_BLINDATTACK','attack',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1117,'Evil Druid@NPC_BLINDATTACK','chase',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1117,'Evil Druid@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1117,'Evil Druid@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1117,'Evil Druid@NPC_ENERGYDRAIN','attack',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1117,'Evil Druid@NPC_ENERGYDRAIN','chase',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1117,'Evil Druid@NPC_UNDEADATTACK','attack',347,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1117,'Evil Druid@NPC_UNDEADATTACK','chase',347,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1117,'Evil Druid@WZ_HEAVENDRIVE','attack',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1117,'Evil Druid@WZ_HEAVENDRIVE','chase',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1118,'Flora@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1118,'Flora@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1118,'Flora@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1119,'Frilldora@AS_CLOAKING','attack',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1119,'Frilldora@AS_CLOAKING','idle',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1119,'Frilldora@AS_CLOAKING','chase',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1119,'Frilldora@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1119,'Frilldora@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',1,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1119,'Frilldora@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1119,'Frilldora@AS_CLOAKING','angry',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1119,'Frilldora@AS_CLOAKING','follow',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1119,'Frilldora@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1119,'Frilldora@NPC_FIREATTACK','angry',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@AL_TELEPORT','attack',26,1,5000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'28',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'28',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'28',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@NPC_INVISIBLE','attack',353,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@NPC_INVISIBLE','idle',353,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@NPC_INVISIBLE','chase',353,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@MG_SOULSTRIKE','chase',13,9,2000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@NPC_DARKBREATH','attack',202,4,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'28',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',28,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@NPC_SUMMONSLAVE','attack',196,5,10000,2000,10000,'no','self','slavele','3',1599,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@NPC_SUMMONSLAVE','idle',196,5,10000,2000,10000,'no','self','slavele','3',1599,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@NPC_SUMMONSLAVE','idle',196,5,10000,0,0,'no','self','onspawn','0',1186,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1120,'Ghostring@NPC_TELEKINESISATTACK','attack',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'28',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1121,'Giearth@HT_SANDMAN','idle',119,5,500,0,300000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1121,'Giearth@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',8,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1121,'Giearth@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1121,'Giearth@TF_SPRINKLESAND','attack',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1122,'Goblin@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',18,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1122,'Goblin@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1122,'Goblin@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1122,'Goblin@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1123,'Goblin@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',29,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1123,'Goblin@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1123,'Goblin@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1123,'Goblin@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1124,'Goblin@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1124,'Goblin@NPC_POISONATTACK','attack',188,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1124,'Goblin@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1124,'Goblin@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1125,'Goblin@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',20,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1125,'Goblin@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1125,'Goblin@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1125,'Goblin@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1126,'Goblin@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',28,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1126,'Goblin@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1126,'Goblin@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1126,'Goblin@NPC_WATERATTACK','attack',184,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1127,'Hode@AS_CLOAKING','attack',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1127,'Hode@AS_CLOAKING','chase',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1127,'Hode@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1128,'Horn@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1128,'Horn@NPC_PIERCINGATT','attack',158,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1129,'Horong@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1129,'Horong@MG_SIGHT','chase',10,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1129,'Horong@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1129,'Horong@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1129,'Horong@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1130,'Jakk@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1130,'Jakk@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1130,'Jakk@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1130,'Jakk@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1130,'Jakk@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1130,'Jakk@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@MG_FIREBALL','chase',17,5,500,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'10',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@MG_FROSTDIVER','chase',15,9,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'10',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@MG_SOULSTRIKE','chase',13,9,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@NPC_ATTRICHANGE','idle',161,1,500,2000,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'10',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@NPC_ENERGYDRAIN','chase',200,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@NPC_WINDATTACK','chase',187,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@WZ_HEAVENDRIVE','chase',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@NPC_DARKTHUNDER','chase',341,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@WZ_QUAGMIRE','chase',92,5,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@NPC_EMOTION_ON','idle',474,1,100,0,60000,'yes','self','always','0',20,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@NPC_EMOTION','idle',197,1,100,0,60000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@NPC_EMOTION','attack',197,1,10000,0,60000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1131,'Joker@NPC_EMOTION_ON','idle',474,1,100,0,60000,'yes','self','always','0',22,0x83,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1132,'Khalitzburg@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1132,'Khalitzburg@AS_GRIMTOOTH','chase',137,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1132,'Khalitzburg@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1132,'Khalitzburg@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1132,'Khalitzburg@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1132,'Khalitzburg@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1133,'Kobold 1@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1133,'Kobold@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1133,'Kobold@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1133,'Kobold@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1134,'Kobold@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1134,'Kobold@NPC_POISONATTACK','attack',188,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1134,'Kobold@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1134,'Kobold@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1135,'Kobold@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1135,'Kobold@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1135,'Kobold@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1135,'Kobold@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1138,'Magnolia@HT_FLASHER','idle',120,5,500,0,300000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1138,'Magnolia@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',28,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1138,'Magnolia@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1138,'Magnolia@NPC_UNDEADATTACK','attack',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1139,'Mantis@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1139,'Mantis@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1139,'Mantis@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1139,'Mantis@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1140,'Marduk@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1140,'Marduk@MG_FIREBOLT','attack',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1140,'Marduk@MG_FIREBOLT','chase',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1140,'Marduk@MG_FIREWALL','chase',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1140,'Marduk@NPC_BLINDATTACK','chase',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1140,'Marduk@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1140,'Marduk@NPC_MAGICALATTACK','attack',192,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1141,'Marina@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1141,'Marina@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1141,'Marina@NPC_WATERATTACK','attack',184,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1142,'Marine Sphere@NPC_RUN','idle',354,7,10000,0,30000,'no','master','alchemist',NULL,NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1142,'Marine Sphere@NPC_SELFDESTRUCTION','any',173,1,10000,3000,0,'no','self','afterskill','354',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1142,'Marine Sphere@NPC_SELFDESTRUCTION','idle',173,1,500,2000,5000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1142,'Marine Sphere@NPC_SELFDESTRUCTION','idle',173,1,10000,2000,5000,'no','self','skillused','173',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1142,'Marine Sphere@NPC_SELFDESTRUCTION','idle',173,1,10000,0,0,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1142,'Marine Sphere@NPC_SPEEDUP','any',332,1,10000,0,700,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1143,'Marionette@HT_FREEZINGTRAP','idle',121,5,500,0,300000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1143,'Marionette@MG_FIREWALL','chase',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1143,'Marionette@NPC_TELEKINESISATTACK','attack',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1144,'Marse@NPC_BLINDATTACK','attack',177,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1144,'Marse@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',1,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1144,'Marse@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x91,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1144,'Marse@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1145,'Martin@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1145,'Martin@TF_HIDING','attack',51,1,2000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1145,'Martin@TF_SPRINKLESAND','attack',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1146,'Matyr@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1146,'Matyr@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1146,'Matyr@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',7,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1146,'Matyr@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@AL_HEAL','attack',28,11,10000,0,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@AL_HEAL','attack',28,11,10000,0,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@AL_HEAL','chase',28,11,10000,0,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@AL_HEAL','chase',28,11,10000,0,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@AL_TELEPORT','walk',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@NPC_WIDESILENCE','chase',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@NPC_WIDESILENCE','attack',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@KN_BRANDISHSPEAR','attack',57,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@NPC_POWERUP','attack',349,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@CR_AUTOGUARD','attack',249,10,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1477,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1477,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@NPC_SUMMONSLAVE','idle',196,10,10000,0,0,'no','self','onspawn','0',1194,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@WZ_HEAVENDRIVE','attack',91,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@WZ_HEAVENDRIVE','chase',91,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1147,'Maya@WZ_HEAVENDRIVE','chase',91,5,10000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1148,'Medusa@MG_STONECURSE','attack',16,10,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1148,'Medusa@NPC_PETRIFYATTACK','attack',180,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1148,'Medusa@NPC_PETRIFYATTACK','chase',180,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1148,'Medusa@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1148,'Medusa@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1149,'Minorous@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1149,'Minorous@BS_HAMMERFALL','attack',110,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1149,'Minorous@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1149,'Minorous@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1149,'Minorous@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1149,'Minorous@WZ_HEAVENDRIVE','attack',91,3,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@AL_HEAL','attack',28,11,10000,0,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@AL_HEAL','attack',28,11,10000,0,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@AL_HEAL','chase',28,11,10000,0,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@AL_HEAL','chase',28,11,10000,0,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@SA_LANDPROTECTOR','chase',288,1,10000,1000,5000,'no','target','skillused','89',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@SA_LANDPROTECTOR','attack',288,1,10000,500,10000,'no','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@NPC_WIDESILENCE','chase',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@NPC_WIDESILENCE','attack',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@ST_FULLSTRIP','attack',476,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@MC_MAMMONITE','attack',42,22,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@MG_COLDBOLT','chase',14,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@MG_COLDBOLT','chase',14,5,4000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@MG_FIREBOLT','chase',19,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@MG_FIREBOLT','chase',19,5,4000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@MG_LIGHTNINGBOLT','chase',20,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@MG_LIGHTNINGBOLT','chase',20,5,4000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@SA_DISPELL','attack',289,5,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@SA_DISPELL','chase',289,5,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1471,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1471,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@NPC_SUMMONSLAVE','idle',196,3,10000,0,0,'no','self','onspawn','0',1180,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@BS_HAMMERFALL','chase',110,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1150,'Moonlight Flower@BS_HAMMERFALL','attack',110,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1151,'Myst@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1151,'Myst@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1151,'Myst@NPC_MENTALBREAKER','attack',159,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1151,'Myst@NPC_POISONATTACK','attack',188,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1152,'Orc Skeleton@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1152,'Orc Skeleton@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1152,'Orc Skeleton@NPC_UNDEADATTACK','attack',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1152,'Orc Skeleton@NPC_UNDEADATTACK','angry',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1153,'Orc Zombie@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1153,'Orc Zombie@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1153,'Orc Zombie@NPC_UNDEADATTACK','attack',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1153,'Orc Zombie@NPC_UNDEADATTACK','angry',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1154,'Pasana@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1154,'Pasana@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1154,'Pasana@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1154,'Pasana@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1154,'Pasana@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1154,'Pasana@SM_BASH','attack',5,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1155,'Petite@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1155,'Petite@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1155,'Petite@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1155,'Petite@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1155,'Petite@NPC_TELEKINESISATTACK','chase',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1156,'Petite@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1156,'Petite@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1156,'Petite@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1156,'Petite@NPC_TELEKINESISATTACK','chase',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1156,'Petite@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@AC_CHARGEARROW','attack',148,1,2000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@MG_THUNDERSTORM','chase',21,9,2000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_DARKSTRIKE','attack',340,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_DARKSTRIKE','chase',340,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_DARKBLESSING','attack',203,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_ENERGYDRAIN','attack',200,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_ENERGYDRAIN','chase',200,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_ENERGYDRAIN','chase',200,1,10000,0,5000,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_GUIDEDATTACK','chase',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_SUMMONSLAVE','attack',196,6,10000,700,10000,'no','self','slavele','3',1458,1464,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1157,'Pharaoh@NPC_SUMMONSLAVE','idle',196,6,10000,700,10000,'no','self','slavele','3',1458,1464,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1158,'Phen@NPC_PROVOCATION','chase',194,1,200,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1158,'Phen@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_POWERUP','attack',349,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_WIDESTONE','chase',666,5,10000,500,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_WIDESTONE','attack',666,5,10000,500,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_HELMBRAKE','attack',345,10,2000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_GUIDEDATTACK','chase',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_LICK','attack',206,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_PETRIFYATTACK','chase',180,5,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_SUMMONSLAVE','attack',196,6,10000,700,10000,'no','self','slavele','3',1558,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_SUMMONSLAVE','idle',196,6,10000,700,10000,'no','self','slavele','3',1558,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@NPC_SUMMONSLAVE','idle',196,10,10000,0,0,'no','self','onspawn','0',1127,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@TF_HIDING','attack',51,1,2000,500,5000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','mystatuson','hiding',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@WZ_HEAVENDRIVE','chase',91,5,10000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1159,'Phreeoni@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1160,'Piere@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1160,'Piere@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1161,'Plankton@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1163,'Raydric@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1163,'Raydric@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1163,'Raydric@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1163,'Raydric@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',0,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1163,'Raydric@SM_MAGNUM','attack',7,9,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1163,'Raydric@CR_AUTOGUARD','chase',249,2,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1163,'Raydric@CR_AUTOGUARD','attack',249,2,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1164,'Requiem@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1164,'Requiem@NPC_EMOTION','walk',197,1,200,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1164,'Requiem@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1165,'Sandman@AS_CLOAKING','attack',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1165,'Sandman@AS_CLOAKING','idle',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1165,'Sandman@AS_CLOAKING','chase',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1165,'Sandman@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1165,'Sandman@TF_SPRINKLESAND','attack',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1165,'Sandman@AS_CLOAKING','angry',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1165,'Sandman@NPC_GROUNDATTACK','angry',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1165,'Sandman@TF_SPRINKLESAND','angry',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1166,'Savage@AL_INCAGI','chase',29,1,500,700,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1166,'Savage@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1166,'Savage@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1167,'Savage Babe@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1167,'Savage Babe@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1169,'Skeleton Worker@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1169,'Skeleton Worker@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',1,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1169,'Skeleton Worker@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1170,'Sohee@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',28,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1170,'Sohee@NPC_STOP','attack',342,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1170,'Sohee@NPC_SUICIDE','attack',175,1,500,0,5000,'yes','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1170,'Sohee@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1174,'Stainer@NPC_KEEPING','attack',201,1,2000,0,5000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1174,'Stainer@NPC_SILENCEATTACK','attack',178,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1174,'Stainer@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1175,'Tarou@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1175,'Tarou@NPC_POISON','attack',176,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1176,'Vitata@AM_POTIONPITCHER','attack',231,2,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1176,'Vitata@AM_POTIONPITCHER','attack',231,2,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1176,'Vitata@AM_POTIONPITCHER','chase',231,2,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1176,'Vitata@AM_POTIONPITCHER','chase',231,2,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1176,'Vitata@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1177,'Zenorc@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1177,'Zenorc@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',29,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1177,'Zenorc@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1178,'Zerom@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1178,'Zerom@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1178,'Zerom@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1178,'Zerom@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1178,'Zerom@NPC_FIREATTACK','angry',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1178,'Zerom@NPC_EMOTION','follow',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1179,'Whisper@AS_CLOAKING','attack',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1179,'Whisper@AS_CLOAKING','idle',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1179,'Whisper@AS_CLOAKING','chase',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1179,'Whisper@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1179,'Whisper@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1179,'Whisper@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',28,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1179,'Whisper@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'28',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1180,'Nine-Tail@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1180,'Nine-Tail@NPC_ATTRICHANGE','attack',161,1,500,2000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1180,'Nine-Tail@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1180,'Nine-Tail@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1180,'Nine-Tail@NPC_RANDOMATTACK','attack',183,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1188,'Bon Gun@KN_SPEARSTAB','attack',58,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1188,'Bon Gun@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1189,'Orc Archer@AC_SHOWER','attack',47,5,2000,1000,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1189,'Orc Archer@HT_ANKLESNARE','idle',117,5,500,0,300000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1189,'Orc Archer@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',5,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1189,'Orc Archer@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1189,'Orc Archer@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@AL_INCAGI','chase',29,10,2000,700,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@CR_SHIELDCHARGE','attack',250,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@NPC_EARTHQUAKE','chase',653,5,10000,1500,30000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@NPC_EARTHQUAKE','attack',653,5,10000,1500,30000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@NPC_POWERUP','attack',349,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@MG_COLDBOLT','chase',14,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@MG_FIREBOLT','chase',19,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@NPC_SHIELDBRAKE','attack',346,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@NPC_GROUNDATTACK','attack',185,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@NPC_SUMMONSLAVE','attack',196,6,10000,700,10000,'no','self','slavele','3',1473,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@NPC_SUMMONSLAVE','idle',196,6,10000,700,10000,'no','self','slavele','3',1473,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@NPC_SUMMONSLAVE','idle',196,5,10000,0,0,'no','self','onspawn','0',1189,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@PR_LEXDIVINA','chase',76,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@PR_LEXDIVINA','chase',76,10,10000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@SM_PROVOKE','chase',6,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1190,'Orc Lord@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1191,'Mimic@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1191,'Mimic@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',29,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1191,'Mimic@CR_AUTOGUARD','chase',249,2,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1191,'Mimic@CR_AUTOGUARD','attack',249,2,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1192,'Wraith@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1192,'Wraith@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1192,'Wraith@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1192,'Wraith@NPC_ENERGYDRAIN','attack',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1193,'Alarm@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1193,'Alarm@NPC_DARKBREATH','attack',202,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1193,'Alarm@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1193,'Alarm@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1193,'Alarm@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1194,'Arclouse@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1194,'Arclouse@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1194,'Arclouse@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1194,'Arclouse@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1195,'Rideword@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1195,'Rideword@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1195,'Rideword@NPC_PIERCINGATT','attack',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1196,'Skeleton Prisoner@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1196,'Skeleton Prisoner@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1197,'Zombie Prisoner@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1197,'Zombie Prisoner@NPC_UNDEADATTACK','attack',347,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1198,'Dark Priest@NPC_DARKCROSS','attack',338,10,5000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1198,'Dark Priest@NPC_CHANGEUNDEAD','attack',348,5,1000,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1198,'Dark Priest@MO_BODYRELOCATION','chase',264,1,10000,0,5000,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1198,'Dark Priest@NPC_DARKBREATH','chase',202,5,500,800,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1198,'Dark Priest@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1199,'Punk@NPC_PETRIFYATTACK','attack',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1199,'Punk@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1199,'Punk@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1199,'Punk@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1200,'Zherlthsh@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1200,'Zherlthsh@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1200,'Zherlthsh@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',30,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1200,'Zherlthsh@NPC_GUIDEDATTACK','attack',172,3,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1200,'Zherlthsh@NPC_LICK','attack',206,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1200,'Zherlthsh@NPC_SUMMONSLAVE','idle',196,3,10000,2000,60000,'no','self','slavele','0',1257,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1200,'Zherlthsh@NPC_STOP','attack',342,1,500,0,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1201,'Rybio@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'4',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1201,'Rybio@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'4',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1201,'Rybio@SM_PROVOKE','chase',6,10,500,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'4',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1202,'Phendark@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1202,'Phendark@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1202,'Phendark@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1203,'Mysteltainn@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1203,'Mysteltainn@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1203,'Mysteltainn@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1203,'Mysteltainn@NPC_GUIDEDATTACK','attack',172,1,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1203,'Mysteltainn@NPC_SHIELDBRAKE','attack',346,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1203,'Mysteltainn@CR_AUTOGUARD','chase',249,10,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1203,'Mysteltainn@CR_AUTOGUARD','attack',249,10,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1204,'Tyrfing@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1204,'Tyrfing@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1204,'Tyrfing@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',29,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1204,'Tyrfing@NPC_PIERCINGATT','attack',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1204,'Tyrfing@NPC_HELMBRAKE','attack',345,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1204,'Tyrfing@CR_AUTOGUARD','chase',249,10,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1204,'Tyrfing@CR_AUTOGUARD','attack',249,10,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1205,'Executioner@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1205,'Executioner@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1205,'Executioner@CR_AUTOGUARD','chase',249,10,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1205,'Executioner@CR_AUTOGUARD','attack',249,10,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1205,'Executioner@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1205,'Executioner@NPC_ARMORBRAKE','attack',344,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1206,'Anolian@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1206,'Anolian@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1206,'Anolian@SM_BASH','attack',5,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1206,'Anolian@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1206,'Anolian@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1207,'Sting@AM_POTIONPITCHER','idle',231,4,10000,0,5000,'yes','self','mystatuson','hiding',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1207,'Sting@KN_SPEARSTAB','attack',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1207,'Sting@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1207,'Sting@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1207,'Sting@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1207,'Sting@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',20,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1207,'Sting@TF_HIDING','attack',51,1,2000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'10',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1207,'Sting@WZ_QUAGMIRE','attack',92,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1207,'Sting@WZ_QUAGMIRE','chase',92,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1208,'Wanderer@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1208,'Wanderer@KN_AUTOCOUNTER','attack',61,5,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1208,'Wanderer@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1208,'Wanderer@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1208,'Wanderer@NPC_UNDEADATTACK','attack',347,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1208,'Wanderer@RG_INTIMIDATE','attack',219,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1209,'Cramp@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1209,'Cramp@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1211,'Brilight@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1211,'Brilight@NPC_KEEPING','attack',201,1,2000,0,5000,'yes','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1211,'Brilight@NPC_PIERCINGATT','attack',158,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1211,'Brilight@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1213,'High Orc@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1213,'High Orc@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1213,'High Orc@CR_SHIELDCHARGE','attack',250,1,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1213,'High Orc@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1213,'High Orc@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1213,'High Orc@NPC_SMOKING','idle',195,1,500,0,36000000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1214,'Choco@AM_POTIONPITCHER','idle',231,1,500,1500,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1214,'Choco@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1214,'Choco@HT_SKIDTRAP','idle',115,5,500,0,5000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1214,'Choco@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1214,'Choco@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1214,'Choco@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1214,'Choco@NPC_SUMMONSLAVE','attack',196,3,10000,2000,60000,'no','self','slavele','0',1057,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1214,'Choco@NPC_SUMMONSLAVE','idle',196,3,10000,2000,60000,'no','self','slavele','0',1057,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1214,'Choco@SM_PROVOKE','chase',6,10,500,600,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1214,'Choco@TF_THROWSTONE','chase',152,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1215,'Stem Worm@NPC_GUIDEDATTACK','attack',172,1,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1215,'Stem Worm@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1216,'Penomena@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1216,'Penomena@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1216,'Penomena@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1219,'Knight of Abyss@AC_CHARGEARROW','chase',148,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1219,'Knight of Abyss@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1219,'Knight of Abyss@KN_BRANDISHSPEAR','attack',57,10,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1219,'Knight of Abyss@NPC_DARKNESSATTACK','attack',190,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1219,'Knight of Abyss@NPC_SUMMONSLAVE','idle',196,2,10000,2000,600000,'no','self','slavele','0',1132,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1219,'Knight of Abyss@NPC_ARMORBRAKE','attack',344,10,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1219,'Knight of Abyss@CR_AUTOGUARD','chase',249,10,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1219,'Knight of Abyss@CR_AUTOGUARD','attack',249,10,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1242,'Marin@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1242,'Marin@MG_FROSTDIVER','attack',15,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1242,'Marin@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1242,'Marin@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1243,'Sasquatch@KN_SPEARSTAB','attack',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1243,'Sasquatch@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1243,'Sasquatch@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1243,'Sasquatch@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1243,'Sasquatch@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1244,'Christmas Jakk@NPC_EMOTION','idle',197,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1245,'Christmas Goblin@MG_FROSTDIVER','attack',15,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1245,'Christmas Goblin@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',18,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1245,'Christmas Goblin@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1245,'Christmas Goblin@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,0x3695,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1245,'Christmas Goblin@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1246,'Christmas Cookie@MG_COLDBOLT','attack',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1246,'Christmas Cookie@MG_COLDBOLT','chase',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1246,'Christmas Cookie@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1246,'Christmas Cookie@NPC_HOLYATTACK','attack',189,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1246,'Christmas Cookie@PR_LEXAETERNA','attack',78,1,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1246,'Christmas Cookie@PR_LEXAETERNA','chase',78,1,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1246,'Christmas Cookie@SA_REVERSEORCISH','attack',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1246,'Christmas Cookie@SA_REVERSEORCISH','chase',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1247,'Antonio@AL_TELEPORT','attack',26,1,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1247,'Antonio@AL_TELEPORT','idle',26,1,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1247,'Antonio@AL_TELEPORT','chase',26,1,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1247,'Antonio@NPC_RUN','attack',354,1,10000,0,0,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1247,'Antonio@NPC_RUN','chase',354,1,10000,0,0,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1248,'Cruiser@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'24',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1248,'Cruiser@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',27,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1248,'Cruiser@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1249,'Myst Case@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1249,'Myst Case@KN_SPEARSTAB','attack',58,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1249,'Myst Case@MC_MAMMONITE','attack',42,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1249,'Myst Case@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',3,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1249,'Myst Case@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1249,'Myst Case@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@AL_HEAL','attack',28,9,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@AL_HEAL','attack',28,9,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@AL_HEAL','chase',28,9,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@AL_HEAL','chase',28,9,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@NPC_EMOTION','attack',197,1,2000,0,5000,'yes','self','always','0',17,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@AM_DEMONSTRATION','attack',229,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'17',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@AM_DEMONSTRATION','chase',229,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'17',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@WZ_FIREPILLAR','idle',80,5,500,0,5000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@NPC_SUMMONSLAVE','attack',196,3,10000,2000,60000,'no','self','slavele','0',1743,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@NPC_SUMMONSLAVE','idle',196,3,10000,2000,60000,'no','self','slavele','0',1743,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@PR_STRECOVERY','attack',72,1,2000,700,5000,'yes','friend','friendstatuson','anybad',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1250,'Chepet@PR_STRECOVERY','chase',72,1,2000,700,5000,'yes','friend','friendstatuson','anybad',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_WIDEFREEZE','chase',664,5,10000,1000,10000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_WIDEFREEZE','attack',664,5,10000,1000,10000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_WINDATTACK','chase',187,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_WINDATTACK','attack',187,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@CR_SHIELDCHARGE','attack',250,5,2000,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_HALLUCINATION','chase',207,1,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_SUMMONSLAVE','attack',196,6,10000,700,10000,'no','self','slavele','3',1607,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_SUMMONSLAVE','idle',196,6,10000,700,10000,'no','self','slavele','3',1607,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@NPC_SUMMONSLAVE','idle',196,2,10000,0,0,'no','self','onspawn','0',1515,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@WZ_STORMGUST','attack',89,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@WZ_STORMGUST','chase',89,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@WZ_STORMGUST','chase',89,10,10000,500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1251,'Stormy Knight@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@AL_DECAGI','chase',30,48,2000,0,300000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_WIDEFREEZE','chase',664,5,10000,1000,20000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_WIDEFREEZE','attack',664,5,10000,1000,20000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_WEAPONBRAKER','attack',343,10,500,0,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@WZ_STORMGUST','chase',89,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@WZ_STORMGUST','attack',89,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1606,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1606,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_WATERATTACK','attack',184,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@NPC_WATERATTACK','chase',184,5,2000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1252,'Garm@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1253,'Gargoyle@AC_CHARGEARROW','attack',148,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1253,'Gargoyle@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1253,'Gargoyle@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1253,'Gargoyle@NPC_KEEPING','attack',201,1,2000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1253,'Gargoyle@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1253,'Gargoyle@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1254,'Raggler@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1254,'Raggler@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1254,'Raggler@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1254,'Raggler@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1255,'Neraid@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1255,'Neraid@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1255,'Neraid@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',0,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1256,'Pest@AS_CLOAKING','attack',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1256,'Pest@AS_CLOAKING','idle',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1256,'Pest@AS_CLOAKING','chase',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1256,'Pest@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1256,'Pest@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1256,'Pest@NPC_POISON','attack',176,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1257,'Injustice@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1257,'Injustice@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1258,'Goblin Archer@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',16,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1258,'Goblin Archer@NPC_POISON','attack',176,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1258,'Goblin Archer@NPC_POISONATTACK','attack',188,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1258,'Goblin Archer@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1259,'Gryphon@KN_PIERCE','attack',56,10,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1259,'Gryphon@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1259,'Gryphon@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1260,'Dark Frame@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'1',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1260,'Dark Frame@NPC_BLINDATTACK','chase',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'1',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1260,'Dark Frame@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1260,'Dark Frame@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1260,'Dark Frame@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1260,'Dark Frame@CR_REFLECTSHIELD','attack',252,2,500,0,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1260,'Dark Frame@NPC_PETRIFYATTACK','attack',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1260,'Dark Frame@NPC_PETRIFYATTACK','chase',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1261,'Wild Rose@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1261,'Wild Rose@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1261,'Wild Rose@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1262,'Mutant Dragon@MG_FIREBALL','chase',17,44,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1262,'Mutant Dragon@NPC_FIREATTACK','attack',186,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1262,'Mutant Dragon@SM_MAGNUM','attack',7,25,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1263,'Wind Ghost@HT_SHOCKWAVE','idle',118,5,500,0,300000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1263,'Wind Ghost@MG_LIGHTNINGBOLT','attack',20,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1263,'Wind Ghost@MG_LIGHTNINGBOLT','chase',20,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1263,'Wind Ghost@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',29,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1263,'Wind Ghost@NPC_MAGICALATTACK','attack',192,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1263,'Wind Ghost@NPC_UNDEADATTACK','attack',347,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1263,'Wind Ghost@WZ_JUPITEL','attack',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1263,'Wind Ghost@WZ_JUPITEL','chase',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1264,'Merman@KN_PIERCE','attack',56,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1264,'Merman@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1264,'Merman@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1264,'Merman@NPC_RANGEATTACK','chase',160,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1264,'Merman@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1265,'Cookie@AL_HEAL','attack',28,5,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1265,'Cookie@AL_HEAL','attack',28,5,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1265,'Cookie@AL_HEAL','idle',28,5,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1265,'Cookie@AL_HEAL','idle',28,5,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1265,'Cookie@AL_HEAL','chase',28,5,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1265,'Cookie@AL_HEAL','chase',28,5,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1265,'Cookie@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1265,'Cookie@NPC_TELEKINESISATTACK','attack',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'4',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1265,'Cookie@NPC_TELEKINESISATTACK','chase',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'4',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1266,'Aster@NPC_RUN','attack',354,1,10000,0,3000,'no','self','always','0',NULL,0x81,NULL,NULL,NULL,'26',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1266,'Aster@NPC_RUN','chase',354,1,10000,0,3000,'no','self','always','0',NULL,0x81,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1267,'Carat@AL_TELEPORT','attack',26,1,500,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1267,'Carat@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1267,'Carat@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1267,'Carat@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1267,'Carat@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1267,'Carat@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1267,'Carat@SM_PROVOKE','chase',6,10,2000,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1267,'Carat@SA_REVERSEORCISH','attack',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1267,'Carat@SA_REVERSEORCISH','chase',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1268,'Bloody Knight@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1268,'Bloody Knight@KN_BRANDISHSPEAR','attack',57,5,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1268,'Bloody Knight@NPC_CHANGEFIRE','attack',164,1,10000,2000,600000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1268,'Bloody Knight@NPC_DARKNESSATTACK','attack',190,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1268,'Bloody Knight@CR_SHIELDCHARGE','attack',250,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1268,'Bloody Knight@WZ_METEOR','attack',83,5,2000,1500,5000,'no','target','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1268,'Bloody Knight@WZ_METEOR','chase',83,5,2000,1500,5000,'no','target','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1268,'Bloody Knight@NPC_WEAPONBRAKER','attack',343,5,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1269,'Clock@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1269,'Clock@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1269,'Clock@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1269,'Clock@NPC_EMOTION_ON','attack',474,1,10000,0,30000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1269,'Clock@NPC_EMOTION','idle',197,1,200,0,30000,'yes','self','always','0',9,0x91,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1270,'Tower Keeper@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1270,'Tower Keeper@WZ_FIREPILLAR','idle',80,5,500,0,5000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1270,'Tower Keeper@SA_DISPELL','attack',289,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1270,'Tower Keeper@NPC_SILENCEATTACK','attack',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1270,'Tower Keeper@NPC_SILENCEATTACK','chase',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1270,'Tower Keeper@NPC_SLEEPATTACK','attack',182,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1270,'Tower Keeper@NPC_SLEEPATTACK','chase',182,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1270,'Tower Keeper@NPC_EMOTION_ON','attack',474,1,10000,0,30000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1270,'Tower Keeper@NPC_EMOTION','idle',197,1,200,0,30000,'yes','self','always','0',9,0x91,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1271,'Alligator@NPC_WATERATTACK','attack',184,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1271,'Alligator@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x91,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@MG_FIREWALL','chase',18,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@NPC_HELLJUDGEMENT','chase',662,5,10000,800,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@NPC_HELLJUDGEMENT','attack',662,5,10000,800,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@NPC_DARKBLESSING','attack',203,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@NPC_HELMBRAKE','attack',345,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@NPC_SUMMONSLAVE','attack',196,3,10000,700,10000,'no','self','slavele','3',1605,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@NPC_SUMMONSLAVE','idle',196,3,10000,700,10000,'no','self','slavele','3',1605,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@WZ_METEOR','attack',83,11,5000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@WZ_METEOR','chase',83,11,5000,500,2000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1272,'Dark Lord@WZ_METEOR','chase',83,11,5000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1273,'Orc Lady@AL_INCAGI','chase',29,1,500,700,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1273,'Orc Lady@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',3,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1273,'Orc Lady@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1274,'Megalith@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1274,'Megalith@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1275,'Alice@AL_HEAL','idle',28,9,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1275,'Alice@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1275,'Alice@CR_SHIELDCHARGE','attack',250,3,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1275,'Alice@SA_DISPELL','chase',289,5,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1275,'Alice@SA_DISPELL','attack',289,5,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1275,'Alice@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1275,'Alice@NPC_SUMMONSLAVE','idle',196,1,500,2000,60000,'no','self','slavele','0',1744,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1276,'Raydric Archer@AC_CHARGEARROW','attack',148,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1276,'Raydric Archer@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1276,'Raydric Archer@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1276,'Raydric Archer@CR_AUTOGUARD','chase',249,2,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1276,'Raydric Archer@CR_AUTOGUARD','attack',249,2,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1277,'Greatest General@NPC_BLINDATTACK','idle',177,3,10000,1500,5000,'no','randomtarget','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1277,'Greatest General@NPC_BLINDATTACK','idle',177,3,10000,1500,5000,'no','randomtarget','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1277,'Greatest General@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1277,'Greatest General@WZ_EARTHSPIKE','idle',90,3,5000,1500,5000,'no','randomtarget','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1277,'Greatest General@WZ_EARTHSPIKE','idle',90,3,5000,1500,5000,'no','randomtarget','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1278,'Stalactite Golem@NPC_STUNATTACK','attack',179,4,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1278,'Stalactite Golem@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1278,'Stalactite Golem@NPC_EMOTION_ON','attack',474,1,10000,0,30000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1278,'Stalactite Golem@NPC_EMOTION','idle',197,1,200,0,30000,'yes','self','always','0',9,0x91,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1278,'Stalactite Golem@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1278,'Stalactite Golem@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1279,'Tri-Joint@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1280,'Steam Goblin@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',27,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1280,'Steam Goblin@NPC_SELFDESTRUCTION','attack',173,1,500,2000,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1280,'Steam Goblin@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1280,'Steam Goblin@SM_MAGNUM','attack',7,9,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1281,'Sage Worm@MG_COLDBOLT','chase',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1281,'Sage Worm@MG_FIREBOLT','chase',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1281,'Sage Worm@MG_LIGHTNINGBOLT','chase',20,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1281,'Sage Worm@MG_SAFETYWALL','attack',12,5,2000,1000,20000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'20',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1281,'Sage Worm@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',32,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1281,'Sage Worm@SA_DISPELL','attack',289,5,0,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'20',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1282,'Kobold Archer@AC_DOUBLE','attack',46,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1282,'Kobold Archer@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',20,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1282,'Kobold Archer@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1282,'Kobold Archer@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1283,'Chimera@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1283,'Chimera@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1283,'Chimera@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1283,'Chimera@NPC_SUMMONSLAVE','idle',196,4,10000,2000,60000,'no','self','slavele','0',1253,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1283,'Chimera@WZ_HEAVENDRIVE','attack',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1283,'Chimera@WZ_HEAVENDRIVE','chase',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1283,'Chimera@NPC_SHIELDBRAKE','attack',346,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1283,'Chimera@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1283,'Chimera@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1285,'Guardian Archer@AC_CHARGEARROW','attack',148,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1285,'Guardian Archer@AC_DOUBLE','attack',46,1,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1287,'Guardian Soldier@NPC_STUNATTACK','attack',179,5,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1287,'Guardian Soldier@SM_BASH','attack',5,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1289,'Maya Purple@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1289,'Maya Purple@KN_BRANDISHSPEAR','attack',57,10,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1289,'Maya Purple@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1289,'Maya Purple@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1289,'Maya Purple@NPC_SUMMONSLAVE','idle',196,3,10000,2000,60000,'no','self','slavele','0',1194,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1289,'Maya Purple@WZ_HEAVENDRIVE','attack',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1289,'Maya Purple@WZ_HEAVENDRIVE','chase',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1290,'Skeleton General@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1290,'Skeleton General@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1290,'Skeleton General@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1290,'Skeleton General@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1290,'Skeleton General@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1028,1016,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1291,'Wraith Dead@AL_DECAGI','chase',30,9,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1291,'Wraith Dead@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1291,'Wraith Dead@AS_GRIMTOOTH','chase',137,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1291,'Wraith Dead@NPC_CURSEATTACK','attack',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1291,'Wraith Dead@NPC_CURSEATTACK','chase',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1291,'Wraith Dead@NPC_POISON','attack',176,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@NPC_DARKBREATH','attack',202,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',18,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@NPC_SUMMONSLAVE','attack',196,2,10000,2000,60000,'no','self','slavele','0',1109,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1109,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@NPC_DARKTHUNDER','attack',341,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@NPC_DARKTHUNDER','chase',341,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@SA_REVERSEORCISH','attack',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1292,'Mini Demon@SA_REVERSEORCISH','chase',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1293,'Creamy Fear@AL_TELEPORT','attack',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1293,'Creamy Fear@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1293,'Creamy Fear@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1293,'Creamy Fear@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1293,'Creamy Fear@NPC_CURSEATTACK','attack',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1293,'Creamy Fear@NPC_SUMMONSLAVE','idle',196,3,10000,2000,60000,'no','self','slavele','0',1018,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1293,'Creamy Fear@RG_INTIMIDATE','attack',219,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1294,'Killer Mantis@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1294,'Killer Mantis@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1294,'Killer Mantis@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1294,'Killer Mantis@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1294,'Killer Mantis@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1294,'Killer Mantis@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1294,'Killer Mantis@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1139,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1295,'Owl Baron@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1295,'Owl Baron@MG_LIGHTNINGBOLT','attack',20,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1295,'Owl Baron@MG_LIGHTNINGBOLT','chase',20,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1295,'Owl Baron@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',32,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1295,'Owl Baron@SA_DISPELL','attack',289,5,0,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1295,'Owl Baron@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1295,'Owl Baron@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1295,'Owl Baron@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1320,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1296,'Kobold Leader@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1296,'Kobold Leader@BS_ADRENALINE','attack',111,10,500,1500,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1296,'Kobold Leader@BS_ADRENALINE','chase',111,10,500,1500,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1296,'Kobold Leader@CR_SHIELDCHARGE','attack',250,3,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1296,'Kobold Leader@NPC_SUMMONSLAVE','attack',196,5,10000,2000,60000,'no','self','slavele','2',1133,1134,1135,1282,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1296,'Kobold Leader@NPC_SUMMONSLAVE','idle',196,5,10000,2000,60000,'no','self','slavele','2',1133,1134,1135,1282,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1297,'Ancient Mummy@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1297,'Ancient Mummy@NPC_UNDEADATTACK','attack',347,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1297,'Ancient Mummy@NPC_DARKBREATH','attack',202,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1298,'Zombie Master@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1298,'Zombie Master@KN_BRANDISHSPEAR','attack',57,5,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1298,'Zombie Master@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1298,'Zombie Master@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1036,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1299,'Goblin Leader@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1299,'Goblin Leader@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1299,'Goblin Leader@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1299,'Goblin Leader@CR_SHIELDCHARGE','attack',250,3,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1299,'Goblin Leader@NPC_SUMMONSLAVE','attack',196,5,10000,2000,60000,'no','self','slavele','2',1122,1123,1124,1125,1126,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1299,'Goblin Leader@NPC_SUMMONSLAVE','idle',196,5,10000,2000,60000,'no','self','slavele','2',1122,1123,1124,1125,1126,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1300,'Caterpillar@NPC_PETRIFYATTACK','attack',180,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1300,'Caterpillar@NPC_POISON','attack',176,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1300,'Caterpillar@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1301,'Am Mut@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1301,'Am Mut@MC_MAMMONITE','attack',42,9,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1301,'Am Mut@AM_ACIDTERROR','chase',230,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1301,'Am Mut@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1301,'Am Mut@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1301,'Am Mut@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1110,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1302,'Dark Illusion@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1302,'Dark Illusion@NPC_GUIDEDATTACK','attack',172,2,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1302,'Dark Illusion@WZ_METEOR','attack',83,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1302,'Dark Illusion@WZ_METEOR','chase',83,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1303,'Giant Hornet@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1303,'Giant Hornet@NPC_PIERCINGATT','attack',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1303,'Giant Hornet@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1303,'Giant Hornet@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1303,'Giant Hornet@NPC_SILENCEATTACK','chase',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1303,'Giant Hornet@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1303,'Giant Hornet@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1304,'Giant Spider@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1304,'Giant Spider@AS_GRIMTOOTH','chase',137,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1304,'Giant Spider@NPC_POISON','attack',176,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1304,'Giant Spider@NPC_STOP','attack',342,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1304,'Giant Spider@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1304,'Giant Spider@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1304,'Giant Spider@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1100,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1305,'Ancient Worm@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1305,'Ancient Worm@AS_VENOMDUST','attack',140,1,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1305,'Ancient Worm@NPC_POISON','attack',176,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1305,'Ancient Worm@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1305,'Ancient Worm@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1099,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1306,'Leib Olmai@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1306,'Leib Olmai@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1306,'Leib Olmai@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1306,'Leib Olmai@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1306,'Leib Olmai@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1306,'Leib Olmai@NPC_SUMMONSLAVE','idle',196,3,10000,2000,60000,'no','self','slavele','0',1243,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1306,'Leib Olmai@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1306,'Leib Olmai@SM_MAGNUM','attack',7,9,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1307,'Cat\'o\'Nine Tails@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1307,'Cat\'o\'Nine Tails@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1307,'Cat\'o\'Nine Tails@MC_MAMMONITE','attack',42,9,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1307,'Cat\'o\'Nine Tails@NPC_GUIDEDATTACK','attack',172,2,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1307,'Cat\'o\'Nine Tails@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1180,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1308,'Panzer Goblin@NPC_SELFDESTRUCTION','attack',173,1,500,2000,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1308,'Panzer Goblin@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1308,'Panzer Goblin@SM_MAGNUM','attack',7,9,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1309,'Gajomart@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1309,'Gajomart@MG_SIGHT','chase',10,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1309,'Gajomart@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1309,'Gajomart@NPC_BLINDATTACK','chase',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1309,'Gajomart@WZ_SIGHTRASHER','attack',81,7,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1309,'Gajomart@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1309,'Gajomart@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1309,'Gajomart@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1129,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1309,'Gajomart@RG_STRIPWEAPON','attack',215,5,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1310,'Majoruros@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1310,'Majoruros@BS_HAMMERFALL','attack',110,5,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1310,'Majoruros@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1310,'Majoruros@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1310,'Majoruros@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1310,'Majoruros@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1149,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1310,'Majoruros@WZ_HEAVENDRIVE','attack',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1310,'Majoruros@WZ_HEAVENDRIVE','chase',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1311,'Gullinbursti@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1311,'Gullinbursti@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1311,'Gullinbursti@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1311,'Gullinbursti@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1311,'Gullinbursti@NPC_STUNATTACK','attack',179,5,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1311,'Gullinbursti@NPC_SUMMONSLAVE','idle',196,4,10000,2000,60000,'no','self','slavele','0',1166,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1311,'Gullinbursti@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1311,'Gullinbursti@RG_STRIPSHIELD','attack',216,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@AS_SONICBLOW','attack',136,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@BS_MAXIMIZE','attack',114,5,500,0,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@BS_MAXIMIZE','chase',114,5,500,0,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@WZ_WATERBALL','chase',86,10,10000,500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@NPC_AGIUP','attack',350,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@NPC_GROUNDATTACK','attack',185,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@NPC_WEAPONBRAKER','attack',343,10,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@NPC_STUNATTACK','attack',179,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@NPC_SUMMONSLAVE','attack',196,6,10000,700,10000,'no','self','slavele','3',1364,1594,1600,1601,1602,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@NPC_SUMMONSLAVE','idle',196,6,10000,700,10000,'no','self','slavele','3',1364,1594,1600,1601,1602,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1312,'Turtle General@WZ_WATERBALL','attack',86,5,2000,500,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1313,'Mobster@KN_SPEARBOOMERANG','chase',59,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1313,'Mobster@KN_SPEARSTAB','attack',58,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1313,'Mobster@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',32,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1313,'Mobster@NPC_SUMMONSLAVE','idle',196,1,500,2000,60000,'no','self','slavele','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1313,'Mobster@TF_SPRINKLESAND','attack',149,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1313,'Mobster@RG_INTIMIDATE','attack',219,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@AM_POTIONPITCHER','attack',231,4,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@AM_POTIONPITCHER','attack',231,4,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@AM_POTIONPITCHER','idle',231,4,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@AM_POTIONPITCHER','idle',231,4,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@AM_POTIONPITCHER','chase',231,4,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@AM_POTIONPITCHER','chase',231,4,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x91,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1314,'Perimeter@TF_SPRINKLESAND','attack',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1315,'Assaulter@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1315,'Assaulter@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1315,'Assaulter@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1315,'Assaulter@NPC_EMOTION','attack',197,1,2000,0,600000,'yes','self','myhpltmaxrate','20',23,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1315,'Assaulter@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1315,'Assaulter@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1315,'Assaulter@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1315,'Assaulter@TF_BACKSLIDING','attack',150,1,10000,500,600000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1315,'Assaulter@NPC_SUMMONSLAVE','chase',196,3,10000,0,600000,'yes','self','myhpltmaxrate','10',1364,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1316,'Solider@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1316,'Solider@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1316,'Solider@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x91,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1316,'Solider@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1316,'Solider@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1316,'Solider@CR_AUTOGUARD','chase',249,2,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1316,'Solider@CR_AUTOGUARD','attack',249,2,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1317,'Seal@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1317,'Seal@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1317,'Seal@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',1,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1317,'Seal@NPC_WATERATTACK','attack',184,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1318,'Heater@MG_FIREBALL','chase',17,9,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1318,'Heater@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1318,'Heater@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1318,'Heater@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1318,'Heater@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1318,'Heater@WZ_FIREPILLAR','idle',80,3,500,0,5000,'no','around2','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1319,'Freezer@MG_COLDBOLT','attack',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1319,'Freezer@MG_COLDBOLT','chase',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1319,'Freezer@MG_FROSTDIVER','attack',15,9,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1319,'Freezer@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',20,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1319,'Freezer@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1319,'Freezer@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1319,'Freezer@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1320,'Owl Duke@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1320,'Owl Duke@MG_LIGHTNINGBOLT','attack',20,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1320,'Owl Duke@MG_LIGHTNINGBOLT','chase',20,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1320,'Owl Duke@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',32,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1320,'Owl Duke@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1320,'Owl Duke@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1321,'Dragon Tail@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1321,'Dragon Tail@NPC_SLEEPATTACK','attack',182,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1321,'Dragon Tail@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1322,'Spring Rabbit@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1322,'Spring Rabbit@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1322,'Spring Rabbit@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x83,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1322,'Spring Rabbit@SM_BASH','attack',5,10,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1322,'Spring Rabbit@TF_THROWSTONE','chase',152,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1323,'Sea Otter@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1323,'Sea Otter@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1323,'Sea Otter@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1323,'Sea Otter@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1323,'Sea Otter@WZ_WATERBALL','attack',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1323,'Sea Otter@WZ_WATERBALL','chase',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1365,'Apocalypse@KN_BRANDISHSPEAR','attack',57,5,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1365,'Apocalypse@NPC_DARKTHUNDER','attack',341,4,1000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1365,'Apocalypse@NPC_SELFDESTRUCTION','attack',173,1,1000,2000,5000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1365,'Apocalypse@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1365,'Apocalypse@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1366,'Lava Golem@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1366,'Lava Golem@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1366,'Lava Golem@NPC_SUMMONSLAVE','idle',196,2,10000,2000,60000,'no','self','slavele','0',1367,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1366,'Lava Golem@WZ_FIREPILLAR','idle',80,3,500,0,5000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1367,'Blazer@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1367,'Blazer@MG_FIREBALL','chase',17,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1367,'Blazer@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1367,'Blazer@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1367,'Blazer@WZ_SIGHTRASHER','attack',81,5,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1368,'Geographer@AL_HEAL','attack',28,9,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1368,'Geographer@AL_HEAL','idle',28,9,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1368,'Geographer@NPC_SLEEPATTACK','attack',182,5,500,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1369,'Grand Peco@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1369,'Grand Peco@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1369,'Grand Peco@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1369,'Grand Peco@NPC_EMOTION_ON','attack',474,1,10000,0,30000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1369,'Grand Peco@NPC_EMOTION','idle',197,1,200,0,30000,'yes','self','always','0',9,0x1089,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1370,'Succubus@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1370,'Succubus@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1370,'Succubus@NPC_BLOODDRAIN','attack',199,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1370,'Succubus@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1370,'Succubus@SA_REVERSEORCISH','chase',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1370,'Succubus@SA_REVERSEORCISH','attack',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_DARKSTRIKE','attack',340,7,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_DARKSTRIKE','chase',340,7,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_CURSEATTACK','attack',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_CURSEATTACK','chase',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_SILENCEATTACK','attack',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_SILENCEATTACK','chase',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_BLINDATTACK','angry',177,7,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_BLINDATTACK','follow',177,7,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_CURSEATTACK','angry',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_CURSEATTACK','follow',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_HALLUCINATION','angry',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_HALLUCINATION','follow',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_SILENCEATTACK','angry',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1371,'Fake Angel@NPC_SILENCEATTACK','follow',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1372,'Goat@BS_ADRENALINE','attack',111,10,500,1500,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1372,'Goat@BS_ADRENALINE','chase',111,10,500,1500,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1372,'Goat@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x1089,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1372,'Goat@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1372,'Goat@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@AL_DECAGI','chase',30,48,2000,0,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_HELLJUDGEMENT','chase',662,10,10000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_HELLJUDGEMENT','attack',662,10,10000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@KN_BRANDISHSPEAR','attack',57,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_DARKSTRIKE','chase',340,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_CHANGEUNDEAD','attack',348,1,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_AGIUP','attack',350,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_GRANDDARKNESS','attack',339,10,1000,700,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_STUNATTACK','attack',179,5,2000,0,0,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1490,1490,1509,1508,1179,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1490,1490,1509,1508,1179,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1373,'Lord of Death@NPC_DARKSTRIKE','chase',340,10,10000,0,5000,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1374,'Incubus@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1374,'Incubus@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1374,'Incubus@NPC_DARKNESSATTACK','attack',190,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1374,'Incubus@NPC_DARKSTRIKE','attack',340,9,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1374,'Incubus@NPC_DARKSTRIKE','chase',340,9,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1374,'Incubus@NPC_MENTALBREAKER','attack',159,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'14',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1374,'Incubus@NPC_MENTALBREAKER','chase',159,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'14',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1375,'The Paper@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1375,'The Paper@NPC_DEFENDER','attack',205,1,500,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1375,'The Paper@NPC_DEFENDER','chase',205,1,500,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1375,'The Paper@NPC_COMBOATTACK','angry',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1375,'The Paper@NPC_DEFENDER','angry',205,1,500,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1375,'The Paper@NPC_DEFENDER','follow',205,1,500,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1376,'Harpy@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1376,'Harpy@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1376,'Harpy@NPC_SILENCEATTACK','attack',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1376,'Harpy@NPC_SILENCEATTACK','chase',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1376,'Harpy@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1376,'Harpy@NPC_BLOODDRAIN','angry',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1376,'Harpy@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1376,'Harpy@NPC_SILENCEATTACK','angry',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1376,'Harpy@NPC_SILENCEATTACK','follow',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1376,'Harpy@NPC_WINDATTACK','angry',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@MG_FIREBOLT','attack',19,7,10000,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@MG_FROSTDIVER','chase',15,9,10000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@MG_LIGHTNINGBOLT','chase',20,7,10000,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@MG_STONECURSE','attack',16,10,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@SA_DISPELL','attack',289,1,0,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@NPC_RUN','attack',354,1,2000,500,0,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@NPC_SILENCEATTACK','attack',178,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@NPC_EMOTION','idle',197,1,200,0,30000,'yes','self','always','0',9,0x91,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@MG_FIREBOLT','idle',19,7,10000,1500,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@MG_FROSTDIVER','idle',15,9,10000,500,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@MG_LIGHTNINGBOLT','idle',20,7,10000,1500,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1377,'Elder@MG_STONECURSE','idle',16,10,10000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1378,'Demon Pungus@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1378,'Demon Pungus@NPC_BLINDATTACK','chase',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1378,'Demon Pungus@NPC_PETRIFYATTACK','attack',180,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1378,'Demon Pungus@NPC_PETRIFYATTACK','chase',180,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1378,'Demon Pungus@NPC_BLINDATTACK','angry',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1378,'Demon Pungus@NPC_BLINDATTACK','follow',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1378,'Demon Pungus@NPC_PETRIFYATTACK','angry',180,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1378,'Demon Pungus@NPC_PETRIFYATTACK','follow',180,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1379,'Nightmare Terror@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1379,'Nightmare Terror@NPC_DARKSTRIKE','attack',340,7,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1379,'Nightmare Terror@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1379,'Nightmare Terror@NPC_MENTALBREAKER','attack',159,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1379,'Nightmare Terror@NPC_CURSEATTACK','angry',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1379,'Nightmare Terror@NPC_DARKSTRIKE','angry',340,7,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1379,'Nightmare Terror@NPC_FIREATTACK','angry',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1379,'Nightmare Terror@NPC_MENTALBREAKER','angry',159,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1380,'Driller@AS_CLOAKING','attack',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1380,'Driller@AS_CLOAKING','idle',135,1,100,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1380,'Driller@AS_CLOAKING','chase',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1380,'Driller@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1380,'Driller@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1380,'Driller@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1380,'Driller@AS_CLOAKING','angry',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1380,'Driller@AS_CLOAKING','follow',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1380,'Driller@NPC_COMBOATTACK','angry',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1380,'Driller@NPC_GROUNDATTACK','angry',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1381,'Grizzly@KN_SPEARSTAB','attack',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1381,'Grizzly@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1381,'Grizzly@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1381,'Grizzly@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1381,'Grizzly@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1381,'Grizzly@KN_SPEARSTAB','angry',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1381,'Grizzly@NPC_EMOTION','follow',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1381,'Grizzly@NPC_STUNATTACK','angry',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1381,'Grizzly@SM_ENDURE','follow',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1382,'Diabolic@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1382,'Diabolic@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1382,'Diabolic@WZ_METEOR','attack',83,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1382,'Diabolic@WZ_METEOR','chase',83,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1382,'Diabolic@MO_BODYRELOCATION','follow',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1382,'Diabolic@NPC_FIREATTACK','angry',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1382,'Diabolic@WZ_METEOR','angry',83,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1382,'Diabolic@WZ_METEOR','follow',83,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1383,'Explosion@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1383,'Explosion@AM_DEMONSTRATION','attack',229,1,100,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1383,'Explosion@SM_MAGNUM','attack',7,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1383,'Explosion@NPC_FIREATTACK','angry',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1383,'Explosion@AM_DEMONSTRATION','angry',229,1,100,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1383,'Explosion@SM_MAGNUM','angry',7,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1384,'Deleter@MG_FIREBALL','chase',17,9,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1384,'Deleter@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1384,'Deleter@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1384,'Deleter@NPC_PIERCINGATT','attack',158,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1384,'Deleter@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1384,'Deleter@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1385,'Deleter@MG_FIREWALL','attack',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1385,'Deleter@MG_FIREWALL','chase',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1385,'Deleter@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1385,'Deleter@NPC_FIREATTACK','chase',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1385,'Deleter@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1385,'Deleter@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1385,'Deleter@SM_MAGNUM','attack',7,9,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@AS_CLOAKING','attack',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@AS_CLOAKING','idle',135,1,100,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@AS_CLOAKING','chase',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@NPC_DEFENDER','attack',205,1,500,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@NPC_DEFENDER','chase',205,1,500,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@NPC_SLEEPATTACK','attack',182,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@TF_SPRINKLESAND','attack',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@AS_CLOAKING','angry',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@AS_CLOAKING','follow',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@NPC_DEFENDER','angry',205,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@NPC_DEFENDER','follow',205,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@NPC_SLEEPATTACK','angry',182,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1386,'Sleeper@TF_SPRINKLESAND','angry',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@TF_HIDING','attack',51,1,2000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@TF_POISON','attack',52,10,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@NPC_GROUNDATTACK','angry',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@NPC_EMOTION','follow',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@TF_HIDING','angry',51,1,2000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@TF_POISON','angry',52,10,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@CR_AUTOGUARD','attack',249,2,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@CR_AUTOGUARD','angry',249,2,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@CR_AUTOGUARD','chase',249,2,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1387,'Gig@CR_AUTOGUARD','follow',249,2,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@CR_GRANDCROSS','attack',254,1,2000,0,0,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@AL_HEAL','attack',28,11,10000,0,1000,'no','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@AL_HEAL','attack',28,11,10000,0,0,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@AL_HEAL','chase',28,11,10000,0,1000,'no','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@AL_HEAL','chase',28,11,10000,0,0,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@PR_SANCTUARY','attack',70,10,10000,500,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@PR_SANCTUARY','chase',70,10,10000,500,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@NPC_BARRIER','attack',204,1,500,1000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@NPC_HOLYATTACK','attack',189,5,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@NPC_HOLYATTACK','chase',189,5,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@NPC_SUMMONSLAVE','attack',196,7,10000,700,60000,'no','self','slavele','3',1443,1246,1742,1743,1744,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@NPC_SUMMONSLAVE','idle',196,7,10000,700,60000,'no','self','slavele','3',1443,1246,1742,1743,1744,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1388,'Arc Angeling@RG_INTIMIDATE','attack',219,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@AL_DECAGI','chase',30,48,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_HELLJUDGEMENT','chase',662,10,10000,500,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_HELLJUDGEMENT','attack',662,10,10000,500,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@AS_GRIMTOOTH','chase',137,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_BLOODDRAIN','attack',199,1,3000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_ENERGYDRAIN','chase',200,1,3000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@MO_BODYRELOCATION','chase',264,1,2000,200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_CHANGEUNDEAD','attack',348,1,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_INVISIBLE','attack',353,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_INVISIBLE','idle',353,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_INVISIBLE','chase',353,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_SILENCEATTACK','attack',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_SILENCEATTACK','chase',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_SUMMONSLAVE','attack',196,16,10000,700,5000,'no','self','slavele','5',1419,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_SUMMONSLAVE','idle',196,16,10000,700,5000,'no','self','slavele','5',1419,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1389,'Dracula@NPC_ENERGYDRAIN','chase',200,1,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1390,'Violy@NPC_DARKSTRIKE','attack',340,5,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1390,'Violy@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1390,'Violy@NPC_DARKBREATH','attack',202,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1390,'Violy@PR_LEXDIVINA','attack',76,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1390,'Violy@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1391,'Galapago@AM_POTIONPITCHER','idle',231,4,500,500,5000,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1391,'Galapago@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1391,'Galapago@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',1,0x108B,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1391,'Galapago@NPC_WATERATTACK','attack',184,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'1',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1391,'Galapago@WZ_WATERBALL','attack',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1391,'Galapago@WZ_WATERBALL','chase',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1392,'Rotar Zairo@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1392,'Rotar Zairo@NPC_SELFDESTRUCTION','attack',173,1,500,2000,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1393,'G Mummy@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1393,'G Mummy@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@WZ_EARTHSPIKE','chase',90,5,4000,0,0,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@WZ_EARTHSPIKE','chase',90,5,10000,0,0,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@WZ_EARTHSPIKE','attack',90,5,4000,0,0,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@WZ_HEAVENDRIVE','chase',91,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@WZ_HEAVENDRIVE','chase',91,5,10000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@WZ_HEAVENDRIVE','attack',91,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@MG_STONECURSE','attack',16,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@NPC_SILENCEATTACK','chase',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@NPC_SILENCEATTACK','attack',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@SM_ENDURE','chase',8,7,10000,0,20000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@AL_INCAGI','chase',29,1,5000,3000,120000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@KN_TWOHANDQUICKEN','attack',60,30,5000,3000,300000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@AL_DECAGI','chase',30,1,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@NPC_BLOODDRAIN','attack',199,1,2000,0,5000,'yes','target','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@NPC_GROUNDATTACK','attack',185,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@NPC_CHANGEDARKNESS','chase',168,1,10000,0,300000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@NPC_CHANGEDARKNESS','attack',168,1,10000,0,300000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@AL_TELEPORT','walk',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1395,'Wind Crystal@NPC_HELMBRAKE','attack',345,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@MG_LIGHTNINGBOLT','chase',20,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@MG_LIGHTNINGBOLT','chase',20,5,4000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@WZ_JUPITEL','chase',84,28,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@WZ_JUPITEL','chase',84,28,10000,500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@WZ_JUPITEL','attack',84,28,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@WZ_VERMILION','chase',85,21,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@WZ_VERMILION','chase',85,21,10000,500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@WZ_VERMILION','attack',85,21,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@NPC_SILENCEATTACK','chase',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@NPC_SILENCEATTACK','attack',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@SM_ENDURE','chase',8,7,10000,0,20000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@AL_INCAGI','chase',29,1,5000,3000,120000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@KN_TWOHANDQUICKEN','attack',60,30,5000,3000,300000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@AL_DECAGI','chase',30,1,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@NPC_BLOODDRAIN','attack',199,1,2000,0,5000,'yes','target','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@NPC_WINDATTACK','attack',187,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@NPC_CHANGEDARKNESS','chase',168,1,10000,0,300000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@NPC_CHANGEDARKNESS','attack',168,1,10000,0,300000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@AL_TELEPORT','walk',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1396,'Earth Crystal@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@MG_FIREBOLT','chase',19,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@MG_FIREBOLT','chase',19,5,4000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@MG_FIREBALL','chase',17,44,4000,0,0,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@MG_FIREBALL','chase',17,44,10000,0,0,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@MG_FIREBALL','attack',17,44,4000,0,0,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@WZ_METEOR','chase',83,11,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@WZ_METEOR','chase',83,11,10000,500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@WZ_METEOR','attack',83,11,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@WZ_SIGHTRASHER','attack',81,10,1000,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@NPC_SILENCEATTACK','chase',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@NPC_SILENCEATTACK','attack',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@SM_ENDURE','chase',8,7,10000,0,20000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@AL_INCAGI','chase',29,1,5000,3000,120000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@KN_TWOHANDQUICKEN','attack',60,30,5000,3000,300000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@AL_DECAGI','chase',30,1,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@NPC_BLOODDRAIN','attack',199,1,2000,0,5000,'yes','target','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@NPC_FIREATTACK','attack',186,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@NPC_CHANGEDARKNESS','chase',168,1,10000,0,300000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@NPC_CHANGEDARKNESS','attack',168,1,10000,0,300000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@AL_TELEPORT','walk',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1397,'Fire Crystal@NPC_WEAPONBRAKER','attack',343,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@MG_COLDBOLT','chase',14,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@MG_COLDBOLT','chase',14,5,4000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@WZ_WATERBALL','chase',86,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@WZ_WATERBALL','chase',86,10,10000,500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@WZ_WATERBALL','attack',86,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@WZ_STORMGUST','chase',89,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@WZ_STORMGUST','chase',89,10,10000,500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@WZ_STORMGUST','attack',89,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@NPC_SILENCEATTACK','chase',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@NPC_SILENCEATTACK','attack',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@SM_ENDURE','chase',8,7,10000,0,20000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@AL_INCAGI','chase',29,1,5000,3000,120000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@KN_TWOHANDQUICKEN','attack',60,30,5000,3000,300000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@AL_DECAGI','chase',30,1,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@NPC_BLOODDRAIN','attack',199,1,2000,0,5000,'yes','target','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@NPC_WATERATTACK','attack',184,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@NPC_CHANGEDARKNESS','chase',168,1,10000,0,300000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@NPC_CHANGEDARKNESS','attack',168,1,10000,0,300000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@AL_TELEPORT','walk',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1398,'Water Crystal@NPC_SHIELDBRAKE','attack',346,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@AL_TELEPORT','idle',26,1,2000,0,0,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'20',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@KN_BRANDISHSPEAR','attack',57,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@KN_TWOHANDQUICKEN','attack',60,30,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@NPC_BARRIER','attack',204,1,2000,3000,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@NPC_GUIDEDATTACK','attack',172,5,2000,0,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@NPC_SUMMONSLAVE','attack',196,10,10000,2000,20000,'no','self','slavele','3',1026,1170,1029,1044,1749,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@NPC_SUMMONSLAVE','idle',196,10,10000,2000,20000,'no','self','slavele','3',1026,1170,1029,1044,1749,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@WZ_METEOR','chase',83,11,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@WZ_METEOR','attack',83,11,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@WZ_STORMGUST','chase',89,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@WZ_STORMGUST','attack',89,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@WZ_VERMILION','chase',85,21,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1399,'Event Baphomet@WZ_VERMILION','attack',85,21,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1400,'Karakasa@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'31',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1400,'Karakasa@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'31',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1400,'Karakasa@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1400,'Karakasa@WZ_WATERBALL','chase',86,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1400,'Karakasa@NPC_EMOTION','attack',197,1,10000,0,30000,'yes','self','always','0',28,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1401,'Shinobi@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1401,'Shinobi@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1401,'Shinobi@AS_CLOAKING','idle',135,1,500,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1401,'Shinobi@HT_CLAYMORETRAP','idle',123,5,500,0,300000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1401,'Shinobi@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1401,'Shinobi@NPC_REBIRTH','dead',208,2,5000,0,0,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1401,'Shinobi@SM_BASH','attack',5,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1401,'Shinobi@TF_BACKSLIDING','attack',150,1,10000,500,3600000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1402,'Poison Toad@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1402,'Poison Toad@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1402,'Poison Toad@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1403,'Antique Firelock@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1404,'Miyabi Ningyo@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1404,'Miyabi Ningyo@NPC_BLINDATTACK','chase',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1404,'Miyabi Ningyo@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1404,'Miyabi Ningyo@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1404,'Miyabi Ningyo@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1404,'Miyabi Ningyo@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1404,'Miyabi Ningyo@NPC_SILENCEATTACK','chase',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@NPC_FIREATTACK','attack',186,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@NPC_STUNATTACK','chase',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@SM_PROVOKE','attack',6,10,2000,600,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@SM_PROVOKE','chase',6,10,2000,600,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@WZ_EARTHSPIKE','attack',90,1,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@WZ_EARTHSPIKE','attack',90,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@WZ_EARTHSPIKE','attack',90,3,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@NPC_FIREATTACK','angry',186,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@NPC_STUNATTACK','follow',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@SM_PROVOKE','angry',6,10,2000,600,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@SM_PROVOKE','follow',6,10,2000,600,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@WZ_EARTHSPIKE','angry',90,1,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@WZ_EARTHSPIKE','angry',90,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1405,'Tengu@WZ_EARTHSPIKE','angry',90,3,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1406,'Kapha@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1406,'Kapha@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',20,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1406,'Kapha@NPC_WATERATTACK','attack',184,3,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1406,'Kapha@WZ_WATERBALL','chase',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'16',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1406,'Kapha@NPC_BLOODDRAIN','angry',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1406,'Kapha@NPC_WATERATTACK','angry',184,3,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1406,'Kapha@WZ_WATERBALL','follow',86,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'16',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1408,'Bloody Butterfly@KN_PIERCE','attack',56,10,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1408,'Bloody Butterfly@NPC_DARKSTRIKE','chase',340,5,2000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1408,'Bloody Butterfly@NPC_SLEEPATTACK','attack',182,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1408,'Bloody Butterfly@NPC_SLEEPATTACK','chase',182,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1409,'Rice Cake Boy@NPC_WINDATTACK','attack',187,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1410,'Live Peach Tree@AM_POTIONPITCHER','attack',231,2,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1410,'Live Peach Tree@AM_POTIONPITCHER','idle',231,3,10000,500,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1410,'Live Peach Tree@AM_POTIONPITCHER','chase',231,2,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1410,'Live Peach Tree@NPC_GUIDEDATTACK','attack',172,3,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1410,'Live Peach Tree@NPC_GUIDEDATTACK','chase',172,2,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1410,'Live Peach Tree@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1412,'Taoist Hermit@AL_TELEPORT','attack',26,1,500,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1412,'Taoist Hermit@MG_LIGHTNINGBOLT','attack',20,5,2000,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1412,'Taoist Hermit@MG_LIGHTNINGBOLT','chase',20,5,2000,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1412,'Taoist Hermit@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1412,'Taoist Hermit@NPC_BLINDATTACK','chase',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1412,'Taoist Cloud Hermit@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1413,'Wild Ginseng@NPC_BARRIER','attack',204,1,2000,3000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1413,'Wild Ginseng@NPC_MAGICALATTACK','attack',192,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1415,'Baby Leopard@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1415,'Baby Leopard@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1415,'Baby Leopard@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1416,'Wicked Nymph@AL_HEAL','attack',28,3,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1416,'Wicked Nymph@AL_HEAL','attack',28,3,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1416,'Wicked Nymph@AL_HEAL','idle',28,3,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1416,'Wicked Nymph@AL_HEAL','idle',28,3,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1416,'Wicked Nymph@AL_HEAL','chase',28,3,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1416,'Wicked Nymph@AL_HEAL','chase',28,3,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1416,'Wicked Nymph@NPC_STOP','attack',342,1,500,0,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1416,'Wicked Nymph@SA_DISPELL','attack',289,5,0,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1417,'Zipper Bear@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1417,'Zipper Bear@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_DRAGONFEAR','chase',659,5,10000,0,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_DRAGONFEAR','attack',659,5,2000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_WIDESILENCE','chase',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_WIDESILENCE','attack',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@MG_FROSTDIVER','attack',15,40,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@MG_FROSTDIVER','chase',15,40,2000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_SHIELDBRAKE','attack',346,10,2000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_DARKBREATH','attack',202,5,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_STOP','attack',342,1,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','2',1531,1531,1564,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','2',1531,1531,1564,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@SM_MAGNUM','attack',7,25,2000,0,5000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1418,'Evil Snake Lord@MG_FROSTDIVER','chase',15,40,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1419,'Farmiliar@NPC_BLINDATTACK','angry',177,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1419,'Farmiliar@NPC_DARKNESSATTACK','angry',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1419,'Farmiliar@NPC_BLINDATTACK','attack',177,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1419,'Farmiliar@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1420,'Skeleton Archer@AC_DOUBLE','angry',46,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1420,'Skeleton Archer@NPC_FIREATTACK','angry',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1420,'Skeleton Archer@AC_DOUBLE','attack',46,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1420,'Skeleton Archer@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1421,'Isis@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1421,'Isis@NPC_DARKNESSATTACK','angry',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1421,'Isis@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1421,'Isis@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1422,'Hunter Fly@NPC_BLOODDRAIN','angry',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1422,'Hunter Fly@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1422,'Hunter Fly@NPC_WINDATTACK','angry',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1422,'Hunter Fly@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1422,'Hunter Fly@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1422,'Hunter Fly@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1423,'Ghoul@NPC_POISON','angry',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1423,'Ghoul@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1424,'Sidewinder@KN_PIERCE','angry',56,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1424,'Sidewinder@NPC_POISON','angry',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1424,'Sidewinder@NPC_POISONATTACK','angry',188,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1424,'Sidewinder@KN_PIERCE','attack',56,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1424,'Sidewinder@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1424,'Sidewinder@NPC_POISONATTACK','attack',188,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1425,'Obeaune@NPC_WATERATTACK','angry',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1425,'Obeaune@PR_LEXDIVINA','follow',76,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1425,'Obeaune@PR_LEXDIVINA','angry',76,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1425,'Obeaune@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1425,'Obeaune@PR_LEXDIVINA','chase',76,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1425,'Obeaune@PR_LEXDIVINA','attack',76,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1426,'Marc@NPC_STUNATTACK','angry',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1426,'Marc@NPC_WATERATTACK','angry',184,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1426,'Marc@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1426,'Marc@NPC_WATERATTACK','attack',184,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1427,'Nightmare@NPC_BLINDATTACK','angry',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1427,'Nightmare@NPC_CURSEATTACK','angry',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1427,'Nightmare@NPC_MENTALBREAKER','angry',159,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1427,'Nightmare@NPC_TELEKINESISATTACK','angry',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1427,'Nightmare@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1427,'Nightmare@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1427,'Nightmare@NPC_MENTALBREAKER','attack',159,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1427,'Nightmare@NPC_TELEKINESISATTACK','attack',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1428,'Poison Spore@NPC_POISON','angry',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1428,'Poison Spore@NPC_POISONATTACK','angry',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1428,'Poison Spore@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1428,'Poison Spore@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1429,'Argiope@AS_VENOMDUST','angry',140,1,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1429,'Argiope@NPC_POISON','angry',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1429,'Argiope@NPC_POISONATTACK','angry',188,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1429,'Argiope@AS_VENOMDUST','attack',140,1,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1429,'Argiope@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1429,'Argiope@NPC_POISONATTACK','attack',188,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1430,'Argos@NPC_POISON','angry',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1430,'Argos@NPC_POISONATTACK','angry',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1430,'Argos@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1430,'Argos@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1431,'Baphomet Jr.@NPC_DARKBREATH','angry',202,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1431,'Baphomet Jr.@NPC_DARKNESSATTACK','angry',190,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1431,'Baphomet Jr.@NPC_HALLUCINATION','follow',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1431,'Baphomet Jr.@NPC_HALLUCINATION','angry',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1431,'Baphomet Jr.@NPC_DARKBREATH','attack',202,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1431,'Baphomet Jr.@NPC_DARKNESSATTACK','attack',190,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1431,'Baphomet Jr.@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1431,'Baphomet Jr.@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1432,'Desert Wolf@NPC_FIREATTACK','angry',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1432,'Desert Wolf@TF_SPRINKLESAND','angry',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1432,'Desert Wolf@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1432,'Desert Wolf@TF_SPRINKLESAND','attack',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_BLINDATTACK','angry',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_BLINDATTACK','follow',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_DARKNESSATTACK','angry',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_ENERGYDRAIN','follow',200,1,500,0,5000,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_ENERGYDRAIN','angry',200,1,500,0,5000,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_DARKTHUNDER','follow',341,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_DARKTHUNDER','angry',341,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_BLINDATTACK','chase',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_ENERGYDRAIN','chase',200,1,500,0,5000,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_ENERGYDRAIN','attack',200,1,500,0,5000,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_DARKTHUNDER','chase',341,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1433,'Deviruchi@NPC_DARKTHUNDER','attack',341,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1434,'Drainliar@NPC_BLINDATTACK','angry',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1434,'Drainliar@NPC_BLOODDRAIN','angry',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1434,'Drainliar@NPC_DARKNESSATTACK','angry',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1434,'Drainliar@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1434,'Drainliar@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1434,'Drainliar@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_BLINDATTACK','angry',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_BLINDATTACK','follow',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_CURSEATTACK','follow',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_CURSEATTACK','angry',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_ENERGYDRAIN','follow',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_ENERGYDRAIN','angry',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_PETRIFYATTACK','follow',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_PETRIFYATTACK','angry',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@WZ_HEAVENDRIVE','follow',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@WZ_HEAVENDRIVE','angry',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_BLINDATTACK','attack',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_BLINDATTACK','chase',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_ENERGYDRAIN','chase',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_ENERGYDRAIN','attack',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_PETRIFYATTACK','chase',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@NPC_PETRIFYATTACK','attack',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@WZ_HEAVENDRIVE','chase',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1435,'Evil Druid@WZ_HEAVENDRIVE','attack',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1436,'Jakk@NPC_BLINDATTACK','angry',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1436,'Jakk@NPC_CURSEATTACK','angry',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1436,'Jakk@NPC_CURSEATTACK','follow',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1436,'Jakk@NPC_FIREATTACK','angry',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1436,'Jakk@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1436,'Jakk@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1436,'Jakk@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1436,'Jakk@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@MG_FIREBALL','follow',17,5,500,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@MG_FROSTDIVER','follow',15,40,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@MG_SOULSTRIKE','follow',13,9,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@NPC_ENERGYDRAIN','follow',200,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@NPC_WINDATTACK','follow',187,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@WZ_HEAVENDRIVE','follow',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@NPC_DARKTHUNDER','follow',341,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@WZ_QUAGMIRE','follow',92,5,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@MG_FIREBALL','chase',17,5,500,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@MG_FROSTDIVER','chase',15,40,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@MG_SOULSTRIKE','chase',13,9,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@NPC_ATTRICHANGE','idle',161,1,500,2000,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@NPC_ENERGYDRAIN','chase',200,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@NPC_WINDATTACK','chase',187,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@WZ_HEAVENDRIVE','chase',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@NPC_DARKTHUNDER','chase',341,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1437,'Joker@WZ_QUAGMIRE','chase',92,5,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1438,'Khalitzburg@AS_GRIMTOOTH','follow',137,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1438,'Khalitzburg@BS_MAXIMIZE','follow',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1438,'Khalitzburg@BS_MAXIMIZE','angry',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1438,'Khalitzburg@NPC_SPLASHATTACK','angry',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1438,'Khalitzburg@NPC_STUNATTACK','angry',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1438,'Khalitzburg@AS_GRIMTOOTH','chase',137,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1438,'Khalitzburg@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1438,'Khalitzburg@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1438,'Khalitzburg@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1438,'Khalitzburg@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1439,'High Orc@NPC_FIREATTACK','angry',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1439,'High Orc@NPC_GUIDEDATTACK','angry',172,1,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1439,'High Orc@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1439,'High Orc@NPC_GUIDEDATTACK','attack',172,1,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1439,'High Orc@NPC_SMOKING','idle',195,1,500,0,36000000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1440,'Stem Worm@NPC_GUIDEDATTACK','angry',172,1,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1440,'Stem Worm@NPC_WINDATTACK','angry',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1440,'Stem Worm@NPC_GUIDEDATTACK','attack',172,1,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1440,'Stem Worm@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1441,'Penomena@NPC_BLOODDRAIN','angry',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1441,'Penomena@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1441,'Penomena@NPC_POISONATTACK','angry',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1441,'Penomena@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1441,'Penomena@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1441,'Penomena@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1442,'Sasquatch@KN_SPEARSTAB','angry',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1442,'Sasquatch@NPC_EMOTION','follow',197,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1442,'Sasquatch@SM_ENDURE','follow',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1442,'Sasquatch@KN_SPEARSTAB','attack',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1442,'Sasquatch@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1442,'Sasquatch@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1443,'Cruiser@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1443,'Cruiser@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@AL_HEAL','angry',28,11,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@AL_HEAL','follow',28,11,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@AL_HEAL','angry',28,11,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@AL_HEAL','follow',28,11,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@MG_FIREWALL','follow',18,10,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@MG_FIREWALL','angry',18,10,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@NPC_FIREATTACK','angry',186,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@NPC_GUIDEDATTACK','angry',172,5,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@PR_STRECOVERY','follow',72,1,2000,700,5000,'yes','friend','friendstatuson','anybad',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@PR_STRECOVERY','angry',72,1,2000,700,5000,'yes','friend','friendstatuson','anybad',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@AL_HEAL','attack',28,11,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@AL_HEAL','chase',28,11,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@AL_HEAL','attack',28,11,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@AL_HEAL','chase',28,11,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@MG_FIREWALL','chase',18,10,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@MG_FIREWALL','attack',18,10,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@NPC_FIREATTACK','attack',186,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@NPC_GUIDEDATTACK','attack',172,5,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@PR_STRECOVERY','chase',72,1,2000,700,5000,'yes','friend','friendstatuson','anybad',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1444,'Chepet@PR_STRECOVERY','attack',72,1,2000,700,5000,'yes','friend','friendstatuson','anybad',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1445,'Raggler@NPC_COMBOATTACK','angry',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1445,'Raggler@NPC_WINDATTACK','angry',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1445,'Raggler@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1445,'Raggler@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1446,'Injustice@AS_SONICBLOW','angry',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1446,'Injustice@NPC_DARKNESSATTACK','angry',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1446,'Injustice@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1446,'Injustice@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1447,'Gryphon@KN_PIERCE','angry',56,10,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1447,'Gryphon@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1447,'Gryphon@NPC_WINDATTACK','angry',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1447,'Gryphon@KN_PIERCE','attack',56,10,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1447,'Gryphon@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1447,'Gryphon@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_BLINDATTACK','angry',177,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_BLINDATTACK','follow',177,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_BLOODDRAIN','angry',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_CURSEATTACK','angry',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_CURSEATTACK','follow',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_DARKNESSATTACK','angry',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_PETRIFYATTACK','angry',180,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_PETRIFYATTACK','follow',180,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_BLINDATTACK','attack',177,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_BLINDATTACK','chase',177,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_PETRIFYATTACK','attack',180,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1448,'Dark Frame@NPC_PETRIFYATTACK','chase',180,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1449,'Mutant Dragon@MG_FIREBALL','follow',17,44,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1449,'Mutant Dragon@NPC_FIREATTACK','angry',186,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1449,'Mutant Dragon@SM_MAGNUM','angry',7,25,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1449,'Mutant Dragon@MG_FIREBALL','chase',17,44,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1449,'Mutant Dragon@NPC_FIREATTACK','attack',186,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1449,'Mutant Dragon@SM_MAGNUM','attack',7,25,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@MG_LIGHTNINGBOLT','follow',20,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@MG_LIGHTNINGBOLT','angry',20,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@NPC_MAGICALATTACK','angry',192,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@NPC_WINDATTACK','angry',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@WZ_JUPITEL','follow',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@WZ_JUPITEL','angry',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@HT_SHOCKWAVE','idle',118,5,500,0,300000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@MG_LIGHTNINGBOLT','chase',20,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@MG_LIGHTNINGBOLT','attack',20,5,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@NPC_MAGICALATTACK','attack',192,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@WZ_JUPITEL','chase',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1450,'Wind Ghost@WZ_JUPITEL','attack',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1451,'Merman@KN_PIERCE','angry',56,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1451,'Merman@NPC_RANGEATTACK','follow',160,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1451,'Merman@NPC_WATERATTACK','angry',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1451,'Merman@KN_PIERCE','attack',56,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1451,'Merman@NPC_RANGEATTACK','chase',160,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1451,'Merman@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1452,'Orc Lady@AL_INCAGI','follow',29,1,500,700,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1452,'Orc Lady@NPC_GROUNDATTACK','angry',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1452,'Orc Lady@AL_INCAGI','chase',29,1,500,700,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1452,'Orc Lady@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1453,'Raydric Archer@AC_CHARGEARROW','angry',148,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1453,'Raydric Archer@NPC_DARKNESSATTACK','angry',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1453,'Raydric Archer@AC_CHARGEARROW','attack',148,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1453,'Raydric Archer@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1454,'Tri Joint@NPC_GROUNDATTACK','angry',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1454,'Tri Joint@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1455,'Kobold Archer@AC_DOUBLE','angry',46,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1455,'Kobold Archer@NPC_FIREATTACK','angry',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1455,'Kobold Archer@AC_DOUBLE','attack',46,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1455,'Kobold Archer@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1456,'Chimera@NPC_FIREATTACK','angry',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1456,'Chimera@NPC_SPLASHATTACK','angry',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1456,'Chimera@WZ_HEAVENDRIVE','follow',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1456,'Chimera@WZ_HEAVENDRIVE','angry',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1456,'Chimera@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1456,'Chimera@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1456,'Chimera@WZ_HEAVENDRIVE','chase',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1456,'Chimera@WZ_HEAVENDRIVE','attack',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1457,'Mantis@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1457,'Mantis@NPC_GROUNDATTACK','angry',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1457,'Mantis@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1457,'Mantis@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@MG_FIREBOLT','follow',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@MG_FIREBOLT','angry',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@MG_FIREWALL','follow',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@NPC_BLINDATTACK','follow',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@NPC_FIREATTACK','angry',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@NPC_MAGICALATTACK','angry',192,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@MG_FIREBOLT','chase',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@MG_FIREBOLT','attack',19,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@MG_FIREWALL','chase',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@NPC_BLINDATTACK','chase',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1458,'Marduk@NPC_MAGICALATTACK','attack',192,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1459,'Marionette@MG_FIREWALL','follow',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1459,'Marionette@NPC_TELEKINESISATTACK','angry',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1459,'Marionette@HT_FREEZINGTRAP','idle',121,5,500,0,300000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1459,'Marionette@MG_FIREWALL','chase',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1459,'Marionette@NPC_TELEKINESISATTACK','attack',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1460,'Matyr@AS_SONICBLOW','angry',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1460,'Matyr@NPC_DARKNESSATTACK','angry',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1460,'Matyr@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1460,'Matyr@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1461,'Minorous@BS_HAMMERFALL','angry',110,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1461,'Minorous@NPC_FIREATTACK','angry',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1461,'Minorous@WZ_HEAVENDRIVE','angry',91,3,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1461,'Minorous@BS_HAMMERFALL','attack',110,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1461,'Minorous@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1461,'Minorous@WZ_HEAVENDRIVE','attack',91,3,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1462,'Orc Skeleton@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1462,'Orc Skeleton@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1463,'Orc Zombie@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1463,'Orc Zombie@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1464,'Pasana@NPC_COMBOATTACK','angry',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1464,'Pasana@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1464,'Pasana@SM_BASH','angry',5,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1464,'Pasana@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1464,'Pasana@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1464,'Pasana@SM_BASH','attack',5,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1465,'Petite@NPC_GROUNDATTACK','angry',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1465,'Petite@NPC_TELEKINESISATTACK','follow',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1465,'Petite@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1465,'Petite@NPC_TELEKINESISATTACK','chase',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1466,'Petite@NPC_TELEKINESISATTACK','follow',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1466,'Petite@NPC_WINDATTACK','angry',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1466,'Petite@NPC_TELEKINESISATTACK','chase',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1466,'Petite@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1467,'Raydric@BS_MAXIMIZE','follow',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1467,'Raydric@BS_MAXIMIZE','angry',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1467,'Raydric@NPC_DARKNESSATTACK','angry',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1467,'Raydric@SM_MAGNUM','angry',7,25,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1467,'Raydric@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1467,'Raydric@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1467,'Raydric@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1467,'Raydric@SM_MAGNUM','attack',7,25,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1468,'Requim@NPC_DARKNESSATTACK','angry',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1468,'Requim@NPC_STUNATTACK','angry',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1468,'Requim@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1468,'Requim@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1469,'Skeleton Worker@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1469,'Skeleton Worker@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1470,'Zerom@NPC_FIREATTACK','angry',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1470,'Zerom@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1471,'Nine Tail@NPC_ATTRICHANGE','angry',161,1,500,2000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1471,'Nine Tail@NPC_RANDOMATTACK','angry',183,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1471,'Nine Tail@NPC_ATTRICHANGE','attack',161,1,500,2000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1471,'Nine Tail@NPC_RANDOMATTACK','attack',183,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1472,'Bon Gun@KN_SPEARSTAB','angry',58,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1472,'Bon Gun@NPC_STUNATTACK','angry',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1472,'Bon Gun@KN_SPEARSTAB','attack',58,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1472,'Bon Gun@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1473,'Orc Archer@AC_SHOWER','angry',47,5,2000,1000,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1473,'Orc Archer@NPC_GROUNDATTACK','angry',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1473,'Orc Archer@AC_SHOWER','attack',47,5,2000,1000,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1473,'Orc Archer@HT_ANKLESNARE','idle',117,5,500,0,300000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1473,'Orc Archer@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1474,'Mimic@NPC_BLOODDRAIN','angry',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1474,'Mimic@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1475,'Wraith@NPC_BLINDATTACK','angry',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1475,'Wraith@NPC_CURSEATTACK','angry',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1475,'Wraith@NPC_CURSEATTACK','follow',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1475,'Wraith@NPC_ENERGYDRAIN','angry',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1475,'Wraith@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1475,'Wraith@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1475,'Wraith@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1475,'Wraith@NPC_ENERGYDRAIN','attack',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1476,'Alarm@NPC_BLINDATTACK','angry',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1476,'Alarm@NPC_DARKBREATH','angry',202,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1476,'Alarm@NPC_SPLASHATTACK','angry',174,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1476,'Alarm@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1476,'Alarm@NPC_DARKBREATH','attack',202,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1476,'Alarm@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1477,'Arclouse@NPC_GROUNDATTACK','angry',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1477,'Arclouse@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1478,'Rideword@NPC_BLINDATTACK','angry',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1478,'Rideword@NPC_BLOODDRAIN','angry',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1478,'Rideword@NPC_PIERCINGATT','angry',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1478,'Rideword@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1478,'Rideword@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1478,'Rideword@NPC_PIERCINGATT','attack',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1479,'Skeleton Prisoner@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1479,'Skeleton Prisoner@NPC_SPLASHATTACK','angry',174,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1479,'Skeleton Prisoner@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1479,'Skeleton Prisoner@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1480,'Zombie Prisoner@NPC_POISON','angry',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1480,'Zombie Prisoner@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1481,'Punk@NPC_PETRIFYATTACK','angry',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1481,'Punk@NPC_WINDATTACK','angry',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1481,'Punk@NPC_PETRIFYATTACK','attack',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1481,'Punk@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1482,'Zherlthsh@AS_SONICBLOW','angry',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1482,'Zherlthsh@NPC_GUIDEDATTACK','angry',172,3,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1482,'Zherlthsh@NPC_LICK','angry',206,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1482,'Zherlthsh@SM_PROVOKE','follow',6,10,500,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1482,'Zherlthsh@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1482,'Zherlthsh@NPC_GUIDEDATTACK','attack',172,3,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1482,'Zherlthsh@NPC_LICK','attack',206,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1482,'Zherlthsh@SM_PROVOKE','chase',6,10,500,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1483,'Rybio@AS_SONICBLOW','angry',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1483,'Rybio@NPC_POISON','angry',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1483,'Rybio@SM_PROVOKE','follow',6,5,500,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1483,'Rybio@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1483,'Rybio@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1483,'Rybio@SM_PROVOKE','chase',6,5,500,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1484,'Phendark@NPC_POISON','angry',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1484,'Phendark@NPC_STUNATTACK','angry',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1484,'Phendark@NPC_WINDATTACK','angry',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1484,'Phendark@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1484,'Phendark@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1484,'Phendark@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1485,'Mysteltainn@BS_MAXIMIZE','follow',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1485,'Mysteltainn@BS_MAXIMIZE','angry',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1485,'Mysteltainn@NPC_DARKNESSATTACK','angry',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1485,'Mysteltainn@NPC_GUIDEDATTACK','angry',172,1,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1485,'Mysteltainn@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1485,'Mysteltainn@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1485,'Mysteltainn@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1485,'Mysteltainn@NPC_GUIDEDATTACK','attack',172,1,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1486,'Tirfing@AS_SONICBLOW','angry',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1486,'Tirfing@BS_MAXIMIZE','follow',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1486,'Tirfing@BS_MAXIMIZE','angry',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1486,'Tirfing@NPC_DARKNESSATTACK','angry',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1486,'Tirfing@NPC_PIERCINGATT','angry',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1486,'Tirfing@AS_SONICBLOW','attack',136,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1486,'Tirfing@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1486,'Tirfing@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1486,'Tirfing@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1486,'Tirfing@NPC_PIERCINGATT','attack',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1487,'Executioner@BS_MAXIMIZE','follow',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1487,'Executioner@BS_MAXIMIZE','angry',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1487,'Executioner@KN_AUTOCOUNTER','angry',61,5,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1487,'Executioner@KN_SPEARBOOMERANG','follow',59,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1487,'Executioner@NPC_DARKNESSATTACK','angry',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1487,'Executioner@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1487,'Executioner@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1487,'Executioner@KN_AUTOCOUNTER','attack',61,5,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1487,'Executioner@KN_SPEARBOOMERANG','chase',59,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1487,'Executioner@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1488,'Anolian@NPC_WATERATTACK','angry',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1488,'Anolian@NPC_WATERATTACK','follow',184,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1488,'Anolian@SM_BASH','angry',5,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1488,'Anolian@NPC_WATERATTACK','attack',184,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1488,'Anolian@NPC_WATERATTACK','chase',184,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1488,'Anolian@SM_BASH','attack',5,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@KN_SPEARSTAB','angry',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@NPC_GROUNDATTACK','angry',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@TF_HIDING','angry',51,1,2000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@WZ_QUAGMIRE','follow',92,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@WZ_QUAGMIRE','angry',92,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@AL_HEAL','idle',28,5,10000,0,5000,'yes','self','mystatuson','hiding',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@KN_SPEARSTAB','attack',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@TF_HIDING','attack',51,1,2000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@WZ_QUAGMIRE','chase',92,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1489,'Sting@WZ_QUAGMIRE','attack',92,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1490,'Wander Man@KN_AUTOCOUNTER','angry',61,5,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1490,'Wander Man@NPC_SPLASHATTACK','angry',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1490,'Wander Man@NPC_WINDATTACK','angry',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1490,'Wander Man@KN_AUTOCOUNTER','attack',61,5,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1490,'Wander Man@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1490,'Wander Man@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1491,'Dokebi@BS_ADRENALINE','follow',111,1,500,1500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1491,'Dokebi@BS_ADRENALINE','angry',111,1,500,1500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1491,'Dokebi@MC_MAMMONITE','angry',42,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1491,'Dokebi@NPC_DARKNESSATTACK','angry',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1491,'Dokebi@BS_ADRENALINE','chase',111,1,500,1500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1491,'Dokebi@BS_ADRENALINE','attack',111,1,500,1500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1491,'Dokebi@MC_MAMMONITE','attack',42,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1491,'Dokebi@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@AL_TELEPORT','idle',26,1,5000,1000,5000,'yes','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@KN_BRANDISHSPEAR','attack',57,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_AGIUP','attack',350,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@KN_TWOHANDQUICKEN','attack',60,30,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_HELLJUDGEMENT','chase',662,10,10000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_HELLJUDGEMENT','attack',662,10,10000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@ASC_BREAKER','idle',379,10,10000,500,5000,'no','target','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@ASC_BREAKER','chase',379,10,5000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@ASC_BREAKER','attack',379,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_CRITICALSLASH','attack',170,1,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_HELMBRAKE','chase',345,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_SHIELDBRAKE','attack',346,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','2',1560,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','2',1560,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@RG_INTIMIDATE','attack',219,10,2000,0,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@AL_TELEPORT','chase',26,1,10000,0,0,'yes','self','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1492,'Incantation Samurai@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1493,'Dryad@AL_HEAL','idle',28,9,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1493,'Dryad@AL_HEAL','attack',28,9,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1493,'Dryad@NPC_STOP','attack',342,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1493,'Dryad@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1493,'Dryad@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1493,'Dryad@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1494,'Beetle King@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1494,'Beetle King@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1494,'Beetle King@NPC_KEEPING','attack',201,1,2000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1495,'Stone Shooter@NPC_FIREATTACK','attack',186,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1495,'Stone Shooter@NPC_PIERCINGATT','attack',158,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1495,'Stone Shooter@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1497,'Wooden Golem@AL_HEAL','idle',28,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1497,'Wooden Golem@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1497,'Wooden Golem@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1498,'Wootan Shooter@NPC_GUIDEDATTACK','attack',172,2,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1498,'Wootan Shooter@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1499,'Wootan Fighter@KN_TWOHANDQUICKEN','attack',60,9,2000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1499,'Wootan Fighter@SM_MAGNUM','attack',7,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1498,'Wootan Shooter@NPC_RUN','attack',354,1,500,0,5000,'yes','self','attackpcge','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1500,'Parasite@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1500,'Parasite@NPC_PETRIFYATTACK','attack',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1500,'Parasite@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1500,'Parasite@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1500,'Parasite@NPC_PETRIFYATTACK','chase',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1500,'Parasite@NPC_POISON','chase',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@AL_HEAL','idle',28,11,10000,0,2000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'4',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@AL_HEAL','walk',28,11,10000,0,2000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'4',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@BS_HAMMERFALL','chase',110,10,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@BS_HAMMERFALL','attack',110,10,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@MG_FIREWALL','attack',18,10,10000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@AS_SONICBLOW','attack',136,10,10000,0,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@SM_MAGNUM','attack',7,25,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@SM_MAGNUM','attack',7,25,10000,0,5000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@WZ_VERMILION','chase',85,21,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@WZ_VERMILION','attack',85,21,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@WZ_METEOR','chase',83,11,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@WZ_METEOR','attack',83,11,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@WZ_STORMGUST','chase',89,10,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@WZ_STORMGUST','attack',89,10,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@NPC_DARKBLESSING','attack',203,1,1000,2000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@NPC_SUMMONSLAVE','idle',196,16,10000,2000,10000,'no','self','slavele','3',1491,1431,1433,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@NPC_SUMMONSLAVE','attack',196,16,10000,2000,10000,'no','self','slavele','3',1491,1431,1433,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@RG_STRIPARMOR','attack',217,5,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@RG_STRIPHELM','attack',218,5,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@RG_STRIPSHIELD','attack',216,5,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1502,'Bring it on!@RG_STRIPWEAPON','attack',215,5,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1503,'Gibbet@AS_GRIMTOOTH','chase',137,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1503,'Gibbet@NPC_CURSEATTACK','attack',181,3,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1503,'Gibbet@NPC_UNDEADATTACK','attack',347,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1504,'Dullahan@NPC_CRITICALSLASH','attack',170,1,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1504,'Dullahan@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1505,'Loli Ruri@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1505,'Loli Ruri@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1505,'Loli Ruri@NPC_DARKSTRIKE','attack',340,5,500,700,5000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1505,'Loli Ruri@NPC_DARKSTRIKE','chase',340,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1505,'Loli Ruri@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',3,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1505,'Loli Ruri@NPC_SUMMONSLAVE','idle',196,1,500,2000,60000,'no','self','slavele','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1505,'Loli Ruri@PR_LEXDIVINA','chase',76,10,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1505,'Loli Ruri@PR_LEXDIVINA','attack',76,10,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1505,'Loli Ruri@SA_REVERSEORCISH','chase',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1505,'Loli Ruri@SA_REVERSEORCISH','attack',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1506,'Disguise@NPC_COMBOATTACK','attack',171,1,1000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1506,'Disguise@NPC_METAMORPHOSIS','attack',193,2,500,0,60000,'no','self','myhpltmaxrate','10',1509,1508,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1506,'Disguise@NPC_PIERCINGATT','attack',158,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1507,'Bloody Murderer@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1507,'Bloody Murderer@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1508,'Quve@MG_STONECURSE','attack',16,10,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1508,'Quve@NPC_MENTALBREAKER','attack',159,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1508,'Quve@NPC_METAMORPHOSIS','attack',193,1,1000,0,60000,'no','self','myhpltmaxrate','30',1509,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1509,'Lude@AL_HEAL','chase',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1509,'Lude@AL_HEAL','attack',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1509,'Lude@AL_HEAL','chase',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1509,'Lude@AL_HEAL','attack',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1509,'Lude@NPC_METAMORPHOSIS','attack',193,1,1000,0,60000,'no','self','myhpltmaxrate','30',1508,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1509,'Lude@PR_LEXAETERNA','chase',78,1,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1509,'Lude@PR_LEXAETERNA','attack',78,1,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1510,'Hylozoist@AL_DECAGI','attack',30,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1510,'Hylozoist@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1510,'Hylozoist@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1510,'Hylozoist@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_BLOODDRAIN','idle',199,1,2000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_BLOODDRAIN','idle',199,1,2000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_BLOODDRAIN','attack',199,1,2000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_BLOODDRAIN','attack',199,1,2000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_SUMMONMONSTER','idle',209,5,5000,0,10000,'no','self','longrangeattacked','0',1474,1477,1438,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_SUMMONMONSTER','idle',209,5,5000,0,10000,'no','self','casttargeted','0',1474,1477,1438,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_SUMMONMONSTER','attack',209,5,5000,0,10000,'no','self','longrangeattacked','0',1474,1477,1438,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_SUMMONMONSTER','attack',209,5,5000,0,10000,'no','self','casttargeted','0',1474,1477,1438,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_SUMMONMONSTER','idle',209,5,5000,0,10000,'no','self','skillused','18',1474,1477,1438,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_SUMMONMONSTER','idle',209,5,5000,0,10000,'no','self','skillused','89',1474,1477,1438,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_SUMMONMONSTER','idle',209,5,5000,0,10000,'no','self','skillused','21',1474,1477,1438,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_SUMMONMONSTER','idle',209,5,5000,0,10000,'no','self','skillused','28',1474,1477,1438,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_SUMMONMONSTER','idle',209,5,5000,0,10000,'no','self','skillused','79',1474,1477,1438,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_SUMMONMONSTER','idle',209,5,5000,0,10000,'no','self','skillused','83',1474,1477,1438,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_METEOR','idle',83,11,10000,0,0,'yes','randomtarget','skillused','18',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_METEOR','idle',83,11,10000,0,0,'yes','randomtarget','skillused','89',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_METEOR','idle',83,11,10000,0,0,'yes','randomtarget','skillused','21',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_METEOR','idle',83,11,10000,0,0,'yes','randomtarget','skillused','28',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_METEOR','idle',83,11,10000,0,0,'yes','randomtarget','skillused','79',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_METEOR','idle',83,11,10000,0,0,'yes','randomtarget','skillused','83',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_METEOR','idle',83,11,10000,0,0,'yes','randomtarget','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_METEOR','idle',83,11,10000,0,0,'yes','randomtarget','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_METEOR','attack',83,11,5000,0,3000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_FIREPILLAR','idle',80,10,10000,0,2000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_FIREPILLAR','idle',80,10,10000,0,2000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_FIREPILLAR','attack',80,10,5000,0,2000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@NPC_DARKBLESSING','attack',203,1,5000,0,2000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@WZ_METEOR','idle',83,11,10000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1511,'Amon Ra@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1512,'Hyegun@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1512,'Hyegun@AS_SONICBLOW','attack',136,5,500,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1512,'Hyegun@NPC_CRITICALSLASH','attack',170,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1513,'Civil Servant@NPC_DARKTHUNDER','chase',341,3,500,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1513,'Civil Servant@NPC_DARKTHUNDER','attack',341,3,500,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1513,'Civil Servant@AM_POTIONPITCHER','idle',231,4,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1513,'Civil Servant@AM_POTIONPITCHER','attack',231,4,10000,500,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1513,'Civil Servant@AM_POTIONPITCHER','idle',231,4,10000,500,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1514,'Dancing Dragon@NPC_AGIUP','loot',350,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1514,'Dancing Dragon@NPC_AGIUP','idle',350,1,0,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1514,'Dancing Dragon@NPC_EMOTION','idle',197,1,10000,0,3000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1514,'Dancing Dragon@NPC_EMOTION','attack',197,1,10000,0,3000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1514,'Dancing Dragon@NPC_EMOTION','chase',197,1,10000,0,3000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1515,'Garm Baby@MG_FROSTDIVER','chase',15,40,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1515,'Garm Baby@NPC_LICK','attack',206,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1516,'Increase Soil@NPC_METAMORPHOSIS','attack',193,2,50,5000,5000,'no','self','always','0',1516,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1517,'Li Me Mang Ryang@NPC_RANGEATTACK','chase',160,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'24',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1517,'Li Me Mang Ryang@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@NPC_INVISIBLE','chase',353,1,2000,1000,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@PR_SANCTUARY','attack',70,10,2000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@HP_ASSUMPTIO','idle',361,5,10000,500,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@HP_ASSUMPTIO','chase',361,5,10000,500,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@HP_ASSUMPTIO','attack',361,5,10000,500,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@NPC_WIDESLEEP','chase',668,5,10000,700,25000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@NPC_WIDESLEEP','attack',668,5,10000,700,25000,'yes','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@WZ_WATERBALL','chase',86,3,2000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@WZ_WATERBALL','attack',86,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@NPC_STOP','attack',342,1,2000,500,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@AL_TELEPORT','idle',26,1,1000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@NPC_SUMMONSLAVE','idle',196,1,10000,0,5000,'yes','self','slavele','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@NPC_SUMMONSLAVE','attack',196,1,10000,0,5000,'yes','self','slavele','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1518,'Bacsojin@NPC_SUMMONSLAVE','chase',196,1,10000,0,5000,'yes','self','slavele','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1519,'Chung E@CR_SHIELDCHARGE','attack',250,5,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1519,'Chung E@RG_INTIMIDATE','attack',219,1,1000,1000,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1519,'Chung E@PR_LEXDIVINA','chase',76,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1519,'Chung E@TF_POISON','attack',52,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1520,'Boiled Rice@CR_AUTOGUARD','idle',249,10,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1520,'Boiled Rice@NPC_SUICIDE','attack',175,1,10000,4000,0,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1566,'Wraith Dead@AL_DECAGI','chase',30,9,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1566,'Wraith Dead@AS_GRIMTOOTH','chase',137,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1566,'Wraith Dead@NPC_CURSEATTACK','attack',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1566,'Wraith Dead@NPC_CURSEATTACK','chase',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1566,'Wraith Dead@NPC_POISON','attack',176,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1555,'Parasite@NPC_REVENGE','idle',333,1,10000,0,0,'yes','target','masterattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1575,'Flora@NPC_REVENGE','idle',333,1,10000,0,0,'yes','target','masterattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1579,'Hydra@NPC_REVENGE','idle',333,1,10000,0,0,'yes','target','masterattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1580,'Incubus@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1580,'Incubus@NPC_DARKNESSATTACK','attack',190,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1580,'Incubus@NPC_DARKSTRIKE','attack',340,9,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1580,'Incubus@NPC_DARKSTRIKE','chase',340,9,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1580,'Incubus@NPC_MENTALBREAKER','attack',159,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'14',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1580,'Incubus@NPC_MENTALBREAKER','chase',159,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'14',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1582,'Deviling@NPC_SUMMONSLAVE','attack',196,7,10000,2000,10000,'no','self','slavele','3',1595,1595,1595,1433,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1582,'Deviling@NPC_SUMMONSLAVE','idle',196,7,10000,2000,10000,'no','self','slavele','3',1595,1595,1595,1433,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1582,'Deviling@NPC_DARKSTRIKE','chase',340,5,3000,700,0,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1582,'Deviling@NPC_DARKSTRIKE','attack',340,5,3000,700,0,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1582,'Deviling@NPC_DARKNESSATTACK','attack',190,2,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1582,'Deviling@AL_DECAGI','chase',30,1,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_AGIUP','attack',350,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','4',1793,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','4',1793,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@AL_TELEPORT','chase',26,1,10000,0,0,'yes','self','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_MENTALBREAKER','attack',159,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_MENTALBREAKER','chase',159,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_COMBOATTACK','attack',171,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_COMBOATTACK','chase',171,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_STUNATTACK','attack',179,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_STUNATTACK','chase',179,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_GUIDEDATTACK','attack',172,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_GUIDEDATTACK','chase',172,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1583,'Tao Gunka@NPC_CRITICALSLASH','attack',170,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1584,'Tamruan@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1584,'Tamruan@NPC_SILENCEATTACK','attack',178,5,2000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1584,'Tamruan@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1585,'Mime Monkey@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1585,'Mime Monkey@SM_PROVOKE','chase',6,10,500,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1585,'Mime Monkey@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1585,'Mime Monkey@SM_PROVOKE','attack',6,10,500,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1586,'Leaf Cat@AL_HEAL','attack',28,1,10000,500,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1586,'Leaf Cat@AL_HEAL','attack',28,1,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1586,'Leaf Cat@AL_HEAL','chase',28,1,10000,500,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1586,'Leaf Cat@AL_HEAL','chase',28,1,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1587,'Kraben@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1587,'Kraben@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1587,'Kraben@NPC_STUNATTACK','attack',179,1,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1588,'Christmas Orc@NPC_EMOTION','idle',197,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1589,'Mandragora@NPC_REVENGE','idle',333,1,10000,0,0,'yes','target','masterattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1590,'Geographer@AL_HEAL','idle',28,9,10000,500,5000,'yes','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1590,'Geographer@NPC_REVENGE','idle',333,1,10000,0,0,'yes','target','masterattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1609,'Dancing Dragon@NPC_AGIUP','loot',350,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1609,'Dancing Dragon@NPC_AGIUP','idle',350,1,0,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1609,'Dancing Dragon@NPC_EMOTION','idle',197,1,10000,0,3000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1609,'Dancing Dragon@NPC_EMOTION','attack',197,1,10000,0,3000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1609,'Dancing Dragon@NPC_EMOTION','chase',197,1,10000,0,3000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1613,'Metaling@CR_REFLECTSHIELD','attack',252,3,1000,0,200000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1613,'Metaling@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1613,'Metaling@CR_AUTOGUARD','chase',249,5,500,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1613,'Metaling@RG_STRIPWEAPON','attack',215,3,500,0,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1613,'Metaling@MC_MAMMONITE','attack',42,5,1000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1614,'Mineral@CR_REFLECTSHIELD','attack',252,2,1000,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1614,'Mineral@NPC_RANDOMATTACK','attack',183,2,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1614,'Mineral@NPC_BARRIER','attack',204,1,500,3000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1614,'Mineral@NPC_SPLASHATTACK','attack',174,1,500,0,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1614,'Mineral@TF_HIDING','attack',51,1,500,500,50000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1614,'Mineral@TF_HIDING','idle',51,1,500,500,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1615,'Obsidian@CR_SHIELDCHARGE','attack',250,2,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1615,'Obsidian@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1615,'Obsidian@NPC_BARRIER','attack',204,1,500,3000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1615,'Obsidian@SM_MAGNUM','attack',7,5,500,500,5000,'no','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1615,'Obsidian@TF_HIDING','attack',51,1,500,500,50000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1615,'Obsidian@TF_HIDING','idle',51,1,500,500,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1616,'Pitman@TF_SPRINKLESAND','attack',149,1,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1616,'Pitman@TF_SPRINKLESAND','chase',149,1,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1616,'Pitman@NPC_COMBOATTACK','attack',171,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1616,'Pitman@NPC_POWERUP','attack',349,2,3000,500,10000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1616,'Pitman@HT_CLAYMORETRAP','idle',123,5,500,0,300000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1617,'Waste Stove@NPC_STUNATTACK','attack',179,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1617,'Waste Stove@TF_THROWSTONE','chase',152,1,1000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1617,'Waste Stove@NPC_RANDOMATTACK','attack',183,3,500,200,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1617,'Waste Stove@NPC_SPLASHATTACK','attack',174,1,1000,500,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1618,'Ungoliant@NPC_PETRIFYATTACK','attack',180,2,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1618,'Ungoliant@NPC_DARKBREATH','attack',202,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1618,'Ungoliant@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'14',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1618,'Ungoliant@NPC_POISONATTACK','attack',188,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1618,'Ungoliant@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1618,'Ungoliant@AL_TELEPORT','attack',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1618,'Ungoliant@NPC_SUMMONSLAVE','attack',196,3,10000,700,30000,'no','self','slavele','0',1625,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1618,'Ungoliant@NPC_SUMMONSLAVE','idle',196,3,10000,700,30000,'no','self','slavele','0',1625,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1619,'Porcellio@AL_PNEUMA','attack',25,1,500,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1619,'Porcellio@NPC_GROUNDATTACK','attack',185,2,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1619,'Porcellio@NPC_KEEPING','attack',201,1,2000,1000,5000,'no','self','myhpltmaxrate','25',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1620,'Noxious@NPC_SELFDESTRUCTION','attack',173,1,500,2000,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1620,'Noxious@NPC_SELFDESTRUCTION','chase',173,1,500,2000,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1620,'Noxious@NPC_SELFDESTRUCTION','attack',173,1,500,2000,5000,'no','self','skillused','173',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1620,'Noxious@NPC_TELEKINESISATTACK','attack',191,3,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1620,'Noxious@NPC_MENTALBREAKER','attack',159,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'14',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1620,'Noxious@NPC_MENTALBREAKER','chase',159,2,500,0,5000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'14',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1621,'Venomous@NPC_SELFDESTRUCTION','attack',173,1,500,2000,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1621,'Venomous@NPC_SELFDESTRUCTION','chase',173,1,500,2000,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1621,'Venomous@NPC_SELFDESTRUCTION','attack',173,1,500,2000,5000,'no','self','skillused','173',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1621,'Venomous@NPC_POISON','attack',176,3,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1621,'Venomous@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1621,'Venomous@NPC_BLINDATTACK','chase',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1622,'Teddy Bear@NPC_SELFDESTRUCTION','attack',173,1,1000,2000,10000,'no','self','attackpcge','3',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1622,'Teddy Bear@NPC_SELFDESTRUCTION','chase',173,1,1000,2000,10000,'no','self','attackpcge','3',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1622,'Teddy Bear@NPC_CURSEATTACK','attack',181,4,500,800,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1622,'Teddy Bear@NPC_CURSEATTACK','chase',181,4,500,800,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1622,'Teddy Bear@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1622,'Teddy Bear@SA_DISPELL','attack',289,1,50,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1622,'Teddy Bear@NPC_EMOTION_ON','attack',474,1,10000,0,30000,'yes','self','always','0',7,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1622,'Teddy Bear@NPC_EMOTION','idle',197,1,10000,0,30000,'yes','self','always','0',23,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_AGIUP','chase',350,5,2000,0,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_POWERUP','attack',349,5,2000,0,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_EARTHQUAKE','chase',653,5,10000,2000,30000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_EARTHQUAKE','attack',653,5,10000,2000,30000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_SUMMONSLAVE','attack',196,5,10000,2000,10000,'no','self','slavele','3',1624,1624,1621,1620,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_SUMMONSLAVE','idle',196,5,10000,2000,10000,'no','self','slavele','3',1624,1624,1621,1620,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_SUMMONSLAVE','idle',196,5,10000,0,0,'no','self','onspawn','0',1617,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_WEAPONBRAKER','attack',343,10,1000,0,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@BS_HAMMERFALL','chase',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@AL_TELEPORT','idle',26,1,10000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@AL_TELEPORT','walk',26,1,10000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@NPC_CRITICALSLASH','attack',170,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@AS_SONICBLOW','attack',136,10,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1623,'RSX 0806@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1624,'Waste Stove@NPC_STUNATTACK','attack',179,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1624,'Waste Stove@TF_THROWSTONE','chase',152,1,4000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1624,'Waste Stove@NPC_RANDOMATTACK','attack',183,3,500,200,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1624,'Waste Stove@NPC_SPLASHATTACK','attack',174,1,1000,500,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1625,'Porcellio@AL_PNEUMA','attack',25,1,500,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1625,'Porcellio@NPC_GROUNDATTACK','attack',185,2,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1625,'Porcellio@NPC_KEEPING','attack',201,1,2000,1000,5000,'no','self','myhpltmaxrate','25',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1626,'Dark Priest@NPC_DARKCROSS','attack',338,10,5000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1626,'Dark Priest@NPC_CHANGEUNDEAD','attack',348,5,1000,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1626,'Dark Priest@MO_BODYRELOCATION','chase',264,1,10000,0,5000,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1626,'Dark Priest@NPC_DARKBREATH','chase',202,5,500,800,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1626,'Dark Priest@NPC_GRANDDARKNESS','attack',339,5,2000,2000,30000,'no','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1626,'Dark Priest@NPC_GRANDDARKNESS','attack',339,5,500,2000,30000,'no','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1626,'Dark Priest@NPC_DARKSTRIKE','chase',340,10,2000,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1626,'Dark Priest@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1626,'Dark Priest@AL_HEAL','attack',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1626,'Dark Priest@NPC_DARKNESSATTACK','attack',190,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1627,'Anopheles@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1627,'Anopheles@NPC_BLOODDRAIN','chase',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1627,'Anopheles@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1627,'Anopheles@NPC_COMBOATTACK','chase',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1627,'Anopheles@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1627,'Anopheles@NPC_WINDATTACK','chase',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1628,'Mole@TF_HIDING','idle',51,1,500,500,25000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1628,'Mole@TF_HIDING','attack',51,1,2000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1628,'Mole@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1628,'Mole@NPC_GROUNDATTACK','chase',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1628,'Mole@TF_SPRINKLESAND','attack',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1628,'Mole@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1628,'Mole@NPC_COMBOATTACK','chase',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1629,'Hill Wind@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',1,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1629,'Hill Wind@KN_SPEARSTAB','attack',58,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1629,'Hill Wind@NPC_WINDATTACK','chase',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1629,'Hill Wind@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1629,'Hill Wind@KN_SPEARBOOMERANG','chase',59,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@NPC_INVISIBLE','chase',353,1,2000,1000,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@PR_SANCTUARY','attack',70,10,2000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@HP_ASSUMPTIO','idle',361,5,10000,500,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@HP_ASSUMPTIO','chase',361,5,10000,500,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@HP_ASSUMPTIO','attack',361,5,10000,500,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@WZ_WATERBALL','chase',86,3,2000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@WZ_WATERBALL','attack',86,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@NPC_STOP','attack',342,1,2000,500,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@AL_TELEPORT','idle',26,1,1000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@NPC_SUMMONSLAVE','idle',196,3,10000,0,5000,'no','self','slavele','1',1631,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@NPC_SUMMONSLAVE','attack',196,3,10000,0,5000,'no','self','slavele','1',1631,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1630,'Bacsojin@NPC_SUMMONSLAVE','chase',196,3,10000,0,5000,'no','self','slavele','1',1631,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1631,'Chung E@CR_SHIELDCHARGE','attack',250,5,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1631,'Chung E@RG_INTIMIDATE','attack',219,1,1000,1000,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1631,'Chung E@PR_LEXDIVINA','chase',76,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1631,'Chung E@TF_POISON','attack',52,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1632,'Gremlin@RG_STRIPARMOR','attack',217,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1632,'Gremlin@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1633,'Beholder@NPC_PETRIFYATTACK','attack',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1633,'Beholder@NPC_PETRIFYATTACK','chase',180,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1633,'Beholder@MG_NAPALMBEAT','chase',11,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1633,'Beholder@SA_DISPELL','attack',289,5,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1633,'Beholder@NPC_MENTALBREAKER','attack',159,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1633,'Beholder@NPC_MENTALBREAKER','chase',159,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@KN_SPEARBOOMERANG','idle',59,5,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@LK_SPIRALPIERCE','chase',397,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@LK_SPIRALPIERCE','attack',397,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@KN_SPEARBOOMERANG','chase',59,5,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'6',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@KN_BOWLINGBASH','attack',62,5,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@SM_BASH','attack',5,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@SM_MAGNUM','attack',7,9,1000,0,0,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@SM_PROVOKE','attack',6,10,1000,0,300000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@SM_PROVOKE','chase',6,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@NPC_CRITICALSLASH','attack',170,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@NPC_STUNATTACK','attack',179,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1634,'Seyren Windsor@NPC_FIREATTACK','attack',186,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AS_CLOAKING','attack',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AS_CLOAKING','idle',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AS_CLOAKING','chase',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AS_GRIMTOOTH','idle',137,5,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AS_GRIMTOOTH','chase',137,5,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@ASC_BREAKER','chase',379,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@ASC_METEORASSAULT','attack',406,10,2000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@TF_POISON','attack',52,10,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@NPC_AGIUP','attack',350,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AS_SONICBLOW','attack',136,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AS_GRIMTOOTH','chase',137,5,2000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AS_VENOMDUST','idle',140,1,2000,0,50000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@AS_VENOMDUST','attack',140,1,2000,0,50000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1635,'Eremes Guile@NPC_POISONATTACK','attack',188,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@BS_ADRENALINE','attack',111,10,2000,0,150000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@BS_MAXIMIZE','attack',114,1,1000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@MC_MAMMONITE','attack',42,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@BS_HAMMERFALL','chase',110,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@BS_HAMMERFALL','attack',110,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@NPC_SPLASHATTACK','attack',174,1,1000,0,0,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@NPC_ARMORBRAKE','attack',344,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@NPC_FIREATTACK','attack',186,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1636,'Howard Alt-Eisen@NPC_WATERATTACK','attack',184,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@HP_ASSUMPTIO','idle',361,5,10000,1000,10000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@HP_ASSUMPTIO','chase',361,5,10000,1000,10000,'no','self','myhpltmaxrate','100',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@HP_ASSUMPTIO','idle',361,5,10000,1000,10000,'no','friend','friendhpltmaxrate','100',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@HP_ASSUMPTIO','chase',361,5,10000,1000,10000,'no','friend','friendhpltmaxrate','100',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_PNEUMA','idle',25,1,10000,0,0,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_INCAGI','attack',29,10,2000,0,240000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_INCAGI','chase',29,10,2000,0,240000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_DECAGI','chase',30,48,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@MG_SAFETYWALL','attack',12,10,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_PNEUMA','attack',25,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_PNEUMA','chase',25,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@PR_LEXDIVINA','attack',76,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@PR_LEXDIVINA','chase',76,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@PR_LEXDIVINA','idle',76,10,10000,0,5000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@PR_LEXDIVINA','attack',76,10,5000,0,5000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@PR_LEXDIVINA','chase',76,10,5000,0,5000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@PR_LEXAETERNA','attack',78,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@PR_LEXAETERNA','chase',78,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@NPC_HOLYATTACK','attack',189,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_HEAL','attack',28,9,3000,0,2000,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_HEAL','attack',28,9,3000,0,2000,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_HEAL','idle',28,9,3000,0,2000,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_HEAL','idle',28,9,3000,0,2000,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_HEAL','chase',28,9,3000,0,2000,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1637,'Margaretha Sorin@AL_HEAL','chase',28,9,3000,0,2000,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@AC_DOUBLE','attack',46,10,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@AC_SHOWER','attack',47,10,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@AC_CHARGEARROW','attack',148,1,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@NPC_POWERUP','attack',349,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@NPC_AGIUP','idle',350,5,10000,0,35000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@NPC_AGIUP','attack',350,5,2000,0,25000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@SN_SHARPSHOOTING','attack',382,5,2000,500,1500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@HT_SKIDTRAP','idle',115,5,2000,0,60000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@HT_SKIDTRAP','attack',115,5,500,0,5000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@HT_FLASHER','idle',120,5,2000,0,60000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@HT_FLASHER','attack',120,5,500,0,5000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@HT_FREEZINGTRAP','idle',121,5,2000,0,60000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@HT_FREEZINGTRAP','attack',121,5,500,0,5000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1638,'Cecil Damon@NPC_WINDATTACK','attack',187,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_SIGHT','idle',10,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_SIGHT','idle',10,1,10000,0,5000,'yes','self','skillused','137',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FROSTDIVER','idle',15,40,10000,1000,10000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_JUPITEL','idle',84,28,10000,1000,10000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FIREBALL','idle',17,44,10000,500,10000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FROSTDIVER','chase',15,40,10000,1000,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_JUPITEL','chase',84,28,10000,1000,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FIREBALL','chase',17,44,10000,500,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FROSTDIVER','attack',15,40,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FROSTDIVER','chase',15,40,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@HW_GANBANTEIN','attack',483,1,10000,500,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@HW_NAPALMVULCAN','chase',400,5,2000,1000,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_JUPITEL','attack',84,28,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_JUPITEL','chase',84,28,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_THUNDERSTORM','attack',21,20,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_THUNDERSTORM','chase',21,20,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_COLDBOLT','attack',14,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_COLDBOLT','chase',14,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FIREBALL','attack',17,44,3000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FIREBALL','chase',17,44,3000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_SIGHTRASHER','attack',81,20,3000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_QUAGMIRE','chase',92,5,3000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_SAFETYWALL','attack',12,10,3000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FIREBOLT','chase',19,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FIREBOLT','attack',19,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FIREWALL','chase',18,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_FIREWALL','attack',18,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_LIGHTNINGBOLT','chase',20,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@MG_LIGHTNINGBOLT','attack',20,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_FROSTNOVA','chase',88,10,3000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_FROSTNOVA','attack',88,10,3000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_EARTHSPIKE','chase',90,5,3000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_EARTHSPIKE','attack',90,5,3000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_HEAVENDRIVE','chase',91,5,3000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1639,'Kathryne Keyron@WZ_HEAVENDRIVE','attack',91,5,3000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@NPC_SELFDESTRUCTION','attack',173,1,2000,2000,0,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@RG_INTIMIDATE','attack',219,10,100,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@WZ_STORMGUST','idle',89,1,10000,0,0,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@WZ_STORMGUST','walk',89,1,5000,0,5000,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@KN_SPEARBOOMERANG','idle',59,5,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@LK_SPIRALPIERCE','chase',397,5,2000,0,5000,'yes','target','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@LK_SPIRALPIERCE','attack',397,5,2000,0,5000,'yes','target','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@KN_SPEARBOOMERANG','chase',59,5,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@KN_TWOHANDQUICKEN','attack',60,30,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@KN_BOWLINGBASH','attack',62,10,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@KN_BOWLINGBASH','attack',62,10,2000,0,0,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@SM_BASH','attack',5,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@SM_BASH','attack',5,10,2000,0,0,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@SM_MAGNUM','attack',7,25,1000,0,0,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@NPC_POWERUP','attack',349,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@SM_PROVOKE','attack',6,10,1000,0,300000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@SM_PROVOKE','chase',6,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@SM_ENDURE','chase',8,10,2000,0,30000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1640,'Lord Knight Seyren@NPC_FIREATTACK','attack',186,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@NPC_SELFDESTRUCTION','attack',173,1,2000,2000,0,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@RG_INTIMIDATE','attack',219,10,100,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@WZ_METEOR','idle',83,1,10000,0,0,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@WZ_METEOR','walk',83,1,5000,0,5000,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@AS_GRIMTOOTH','idle',137,5,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@AS_GRIMTOOTH','chase',137,5,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@ASC_BREAKER','chase',379,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@ASC_METEORASSAULT','attack',406,10,2000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@NPC_INVISIBLE','idle',353,1,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@NPC_INVISIBLE','attack',353,1,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@NPC_GUIDEDATTACK','attack',172,10,2000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@TF_POISON','attack',52,10,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@NPC_AGIUP','attack',350,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@NPC_AGIUP','attack',350,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@AS_SONICBLOW','attack',136,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@AS_SONICBLOW','attack',136,10,3000,0,0,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@AS_GRIMTOOTH','chase',137,5,2000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@AS_VENOMDUST','idle',140,1,2000,0,10000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@AS_VENOMDUST','attack',140,1,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1641,'Assassin Cross Eremes@NPC_POISONATTACK','attack',188,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@NPC_SELFDESTRUCTION','attack',173,1,2000,2000,0,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@RG_INTIMIDATE','attack',219,10,100,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@WZ_METEOR','idle',83,1,10000,0,0,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@WZ_METEOR','walk',83,1,5000,0,5000,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@BS_ADRENALINE','attack',111,10,2000,0,150000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@BS_MAXIMIZE','attack',114,1,1000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@MC_MAMMONITE','attack',42,22,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@MC_MAMMONITE','attack',42,22,2000,0,0,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@BS_HAMMERFALL','chase',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@BS_HAMMERFALL','attack',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@NPC_POWERUP','attack',349,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@NPC_SPLASHATTACK','attack',174,1,1000,0,0,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@NPC_ARMORBRAKE','attack',344,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@NPC_HELMBRAKE','attack',345,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@NPC_SHIELDBRAKE','attack',346,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1642,'Whitesmith Howard@NPC_WATERATTACK','attack',184,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@HP_ASSUMPTIO','idle',361,5,10000,1000,10000,'no','self','myhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@HP_ASSUMPTIO','chase',361,5,10000,1000,10000,'no','self','myhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@HP_ASSUMPTIO','idle',361,5,10000,1000,10000,'no','friend','friendhpltmaxrate','100',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@HP_ASSUMPTIO','chase',361,5,10000,1000,10000,'no','friend','friendhpltmaxrate','100',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@NPC_SELFDESTRUCTION','attack',173,1,2000,2000,0,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@RG_INTIMIDATE','attack',219,10,100,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@WZ_METEOR','idle',83,1,10000,0,0,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@WZ_METEOR','walk',83,1,5000,0,5000,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_PNEUMA','idle',25,1,10000,0,0,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_INCAGI','attack',29,10,2000,0,240000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_INCAGI','chase',29,10,2000,0,240000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_DECAGI','chase',30,48,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@MG_SAFETYWALL','attack',12,10,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_PNEUMA','attack',25,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_PNEUMA','chase',25,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@PR_LEXDIVINA','attack',76,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@PR_LEXDIVINA','chase',76,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@PR_LEXDIVINA','idle',76,10,10000,0,5000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@PR_LEXDIVINA','attack',76,10,5000,0,5000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@PR_LEXDIVINA','chase',76,10,5000,0,5000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@PR_LEXAETERNA','attack',78,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@PR_LEXAETERNA','chase',78,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@NPC_HOLYATTACK','attack',189,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_HEAL','attack',28,11,3000,0,1500,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_HEAL','attack',28,11,3000,0,1500,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_HEAL','idle',28,11,3000,0,1500,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_HEAL','idle',28,11,3000,0,1500,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_HEAL','chase',28,11,3000,0,1500,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1643,'High Priest Margaretha@AL_HEAL','chase',28,11,3000,0,1500,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@NPC_SELFDESTRUCTION','attack',173,1,2000,2000,0,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@RG_INTIMIDATE','attack',219,10,100,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@WZ_METEOR','idle',83,1,10000,0,0,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@WZ_METEOR','walk',83,1,5000,0,5000,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@AC_DOUBLE','attack',46,10,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@AC_SHOWER','attack',47,10,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@AC_CHARGEARROW','attack',148,1,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@NPC_POWERUP','attack',349,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@NPC_AGIUP','attack',350,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@NPC_AGIUP','attack',350,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@SN_SHARPSHOOTING','attack',382,5,2000,500,1500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@HT_LANDMINE','idle',116,5,2000,0,60000,'yes','around3','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@HT_LANDMINE','attack',116,5,500,0,5000,'yes','around3','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@HT_ANKLESNARE','idle',117,5,2000,0,60000,'yes','around3','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@HT_ANKLESNARE','attack',117,5,500,0,5000,'yes','around3','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@HT_BLASTMINE','idle',122,5,2000,0,60000,'yes','around3','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@HT_BLASTMINE','attack',122,5,500,0,5000,'yes','around3','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1644,'Sniper Cecil@NPC_WINDATTACK','attack',187,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@NPC_SELFDESTRUCTION','attack',173,1,2000,2000,0,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@RG_INTIMIDATE','attack',219,10,100,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_METEOR','idle',83,1,10000,0,0,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_METEOR','walk',83,1,5000,0,5000,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@NPC_SUMMONSLAVE','attack',196,1,10000,700,30000,'no','self','slavele','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@NPC_SUMMONSLAVE','idle',196,1,10000,700,30000,'no','self','slavele','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_STORMGUST','idle',89,10,10000,1000,10000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_VERMILION','idle',85,21,10000,1000,10000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_METEOR','idle',83,11,10000,1000,10000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@HW_GANBANTEIN','attack',483,5,10000,500,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@HW_NAPALMVULCAN','chase',400,5,2000,1000,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_STORMGUST','chase',89,10,10000,1000,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_VERMILION','chase',85,21,10000,1000,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_METEOR','chase',83,11,10000,1000,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@MG_SIGHT','idle',10,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@MG_SIGHT','idle',10,1,10000,0,5000,'yes','self','skillused','137',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_STORMGUST','chase',89,10,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_VERMILION','chase',85,21,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_STORMGUST','attack',89,10,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_VERMILION','attack',85,21,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_FIREPILLAR','idle',80,10,5000,200,2000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_FIREPILLAR','attack',80,10,2000,200,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_METEOR','chase',83,11,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_METEOR','attack',83,11,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_HEAVENDRIVE','attack',91,5,2000,0,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_WATERBALL','chase',86,5,5000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1645,'High Wizard Kathryne@WZ_WATERBALL','attack',86,5,5000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_CALLSLAVE','attack',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_CALLSLAVE','idle',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1641,1642,1643,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1641,1642,1643,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_SUMMONMONSTER','attack',209,5,10000,700,60000000,'yes','self','myhpltmaxrate','30',1641,1642,1643,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@KN_SPEARBOOMERANG','idle',59,5,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@KN_SPEARBOOMERANG','chase',59,5,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@LK_SPIRALPIERCE','chase',397,5,2000,0,5000,'yes','target','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@LK_SPIRALPIERCE','attack',397,5,2000,0,5000,'yes','target','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@KN_TWOHANDQUICKEN','attack',60,30,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@KN_BOWLINGBASH','attack',62,10,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@KN_BOWLINGBASH','attack',62,10,2000,0,0,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@SM_BASH','attack',5,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@SM_BASH','attack',5,10,2000,0,0,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@SM_MAGNUM','attack',7,25,1000,0,0,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_POWERUP','attack',349,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@SM_PROVOKE','attack',6,10,1000,0,300000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@SM_PROVOKE','chase',6,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@SM_ENDURE','chase',8,10,2000,0,30000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_FIREATTACK','attack',186,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_CHANGEFIRE','attack',164,1,10000,500,60000000,'no','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_CHANGEHOLY','attack',167,1,10000,500,60000000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1646,'Lord Knight Seyren@NPC_CHANGETELEKINESIS','attack',169,1,10000,500,60000000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_CALLSLAVE','attack',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_CALLSLAVE','idle',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1640,1642,1643,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1640,1642,1643,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_SUMMONMONSTER','attack',209,5,10000,700,60000000,'yes','self','myhpltmaxrate','30',1640,1642,1643,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@AS_GRIMTOOTH','idle',137,5,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@AS_GRIMTOOTH','chase',137,5,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_INVISIBLE','idle',353,1,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_INVISIBLE','attack',353,1,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_GUIDEDATTACK','attack',172,10,2000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@TF_POISON','attack',52,10,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_AGIUP','attack',350,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_AGIUP','attack',350,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@AS_SONICBLOW','attack',136,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@AS_SONICBLOW','attack',136,10,3000,0,0,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@AS_GRIMTOOTH','chase',137,5,2000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@AS_VENOMDUST','idle',140,1,2000,0,10000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@AS_VENOMDUST','attack',140,1,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@ASC_BREAKER','chase',379,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@ASC_METEORASSAULT','attack',406,10,2000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_POISONATTACK','attack',188,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_CHANGEWIND','attack',165,1,10000,500,6000000,'no','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_CHANGEHOLY','attack',167,1,10000,500,6000000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1647,'Assassin Cross Eremes@NPC_CHANGETELEKINESIS','attack',169,1,10000,500,6000000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_CALLSLAVE','attack',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_CALLSLAVE','idle',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1640,1641,1643,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1640,1641,1643,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_SUMMONMONSTER','attack',209,5,10000,700,60000000,'yes','self','myhpltmaxrate','30',1640,1641,1643,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@BS_ADRENALINE','attack',111,10,2000,0,150000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@BS_MAXIMIZE','attack',114,1,1000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@MC_MAMMONITE','attack',42,22,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@MC_MAMMONITE','attack',42,22,2000,0,0,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'23',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@BS_HAMMERFALL','chase',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@BS_HAMMERFALL','attack',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_POWERUP','attack',349,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_SPLASHATTACK','attack',174,1,1000,0,0,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_ARMORBRAKE','attack',344,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_HELMBRAKE','attack',345,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_SHIELDBRAKE','attack',346,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@ST_FULLSTRIP','attack',476,5,1500,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_WATERATTACK','attack',184,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_CHANGEGROUND','attack',163,1,10000,500,6000000,'no','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_CHANGEHOLY','attack',167,1,10000,500,6000000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1648,'Whitesmith Howard@NPC_CHANGETELEKINESIS','attack',169,1,10000,500,6000000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@HP_ASSUMPTIO','idle',361,5,10000,1000,10000,'no','self','myhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@HP_ASSUMPTIO','chase',361,5,10000,1000,10000,'no','self','myhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@HP_ASSUMPTIO','idle',361,5,10000,1000,10000,'no','friend','friendhpltmaxrate','100',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@HP_ASSUMPTIO','chase',361,5,10000,1000,10000,'no','friend','friendhpltmaxrate','100',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_HEAL','attack',28,11,10000,0,1000,'yes','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_HEAL','attack',28,11,10000,0,1000,'yes','friend','friendhpltmaxrate','5',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_CALLSLAVE','attack',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_CALLSLAVE','idle',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1640,1641,1642,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1640,1641,1642,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_SUMMONMONSTER','attack',209,5,10000,700,60000000,'yes','self','myhpltmaxrate','30',1640,1641,1642,1644,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_PNEUMA','idle',25,1,10000,0,0,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_INCAGI','attack',29,10,2000,0,240000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_INCAGI','chase',29,10,2000,0,240000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_DECAGI','chase',30,48,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@MG_SAFETYWALL','attack',12,10,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_PNEUMA','attack',25,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_PNEUMA','chase',25,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@PR_LEXDIVINA','attack',76,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@PR_LEXDIVINA','chase',76,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@PR_LEXDIVINA','idle',76,10,10000,0,5000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@PR_LEXDIVINA','attack',76,10,5000,0,5000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@PR_LEXDIVINA','chase',76,10,5000,0,5000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@PR_LEXAETERNA','attack',78,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@PR_LEXAETERNA','chase',78,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_HOLYATTACK','attack',189,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_CHANGEWATER','attack',162,1,10000,500,6000000,'no','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_CHANGEHOLY','attack',167,1,10000,500,6000000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@NPC_CHANGETELEKINESIS','attack',169,1,10000,500,6000000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_HEAL','attack',28,11,3000,0,1500,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_HEAL','attack',28,11,3000,0,1500,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_HEAL','idle',28,11,3000,0,1500,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_HEAL','idle',28,11,3000,0,1500,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_HEAL','chase',28,11,3000,0,1500,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1649,'High Priest Margaretha@AL_HEAL','chase',28,11,3000,0,1500,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_CALLSLAVE','attack',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_CALLSLAVE','idle',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1640,1641,1642,1643,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1640,1641,1642,1643,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_SUMMONMONSTER','attack',209,5,10000,700,60000000,'yes','self','myhpltmaxrate','30',1640,1641,1642,1643,1645,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@AC_DOUBLE','attack',46,10,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@AC_SHOWER','attack',47,10,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@AC_CHARGEARROW','attack',148,1,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_POWERUP','attack',349,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_AGIUP','attack',350,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_AGIUP','attack',350,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@HT_CLAYMORETRAP','idle',123,5,2000,0,10000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@HT_CLAYMORETRAP','attack',123,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@HT_SANDMAN','idle',119,5,2000,0,10000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@HT_SANDMAN','attack',119,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@HT_SHOCKWAVE','idle',118,5,2000,0,10000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@SN_SHARPSHOOTING','attack',382,5,2000,500,1500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@HT_SHOCKWAVE','attack',118,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_WINDATTACK','attack',187,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_CHANGEWATER','attack',162,1,10000,500,6000000,'no','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_CHANGEHOLY','attack',167,1,10000,500,6000000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1650,'Sniper Cecil@NPC_CHANGETELEKINESIS','attack',169,1,10000,500,6000000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@NPC_CALLSLAVE','attack',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@NPC_CALLSLAVE','idle',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@NPC_SUMMONSLAVE','attack',196,5,10000,700,30000,'no','self','slavele','3',1640,1641,1642,1643,1644,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@NPC_SUMMONSLAVE','idle',196,5,10000,700,30000,'no','self','slavele','3',1640,1641,1642,1643,1644,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@NPC_SUMMONMONSTER','attack',209,5,10000,700,60000000,'yes','self','myhpltmaxrate','30',1640,1641,1642,1643,1644,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_STORMGUST','idle',89,10,10000,1000,10000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_VERMILION','idle',85,21,10000,1000,10000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_METEOR','idle',83,11,10000,1000,10000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@HW_GANBANTEIN','attack',483,1,10000,500,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@HW_NAPALMVULCAN','chase',400,5,2000,1000,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_STORMGUST','chase',89,10,10000,1000,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_VERMILION','chase',85,21,10000,1000,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_METEOR','chase',83,11,10000,1000,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@MG_SIGHT','idle',10,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@MG_SIGHT','idle',10,1,10000,0,5000,'yes','self','skillused','137',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_STORMGUST','chase',89,10,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_VERMILION','chase',85,21,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_STORMGUST','attack',89,10,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_VERMILION','attack',85,21,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_FIREPILLAR','idle',80,10,5000,200,2000,'yes','around3','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_FIREPILLAR','attack',80,10,2000,200,0,'yes','around3','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_METEOR','chase',83,11,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_METEOR','attack',83,11,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_HEAVENDRIVE','attack',91,5,2000,0,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_WATERBALL','chase',86,5,5000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@WZ_WATERBALL','attack',86,5,5000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@NPC_ATTRICHANGE','attack',161,1,10000,500,6000000,'no','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@NPC_CHANGEHOLY','attack',167,1,10000,500,6000000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1651,'High Wizard Kathryne@NPC_CHANGETELEKINESIS','attack',169,1,10000,500,6000000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1652,'Egnigem Cenia@SM_BASH','attack',5,9,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1652,'Egnigem Cenia@SM_BASH','attack',5,9,10000,800,1000,'no','target','skillused','5',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1652,'Egnigem Cenia@SM_MAGNUM','attack',7,9,5000,500,5000,'no','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1652,'Egnigem Cenia@SM_PROVOKE','chase',6,9,500,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1652,'Egnigem Cenia@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1652,'Egnigem Cenia@NPC_FIREATTACK','attack',186,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1652,'Egnigem Cenia@NPC_EMOTION','idle',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1652,'Egnigem Cenia@NPC_EMOTION','attack',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1652,'Egnigem Cenia@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1652,'Egnigem Cenia@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1653,'Wickebine Tres@TF_POISON','attack',52,9,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1653,'Wickebine Tres@TF_POISON','attack',52,9,10000,1000,1000,'no','target','skillused','52',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1653,'Wickebine Tres@TF_THROWSTONE','chase',152,1,4000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1653,'Wickebine Tres@NPC_POISONATTACK','attack',188,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1653,'Wickebine Tres@NPC_POISON','attack',176,5,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1653,'Wickebine Tres@NPC_EMOTION','idle',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1653,'Wickebine Tres@NPC_EMOTION','attack',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1653,'Wickebine Tres@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1653,'Wickebine Tres@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1654,'Armeyer Dinze@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',8,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1654,'Armeyer Dinze@MC_MAMMONITE','attack',42,9,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1654,'Armeyer Dinze@MC_MAMMONITE','attack',42,9,10000,800,1000,'no','target','skillused','42',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1654,'Armeyer Dinze@NPC_STUNATTACK','attack',179,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1654,'Armeyer Dinze@NPC_GROUNDATTACK','attack',185,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1654,'Armeyer Dinze@NPC_EMOTION','idle',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1654,'Armeyer Dinze@NPC_EMOTION','attack',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1654,'Armeyer Dinze@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1654,'Armeyer Dinze@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@AL_PNEUMA','idle',25,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'22',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@AL_HEAL','attack',28,5,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@AL_HEAL','attack',28,5,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@AL_HEAL','idle',28,5,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@AL_HEAL','idle',28,5,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@AL_HEAL','chase',28,5,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@AL_HEAL','chase',28,5,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@NPC_HOLYATTACK','attack',189,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@NPC_SILENCEATTACK','attack',178,4,1000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@AL_DECAGI','attack',30,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@AL_DECAGI','chase',30,1,2000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1655,'Errende Ebecee@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1656,'Kavach Icarus@AC_DOUBLE','attack',46,1,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1656,'Kavach Icarus@AC_DOUBLE','attack',46,1,10000,1000,1000,'no','target','skillused','46',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1656,'Kavach Icarus@AC_DOUBLE','chase',46,1,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1656,'Kavach Icarus@AC_SHOWER','attack',47,5,2000,1000,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1656,'Kavach Icarus@NPC_WINDATTACK','attack',187,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1656,'Kavach Icarus@NPC_PIERCINGATT','attack',158,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1656,'Kavach Icarus@NPC_EMOTION','idle',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1656,'Kavach Icarus@NPC_EMOTION','attack',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1656,'Kavach Icarus@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1656,'Kavach Icarus@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_SOULSTRIKE','idle',13,9,5000,0,1000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_LIGHTNINGBOLT','idle',20,9,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_FIREWALL','chase',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_THUNDERSTORM','attack',21,5,2000,1500,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_FROSTDIVER','chase',15,9,10000,500,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_LIGHTNINGBOLT','chase',20,7,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_LIGHTNINGBOLT','attack',20,7,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_SOULSTRIKE','attack',13,9,5000,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_SOULSTRIKE','attack',13,5,3000,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_SOULSTRIKE','attack',13,3,2000,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@MG_SAFETYWALL','attack',12,10,2000,1000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1657,'Laurell Weinder@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@SM_BASH','attack',5,10,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@SM_BASH','attack',5,10,10000,800,1000,'no','target','skillused','5',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@SM_MAGNUM','attack',7,25,5000,500,5000,'no','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@SM_PROVOKE','attack',6,10,500,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@SM_PROVOKE','chase',6,10,500,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@KN_TWOHANDQUICKEN','attack',60,30,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@LK_SPIRALPIERCE','attack',397,2,2500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_SHIELDBRAKE','attack',346,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_CHANGEWATER','attack',162,1,10000,500,10000,'no','self','skillused','89',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_CHANGEWIND','attack',165,1,10000,500,10000,'no','self','skillused','84',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1659,1660,1661,1662,1663,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1659,1660,1661,1662,1663,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_CRITICALSLASH','attack',170,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_EMOTION','idle',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_EMOTION','attack',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1658,'Egnigem Cenia@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1659,'Wickebine Tres@TF_POISON','attack',52,9,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1659,'Wickebine Tres@TF_POISON','attack',52,9,10000,1000,1000,'no','target','skillused','52',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1659,'Wickebine Tres@TF_THROWSTONE','chase',152,1,4000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1659,'Wickebine Tres@NPC_POISONATTACK','attack',188,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1659,'Wickebine Tres@NPC_POISON','attack',176,5,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1659,'Wickebine Tres@NPC_EMOTION','idle',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1659,'Wickebine Tres@NPC_EMOTION','attack',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1659,'Wickebine Tres@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1660,'Armeyer Dinze@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',8,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1660,'Armeyer Dinze@MC_MAMMONITE','attack',42,9,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1660,'Armeyer Dinze@MC_MAMMONITE','attack',42,9,10000,800,1000,'no','target','skillused','42',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1660,'Armeyer Dinze@NPC_STUNATTACK','attack',179,4,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1660,'Armeyer Dinze@NPC_GROUNDATTACK','attack',185,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1660,'Armeyer Dinze@NPC_EMOTION','idle',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1660,'Armeyer Dinze@NPC_EMOTION','attack',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1660,'Armeyer Dinze@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1661,'Errende Ebecee@AL_HEAL','attack',28,11,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1661,'Errende Ebecee@AL_HEAL','attack',28,11,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1661,'Errende Ebecee@AL_HEAL','idle',28,11,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1661,'Errende Ebecee@AL_HEAL','idle',28,11,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1661,'Errende Ebecee@AL_HEAL','chase',28,11,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1661,'Errende Ebecee@AL_HEAL','chase',28,11,10000,500,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1661,'Errende Ebecee@NPC_HOLYATTACK','attack',189,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1661,'Errende Ebecee@NPC_SILENCEATTACK','attack',178,4,1000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1661,'Errende Ebecee@AL_DECAGI','attack',30,48,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1661,'Errende Ebecee@AL_DECAGI','chase',30,48,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1662,'Kavach Icarus@AC_DOUBLE','attack',46,10,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1662,'Kavach Icarus@AC_DOUBLE','attack',46,10,10000,1000,1000,'no','target','skillused','46',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1662,'Kavach Icarus@AC_DOUBLE','chase',46,10,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1662,'Kavach Icarus@AC_SHOWER','attack',47,10,2000,1000,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1662,'Kavach Icarus@NPC_WINDATTACK','attack',187,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1662,'Kavach Icarus@NPC_PIERCINGATT','attack',158,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1662,'Kavach Icarus@NPC_EMOTION','idle',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1662,'Kavach Icarus@NPC_EMOTION','attack',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1662,'Kavach Icarus@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1663,'Laurell Weinder@MG_FIREWALL','chase',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1663,'Laurell Weinder@MG_THUNDERSTORM','attack',21,5,2000,1500,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1663,'Laurell Weinder@MG_FROSTDIVER','chase',15,9,10000,500,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1663,'Laurell Weinder@MG_LIGHTNINGBOLT','chase',20,7,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1663,'Laurell Weinder@MG_LIGHTNINGBOLT','attack',20,7,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1663,'Laurell Weinder@MG_SOULSTRIKE','attack',13,9,5000,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1663,'Laurell Weinder@MG_SAFETYWALL','attack',12,10,2000,1000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1663,'Laurell Weinder@NPC_EMOTION','idle',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1663,'Laurell Weinder@NPC_EMOTION','attack',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1663,'Laurell Weinder@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','skillused','28',15,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1664,'Photon Cannon@NPC_WINDATTACK','attack',187,5,1000,1000,10000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1664,'Photon Cannon@NPC_WINDATTACK','attack',187,3,2000,500,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1664,'Photon Cannon@NPC_WINDATTACK','attack',187,1,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1665,'Photon Cannon@NPC_FIREATTACK','attack',186,5,1000,1000,10000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1665,'Photon Cannon@NPC_FIREATTACK','attack',186,3,2000,500,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1665,'Photon Cannon@NPC_FIREATTACK','attack',186,1,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1666,'Photon Cannon@NPC_WATERATTACK','attack',184,5,1000,1000,10000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1666,'Photon Cannon@NPC_WATERATTACK','attack',184,3,2000,500,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1666,'Photon Cannon@NPC_WATERATTACK','attack',184,1,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1667,'Photon Cannon@NPC_GROUNDATTACK','attack',185,5,1000,1000,10000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1667,'Photon Cannon@NPC_GROUNDATTACK','attack',185,3,2000,500,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1667,'Photon Cannon@NPC_GROUNDATTACK','attack',185,1,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1668,'Archdam@NPC_PIERCINGATT','attack',158,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1668,'Archdam@NPC_GUIDEDATTACK','attack',172,2,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1668,'Archdam@KN_SPEARSTAB','attack',58,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1668,'Archdam@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1668,'Archdam@NPC_RANDOMATTACK','attack',183,5,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1669,'Dimik@NPC_PIERCINGATT','attack',158,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1669,'Dimik@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1669,'Dimik@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1669,'Dimik@NPC_COMBOATTACK','attack',171,4,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1669,'Dimik@NPC_COMBOATTACK','chase',171,4,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1670,'Dimik@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1670,'Dimik@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1670,'Dimik@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1670,'Dimik@NPC_COMBOATTACK','attack',171,4,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1670,'Dimik@NPC_COMBOATTACK','chase',171,4,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1670,'Dimik@NPC_WINDATTACK','attack',187,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1671,'Dimik@NPC_DARKBREATH','attack',202,4,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1671,'Dimik@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1671,'Dimik@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1671,'Dimik@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1671,'Dimik@NPC_COMBOATTACK','attack',171,6,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1671,'Dimik@NPC_COMBOATTACK','chase',171,6,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1671,'Dimik@NPC_WATERATTACK','attack',184,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1672,'Dimik@NPC_RANDOMATTACK','attack',183,2,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1672,'Dimik@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1672,'Dimik@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1672,'Dimik@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1672,'Dimik@NPC_COMBOATTACK','attack',171,4,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1672,'Dimik@NPC_COMBOATTACK','chase',171,4,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1672,'Dimik@NPC_GROUNDATTACK','attack',185,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1673,'Dimik@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1673,'Dimik@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1673,'Dimik@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1673,'Dimik@NPC_COMBOATTACK','attack',171,4,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1673,'Dimik@NPC_COMBOATTACK','chase',171,4,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1673,'Dimik@NPC_FIREATTACK','attack',186,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1674,'Monemus@NPC_FIREATTACK','attack',186,10,500,1000,30000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1674,'Monemus@NPC_FIREATTACK','attack',186,3,1000,0,10000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1674,'Monemus@NPC_FIREATTACK','attack',186,1,10000,0,0,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1675,'Venatu@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1675,'Venatu@NPC_GUIDEDATTACK','attack',172,3,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1675,'Venatu@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1675,'Venatu@NPC_FIREATTACK','attack',186,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1675,'Venatu@NPC_EMOTION','chase',197,1,100,0,5000,'yes','self','always','0',7,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1675,'Venatu@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',0,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1676,'Venatu@NPC_SLEEPATTACK','attack',182,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1676,'Venatu@NPC_GUIDEDATTACK','attack',172,3,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1676,'Venatu@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1676,'Venatu@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1676,'Venatu@NPC_EMOTION','chase',197,1,100,0,5000,'yes','self','always','0',7,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1676,'Venatu@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',0,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1677,'Venatu@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1677,'Venatu@NPC_GUIDEDATTACK','attack',172,3,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1677,'Venatu@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1677,'Venatu@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1677,'Venatu@NPC_WINDATTACK','attack',187,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1677,'Venatu@NPC_EMOTION','chase',197,1,100,0,5000,'yes','self','always','0',7,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1677,'Venatu@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',0,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1678,'Venatu@NPC_RANDOMATTACK','attack',183,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1678,'Venatu@NPC_GUIDEDATTACK','attack',172,3,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1678,'Venatu@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1678,'Venatu@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1678,'Venatu@NPC_GROUNDATTACK','attack',185,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1678,'Venatu@NPC_EMOTION','chase',197,1,100,0,5000,'yes','self','always','0',7,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1678,'Venatu@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',0,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1679,'Venatu@NPC_GUIDEDATTACK','attack',172,3,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1679,'Venatu@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1679,'Venatu@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1679,'Venatu@NPC_WATERATTACK','attack',184,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1679,'Venatu@NPC_EMOTION','chase',197,1,100,0,5000,'yes','self','always','0',7,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1679,'Venatu@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',0,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1680,'Hill Wind@NPC_WINDATTACK','chase',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1680,'Hill Wind@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1680,'Hill Wind@MG_THUNDERSTORM','attack',21,5,2000,1500,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1680,'Hill Wind@WZ_JUPITEL','attack',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1680,'Hill Wind@WZ_JUPITEL','chase',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1681,'Gemini-S58@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',30,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1681,'Gemini-S58@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',31,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1681,'Gemini-S58@KN_PIERCE','attack',56,5,1000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1681,'Gemini-S58@NPC_PIERCINGATT','attack',158,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1681,'Gemini-S58@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1681,'Gemini-S58@AS_GRIMTOOTH','chase',137,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1681,'Gemini-S58@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1681,'Gemini-S58@NPC_COMBOATTACK','chase',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1682,'Remover@SM_BASH','attack',5,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1682,'Remover@NPC_UNDEADATTACK','attack',347,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1684,'Archdam@NPC_PIERCINGATT','attack',158,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1684,'Archdam@NPC_GUIDEDATTACK','attack',172,2,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1684,'Archdam@KN_SPEARSTAB','attack',58,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1684,'Archdam@NPC_RANDOMATTACK','attack',183,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1685,'Vesper@NPC_SUMMONSLAVE','attack',196,3,10000,2000,5000,'no','self','slavele','15',1365,1669,1675,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1685,'Vesper@NPC_SUMMONSLAVE','idle',196,2,10000,0,0,'no','self','onspawn','0',1365,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1685,'Vesper@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1685,'Vesper@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1685,'Vesper@NPC_CALLSLAVE','attack',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1685,'Vesper@NPC_CALLSLAVE','idle',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1685,'Vesper@NPC_POWERUP','attack',349,5,5000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1685,'Vesper@NPC_CRITICALSLASH','attack',170,1,5000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1685,'Vesper@WZ_METEOR','attack',83,11,500,10000,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1685,'Vesper@NPC_EMOTION','idle',197,1,1000,0,0,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1686,'Orc Baby@SM_BASH','attack',5,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1686,'Orc Baby@NPC_EMOTION','idle',197,1,10000,0,5000,'no','self','slavele','0',28,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1686,'Orc Baby@NPC_EMOTION','attack',197,1,10000,0,5000,'no','self','slavele','0',28,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1686,'Orc Baby@NPC_SUMMONSLAVE','idle',196,2,10000,0,6000000,'yes','self','slavele','0',1023,1273,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1686,'Orc Baby@NPC_SUMMONSLAVE','attack',196,2,10000,0,6000000,'yes','self','slavele','0',1023,1273,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1686,'Orc Baby@NPC_SUMMONSLAVE','chase',196,2,10000,0,6000000,'yes','self','slavele','0',1023,1273,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@AL_HEAL','attack',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@AM_POTIONPITCHER','idle',231,4,2000,0,0,'yes','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@AM_POTIONPITCHER','attack',231,4,2000,0,0,'yes','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@AL_TELEPORT','idle',26,1,1000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@AL_TELEPORT','attack',26,1,1000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_EXPULSION','attack',674,1,1000,1000,10000,'no','target','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@AC_CHARGEARROW','attack',148,1,2000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_COMBOATTACK','attack',171,1,1000,0,5000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_STUNATTACK','attack',179,5,500,0,5000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_DEFENDER','attack',205,1,500,0,30000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_SUMMONSLAVE','attack',196,5,10000,2000,5000,'no','self','slavele','2',1691,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_SUMMONSLAVE','idle',196,5,10000,2000,5000,'no','self','slavele','2',1691,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_CALLSLAVE','attack',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1688,'Lady Tany@NPC_CALLSLAVE','idle',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1689,'Bacsojin@NPC_INVISIBLE','chase',353,1,2000,1000,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1689,'Bacsojin@PR_SANCTUARY','attack',70,10,2000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1689,'Bacsojin@WZ_WATERBALL','chase',86,3,2000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1689,'Bacsojin@WZ_WATERBALL','attack',86,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1689,'Bacsojin@NPC_STOP','attack',342,1,2000,500,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1689,'Bacsojin@AL_TELEPORT','idle',26,1,1000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1689,'Bacsojin@NPC_SUMMONSLAVE','idle',196,4,10000,0,5000,'yes','self','slavele','2',1690,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1689,'Bacsojin@NPC_SUMMONSLAVE','attack',196,4,10000,0,5000,'yes','self','slavele','2',1690,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1689,'Bacsojin@NPC_SUMMONSLAVE','chase',196,4,10000,0,5000,'yes','self','slavele','2',1690,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1690,'Spring Rabbit@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1690,'Spring Rabbit@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1690,'Spring Rabbit@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x83,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1690,'Spring Rabbit@SM_BASH','attack',5,10,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1690,'Spring Rabbit@TF_THROWSTONE','chase',152,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1691,'Kraben@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1691,'Kraben@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1691,'Kraben@NPC_STUNATTACK','attack',179,1,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);

REPLACE INTO `mob_skill_db_re` VALUES (1692,'Breeze@NPC_DEFENDER','attack',205,1,1000,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1692,'Breeze@NPC_DEFENDER','chase',205,1,500,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1692,'Breeze@NPC_CRITICALSLASH','attack',170,1,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1692,'Breeze@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1692,'Breeze@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1693,'Plasma@NPC_STUNATTACK','chase',179,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'39',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1693,'Plasma@NPC_STUNATTACK','attack',179,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'39',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1693,'Plasma@MG_SOULSTRIKE','chase',13,9,3000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1693,'Plasma@MG_SOULSTRIKE','attack',13,9,3000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1693,'Plasma@MG_NAPALMBEAT','attack',11,7,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1693,'Plasma@MG_NAPALMBEAT','attack',11,7,4000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1693,'Plasma@NPC_TELEKINESISATTACK','attack',191,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1694,'Plasma@NPC_SLEEPATTACK','chase',182,5,1000,300,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1694,'Plasma@NPC_SLEEPATTACK','attack',182,5,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1694,'Plasma@MG_FIREBOLT','chase',19,7,3000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1694,'Plasma@MG_FIREBOLT','attack',19,7,3000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1694,'Plasma@MG_FIREBALL','chase',17,5,3000,500,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1694,'Plasma@MG_FIREBALL','attack',17,7,2000,500,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1694,'Plasma@NPC_FIREATTACK','attack',186,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1695,'Plasma@MG_STONECURSE','chase',16,8,2000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1695,'Plasma@MG_STONECURSE','attack',16,8,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1695,'Plasma@WZ_EARTHSPIKE','chase',90,5,3000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1695,'Plasma@WZ_EARTHSPIKE','attack',90,5,3000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1695,'Plasma@WZ_QUAGMIRE','attack',92,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1695,'Plasma@WZ_QUAGMIRE','chase',92,5,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1695,'Plasma@NPC_GROUNDATTACK','attack',185,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1696,'Plasma@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1696,'Plasma@NPC_CURSEATTACK','chase',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1696,'Plasma@NPC_DARKSTRIKE','chase',340,9,3000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1696,'Plasma@NPC_DARKSTRIKE','attack',340,9,3000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1696,'Plasma@NPC_DARKNESSATTACK','attack',190,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1696,'Plasma@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1697,'Plasma@MG_FROSTDIVER','chase',15,9,2000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1697,'Plasma@MG_FROSTDIVER','attack',15,9,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1697,'Plasma@MG_COLDBOLT','chase',14,6,3000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1697,'Plasma@MG_COLDBOLT','attack',14,6,3000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1697,'Plasma@WZ_WATERBALL','attack',86,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1697,'Plasma@NPC_WATERATTACK','attack',184,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);

# Thanatos Tower Mobs
REPLACE INTO `mob_skill_db_re` VALUES (1698,'Deathword@NPC_SPLASHATTACK','attack',174,1,1000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1698,'Deathword@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1698,'Deathword@NPC_PIERCINGATT','attack',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1698,'Deathword@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1699,'Ancient Mimic@CR_AUTOGUARD','chase',249,3,1000,0,250000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1699,'Ancient Mimic@CR_AUTOGUARD','attack',249,3,500,0,250000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1699,'Ancient Mimic@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@NPC_HOLYATTACK','attack',189,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@NPC_HOLYATTACK','chase',189,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@RG_INTIMIDATE','attack',219,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@MG_SAFETYWALL','attack',12,5,1000,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@WZ_JUPITEL','attack',84,4,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@WZ_JUPITEL','chase',84,4,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@AL_HEAL','chase',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@AL_HEAL','attack',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@AL_HEAL','chase',28,9,10000,500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1700,'Observation@AL_HEAL','attack',28,9,10000,500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1701,'Shelter@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1701,'Shelter@NPC_DARKNESSATTACK','chase',190,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1701,'Shelter@NPC_DARKNESSATTACK','attack',190,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1701,'Shelter@NPC_DARKTHUNDER','chase',341,4,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1701,'Shelter@NPC_DARKTHUNDER','attack',341,4,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1701,'Shelter@AS_VENOMDUST','idle',140,1,2000,0,10000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1701,'Shelter@AS_VENOMDUST','attack',140,1,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1701,'Shelter@NPC_BLINDATTACK','angry',177,7,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1701,'Shelter@NPC_BLINDATTACK','follow',177,7,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1702,'Retribution@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1702,'Retribution@NPC_DARKNESSATTACK','attack',190,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1702,'Retribution@NPC_GRANDDARKNESS','attack',339,1,500,700,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1702,'Retribution@NPC_DARKCROSS','attack',338,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1702,'Retribution@KN_BOWLINGBASH','attack',62,7,500,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1702,'Retribution@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1702,'Retribution@NPC_DARKBREATH','attack',202,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1703,'Solace@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1703,'Solace@NPC_HOLYATTACK','attack',189,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1703,'Solace@NPC_HOLYATTACK','chase',189,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1703,'Solace@CR_GRANDCROSS','attack',254,1,1000,1500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1703,'Solace@PR_LEXAETERNA','attack',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1703,'Solace@PR_LEXAETERNA','chase',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1703,'Solace@PR_LEXDIVINA','chase',76,10,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1703,'Solace@PR_LEXDIVINA','attack',76,10,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1703,'Solace@MG_NAPALMBEAT','attack',11,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1703,'Solace@MG_NAPALMBEAT','chase',11,5,1000,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1704,'Thanatos Odium@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1704,'Thanatos Odium@NPC_DARKNESSATTACK','attack',190,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1704,'Thanatos Odium@NPC_PIERCINGATT','attack',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1704,'Thanatos Odium@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1704,'Thanatos Odium@NPC_CHANGEDARKNESS','attack',168,1,1000,0,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1704,'Thanatos Odium@NPC_POWERUP','attack',349,5,2000,0,50000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1704,'Thanatos Odium@NPC_POWERUP','attack',349,5,2000,0,10000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1704,'Thanatos Odium@NPC_TELEKINESISATTACK','attack',191,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@NPC_FIREATTACK','attack',186,4,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@NPC_STUNATTACK','attack',179,4,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@NPC_TELEKINESISATTACK','attack',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@WZ_SIGHTRASHER','attack',81,20,1000,0,10000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@KN_BOWLINGBASH','attack',62,4,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@NPC_AGIUP','attack',350,5,1000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@NPC_AGIUP','attack',350,5,2000,0,10000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@SM_PROVOKE','attack',6,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1705,'Thanatos Despero@SM_PROVOKE','chase',6,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1706,'Thanatos Maero@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1706,'Thanatos Maero@NPC_DARKSTRIKE','attack',340,9,1000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1706,'Thanatos Maero@NPC_DARKSTRIKE','chase',340,9,1000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1706,'Thanatos Maero@AS_SONICBLOW','attack',136,10,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1706,'Thanatos Maero@NPC_TELEKINESISATTACK','attack',191,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1706,'Thanatos Maero@NPC_INVISIBLE','attack',353,1,500,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1706,'Thanatos Maero@NPC_INVISIBLE','idle',353,1,500,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@NPC_MAGICALATTACK','attack',192,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@NPC_MENTALBREAKER','attack',159,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@NPC_MENTALBREAKER','chase',159,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@NPC_DARKTHUNDER','attack',341,9,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@NPC_DARKTHUNDER','chase',341,9,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@AL_DECAGI','chase',30,48,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@AL_DECAGI','attack',30,48,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@AL_HEAL','attack',28,8,1000,0,5000,'yes','friend','friendhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@AL_HEAL','attack',28,8,1000,0,5000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@AL_HEAL','idle',28,8,1000,0,5000,'yes','friend','friendhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@AL_HEAL','idle',28,8,1000,0,5000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@AL_HEAL','chase',28,8,1000,0,5000,'yes','friend','friendhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1707,'Thanatos Dolor@AL_HEAL','chase',28,8,1000,0,5000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@NPC_CALLSLAVE','attack',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@NPC_CALLSLAVE','idle',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@NPC_SUMMONSLAVE','attack',196,6,10000,700,30000,'no','self','slavele','0',1711,1710,1709,1712,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@NPC_SUMMONSLAVE','idle',196,6,10000,700,30000,'no','self','slavele','0',1711,1710,1709,1712,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@NPC_EXPULSION','attack',674,1,1000,1000,10000,'no','target','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@KN_TWOHANDQUICKEN','attack',60,30,3000,0,300000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'2',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@KN_BOWLINGBASH','attack',62,10,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@SM_BASH','attack',5,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@BS_HAMMERFALL','chase',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@BS_HAMMERFALL','attack',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@NPC_POWERUP','attack',349,5,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@SM_PROVOKE','chase',6,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@SM_PROVOKE','attack',6,10,1000,0,300000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@NPC_CHANGEHOLY','attack',167,1,5000,500,6000000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@WZ_STORMGUST','chase',89,10,2000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@WZ_VERMILION','chase',85,21,2000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@WZ_STORMGUST','attack',89,10,2000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@WZ_VERMILION','attack',85,21,2000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@WZ_METEOR','chase',83,11,2000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@WZ_METEOR','attack',83,11,2000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@MG_SOULSTRIKE','chase',13,10,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@MG_SOULSTRIKE','attack',13,10,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@AL_TELEPORT','walk',26,1,10000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1708,'Thanatos@AL_TELEPORT','attack',26,1,500,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1709,'Thanatos Odium@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1709,'Thanatos Odium@NPC_DARKNESSATTACK','attack',190,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1709,'Thanatos Odium@NPC_PIERCINGATT','attack',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1709,'Thanatos Odium@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1709,'Thanatos Odium@NPC_CHANGEDARKNESS','attack',168,1,1000,0,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1709,'Thanatos Odium@NPC_POWERUP','attack',349,5,2000,0,50000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1709,'Thanatos Odium@NPC_POWERUP','attack',349,5,2000,0,10000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1709,'Thanatos Odium@NPC_TELEKINESISATTACK','attack',191,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@NPC_FIREATTACK','attack',186,4,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@NPC_STUNATTACK','attack',179,4,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@NPC_TELEKINESISATTACK','attack',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@WZ_SIGHTRASHER','attack',81,20,1000,0,10000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@KN_BOWLINGBASH','attack',62,5,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@NPC_AGIUP','attack',350,5,1000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@NPC_AGIUP','attack',350,5,2000,0,10000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@SM_PROVOKE','attack',6,10,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1710,'Thanatos Despero@SM_PROVOKE','chase',6,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1711,'Thanatos Maero@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1711,'Thanatos Maero@NPC_DARKSTRIKE','attack',340,9,1000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1711,'Thanatos Maero@NPC_DARKSTRIKE','chase',340,9,1000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1711,'Thanatos Maero@AS_SONICBLOW','attack',136,10,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1711,'Thanatos Maero@NPC_TELEKINESISATTACK','attack',191,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1711,'Thanatos Maero@NPC_INVISIBLE','attack',353,1,500,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1711,'Thanatos Maero@NPC_INVISIBLE','idle',353,1,500,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@NPC_MAGICALATTACK','attack',192,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@NPC_MENTALBREAKER','attack',159,2,500,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@NPC_MENTALBREAKER','chase',159,2,500,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@NPC_DARKTHUNDER','attack',341,9,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@NPC_DARKTHUNDER','chase',341,9,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@AL_DECAGI','chase',30,48,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@AL_DECAGI','attack',30,48,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@AL_HEAL','attack',28,11,1000,0,5000,'yes','friend','friendhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@AL_HEAL','attack',28,11,1000,0,5000,'yes','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@AL_HEAL','idle',28,9,1000,0,5000,'yes','friend','friendhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@AL_HEAL','idle',28,9,1000,0,5000,'yes','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@AL_HEAL','chase',28,9,1000,0,5000,'yes','friend','friendhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1712,'Thanatos Dolor@AL_HEAL','chase',28,9,1000,0,5000,'yes','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'3',NULL);

# Abyss Lake
REPLACE INTO `mob_skill_db_re` VALUES (1713,'Acidus@NPC_FIREATTACK','attack',186,6,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1713,'Acidus@NPC_CRITICALSLASH','attack',170,1,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1713,'Acidus@NPC_STUNATTACK','attack',179,5,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1713,'Acidus@MG_FIREBALL','idle',17,9,2000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1713,'Acidus@MG_FIREBALL','chase',17,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'44',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1713,'Acidus@SM_MAGNUM','attack',7,9,2000,500,5000,'no','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1713,'Acidus@WZ_FIREPILLAR','idle',80,3,100,0,30000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1713,'Acidus@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1714,'Ferus@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',32,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1714,'Ferus@KN_BRANDISHSPEAR','attack',57,10,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1714,'Ferus@NPC_FIREATTACK','attack',186,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1714,'Ferus@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1714,'Ferus@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1714,'Ferus@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',36,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1714,'Ferus@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1714,'Ferus@KN_SPEARSTAB','attack',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1714,'Ferus@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1715,'Novus@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1715,'Novus@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1715,'Novus@SM_BASH','attack',5,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1715,'Novus@NPC_PIERCINGATT','attack',158,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1715,'Novus@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'37',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1716,'Acidus@NPC_WINDATTACK','attack',187,6,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1716,'Acidus@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1716,'Acidus@MG_LIGHTNINGBOLT','idle',20,8,2000,1000,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1716,'Acidus@MG_LIGHTNINGBOLT','chase',20,8,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1716,'Acidus@MG_LIGHTNINGBOLT','attack',20,8,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1716,'Acidus@MG_THUNDERSTORM','attack',21,9,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1716,'Acidus@MG_THUNDERSTORM','attack',21,9,2000,1000,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1716,'Acidus@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1717,'Ferus@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',32,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1717,'Ferus@KN_BRANDISHSPEAR','attack',57,10,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1717,'Ferus@SM_PROVOKE','chase',6,10,2000,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'44',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1717,'Ferus@NPC_GROUNDATTACK','attack',185,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1717,'Ferus@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1717,'Ferus@NPC_PIERCINGATT','attack',158,5,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1717,'Ferus@KN_SPEARSTAB','attack',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1717,'Ferus@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1718,'Novus@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1718,'Novus@SM_BASH','attack',5,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1718,'Novus@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1718,'Novus@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_SUMMONSLAVE','attack',196,1,10000,2000,5000,'no','self','slavele','0',1756,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_SUMMONSLAVE','idle',196,1,10000,2000,5000,'no','self','slavele','0',1756,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_SUMMONSLAVE','chase',196,1,10000,2000,5000,'no','self','slavele','0',1756,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_CALLSLAVE','chase',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_DRAGONFEAR','chase',659,5,10000,0,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_DRAGONFEAR','attack',659,5,2000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_FIREBREATH','attack',654,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_DARKBREATH','attack',202,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@NPC_WEAPONBRAKER','attack',343,10,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@CR_REFLECTSHIELD','attack',252,5,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@CR_REFLECTSHIELD','chase',252,5,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@WZ_METEOR','attack',83,11,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@WZ_METEOR','chase',83,11,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@WZ_VERMILION','attack',85,21,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@WZ_VERMILION','chase',85,21,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@MG_FIREBALL','chase',17,44,5000,500,1000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@SM_PROVOKE','attack',6,10,10000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@SM_MAGNUM','attack',7,25,10000,0,5000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@AL_HEAL','attack',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1719,'Detale@AL_HEAL','chase',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@AL_HEAL','attack',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@AL_HEAL','chase',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_RANDOMATTACK','attack',183,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@AS_SONICBLOW','attack',136,10,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_DARKBREATH','attack',202,4,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_POWERUP','attack',349,3,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@WZ_METEOR','attack',83,11,2000,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_SUMMONSLAVE','attack',196,4,10000,2000,5000,'no','self','slavele','2',1757,1758,1759,1760,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_SUMMONSLAVE','idle',196,4,10000,2000,5000,'no','self','slavele','2',1757,1758,1759,1760,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_SUMMONSLAVE','chase',196,4,10000,2000,5000,'no','self','slavele','2',1757,1758,1759,1760,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1720,'Hydro@NPC_CALLSLAVE','chase',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1721,'Dragon Egg@NPC_METAMORPHOSIS','idle',193,1,100,2000,5000,'no','self','myhpltmaxrate','99',1715,1718,NULL,NULL,NULL,NULL,NULL);

# Kiel dungeon
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@SM_MAGNUM','chase',7,5,2500,0,3000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@SM_MAGNUM','attack',7,5,2500,0,3000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@MG_SAFETYWALL','idle',12,10,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@MG_SAFETYWALL','attack',12,10,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@MG_SAFETYWALL','attack',12,10,4000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@SM_BASH','attack',5,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@SM_ENDURE','chase',8,10,5000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@SM_ENDURE','attack',8,10,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@PR_LEXDIVINA','attack',76,5,1000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@PR_LEXDIVINA','attack',76,5,1000,0,30000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@PR_LEXAETERNA','attack',78,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@KN_BRANDISHSPEAR','chase',57,6,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@KN_BRANDISHSPEAR','attack',57,6,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@AL_PNEUMA','attack',25,1,10000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1733,'Kiel@AL_TELEPORT','walk',26,1,10000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@NPC_CALLSLAVE','attack',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@NPC_CALLSLAVE','idle',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@NPC_SUMMONSLAVE','attack',196,6,10000,700,30000,'no','self','slavele','0',1739,1740,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@NPC_SUMMONSLAVE','idle',196,6,10000,700,30000,'no','self','slavele','0',1739,1740,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@HW_GANBANTEIN','attack',483,5,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@SM_MAGNUM','chase',7,25,1000,0,3000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@SM_MAGNUM','attack',7,25,1000,0,3000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@NPC_WIDESILENCE','chase',663,5,10000,500,25000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@NPC_WIDESILENCE','attack',663,5,10000,500,25000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@NPC_DARKBLESSING','attack',203,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@MG_SAFETYWALL','attack',12,10,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@MG_SAFETYWALL','attack',12,10,4000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@SM_BASH','attack',5,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@SM_ENDURE','chase',8,10,5000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@SM_ENDURE','attack',8,10,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@NPC_POWERUP','attack',349,4,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@NPC_POWERUP','attack',349,4,3000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@PR_LEXDIVINA','attack',76,5,1000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@PR_LEXDIVINA','attack',76,5,1000,0,30000,'yes','target','casttargeted',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@PR_LEXAETERNA','attack',78,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@KN_BRANDISHSPEAR','chase',57,10,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@KN_BRANDISHSPEAR','attack',57,10,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@AL_TELEPORT','walk',26,1,10000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@AL_PNEUMA','attack',25,1,10000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1734,'Kiel-D-01@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1735,'Alicel@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1735,'Alicel@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',29,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1735,'Alicel@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1735,'Alicel@NPC_GUIDEDATTACK','attack',172,1,1000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1735,'Alicel@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1736,'Aliot@KN_SPEARSTAB','attack',58,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1736,'Aliot@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1736,'Aliot@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1736,'Aliot@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1736,'Aliot@CR_AUTOGUARD','attack',249,5,1000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1736,'Aliot@NPC_CRITICALSLASH','attack',170,1,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1736,'Aliot@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1736,'Aliot@NPC_REBIRTH','dead',208,3,2000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1737,'Aliza@SM_BASH','attack',5,10,2000,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'52',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1737,'Aliza@NPC_EMOTION','walk',197,1,500,0,30000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1737,'Aliza@NPC_EMOTION','idle',197,1,500,0,30000,'yes','self','always','0',54,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1737,'Aliza@AL_HEAL','idle',28,5,5000,1000,5000,'yes','friend','friendhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1737,'Aliza@AL_HEAL','walk',28,5,5000,1000,5000,'yes','friend','friendhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1737,'Aliza@AL_HEAL','chase',28,5,5000,1000,5000,'yes','friend','friendhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1737,'Aliza@AL_HEAL','attack',28,5,5000,1000,5000,'yes','friend','friendhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1738,'Constant@NPC_SELFDESTRUCTION','attack',173,1,10000,1000,0,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1738,'Constant@NPC_SELFDESTRUCTION','chase',173,1,2000,1000,0,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1739,'Alicel@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1739,'Alicel@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',29,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1739,'Alicel@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1739,'Alicel@NPC_GUIDEDATTACK','attack',172,1,1000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1740,'Aliot@KN_SPEARSTAB','attack',58,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1740,'Aliot@BS_MAXIMIZE','attack',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1740,'Aliot@BS_MAXIMIZE','chase',114,5,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1740,'Aliot@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1740,'Aliot@CR_AUTOGUARD','attack',249,5,1000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1740,'Aliot@NPC_CRITICALSLASH','attack',170,1,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1740,'Aliot@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1740,'Aliot@NPC_REBIRTH','dead',208,3,2000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1741,'Christmas Cookie@MG_COLDBOLT','attack',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1741,'Christmas Cookie@MG_COLDBOLT','chase',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1741,'Christmas Cookie@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1741,'Christmas Cookie@NPC_HOLYATTACK','attack',189,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1741,'Christmas Cookie@PR_LEXAETERNA','attack',78,1,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1741,'Christmas Cookie@PR_LEXAETERNA','chase',78,1,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1742,'Carat@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1742,'Carat@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1742,'Carat@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1742,'Carat@SM_PROVOKE','chase',6,10,2000,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1743,'Myst Case@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1743,'Myst Case@KN_SPEARSTAB','attack',58,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1743,'Myst Case@MC_MAMMONITE','attack',42,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1743,'Myst Case@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',3,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1743,'Myst Case@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1743,'Myst Case@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1744,'Wild Rose@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1744,'Wild Rose@NPC_EMOTION','loot',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1744,'Wild Rose@NPC_WINDATTACK','attack',187,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1745,'Constant@NPC_SELFDESTRUCTION','attack',173,1,10000,0,0,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1745,'Constant@NPC_SELFDESTRUCTION','chase',173,1,2000,0,0,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_SUMMONSLAVE','attack',196,3,10000,2000,5000,'no','self','slavele','1',1891,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_SUMMONSLAVE','idle',196,3,10000,2000,5000,'no','self','slavele','1',1891,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_SUMMONSLAVE','chase',196,3,10000,2000,5000,'no','self','slavele','1',1891,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_SUMMONSLAVE','idle',196,3,10000,0,0,'no','self','onspawn','0',1765,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_CALLSLAVE','chase',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_POWERUP','chase',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_AGIUP','chase',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_PULSESTRIKE','attack',661,5,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@HP_ASSUMPTIO','chase',361,5,10000,0,100000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@HP_ASSUMPTIO','attack',361,5,10000,0,100000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@HW_GANBANTEIN','attack',483,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@KN_TWOHANDQUICKEN','attack',60,30,10000,0,90000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@AS_SONICBLOW','attack',136,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@SA_DISPELL','attack',289,5,10000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@SA_DISPELL','chase',289,5,10000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_HOLYATTACK','attack',189,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@CR_HOLYCROSS','attack',253,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@KN_BRANDISHSPEAR','attack',57,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@MG_THUNDERSTORM','attack',21,20,10000,1500,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_EARTHQUAKE','chase',653,5,10000,1000,25000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@NPC_EARTHQUAKE','attack',653,5,10000,1000,25000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@WZ_VERMILION','attack',85,21,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1751,'Valkyrie Randgris@WZ_VERMILION','chase',85,21,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1752,'Skogul@TF_HIDING','idle',51,1,2000,0,180000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1752,'Skogul@MG_SOULSTRIKE','chase',13,5,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1752,'Skogul@AS_GRIMTOOTH','idle',137,5,10000,0,700,'yes','randomtarget','mystatuson','hiding',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1752,'Skogul@NPC_CURSEATTACK','attack',181,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1752,'Skogul@NPC_DARKNESSATTACK','attack',190,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1752,'Skogul@NPC_SUMMONSLAVE','attack',196,1,100,0,3600000,'no','self','slavele','0',1762,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1753,'Frus@RG_STRIPARMOR','attack',217,3,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1753,'Frus@NPC_POISON','attack',176,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1753,'Frus@NPC_DARKNESSATTACK','attack',190,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1753,'Frus@NPC_CHANGEUNDEAD','attack',348,2,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1753,'Frus@MG_FIREWALL','chase',18,5,2000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1753,'Frus@NPC_SUMMONSLAVE','attack',196,1,100,0,3600000,'no','self','slavele','0',1761,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@AL_HEAL','attack',28,9,5000,500,5000,'no','friend','friendhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@AL_HEAL','attack',28,9,5000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@AL_HEAL','idle',28,9,5000,500,5000,'no','friend','friendhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@AL_HEAL','idle',28,9,5000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@MG_THUNDERSTORM','attack',21,7,1000,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@MG_THUNDERSTORM','chase',21,7,1000,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@AL_DECAGI','attack',30,48,500,0,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@AL_DECAGI','chase',30,48,500,0,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@NPC_PETRIFYATTACK','attack',180,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@NPC_PETRIFYATTACK','chase',180,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@RG_STRIPARMOR','attack',217,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@RG_STRIPARMOR','chase',217,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@MG_SAFETYWALL','attack',12,10,1000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@NPC_HOLYATTACK','attack',189,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@NPC_HOLYATTACK','chase',189,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@SA_REVERSEORCISH','chase',294,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@SA_REVERSEORCISH','attack',294,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@NPC_CALLSLAVE','attack',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@NPC_CALLSLAVE','idle',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1754,'Skeggiold@NPC_SUMMONSLAVE','any',196,2,10000,700,60000,'no','self','onspawn','0',1763,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@AL_HEAL','attack',28,9,5000,500,5000,'no','friend','friendhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@AL_HEAL','attack',28,9,5000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@AL_HEAL','idle',28,9,5000,500,5000,'no','friend','friendhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@AL_HEAL','idle',28,9,5000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@CR_HOLYCROSS','attack',253,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@MG_SOULSTRIKE','chase',13,7,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@MG_SOULSTRIKE','attack',13,7,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@MG_SAFETYWALL','attack',12,10,1000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@NPC_HOLYATTACK','attack',189,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@NPC_HOLYATTACK','chase',189,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@SA_REVERSEORCISH','chase',294,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@SA_REVERSEORCISH','attack',294,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@NPC_CALLSLAVE','attack',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@NPC_CALLSLAVE','idle',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1755,'Skeggiold@NPC_SUMMONSLAVE','any',196,2,10000,700,60000,'no','self','onspawn','0',1764,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@AL_HEAL','attack',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@AL_HEAL','chase',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_RANDOMATTACK','attack',183,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@AS_SONICBLOW','attack',136,10,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_DARKBREATH','attack',202,4,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_POWERUP','attack',349,3,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@WZ_METEOR','attack',83,11,2000,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_SUMMONSLAVE','attack',196,4,10000,2000,5000,'no','self','slavele','2',1757,1758,1759,1760,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_SUMMONSLAVE','idle',196,4,10000,2000,5000,'no','self','slavele','2',1757,1758,1759,1760,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_SUMMONSLAVE','chase',196,4,10000,2000,5000,'no','self','slavele','2',1757,1758,1759,1760,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1756,'Hydro@NPC_CALLSLAVE','chase',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1761,'Skogul@TF_HIDING','idle',51,1,2000,0,180000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1761,'Skogul@MG_SOULSTRIKE','chase',13,5,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1761,'Skogul@AS_GRIMTOOTH','idle',137,5,10000,0,700,'yes','randomtarget','mystatuson','hiding',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1761,'Skogul@NPC_CURSEATTACK','attack',181,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1761,'Skogul@NPC_DARKNESSATTACK','attack',190,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1762,'Frus@RG_STRIPARMOR','attack',217,3,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1762,'Frus@NPC_POISON','attack',176,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1762,'Frus@NPC_DARKNESSATTACK','attack',190,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1762,'Frus@NPC_CHANGEUNDEAD','attack',348,2,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1762,'Frus@MG_FIREWALL','chase',18,5,2000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1763,'Skeggiold@MG_THUNDERSTORM','attack',21,4,500,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1763,'Skeggiold@MG_THUNDERSTORM','chase',21,4,500,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1763,'Skeggiold@AL_DECAGI','attack',30,5,500,0,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1763,'Skeggiold@AL_DECAGI','chase',30,5,500,0,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1763,'Skeggiold@NPC_PETRIFYATTACK','attack',180,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1763,'Skeggiold@MG_SAFETYWALL','attack',12,5,500,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1763,'Skeggiold@NPC_HOLYATTACK','attack',189,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1763,'Skeggiold@NPC_HOLYATTACK','chase',189,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1763,'Skeggiold@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1763,'Skeggiold@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1764,'Skeggiold@CR_HOLYCROSS','attack',253,2,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1764,'Skeggiold@MG_SOULSTRIKE','chase',13,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1764,'Skeggiold@MG_SOULSTRIKE','attack',13,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1764,'Skeggiold@MG_SAFETYWALL','attack',12,5,1000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1764,'Skeggiold@NPC_HOLYATTACK','attack',189,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1764,'Skeggiold@NPC_HOLYATTACK','chase',189,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1764,'Skeggiold@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1764,'Skeggiold@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1765,'Valkyrie@AL_HEAL','idle',28,10,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1765,'Valkyrie@AL_HEAL','attack',28,11,10000,500,10000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1765,'Valkyrie@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1765,'Valkyrie@AS_SONICBLOW','attack',136,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1765,'Valkyrie@NPC_HOLYATTACK','attack',189,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1765,'Valkyrie@KN_BRANDISHSPEAR','attack',57,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1765,'Valkyrie@NPC_ARMORBRAKE','attack',344,10,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1765,'Valkyrie@WZ_JUPITEL','attack',84,28,100,2000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@AL_HEAL','attack',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@AL_HEAL','attack',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@AL_HEAL','chase',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@AL_HEAL','chase',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@MG_SAFETYWALL','attack',12,5,1000,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@NPC_HOLYATTACK','attack',189,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@NPC_HOLYATTACK','chase',189,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@NPC_SUMMONSLAVE','attack',196,5,10000,2000,60000,'no','self','slavele','3',1031,1062,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@NPC_SUMMONSLAVE','idle',196,5,10000,2000,60000,'no','self','slavele','3',1031,1062,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@SA_REVERSEORCISH','attack',294,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1766,'Angeling@SA_REVERSEORCISH','chase',294,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1767,'Deviling@AL_DECAGI','chase',30,1,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1767,'Deviling@NPC_DARKNESSATTACK','attack',190,2,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1767,'Deviling@NPC_DARKSTRIKE','attack',340,5,3000,700,0,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1767,'Deviling@NPC_DARKSTRIKE','chase',340,5,3000,700,0,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1767,'Deviling@NPC_SUMMONSLAVE','attack',196,7,10000,2000,10000,'no','self','slavele','3',1595,1595,1595,1433,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1767,'Deviling@NPC_SUMMONSLAVE','idle',196,7,10000,2000,10000,'no','self','slavele','3',1595,1595,1595,1433,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@NPC_FIREATTACK','attack',186,10,1000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@NPC_TELEKINESISATTACK','attack',191,10,1000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@WZ_FIREPILLAR','idle',80,10,1000,0,5000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@AM_DEMONSTRATION','attack',229,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@AM_DEMONSTRATION','chase',229,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@KN_PIERCE','attack',56,10,1000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@NPC_POWERUP','attack',349,5,10000,700,25000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@NPC_POWERUP','attack',349,5,2000,700,50000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@NPC_FIREBREATH','chase',654,10,2000,500,10000,'no','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@SM_MAGNUM','attack',7,25,10000,0,5000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@WZ_SIGHTRASHER','attack',81,20,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@MG_FIREBALL','attack',17,44,1000,500,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@MG_FIREBALL','chase',17,44,10000,500,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@NPC_SUMMONSLAVE','attack',196,4,10000,700,30000,'no','self','slavele','3',1786,1787,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@NPC_SUMMONSLAVE','idle',196,4,10000,700,30000,'no','self','slavele','3',1786,1787,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1768,'Gloom Under Night@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@MG_SIGHT','idle',10,1,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@MG_SIGHT','idle',10,1,10000,0,5000,'yes','self','skillused','137',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@MG_SOULSTRIKE','chase',13,9,1000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@MG_SOULSTRIKE','attack',13,9,1000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@MG_THUNDERSTORM','attack',21,9,2000,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@MG_THUNDERSTORM','chase',21,9,2000,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@NPC_HOLYATTACK','attack',189,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@MG_SAFETYWALL','attack',12,10,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@NPC_CURSEATTACK','attack',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@NPC_CURSEATTACK','chase',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@AL_DECAGI','chase',30,48,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@PR_LEXDIVINA','attack',76,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@PR_LEXDIVINA','chase',76,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@PR_LEXDIVINA','attack',76,1,5000,0,5000,'yes','target','casttargeted','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@PR_LEXDIVINA','chase',76,1,5000,0,5000,'yes','target','casttargeted','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@AL_HEAL','attack',28,9,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@AL_HEAL','attack',28,9,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@AL_HEAL','idle',28,9,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@AL_HEAL','idle',28,9,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@AL_HEAL','chase',28,9,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1769,'Agav@AL_HEAL','chase',28,9,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1770,'Echio@CR_HOLYCROSS','attack',253,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1770,'Echio@SM_BASH','attack',5,7,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1770,'Echio@NPC_SLEEPATTACK','attack',182,4,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1770,'Echio@AS_SONICBLOW','attack',136,5,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1770,'Echio@PR_LEXAETERNA','attack',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1770,'Echio@NPC_HOLYATTACK','attack',189,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1770,'Echio@BS_MAXIMIZE','attack',114,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1770,'Echio@BS_MAXIMIZE','chase',114,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1770,'Echio@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1770,'Echio@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1771,'Vanberk@CR_HOLYCROSS','attack',253,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1771,'Vanberk@NPC_SLEEPATTACK','attack',182,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1771,'Vanberk@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1771,'Vanberk@PR_LEXAETERNA','attack',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1771,'Vanberk@PR_LEXAETERNA','chase',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1771,'Vanberk@BS_MAXIMIZE','attack',114,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1771,'Vanberk@BS_MAXIMIZE','chase',114,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@MG_THUNDERSTORM','attack',21,5,500,1200,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@MG_THUNDERSTORM','chase',21,5,500,1200,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@NPC_HOLYATTACK','attack',189,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@NPC_CURSEATTACK','attack',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@NPC_CURSEATTACK','chase',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@PR_LEXDIVINA','attack',76,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@PR_LEXDIVINA','chase',76,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@PR_LEXDIVINA','attack',76,1,5000,0,5000,'yes','target','casttargeted','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@PR_LEXDIVINA','chase',76,1,5000,0,5000,'yes','target','casttargeted','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@AL_HEAL','attack',28,5,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@AL_HEAL','attack',28,5,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@AL_HEAL','idle',28,5,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@AL_HEAL','idle',28,5,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@AL_HEAL','chase',28,5,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1772,'Isilla@AL_HEAL','chase',28,5,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1773,'Hodremlin@AS_SONICBLOW','attack',136,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1773,'Hodremlin@NPC_BLINDATTACK','chase',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1773,'Hodremlin@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1773,'Hodremlin@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1773,'Hodremlin@NPC_DARKNESSATTACK','attack',190,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1773,'Hodremlin@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',52,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1773,'Hodremlin@RG_STRIPARMOR','attack',217,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1774,'Seeker@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'52',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1774,'Seeker@WZ_JUPITEL','chase',84,4,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1774,'Seeker@NPC_MENTALBREAKER','attack',159,3,200,800,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'39',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1774,'Seeker@NPC_MENTALBREAKER','chase',159,3,200,800,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'39',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1774,'Seeker@NPC_PETRIFYATTACK','attack',180,3,200,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1774,'Seeker@NPC_PETRIFYATTACK','chase',180,3,200,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1774,'Seeker@SA_DISPELL','attack',289,1,200,0,100000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1775,'Snowier@NPC_WATERATTACK','attack',184,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1775,'Snowier@NPC_WATERATTACK','attack',184,4,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1775,'Snowier@NPC_CRITICALSLASH','attack',170,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1775,'Snowier@SM_BASH','attack',5,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1775,'Snowier@BS_HAMMERFALL','attack',110,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1775,'Snowier@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1775,'Snowier@SM_ENDURE','chase',8,3,5000,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1776,'Siroma@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',45,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1776,'Siroma@NPC_EMOTION','idle',197,1,10000,0,5000,'yes','self','myhpltmaxrate','1',28,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1776,'Siroma@NPC_EMOTION','attack',197,1,10000,0,5000,'yes','self','myhpltmaxrate','1',28,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1776,'Siroma@NPC_SILENCEATTACK','attack',178,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1776,'Siroma@NPC_SILENCEATTACK','chase',178,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1776,'Siroma@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1776,'Siroma@NPC_WATERATTACK','attack',184,2,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1776,'Siroma@SA_REVERSEORCISH','chase',294,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1776,'Siroma@SA_REVERSEORCISH','attack',294,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1777,'Ice Titan@KN_BOWLINGBASH','attack',62,7,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1777,'Ice Titan@MG_FROSTDIVER','chase',15,7,10000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1777,'Ice Titan@MG_FROSTDIVER','attack',15,5,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1777,'Ice Titan@NPC_COMBOATTACK','attack',171,1,1000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1777,'Ice Titan@NPC_WATERATTACK','attack',184,3,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1778,'Gazeti@CR_AUTOGUARD','attack',249,3,2000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1778,'Gazeti@MG_COLDBOLT','chase',14,3,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1778,'Gazeti@MG_COLDBOLT','attack',14,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1778,'Gazeti@NPC_GUIDEDATTACK','attack',172,2,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1778,'Gazeti@NPC_WATERATTACK','attack',184,2,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_WATERATTACK','attack',184,10,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_RANDOMATTACK','attack',183,8,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_SUMMONSLAVE','attack',196,4,10000,700,30000,'no','self','slavele','3',1788,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_SUMMONSLAVE','idle',196,4,10000,700,30000,'no','self','slavele','3',1788,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_WIDEFREEZE','chase',664,5,10000,0,20000,'yes','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_WIDEFREEZE','attack',664,5,10000,0,20000,'yes','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@SA_DISPELL','attack',289,5,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@SA_DISPELL','chase',289,5,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@MG_FROSTDIVER','idle',15,40,5000,1000,7000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@MG_FROSTDIVER','chase',15,40,5000,1000,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@WZ_STORMGUST','chase',89,10,5000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@WZ_STORMGUST','attack',89,10,5000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@WZ_WATERBALL','chase',86,10,5000,0,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@WZ_WATERBALL','attack',86,10,5000,0,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@WZ_FROSTNOVA','chase',88,10,5000,0,20000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@WZ_FROSTNOVA','attack',88,10,5000,0,20000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_POWERUP','attack',349,5,10000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_AGIUP','attack',350,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@NPC_AGIUP','attack',350,5,10000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1779,'Ktullanux@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1780,'Muscipular@NPC_BLOODDRAIN','attack',199,1,1000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1780,'Muscipular@KN_SPEARSTAB','attack',58,5,500,800,5000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1780,'Muscipular@NPC_GROUNDATTACK','attack',185,1,1000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1780,'Muscipular@AL_HEAL','attack',28,9,10000,500,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1780,'Muscipular@AL_HEAL','idle',28,9,10000,500,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1780,'Muscipular@NPC_PETRIFYATTACK','attack',180,5,500,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1781,'Drosera@NPC_BLOODDRAIN','attack',199,1,1000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1781,'Drosera@KN_PIERCE','attack',56,5,500,700,5000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1781,'Drosera@NPC_GROUNDATTACK','attack',185,1,1000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1781,'Drosera@RG_CLOSECONFINE','attack',1005,1,1000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1781,'Drosera@NPC_GUIDEDATTACK','attack',172,3,500,1000,20000,'no','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1781,'Drosera@NPC_SLEEPATTACK','attack',182,5,500,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1782,'Roween@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1782,'Roween@NPC_COMBOATTACK','attack',171,4,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1782,'Roween@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1783,'Galion@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1783,'Galion@NPC_COMBOATTACK','attack',171,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1783,'Galion@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1783,'Galion@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1783,'Galion@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1783,'Galion@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1783,'Galion@NPC_SUMMONSLAVE','attack',196,3,10000,1000,30000,'no','self','slavele','3',1794,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1783,'Galion@NPC_SUMMONSLAVE','idle',196,3,10000,1000,30000,'no','self','slavele','3',1794,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1784,'Stapo@NPC_KEEPING','attack',201,1,1000,1000,5000,'no','self','myhpltmaxrate','25',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1784,'Stapo@SM_BASH','attack',5,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@NPC_SUMMONSLAVE','attack',196,3,10000,700,30000,'no','self','slavele','0',1791,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@NPC_SUMMONSLAVE','idle',196,3,10000,700,30000,'no','self','slavele','0',1791,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@NPC_DEFENDER','idle',205,1,10000,0,5000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@KN_TWOHANDQUICKEN','attack',60,30,2000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@NPC_PULSESTRIKE','attack',661,5,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@NPC_BLEEDING','attack',660,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@SM_BASH','attack',5,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@NPC_DARKNESSATTACK','attack',190,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@SM_MAGNUM','attack',7,25,10000,0,5000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@NPC_POWERUP','attack',349,2,2000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@NPC_POWERUP','attack',349,2,2000,0,50000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1785,'Atroce@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@MG_SIGHT','idle',10,1,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@MG_SIGHT','idle',10,1,10000,0,5000,'yes','self','skillused','137',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@MG_SOULSTRIKE','chase',13,9,1000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@MG_SOULSTRIKE','attack',13,9,1000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@MG_THUNDERSTORM','attack',21,9,2000,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@MG_THUNDERSTORM','chase',21,9,2000,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@NPC_HOLYATTACK','attack',189,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@MG_SAFETYWALL','attack',12,10,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@NPC_CURSEATTACK','attack',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@NPC_CURSEATTACK','chase',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@AL_DECAGI','chase',30,48,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@PR_LEXDIVINA','attack',76,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@PR_LEXDIVINA','chase',76,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@PR_LEXDIVINA','attack',76,1,5000,0,5000,'yes','target','casttargeted','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@PR_LEXDIVINA','chase',76,1,5000,0,5000,'yes','target','casttargeted','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@AL_HEAL','attack',28,9,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@AL_HEAL','attack',28,9,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@AL_HEAL','idle',28,9,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@AL_HEAL','idle',28,9,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@AL_HEAL','chase',28,9,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1786,'Agav@AL_HEAL','chase',28,9,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1787,'Echio@CR_HOLYCROSS','attack',253,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1787,'Echio@SM_BASH','attack',5,7,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1787,'Echio@NPC_SLEEPATTACK','attack',182,4,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1787,'Echio@AS_SONICBLOW','attack',136,5,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1787,'Echio@PR_LEXAETERNA','attack',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1787,'Echio@NPC_HOLYATTACK','attack',189,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1787,'Echio@BS_MAXIMIZE','attack',114,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1787,'Echio@BS_MAXIMIZE','chase',114,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1787,'Echio@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1787,'Echio@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1788,'Ice Titan@KN_BOWLINGBASH','attack',62,7,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1788,'Ice Titan@MG_FROSTDIVER','chase',15,7,10000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1788,'Ice Titan@MG_FROSTDIVER','attack',15,5,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1788,'Ice Titan@NPC_COMBOATTACK','attack',171,1,1000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1788,'Ice Titan@NPC_WATERATTACK','attack',184,3,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1791,'Galion@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1791,'Galion@NPC_COMBOATTACK','attack',171,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1791,'Galion@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1791,'Galion@NPC_DARKNESSATTACK','attack',190,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1791,'Galion@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1791,'Galion@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1794,'Roween@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1794,'Roween@NPC_COMBOATTACK','attack',171,4,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1794,'Roween@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',22,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@KN_BOWLINGBASH','attack',62,10,1000,0,10000,'yes','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@KN_BOWLINGBASH','attack',62,10,2000,0,0,'yes','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@KN_BRANDISHSPEAR','attack',57,10,2000,0,5000,'yes','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@BS_HAMMERFALL','chase',110,10,2000,0,5000,'yes','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@BS_HAMMERFALL','attack',110,10,2000,0,5000,'yes','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@CR_GRANDCROSS','attack',254,10,2000,1500,5000,'no','self','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@KN_TWOHANDQUICKEN','attack',60,30,10000,0,90000,'yes','self','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_STORMGUST','idle',89,10,10000,1000,10000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_VERMILION','idle',85,21,10000,1000,10000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_METEOR','idle',83,11,10000,1000,10000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_STORMGUST','chase',89,10,10000,1000,10000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_VERMILION','chase',85,21,10000,1000,10000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_METEOR','chase',83,11,10000,1000,10000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_STORMGUST','chase',89,10,10000,1000,20000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_VERMILION','chase',85,21,10000,1000,20000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_METEOR','chase',83,11,10000,1000,10000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_STORMGUST','attack',89,10,10000,1000,20000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_VERMILION','attack',85,21,10000,1000,20000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1795,'Bloody Knight@WZ_METEOR','attack',83,11,10000,1000,20000,'no','target','always',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
# Guild Dungeon SE (13.1)
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@MG_THUNDERSTORM','attack',21,5,500,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@MG_THUNDERSTORM','chase',21,5,500,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@NPC_HOLYATTACK','attack',189,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@NPC_CURSEATTACK','attack',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@NPC_CURSEATTACK','chase',181,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@PR_LEXDIVINA','attack',76,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@PR_LEXDIVINA','chase',76,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@PR_LEXDIVINA','attack',76,1,5000,0,5000,'yes','target','casttargeted','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@PR_LEXDIVINA','chase',76,1,5000,0,5000,'yes','target','casttargeted','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@AL_HEAL','attack',28,5,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@AL_HEAL','attack',28,5,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@AL_HEAL','idle',28,5,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@AL_HEAL','idle',28,5,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@AL_HEAL','chase',28,5,3000,0,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1796,'Aunoe@AL_HEAL','chase',28,5,3000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1797,'Fanat@CR_HOLYCROSS','attack',253,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1797,'Fanat@NPC_SLEEPATTACK','attack',182,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1797,'Fanat@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1797,'Fanat@PR_LEXAETERNA','attack',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1797,'Fanat@PR_LEXAETERNA','chase',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1797,'Fanat@BS_MAXIMIZE','attack',114,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1797,'Fanat@BS_MAXIMIZE','chase',114,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1812,'Delightful Lude@AL_HEAL','chase',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1812,'Delightful Lude@AL_HEAL','attack',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1812,'Delightful Lude@AL_HEAL','chase',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1812,'Delightful Lude@AL_HEAL','attack',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1812,'Delightful Lude@NPC_METAMORPHOSIS','attack',193,1,1000,0,60000,'no','self','myhpltmaxrate','30',1814,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1812,'Delightful Lude@PR_LEXAETERNA','chase',78,1,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1812,'Delightful Lude@PR_LEXAETERNA','attack',78,1,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@AL_HEAL','attack',28,11,2000,500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@NPC_DARKTHUNDER','chase',341,5,8000,700,1000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@NPC_GRANDDARKNESS','attack',339,10,2000,900,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@NPC_DARKCROSS','attack',338,10,2000,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@WZ_VERMILION','attack',85,21,2500,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@NPC_COMBOATTACK','attack',171,6,2500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'24',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@AS_VENOMDUST','attack',140,10,3500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@NPC_LICK','attack',206,5,4000,0,2000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'39',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@KN_TWOHANDQUICKEN','attack',60,30,5000,0,120000,'yes','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'27',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1813,'Hydrolancer@NPC_POWERUP','attack',349,5,10000,0,25000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@AL_HEAL','attack',28,9,10000,0,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@AL_HEAL','chase',28,9,10000,0,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@MG_FIREBOLT','chase',19,10,3000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@MG_FIREBOLT','attack',19,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@MG_FIREBOLT','chase',19,10,4000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@WZ_WATERBALL','attack',86,5,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@WZ_WATERBALL','chase',86,5,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@WZ_METEOR','attack',83,5,2000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@WZ_METEOR','chase',83,5,2000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@MC_MAMMONITE','attack',42,22,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@NPC_PETRIFYATTACK','attack',180,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@MG_FIREWALL','attack',18,10,1000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@MG_FIREWALL','chase',18,10,1000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@SA_DISPELL','attack',289,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1814,'Moonlight Flower@SA_DISPELL','chase',289,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@NPC_DARKBREATH','attack',202,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@NPC_POWERUP','attack',349,5,10000,0,25000,'yes','self','myhpltmaxrate','12',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@KN_TWOHANDQUICKEN','attack',60,30,10000,0,300000,'yes','self','myhpltmaxrate','12',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@BS_HAMMERFALL','attack',110,10,10000,0,5000,'yes','target','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@BS_HAMMERFALL','chase',110,10,5000,0,5000,'yes','target','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@NPC_WEAPONBRAKER','attack',343,10,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@CR_REFLECTSHIELD','attack',252,5,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@CR_REFLECTSHIELD','chase',252,5,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@CR_GRANDCROSS','attack',254,10,5000,100,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@WZ_STORMGUST','attack',89,10,2000,1000,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@WZ_VERMILION','attack',85,21,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@WZ_VERMILION','chase',85,21,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@MG_FIREBALL','chase',17,44,5000,500,1000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@WZ_METEOR','attack',83,11,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@WZ_METEOR','chase',83,11,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@BS_MAXIMIZE','chase',114,5,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@SM_MAGNUM','attack',7,25,10000,0,5000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@AL_HEAL','attack',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1817,'Detale@AL_HEAL','chase',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1819,'Bathory@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1819,'Bathory@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',30,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1819,'Bathory@NPC_ENERGYDRAIN','attack',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1819,'Bathory@NPC_ENERGYDRAIN','chase',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1819,'Bathory@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1819,'Bathory@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1820,'Bigfoot@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1820,'Bigfoot@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1820,'Bigfoot@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1820,'Bigfoot@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1820,'Bigfoot@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1821,'Desert Wolf@NPC_FIREATTACK','attack',186,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1821,'Desert Wolf@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1821,'Desert Wolf@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x308D,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1821,'Desert Wolf@TF_SPRINKLESAND','attack',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1822,'Deviruchi@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1822,'Deviruchi@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1822,'Deviruchi@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1822,'Deviruchi@NPC_ENERGYDRAIN','attack',200,1,500,0,5000,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1822,'Deviruchi@NPC_ENERGYDRAIN','chase',200,1,500,0,5000,'yes','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1822,'Deviruchi@NPC_DARKTHUNDER','attack',341,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1822,'Deviruchi@NPC_DARKTHUNDER','chase',341,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1823,'Freezer@MG_COLDBOLT','attack',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1823,'Freezer@MG_COLDBOLT','chase',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1823,'Freezer@MG_FROSTDIVER','attack',15,9,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1823,'Freezer@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',20,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1823,'Freezer@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1823,'Freezer@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1823,'Freezer@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1824,'Garm Baby@MG_FROSTDIVER','chase',15,40,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1824,'Garm Baby@NPC_LICK','attack',206,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1825,'Christmas Goblin@MG_FROSTDIVER','attack',15,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1825,'Christmas Goblin@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',18,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1825,'Christmas Goblin@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1825,'Christmas Goblin@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1825,'Christmas Goblin@NPC_WINDATTACK','attack',187,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1826,'Myst@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1826,'Myst@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1826,'Myst@NPC_MENTALBREAKER','attack',159,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1826,'Myst@NPC_POISONATTACK','attack',188,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1827,'Sasquatch@KN_SPEARSTAB','attack',58,10,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1827,'Sasquatch@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1827,'Sasquatch@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1827,'Sasquatch@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1827,'Sasquatch@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);

# Thor Volcano (11.2)
REPLACE INTO `mob_skill_db_re` VALUES (1829,'Sword Guardian@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1829,'Sword Guardian@CR_REFLECTSHIELD','idle',252,10,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1829,'Sword Guardian@KN_SPEARBOOMERANG','chase',59,5,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1829,'Sword Guardian@CR_REFLECTSHIELD','attack',252,10,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1829,'Sword Guardian@KN_TWOHANDQUICKEN','attack',60,30,10000,0,120000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1829,'Sword Guardian@CR_SHIELDCHARGE','attack',250,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1829,'Sword Guardian@NPC_STUNATTACK','attack',179,5,1500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1829,'Sword Guardian@NPC_COMBOATTACK','attack',171,5,1500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1829,'Sword Guardian@NPC_WIDEBLEEDING','attack',665,4,10000,0,15000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@AC_DOUBLE','idle',46,10,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@AC_SHOWER','idle',47,5,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@AC_CHARGEARROW','idle',148,1,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@AC_CHARGEARROW','chase',148,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@AC_DOUBLE','attack',46,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@AC_SHOWER','attack',47,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@AC_CHARGEARROW','attack',148,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@NPC_STUNATTACK','attack',179,5,1500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@NPC_COMBOATTACK','attack',171,5,1500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@NPC_BLEEDING','attack',660,5,1500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1830,'Bow Guardian@NPC_WIDEBLEEDING','attack',665,4,10000,0,15000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@MG_FIREBALL','idle',17,5,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@MG_FIREBALL','chase',17,5,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@CR_REFLECTSHIELD','idle',252,3,1000,0,200000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@CR_REFLECTSHIELD','attack',252,3,1000,0,200000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@NPC_FIREATTACK','attack',186,5,2000,1000,200000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@NPC_BLEEDING','attack',660,3,500,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@AS_SONICBLOW','attack',136,10,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@SM_MAGNUM','attack',7,7,1000,0,10000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@KN_TWOHANDQUICKEN','attack',60,30,2000,0,300000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@NPC_CRITICALSLASH','attack',170,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1831,'Salamander@NPC_WIDEBLEEDING','attack',665,2,10000,500,100000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@AL_PNEUMA','idle',25,1,10000,0,1000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@AL_HEAL','idle',28,1,10000,0,10000,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_SUMMONSLAVE','attack',196,2,10000,1000,30000,'no','self','slavele','1',1834,1835,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_SUMMONSLAVE','idle',196,2,10000,1000,30000,'no','self','slavele','1',1834,1835,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_SUMMONSLAVE','chase',196,2,10000,1000,30000,'no','self','slavele','1',1834,1835,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@ST_FULLSTRIP','attack',476,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@AS_SONICBLOW','attack',136,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_FIREBREATH','chase',654,10,2000,500,5000,'no','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_FIREBREATH','attack',654,10,2000,500,5000,'no','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@SA_LANDPROTECTOR','attack',288,3,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@WZ_METEOR','attack',83,11,2000,500,5000,'no','target','myhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@KN_TWOHANDQUICKEN','attack',60,9,10000,0,100000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_EARTHQUAKE','chase',653,5,10000,500,20000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_EARTHQUAKE','attack',653,5,10000,500,20000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_PULSESTRIKE','attack',661,5,10000,0,15000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_DRAGONFEAR','attack',659,5,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@NPC_DRAGONFEAR','chase',659,5,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1832,'Ifrit@WZ_METEOR','idle',83,9,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@CR_REFLECTSHIELD','idle',252,1,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@CR_REFLECTSHIELD','chase',252,1,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@CR_REFLECTSHIELD','attack',252,1,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@WZ_FIREPILLAR','idle',80,5,10000,500,30000,'no','around2','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@NPC_FIREBREATH','chase',654,10,2000,1500,15000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@NPC_FIREBREATH','attack',654,10,2000,1500,15000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@MG_FIREBALL','idle',17,44,10000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@MG_FIREBALL','chase',17,44,10000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@MG_FIREBALL','attack',17,44,5000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@WZ_SIGHTRASHER','attack',81,20,1000,0,20000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@LK_SPIRALPIERCE','attack',397,1,1500,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@WZ_METEOR','chase',83,1,5000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@WZ_METEOR','attack',83,1,5000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1833,'Kasa@HW_GANBANTEIN','attack',483,5,5000,500,5000,'no','target','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@MG_FIREBALL','idle',17,5,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@MG_FIREBALL','chase',17,5,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@CR_REFLECTSHIELD','attack',252,3,1000,0,200000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@NPC_FIREATTACK','attack',186,5,2000,1000,200000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@NPC_BLEEDING','attack',660,3,500,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@AS_SONICBLOW','attack',136,10,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@SM_MAGNUM','attack',7,7,1000,0,10000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@KN_TWOHANDQUICKEN','attack',60,30,2000,0,300000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@NPC_CRITICALSLASH','attack',170,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1834,'Salamander@NPC_WIDEBLEEDING','attack',665,2,10000,500,100000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@CR_REFLECTSHIELD','idle',252,1,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@CR_REFLECTSHIELD','chase',252,1,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@CR_REFLECTSHIELD','attack',252,1,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@WZ_FIREPILLAR','idle',80,5,10000,500,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@NPC_FIREBREATH','chase',654,10,2000,3000,200000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@NPC_FIREBREATH','attack',654,10,2000,3000,200000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@MG_FIREBALL','idle',17,44,10000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@MG_FIREBALL','chase',17,44,10000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@MG_FIREBALL','attack',17,44,5000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@WZ_SIGHTRASHER','attack',81,10,1000,0,20000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@LK_SPIRALPIERCE','attack',397,1,1500,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@WZ_METEOR','chase',83,1,5000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1835,'Kasa@WZ_METEOR','attack',83,1,5000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1836,'Magmaring@NPC_FIREATTACK','attack',186,2,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1836,'Magmaring@MG_FIREBOLT','attack',19,2,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1836,'Magmaring@SM_BASH','attack',5,4,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1836,'Magmaring@MG_FIREBALL','chase',17,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1836,'Magmaring@SM_MAGNUM','attack',7,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@KN_BRANDISHSPEAR','attack',57,8,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@MG_FIREWALL','chase',18,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@MG_FIREWALL','attack',18,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@MG_FIREBOLT','attack',19,10,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@MG_FIREBALL','attack',17,44,3000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@MG_FIREBALL','chase',17,44,3000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@NPC_FIREATTACK','attack',186,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@NPC_PULSESTRIKE','attack',661,3,1000,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@MG_SIGHT','idle',10,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@WZ_SIGHTRASHER','attack',81,20,3000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1837,'Imp@RG_STRIPARMOR','attack',217,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1838,'Knocker@HT_LANDMINE','idle',116,2,4000,1000,18000,'yes','around2','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1838,'Knocker@NPC_GROUNDATTACK','attack',185,2,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1838,'Knocker@TF_SPRINKLESAND','attack',149,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1838,'Knocker@TF_THROWSTONE','chase',152,1,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1838,'Knocker@TF_THROWSTONE','attack',152,1,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@NPC_SUMMONSLAVE','idle',196,2,10000,1000,60000000,'no','self','slavele','1',1829,1830,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@NPC_SUMMONSLAVE','chase',196,2,10000,1000,60000000,'no','self','slavele','1',1829,1830,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@NPC_SUMMONSLAVE','attack',196,2,10000,1000,60000000,'no','self','slavele','1',1829,1830,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@NPC_CALLSLAVE','idle',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@SM_BASH','attack',5,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@AS_GRIMTOOTH','idle',137,5,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@AS_GRIMTOOTH','chase',137,5,10000,0,5000,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@ASC_BREAKER','chase',379,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@ASC_METEORASSAULT','attack',406,2,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@AS_SONICBLOW','attack',136,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@NPC_STUNATTACK','attack',179,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1839,'Byorgue@NPC_CALLSLAVE','attack',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@AL_INCAGI','chase',29,1,500,700,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@ST_FULLSTRIP','attack',476,5,100,1500,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@KN_TWOHANDQUICKEN','attack',60,5,500,0,30000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@WZ_EARTHSPIKE','attack',90,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@WZ_HEAVENDRIVE','attack',91,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@WZ_QUAGMIRE','attack',92,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@WZ_QUAGMIRE','chase',92,2,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1840,'Golden Savage@NPC_PULSESTRIKE','attack',661,1,500,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);

# Cursed Abbey (11.3)
REPLACE INTO `mob_skill_db_re` VALUES (1864,'Zombie Slaughter@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1864,'Zombie Slaughter@NPC_POISON','attack',176,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1864,'Zombie Slaughter@AS_SONICBLOW','attack',136,5,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1864,'Zombie Slaughter@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1865,'Ragged Zombie@NPC_BLINDATTACK','attack',177,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1865,'Ragged Zombie@AC_DOUBLE','attack',46,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1865,'Ragged Zombie@NPC_MAGICALATTACK','attack',192,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1865,'Ragged Zombie@AC_SHOWER','attack',47,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1866,'Hell Poodle@AL_HEAL','idle',28,1,10000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1866,'Hell Poodle@AS_SONICBLOW','attack',136,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1866,'Hell Poodle@NPC_RUN','attack',354,1,10000,0,0,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1866,'Hell Poodle@NPC_RUN','chase',354,1,10000,0,0,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1867,'Banshee@NPC_CURSEATTACK','chase',181,1,1000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1867,'Banshee@NPC_WIDECURSE','attack',677,1,500,800,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1867,'Banshee@NPC_CRITICALWOUND','attack',673,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1867,'Banshee@NPC_DARKSTRIKE','chase',340,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1867,'Banshee@NPC_DARKSTRIKE','attack',340,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1867,'Banshee@NPC_VAMPIRE_GIFT','attack',679,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1867,'Banshee@NPC_DARKNESSATTACK','attack',190,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1867,'Banshee@NPC_EVILLAND','attack',670,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1867,'Banshee@NPC_EMOTION','chase',197,1,1000,0,5000,'yes','self','always','0',7,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1867,'Banshee@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',NULL,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1868,'Banshee@NPC_CURSEATTACK','chase',181,1,1000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1868,'Banshee@NPC_WIDECURSE','attack',677,1,500,800,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1868,'Banshee@NPC_CRITICALWOUND','attack',673,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1868,'Banshee@NPC_DARKSTRIKE','chase',340,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1868,'Banshee@NPC_DARKSTRIKE','attack',340,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1868,'Banshee@NPC_VAMPIRE_GIFT','attack',679,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1868,'Banshee@NPC_DARKNESSATTACK','attack',190,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1868,'Banshee@NPC_EMOTION','chase',197,1,1000,0,5000,'yes','self','always','0',7,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1868,'Banshee@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',NULL,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1869,'Flame Skull@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1869,'Flame Skull@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',29,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1869,'Flame Skull@MG_FIREBALL','chase',17,5,1500,500,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1869,'Flame Skull@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_STONESKIN','idle',675,3,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_STONESKIN','chase',675,3,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_STONESKIN','attack',675,3,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@CR_REFLECTSHIELD','idle',252,10,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@CR_REFLECTSHIELD','chase',252,10,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@CR_REFLECTSHIELD','attack',252,10,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_SUMMONSLAVE','idle',196,2,10000,0,300000,'yes','self','slavele','0',1864,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_SUMMONSLAVE','chase',196,2,10000,0,300000,'yes','self','slavele','0',1864,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_SUMMONSLAVE','attack',196,2,10000,0,300000,'yes','self','slavele','0',1864,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_CALLSLAVE','attack',352,1,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_CALLSLAVE','idle',352,1,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@MG_FIREBALL','chase',17,5,2000,300,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@MG_THUNDERSTORM','attack',21,5,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@MG_THUNDERSTORM','chase',21,5,3000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@WZ_QUAGMIRE','attack',92,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@WZ_QUAGMIRE','chase',92,5,500,200,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_WIDECURSE','chase',677,1,500,300,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_WIDECURSE','attack',677,1,500,800,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_SLOWCAST','chase',672,1,2000,300,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_SLOWCAST','attack',672,1,2000,800,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_CRITICALWOUND','chase',673,2,2000,500,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_CRITICALWOUND','attack',673,2,2000,700,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_DARKNESSATTACK','attack',190,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_DARKSTRIKE','chase',340,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_DARKSTRIKE','attack',340,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_CHANGEUNDEAD','attack',348,1,500,500,6000000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_DARKNESSBREATH','attack',658,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@NPC_DRAGONFEAR','attack',659,2,500,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@WZ_METEOR','chase',83,3,3000,500,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1870,'Necromancer@WZ_METEOR','chase',83,3,1000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_CALLSLAVE','attack',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_CALLSLAVE','idle',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_SUMMONSLAVE','attack',196,4,10000,700,10000,'no','self','slavele','3',1868,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_SUMMONSLAVE','idle',196,4,10000,700,10000,'no','self','slavele','3',1868,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_WIDECURSE','attack',677,5,2000,800,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_CRITICALWOUND','attack',673,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_DARKSTRIKE','chase',340,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_DARKSTRIKE','attack',340,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_DARKCROSS','attack',338,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@CR_HOLYCROSS','attack',253,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_GRANDDARKNESS','chase',339,10,500,1300,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_GRANDDARKNESS','attack',339,10,500,1300,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@CR_GRANDCROSS','chase',254,10,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@CR_GRANDCROSS','attack',254,10,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_VAMPIRE_GIFT','attack',679,2,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_SLOWCAST','chase',672,5,2000,300,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_SLOWCAST','attack',672,5,2000,800,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_EVILLAND','attack',670,10,10000,1000,600000,'no','target','myhpltmaxrate','44',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_EVILLAND','attack',670,7,500,500,5000,'no','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_MAGICMIRROR','attack',671,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_HELLJUDGEMENT','chase',662,4,10000,800,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_HELLJUDGEMENT','attack',662,4,10000,800,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_WIDESILENCE','chase',663,5,5000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_WIDESILENCE','attack',663,5,5000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@MG_SAFETYWALL','attack',12,10,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@AL_PNEUMA','attack',25,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@AL_PNEUMA','chase',25,1,5000,0,10000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@PR_LEXAETERNA','attack',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@PR_LEXAETERNA','chase',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_DARKNESSATTACK','attack',190,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1871,'Fallen Bishop@NPC_DARKNESSBREATH','attack',658,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1872,'Hell Fly@NPC_CRITICALWOUND','attack',673,5,10,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1872,'Hell Fly@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1872,'Hell Fly@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1872,'Hell Fly@NPC_WINDATTACK','attack',187,4,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1872,'Hell Fly@NPC_MENTALBREAKER','attack',159,1,200,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@AL_TELEPORT','chase',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@AL_HEAL','idle',28,9,10000,0,2000,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_CALLSLAVE','attack',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_CALLSLAVE','chase',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_CALLSLAVE','idle',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_SUMMONSLAVE','attack',196,10,10000,0,10000,'yes','self','slavele','5',1872,1872,1011,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_SUMMONSLAVE','chase',196,10,10000,0,10000,'yes','self','slavele','5',1872,1872,1011,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_SUMMONSLAVE','idle',196,10,10000,0,10000,'yes','self','slavele','5',1872,1872,1011,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_METAMORPHOSIS','chase',193,1,10000,5000,5000,'no','self','myhpltmaxrate','50',1874,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_METAMORPHOSIS','attack',193,1,10000,5000,5000,'no','self','myhpltmaxrate','50',1874,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_SHIELDBRAKE','attack',346,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@LK_SPIRALPIERCE','attack',397,5,2000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_CRITICALWOUND','attack',673,3,2000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_PULSESTRIKE','attack',661,5,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_WIDESLEEP','attack',668,5,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_WIDESILENCE','attack',663,5,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_HELLJUDGEMENT','attack',662,5,10000,700,15000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_HELLJUDGEMENT','chase',662,5,10000,700,15000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_EXPULSION','attack',674,1,100,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_VAMPIRE_GIFT','attack',679,10,10000,1000,10000,'no','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1873,'Beelzebub@NPC_AGIUP','chase',350,5,10000,0,30000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@AL_TELEPORT','chase',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_RUN','attack',354,1,10000,0,0,'yes','self','myhpltmaxrate','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_RUN','chase',354,1,10000,0,0,'yes','self','myhpltmaxrate','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@AL_HEAL','idle',28,9,10000,0,2000,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_CALLSLAVE','attack',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_CALLSLAVE','chase',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_CALLSLAVE','idle',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_SUMMONSLAVE','attack',196,10,10000,0,10000,'yes','self','slavele','5',1872,1872,1011,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_SUMMONSLAVE','chase',196,10,10000,0,10000,'yes','self','slavele','5',1872,1872,1011,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_SUMMONSLAVE','idle',196,10,10000,0,10000,'yes','self','slavele','5',1872,1872,1011,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_STONESKIN','chase',675,4,10000,1000,30000,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_STONESKIN','attack',675,4,10000,1000,30000,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_EVILLAND','attack',670,10,10000,0,15000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@SA_LANDPROTECTOR','attack',288,5,10000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_CRITICALWOUND','attack',673,3,2000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_SHIELDBRAKE','attack',346,10,2000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_SLOWCAST','attack',672,5,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_MAGICMIRROR','attack',671,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_EXPULSION','attack',674,1,50,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_WIDESTONE','attack',666,5,10000,500,15000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_WIDESTONE','chase',666,5,10000,500,15000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@LK_SPIRALPIERCE','attack',397,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_PULSESTRIKE','attack',661,5,10000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_HELLJUDGEMENT','chase',662,2,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_HELLJUDGEMENT','attack',662,2,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_ACIDBREATH','attack',657,1,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_ACIDBREATH','chase',657,1,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_VAMPIRE_GIFT','attack',679,1,1000,500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1874,'Beelzebub@NPC_WIDESOULDRAIN','attack',680,7,1000,500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'42',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1875,'Tristan@NPC_BLOODDRAIN','attack',199,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

# Moscovia (12.1)
REPLACE INTO `mob_skill_db_re` VALUES (1880,'Wood Goblin@AL_HEAL','idle',28,9,10000,3000,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1880,'Wood Goblin@AL_HEAL','idle',28,9,5000,500,5000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1880,'Wood Goblin@NPC_SPLASHATTACK','attack',174,1,3000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1880,'Wood Goblin@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1880,'Wood Goblin@NPC_STUNATTACK','attack',179,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1881,'Les@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1881,'Les@NPC_COMBOATTACK','attack',171,2,3000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1881,'Les@NPC_BLEEDING','attack',660,3,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1881,'Les@NPC_POISON','attack',176,2,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1882,'Baba Yaga@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1882,'Baba Yaga@WZ_WATERBALL','chase',86,1,5000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1882,'Baba Yaga@NPC_COMBOATTACK','attack',171,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1882,'Baba Yaga@WZ_WATERBALL','attack',86,2,2000,3000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1883,'Uzhas@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1883,'Uzhas@NPC_MAGICALATTACK','chase',192,1,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1883,'Uzhas@NPC_POISON','attack',176,2,2000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1883,'Uzhas@WZ_WATERBALL','attack',86,3,2000,3000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1883,'Uzhas@NPC_CURSEATTACK','attack',181,2,1000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1884,'Mavka@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1884,'Mavka@AL_HEAL','idle',28,5,10000,2000,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1884,'Mavka@WZ_EARTHSPIKE','chase',90,2,5000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1884,'Mavka@NPC_GROUNDATTACK','attack',185,2,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1884,'Mavka@NPC_SILENCEATTACK','attack',178,2,2000,2000,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_SUMMONSLAVE','attack',196,5,10000,1000,30000,'no','self','slavele','1',1886,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_SUMMONSLAVE','chase',196,5,5000,1000,30000,'no','self','slavele','0',1886,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_SUMMONSLAVE','idle',196,5,10000,1000,30000,'no','self','slavele','0',1886,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@WZ_QUAGMIRE','chase',92,5,5000,200,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_CALLSLAVE','attack',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_CALLSLAVE','chase',352,1,5000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_CALLSLAVE','idle',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@WZ_METEOR','attack',83,11,5000,1500,5000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@MG_FIREBALL','chase',17,9,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@MG_FIREBALL','attack',17,44,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_AGIUP','attack',350,5,3000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@KN_TWOHANDQUICKEN','attack',60,30,5000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_POWERUP','attack',349,5,6000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@WZ_HEAVENDRIVE','chase',91,5,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@SM_MAGNUM','attack',7,25,5000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_SILENCEATTACK','attack',178,5,1000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_MENTALBREAKER','chase',159,5,500,800,25000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@WZ_HEAVENDRIVE','attack',91,5,5000,500,25000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@NPC_SILENCEATTACK','chase',178,5,5000,700,25000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1885,'Gopinich@WZ_QUAGMIRE','attack',92,5,5000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1886,'Mavka@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1886,'Mavka@AL_HEAL','idle',28,9,10000,1000,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1886,'Mavka@WZ_EARTHSPIKE','chase',90,4,5000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1886,'Mavka@NPC_GROUNDATTACK','attack',185,4,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1886,'Mavka@NPC_SILENCEATTACK','attack',178,4,2000,2000,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1887,'Freezer@MG_COLDBOLT','attack',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1887,'Freezer@MG_COLDBOLT','chase',14,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1887,'Freezer@MG_FROSTDIVER','attack',15,9,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1887,'Freezer@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',20,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1887,'Freezer@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1888,'Garm Baby@MG_FROSTDIVER','chase',15,40,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1888,'Garm Baby@NPC_WATERATTACK','attack',184,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1889,'Marozka\'s Guard@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1889,'Marozka\'s Guard@NPC_WATERATTACK','attack',184,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1889,'Marozka\'s Guard@NPC_WATERATTACK','chase',184,5,2000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1890,'The Immortal Koshei@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1890,'The Immortal Koshei@WZ_QUAGMIRE','chase',92,1,5000,200,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1890,'The Immortal Koshei@MG_FIREBALL','chase',17,9,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1890,'The Immortal Koshei@MG_FIREBALL','attack',17,44,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1890,'The Immortal Koshei@WZ_HEAVENDRIVE','chase',91,5,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1890,'The Immortal Koshei@SM_MAGNUM','attack',7,9,5000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1890,'The Immortal Koshei@NPC_SILENCEATTACK','attack',178,5,1000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1890,'The Immortal Koshei@WZ_HEAVENDRIVE','attack',91,5,5000,500,25000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1890,'The Immortal Koshei@NPC_SILENCEATTACK','chase',178,5,5000,700,25000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1890,'The Immortal Koshei@WZ_QUAGMIRE','attack',92,1,5000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1891,'Valkyrie@AL_HEAL','idle',28,11,10000,500,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1891,'Valkyrie@AL_HEAL','attack',28,11,10000,500,10000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1891,'Valkyrie@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1891,'Valkyrie@AS_SONICBLOW','attack',136,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1891,'Valkyrie@NPC_HOLYATTACK','attack',189,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1891,'Valkyrie@KN_BRANDISHSPEAR','attack',57,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1891,'Valkyrie@NPC_ARMORBRAKE','attack',344,10,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1891,'Valkyrie@WZ_JUPITEL','attack',84,28,100,2000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

REPLACE INTO `mob_skill_db_re` VALUES (1894,'Pouring@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1894,'Pouring@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1894,'Pouring@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1894,'Pouring@WZ_STORMGUST','chase',89,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1894,'Pouring@WZ_STORMGUST','attack',89,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1894,'Pouring@WZ_WATERBALL','attack',86,10,10000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1894,'Pouring@WZ_WATERBALL','chase',86,10,10000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

REPLACE INTO `mob_skill_db_re` VALUES (1904,'Bomb Poring@NPC_SELFDESTRUCTION','any',173,1,10000,3000,0,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

# Satan Morroc (12.1)
#5% HP - Dragon Fear
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_DRAGONFEAR','chase',659,10,10000,0,600000,'no','self','myhpltmaxrate','5',NULL,NULL,NULL,NULL,NULL,NULL,'17');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_DRAGONFEAR','attack',659,10,10000,0,600000,'no','self','myhpltmaxrate','5',NULL,NULL,NULL,NULL,NULL,NULL,'17');
#10% HP - Talk
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_TALK','chase',682,10,10000,0,600000,'no','self','myhpinrate','6',10,NULL,NULL,NULL,NULL,NULL,'16');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_TALK','attack',682,10,10000,0,600000,'no','self','myhpinrate','6',10,NULL,NULL,NULL,NULL,NULL,'16');
#30% HP - Earthquake Combo
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_WIDEHELLDIGNITY','chase',684,1,10000,2000,180000,'no','self','myhpinrate','11',30,NULL,NULL,NULL,NULL,NULL,'6');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_WIDEHELLDIGNITY','attack',684,1,10000,2000,180000,'no','self','myhpinrate','11',30,NULL,NULL,NULL,NULL,NULL,'6');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_WIDESTUN','chase',678,5,10000,1300,180000,'no','self','afterskill','684',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_WIDESTUN','attack',678,5,10000,1300,180000,'no','self','afterskill','684',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_EARTHQUAKE','chase',653,10,10000,2000,180000,'no','self','afterskill','678',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_EARTHQUAKE','attack',653,10,10000,2000,180000,'no','self','afterskill','678',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#40% HP - Mixed Combo
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_PULSESTRIKE','chase',661,5,10000,800,60000,'no','self','myhpinrate','31',40,NULL,NULL,NULL,NULL,NULL,'14');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_PULSESTRIKE','attack',661,5,10000,800,60000,'no','self','myhpinrate','31',40,NULL,NULL,NULL,NULL,NULL,'14');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_WIDESTONE','chase',666,5,10000,0,60000,'no','self','afterskill','661',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_WIDESTONE','attack',666,5,10000,0,60000,'no','self','afterskill','661',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@WZ_METEOR','chase',83,5,10000,800,60000,'no','target','afterskill','666',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@WZ_METEOR','attack',83,5,10000,800,60000,'no','target','afterskill','666',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#50% HP - Vampire Combo
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_VAMPIRE_GIFT','chase',679,9,10000,1000,50000,'no','self','myhpinrate','41',50,NULL,NULL,NULL,NULL,NULL,'15');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_VAMPIRE_GIFT','attack',679,9,10000,1000,50000,'no','self','myhpinrate','41',50,NULL,NULL,NULL,NULL,NULL,'15');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_WIDESOULDRAIN','chase',680,10,10000,1000,50000,'no','self','afterskill','679',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_WIDESOULDRAIN','attack',680,10,10000,1000,50000,'no','self','afterskill','679',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_EVILLAND','chase',670,10,10000,1000,50000,'no','target','afterskill','680',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_EVILLAND','attack',670,10,10000,1000,50000,'no','target','afterskill','680',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#60% HP - Hell Combo
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_WIDESLEEP','chase',668,5,10000,700,35000,'no','self','myhpinrate','51',60,NULL,NULL,NULL,NULL,NULL,'3');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_WIDESLEEP','attack',668,5,10000,700,35000,'no','self','myhpinrate','51',60,NULL,NULL,NULL,NULL,NULL,'3');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_HELLPOWER','chase',683,1,10000,800,35000,'no','target','afterskill','668',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_HELLPOWER','attack',683,1,10000,800,35000,'no','target','afterskill','668',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_HELLJUDGEMENT','chase',662,5,10000,800,35000,'no','self','afterskill','683',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_HELLJUDGEMENT','attack',662,5,10000,800,35000,'no','self','afterskill','683',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#80% HP - Magic Combo
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@MG_STONECURSE','chase',16,10,10000,1000,20000,'no','target','myhpinrate','61',80,NULL,NULL,NULL,NULL,NULL,'2');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@MG_STONECURSE','attack',16,10,10000,1000,20000,'no','target','myhpinrate','61',80,NULL,NULL,NULL,NULL,NULL,'2');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@MG_FIREBOLT','chase',19,10,10000,300,20000,'no','target','afterskill','16',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@MG_FIREBOLT','attack',19,10,10000,300,20000,'no','target','afterskill','16',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@MG_FROSTDIVER','chase',15,40,10000,1000,20000,'no','target','afterskill','19',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@MG_FROSTDIVER','attack',15,40,10000,1000,20000,'no','target','afterskill','19',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@WZ_JUPITEL','chase',84,28,10000,1000,20000,'no','target','afterskill','15',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@WZ_JUPITEL','attack',84,28,10000,1000,20000,'no','target','afterskill','15',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@AL_TELEPORT','chase',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@AL_PNEUMA','idle',25,1,10000,0,1000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','45',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_CALLSLAVE','chase',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_TALK','chase',682,1,10000,0,600000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'1');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_SUMMONSLAVE','attack',196,4,10000,0,30000,'yes','self','slavele','1',1922,1923,1924,1925,NULL,NULL,'4');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_SUMMONSLAVE','chase',196,4,10000,0,30000,'yes','self','slavele','1',1922,1923,1924,1925,NULL,NULL,'4');
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_SUMMONSLAVE','idle',196,4,10000,0,30000,'yes','self','onspawn','0',1922,1923,1924,1925,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_SUMMONSLAVE','idle',196,4,10000,0,30000,'yes','self','slavele','1',1922,1923,1924,1925,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@SA_LANDPROTECTOR','attack',288,1,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1916,'Satan Morroc@NPC_SHIELDBRAKE','attack',346,10,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#5% HP - Dragon Fear
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_DRAGONFEAR','chase',659,10,10000,0,600000,'no','self','myhpltmaxrate','5',NULL,NULL,NULL,NULL,NULL,NULL,'17');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_DRAGONFEAR','attack',659,10,10000,0,600000,'no','self','myhpltmaxrate','5',NULL,NULL,NULL,NULL,NULL,NULL,'17');
#10% HP - Talk
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_TALK','chase',682,10,10000,0,600000,'no','self','myhpinrate','6',10,NULL,NULL,NULL,NULL,NULL,'16');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_TALK','attack',682,10,10000,0,600000,'no','self','myhpinrate','6',10,NULL,NULL,NULL,NULL,NULL,'16');
#30% HP - Earthquake Combo
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_WIDEHELLDIGNITY','chase',684,1,10000,2000,180000,'no','self','myhpinrate','11',30,NULL,NULL,NULL,NULL,NULL,'6');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_WIDEHELLDIGNITY','attack',684,1,10000,2000,180000,'no','self','myhpinrate','11',30,NULL,NULL,NULL,NULL,NULL,'6');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_WIDESTUN','chase',678,5,10000,1300,180000,'no','self','afterskill','684',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_WIDESTUN','attack',678,5,10000,1300,180000,'no','self','afterskill','684',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_EARTHQUAKE','chase',653,10,10000,2000,180000,'no','self','afterskill','678',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_EARTHQUAKE','attack',653,10,10000,2000,180000,'no','self','afterskill','678',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#40% HP - Mixed Combo
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_PULSESTRIKE','chase',661,5,10000,800,60000,'no','self','myhpinrate','31',40,NULL,NULL,NULL,NULL,NULL,'14');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_PULSESTRIKE','attack',661,5,10000,800,60000,'no','self','myhpinrate','31',40,NULL,NULL,NULL,NULL,NULL,'14');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_WIDESTONE','chase',666,5,10000,0,60000,'no','self','afterskill','661',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_WIDESTONE','attack',666,5,10000,0,60000,'no','self','afterskill','661',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@WZ_METEOR','chase',83,5,10000,800,60000,'no','target','afterskill','666',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@WZ_METEOR','attack',83,5,10000,800,60000,'no','target','afterskill','666',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#50% HP - Vampire Combo
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_VAMPIRE_GIFT','chase',679,9,10000,1000,50000,'no','self','myhpinrate','41',50,NULL,NULL,NULL,NULL,NULL,'15');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_VAMPIRE_GIFT','attack',679,9,10000,1000,50000,'no','self','myhpinrate','41',50,NULL,NULL,NULL,NULL,NULL,'15');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_WIDESOULDRAIN','chase',680,10,10000,1000,50000,'no','self','afterskill','679',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_WIDESOULDRAIN','attack',680,10,10000,1000,50000,'no','self','afterskill','679',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_EVILLAND','chase',670,10,10000,1000,50000,'no','target','afterskill','680',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_EVILLAND','attack',670,10,10000,1000,50000,'no','target','afterskill','680',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#60% HP - Hell Combo
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_WIDESLEEP','chase',668,5,10000,700,35000,'no','self','myhpinrate','51',60,NULL,NULL,NULL,NULL,NULL,'3');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_WIDESLEEP','attack',668,5,10000,700,35000,'no','self','myhpinrate','51',60,NULL,NULL,NULL,NULL,NULL,'3');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_HELLPOWER','chase',683,1,10000,800,35000,'no','target','afterskill','668',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_HELLPOWER','attack',683,1,10000,800,35000,'no','target','afterskill','668',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_HELLJUDGEMENT','chase',662,5,10000,800,35000,'no','self','afterskill','683',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_HELLJUDGEMENT','attack',662,5,10000,800,35000,'no','self','afterskill','683',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#80% HP - Magic Combo
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@MG_STONECURSE','chase',16,10,10000,1000,20000,'no','target','myhpinrate','61',80,NULL,NULL,NULL,NULL,NULL,'2');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@MG_STONECURSE','attack',16,10,10000,1000,20000,'no','target','myhpinrate','61',80,NULL,NULL,NULL,NULL,NULL,'2');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@MG_FIREBOLT','chase',19,10,10000,300,20000,'no','target','afterskill','16',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@MG_FIREBOLT','attack',19,10,10000,300,20000,'no','target','afterskill','16',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@MG_FROSTDIVER','chase',15,40,10000,1000,20000,'no','target','afterskill','19',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@MG_FROSTDIVER','attack',15,40,10000,1000,20000,'no','target','afterskill','19',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@WZ_JUPITEL','chase',84,28,10000,1000,20000,'no','target','afterskill','15',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@WZ_JUPITEL','attack',84,28,10000,1000,20000,'no','target','afterskill','15',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@AL_TELEPORT','chase',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@AL_PNEUMA','idle',25,1,10000,0,1000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','45',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_CALLSLAVE','chase',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_TALK','chase',682,1,10000,0,600000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'1');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_SUMMONSLAVE','attack',196,4,10000,0,30000,'yes','self','slavele','1',1922,1923,1924,1925,NULL,NULL,'4');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_SUMMONSLAVE','chase',196,4,10000,0,30000,'yes','self','slavele','1',1922,1923,1924,1925,NULL,NULL,'4');
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_SUMMONSLAVE','idle',196,4,10000,0,30000,'yes','self','onspawn','0',1922,1923,1924,1925,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_SUMMONSLAVE','idle',196,4,10000,0,30000,'yes','self','slavele','1',1922,1923,1924,1925,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@SA_LANDPROTECTOR','attack',288,1,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1917,'Wounded Morroc@NPC_SHIELDBRAKE','attack',346,10,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@AL_PNEUMA','idle',25,1,10000,0,1000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','45',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@AL_TELEPORT','chase',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@NPC_SLOWCAST','attack',672,5,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@NPC_PULSESTRIKE','chase',661,5,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@NPC_PULSESTRIKE','attack',661,5,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@NPC_MAGICMIRROR','chase',671,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@NPC_GRANDDARKNESS','attack',339,5,10000,2000,30000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@SA_DISPELL','chase',289,5,100,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@SA_DISPELL','attack',289,5,100,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@NPC_WIDECURSE','chase',677,5,5000,800,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1918,'Incarnation of Morroc@NPC_WIDECURSE','attack',677,5,5000,800,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1919,'Incarnation of Morroc@AL_PNEUMA','idle',25,1,10000,0,1000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1919,'Incarnation of Morroc@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','45',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1919,'Incarnation of Morroc@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1919,'Incarnation of Morroc@AL_TELEPORT','chase',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1919,'Incarnation of Morroc@NPC_BLOODDRAIN','attack',199,1,3000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1919,'Incarnation of Morroc@NPC_WIDEBLEEDING','chase',665,1,10000,500,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1919,'Incarnation of Morroc@NPC_WIDEBLEEDING','attack',665,1,10000,500,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1919,'Incarnation of Morroc@SM_MAGNUM','attack',7,25,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1919,'Incarnation of Morroc@NPC_EARTHQUAKE','attack',653,1,5000,5000,100000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1920,'Incarnation of Morroc@AL_PNEUMA','idle',25,1,10000,0,1000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1920,'Incarnation of Morroc@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','45',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1920,'Incarnation of Morroc@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1920,'Incarnation of Morroc@AL_TELEPORT','chase',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1920,'Incarnation of Morroc@NPC_CRITICALWOUND','attack',673,3,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1920,'Incarnation of Morroc@NPC_CRITICALWOUND','idle',673,3,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1920,'Incarnation of Morroc@NPC_CRITICALWOUND','chase',673,3,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1920,'Incarnation of Morroc@NPC_ENERGYDRAIN','chase',200,1,3000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1920,'Incarnation of Morroc@NPC_WIDESILENCE','chase',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1920,'Incarnation of Morroc@NPC_WIDESILENCE','attack',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@AL_PNEUMA','idle',25,1,10000,0,1000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','45',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@AL_TELEPORT','chase',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@AL_HEAL','idle',28,11,10000,500,0,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@AL_HEAL','chase',28,11,10000,500,0,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@AL_HEAL','attack',28,11,10000,500,0,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@AL_HEAL','attack',28,11,10000,500,0,'yes','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@HP_ASSUMPTIO','idle',361,5,5000,1000,5000,'no','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@HP_ASSUMPTIO','chase',361,5,5000,1000,10000,'no','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1921,'Incarnation of Morroc@HP_ASSUMPTIO','attack',361,5,5000,1000,10000,'no','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@NPC_EMOTION','idle',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@NPC_EMOTION','chase',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@NPC_EMOTION','attack',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@NPC_SLOWCAST','attack',672,5,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@NPC_PULSESTRIKE','chase',661,5,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@NPC_PULSESTRIKE','attack',661,5,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@KN_TWOHANDQUICKEN','chase',60,30,10000,800,60000,'no','self','myhpltmaxrate','45',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@KN_TWOHANDQUICKEN','attack',60,30,10000,800,60000,'no','self','myhpltmaxrate','45',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@NPC_MAGICMIRROR','chase',671,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@NPC_GRANDDARKNESS','attack',339,5,500,2000,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@NPC_EXPULSION','attack',674,1,100,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@SA_DISPELL','chase',289,5,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@SA_DISPELL','attack',289,5,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@WZ_VERMILION','chase',85,5,5000,700,25000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@WZ_VERMILION','attack',85,5,2000,700,25000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@WZ_JUPITEL','chase',84,5,5000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1922,'Incarnation of Morroc@WZ_JUPITEL','attack',84,5,3000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1923,'Incarnation of Morroc@NPC_EMOTION','idle',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1923,'Incarnation of Morroc@NPC_EMOTION','chase',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1923,'Incarnation of Morroc@NPC_EMOTION','attack',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1923,'Incarnation of Morroc@NPC_SUMMONSLAVE','chase',196,7,10000,1000,10000,'no','self','slavele','0',1937,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1923,'Incarnation of Morroc@NPC_SUMMONSLAVE','attack',196,7,10000,1000,10000,'no','self','slavele','0',1937,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1923,'Incarnation of Morroc@NPC_BLOODDRAIN','attack',199,1,3000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1923,'Incarnation of Morroc@NPC_WIDEBLEEDING','chase',665,2,10000,500,100000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1923,'Incarnation of Morroc@NPC_WIDEBLEEDING','attack',665,2,10000,500,100000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1923,'Incarnation of Morroc@NPC_EARTHQUAKE','attack',653,1,2000,700,100000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1923,'Incarnation of Morroc@SM_MAGNUM','attack',7,25,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1924,'Incarnation of Morroc@NPC_EMOTION','idle',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1924,'Incarnation of Morroc@NPC_EMOTION','chase',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1924,'Incarnation of Morroc@NPC_EMOTION','attack',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1924,'Incarnation of Morroc@NPC_CRITICALWOUND','attack',673,4,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1924,'Incarnation of Morroc@NPC_CRITICALWOUND','idle',673,4,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1924,'Incarnation of Morroc@NPC_CRITICALWOUND','chase',673,4,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1924,'Incarnation of Morroc@NPC_ENERGYDRAIN','chase',200,1,3000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1924,'Incarnation of Morroc@NPC_WIDESILENCE','chase',663,2,10000,1000,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1924,'Incarnation of Morroc@NPC_WIDESILENCE','attack',663,2,10000,1000,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1925,'Incarnation of Morroc@NPC_EMOTION','idle',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1925,'Incarnation of Morroc@NPC_EMOTION','chase',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1925,'Incarnation of Morroc@NPC_EMOTION','attack',197,1,10000,0,30000,'yes','self','always','0',9,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1925,'Incarnation of Morroc@HP_ASSUMPTIO','idle',361,5,5000,1000,5000,'yes','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1925,'Incarnation of Morroc@HP_ASSUMPTIO','chase',361,5,5000,1000,10000,'yes','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1925,'Incarnation of Morroc@HP_ASSUMPTIO','attack',361,5,5000,1000,10000,'yes','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1925,'Incarnation of Morroc@AL_HEAL','idle',28,11,10000,300,0,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1925,'Incarnation of Morroc@AL_HEAL','chase',28,11,10000,300,0,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1925,'Incarnation of Morroc@AL_HEAL','attack',28,11,10000,300,0,'yes','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1925,'Incarnation of Morroc@AL_HEAL','idle',28,11,10000,300,0,'yes','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1927,'Whisper@AS_CLOAKING','attack',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1927,'Whisper@AS_CLOAKING','idle',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1927,'Whisper@AS_CLOAKING','chase',135,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1927,'Whisper@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'28',NULL);

# Sealed Shrine (12.1)
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_TALK','chase',682,1,10000,0,6000000,'yes','target','myhpltmaxrate','2',NULL,NULL,NULL,NULL,NULL,NULL,'25');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_TALK','attack',682,1,10000,0,6000000,'yes','target','myhpltmaxrate','2',NULL,NULL,NULL,NULL,NULL,NULL,'25');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_TALK','chase',682,1,10000,0,6000000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'19');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_ALLHEAL','idle',687,1,3000,10000,10000,'no','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_ALLHEAL','walk',687,1,3000,10000,10000,'no','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@MO_BODYRELOCATION','chase',264,1,2000,200,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_DARKSTRIKE','chase',340,10,2000,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@AS_SONICBLOW','attack',136,5,500,0,20000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,'20');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_DARKNESSBREATH','attack',658,3,2000,800,5000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_EVILLAND','chase',670,10,10000,1000,50000,'no','target','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,NULL,'24');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_EVILLAND','attack',670,10,10000,1000,50000,'no','target','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,NULL,'24');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_HELLJUDGEMENT','chase',662,3,10000,800,15000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,'24');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_HELLJUDGEMENT','attack',662,3,10000,800,15000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,'22');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_SUMMONSLAVE','attack',196,6,10000,700,10000,'no','self','slavele','2',1431,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_SUMMONSLAVE','idle',196,6,10000,700,10000,'no','self','slavele','2',1431,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_INVINCIBLE','idle',685,1,10000,1000,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'19');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_INVINCIBLE','chase',685,1,10000,1000,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'19');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_INVINCIBLE','attack',685,1,10000,1000,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'19');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_PULSESTRIKE','chase',661,5,10000,2500,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'20');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_PULSESTRIKE','attack',661,5,10000,2500,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'21');
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@KN_BRANDISHSPEAR','chase',57,10,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@KN_BRANDISHSPEAR','attack',57,10,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_DARKBREATH','chase',202,1,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_DARKBREATH','attack',202,1,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@WZ_VERMILION','attack',85,21,2000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@WZ_VERMILION','chase',85,21,5000,500,10000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@WZ_VERMILION','chase',85,21,2000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1929,'Great Demon Baphomet@NPC_ALLHEAL','idle',687,1,10000,30000,30000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,'23');

# Fallacious Okolnir (12.1)
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@WZ_METEOR','idle',83,11,10000,300,0,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_WIDECURSE','chase',677,5,10000,700,35000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_WIDECURSE','attack',677,5,10000,700,35000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@MG_THUNDERSTORM','attack',21,9,2000,1500,10000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@MG_THUNDERSTORM','chase',21,9,2000,1500,10000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_HELLJUDGEMENT','chase',662,5,5000,800,35000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_HELLJUDGEMENT','attack',662,5,5000,800,35000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_DARKNESSBREATH','chase',658,2,500,800,5000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_DARKNESSBREATH','attack',658,2,500,800,5000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@WZ_VERMILION','attack',85,21,1000,1000,5000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@WZ_VERMILION','chase',85,21,2000,1000,5000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@AL_HEAL','chase',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@AL_HEAL','attack',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@MG_FROSTDIVER','chase',15,40,3000,1000,20000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@MG_FROSTDIVER','attack',15,40,3000,1000,20000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@WZ_JUPITEL','chase',84,28,5000,1000,20000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@WZ_JUPITEL','attack',84,28,5000,1000,20000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_CRITICALWOUND','attack',673,2,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_CRITICALWOUND','chase',673,2,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_COMBOATTACK','attack',171,1,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_CALLSLAVE','chase',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_SUMMONSLAVE','attack',196,3,10000,2000,60000000,'no','self','myhpltmaxrate','70',1947,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1930,'Piamette@NPC_SUMMONSLAVE','chase',196,3,10000,2000,60000000,'no','self','myhpltmaxrate','70',1947,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@WZ_METEOR','idle',83,11,10000,300,0,'yes','target','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@NPC_SUMMONSLAVE','attack',196,5,10000,2000,5000,'no','self','slavele','1',1933,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@NPC_SUMMONSLAVE','idle',196,5,10000,2000,5000,'no','self','slavele','1',1933,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@NPC_SUMMONSLAVE','chase',196,5,10000,2000,5000,'no','self','slavele','1',1933,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@NPC_CALLSLAVE','chase',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@NPC_AGIUP','attack',350,5,10000,0,100000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@NPC_AGIUP','chase',350,5,10000,0,100000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@NPC_PULSESTRIKE','attack',661,5,2000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@KN_TWOHANDQUICKEN','chase',60,30,10000,0,90000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@KN_TWOHANDQUICKEN','attack',60,30,10000,0,90000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@AS_SONICBLOW','attack',136,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@SA_DISPELL','attack',289,5,10000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@SA_DISPELL','chase',289,5,10000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@LK_SPIRALPIERCE','attack',397,1,2000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@NPC_HOLYATTACK','attack',189,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@CR_HOLYCROSS','attack',253,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@KN_BRANDISHSPEAR','attack',57,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@MG_THUNDERSTORM','attack',21,20,10000,1500,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@WZ_VERMILION','attack',85,21,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1931,'Wish Maiden@WZ_VERMILION','chase',85,21,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1932,'Garden Keeper@NPC_RUN','chase',354,1,10000,0,0,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1932,'Garden Keeper@NPC_RUN','attack',354,1,10000,0,0,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@NPC_HOLYATTACK','attack',189,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@NPC_HOLYATTACK','chase',189,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@MG_SAFETYWALL','attack',12,5,1000,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@WZ_JUPITEL','attack',84,4,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@WZ_JUPITEL','chase',84,4,1000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@AL_HEAL','chase',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@AL_HEAL','attack',28,9,10000,500,5000,'no','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@AL_HEAL','chase',28,9,10000,500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@AL_HEAL','attack',28,9,10000,500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@NPC_DARKBREATH','chase',202,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@NPC_DARKBREATH','attack',202,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@NPC_DARKCROSS','attack',338,5,2000,1500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@CR_REFLECTSHIELD','attack',252,3,10000,0,400000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1933,'Garden Watcher@CR_REFLECTSHIELD','chase',252,3,10000,0,400000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1937,'Constant@NPC_SELFDESTRUCTION','attack',173,1,10000,1000,0,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1937,'Constant@NPC_SELFDESTRUCTION','chase',173,1,2000,1000,0,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_WIDECURSE','chase',677,5,10000,700,35000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_WIDECURSE','attack',677,5,10000,700,35000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@MG_THUNDERSTORM','attack',21,9,2000,1500,10000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@MG_THUNDERSTORM','chase',21,9,2000,1500,10000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_HELLJUDGEMENT','chase',662,2,5000,800,35000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_HELLJUDGEMENT','attack',662,2,5000,800,35000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_DARKNESSBREATH','chase',658,2,500,800,5000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_DARKNESSBREATH','attack',658,2,500,800,5000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@WZ_VERMILION','attack',85,21,1000,1000,5000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@WZ_VERMILION','chase',85,21,2000,1000,5000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@AL_HEAL','chase',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@AL_HEAL','attack',28,9,10000,500,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@MG_FROSTDIVER','chase',15,40,3000,1000,20000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@MG_FROSTDIVER','attack',15,40,3000,1000,20000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@WZ_JUPITEL','chase',84,28,5000,1000,20000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@WZ_JUPITEL','attack',84,28,5000,1000,20000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_DARKBLESSING','attack',203,1,300,0,2000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_CRITICALWOUND','attack',673,2,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_CRITICALWOUND','chase',673,2,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@AL_HEAL','chase',28,11,10000,500,5000,'no','friend','friendhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@AL_HEAL','attack',28,11,10000,500,5000,'no','friend','friendhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@HP_ASSUMPTIO','idle',361,5,5000,1000,5000,'no','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@HP_ASSUMPTIO','chase',361,5,5000,1000,10000,'no','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@HP_ASSUMPTIO','attack',361,5,5000,1000,10000,'no','friend','friendhpltmaxrate','90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_WIDESILENCE','chase',663,5,3000,1000,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1947,'Piamette@NPC_WIDESILENCE','attack',663,5,3000,1000,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);

# Endless Tower (12.1)
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@KN_BRANDISHSPEAR','attack',57,3,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_AGIUP','attack',350,5,10000,0,25000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@KN_TWOHANDQUICKEN','attack',60,30,10000,0,120000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_HELLJUDGEMENT','chase',662,3,10000,1000,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_HELLJUDGEMENT','attack',662,3,10000,1000,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_WIDEFREEZE','attack',664,5,10000,0,20000,'yes','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_DARKSTRIKE','chase',340,10,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_HALLUCINATION','chase',207,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_SHIELDBRAKE','attack',346,10,200,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_WATERATTACK','chase',184,1,5000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_WATERATTACK','attack',184,1,5000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_FIREATTACK','chase',186,1,5000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_FIREATTACK','attack',186,1,5000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_STUNATTACK','chase',179,5,2000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_STUNATTACK','attack',179,2,2000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@ASC_BREAKER','chase',379,3,5000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@ASC_BREAKER','attack',379,3,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@WZ_METEOR','attack',83,11,2000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@WZ_METEOR','chase',83,11,2000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@WZ_STORMGUST','attack',89,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@WZ_STORMGUST','chase',89,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_WIDESILENCE','chase',663,5,3000,1000,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_WIDESILENCE','attack',663,5,3000,1000,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@WZ_STORMGUST','chase',89,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_SUMMONSLAVE','attack',196,4,10000,700,10000,'no','self','slavele','3',1605,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_SUMMONSLAVE','idle',196,4,10000,700,10000,'no','self','slavele','3',1605,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_SUMMONSLAVE','idle',196,4,10000,0,30000,'yes','self','onspawn','0',1605,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_ALLHEAL','idle',687,1,3000,10000,10000,'no','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1956,'Naght Sieger@NPC_ALLHEAL','walk',687,1,3000,10000,10000,'no','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@NPC_ALLHEAL','idle',687,1,3000,10000,10000,'no','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@NPC_ALLHEAL','walk',687,1,3000,10000,10000,'no','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@ASC_BREAKER','attack',379,5,500,1000,20000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@NPC_PULSESTRIKE','attack',661,5,10000,2500,30000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@NPC_EVILLAND','attack',670,4,10000,800,50000,'no','target','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@NPC_DARKSTRIKE','attack',340,10,2000,0,1000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@NPC_DARKNESSATTACK','attack',190,3,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@AC_SHOWER','attack',47,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@WZ_METEOR','attack',83,11,2000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@NPC_WIDECURSE','attack',677,5,5000,300,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@WZ_METEOR','idle',83,11,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@WZ_METEOR','idle',83,11,10000,0,0,'yes','target','skillused','89',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@WZ_METEOR','idle',83,11,10000,0,0,'yes','target','skillused','21',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@WZ_METEOR','idle',83,11,10000,0,0,'yes','target','skillused','28',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@WZ_METEOR','idle',83,11,10000,0,0,'yes','target','skillused','79',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@WZ_METEOR','idle',83,11,10000,0,0,'yes','target','skillused','83',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@WZ_METEOR','idle',83,11,10000,0,0,'yes','target','casttargeted','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@ML_DEFENDER','idle',8219,5,10000,0,180000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@ML_DEFENDER','attack',8219,5,10000,0,180000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1957,'Entweihen Crothen@NPC_ALLHEAL','idle',687,1,10000,30000,30000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1958,'Thorny Skeleton@SN_SHARPSHOOTING','attack',382,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1958,'Thorny Skeleton@AC_SHOWER','attack',47,3,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1958,'Thorny Skeleton@NPC_DEFENDER','idle',205,5,10000,0,180000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1958,'Thorny Skeleton@NPC_DEFENDER','attack',205,5,10000,0,180000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1959,'Thorn of Recovery@AL_HEAL','idle',28,11,10000,300,4000,'no','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1959,'Thorn of Recovery@AL_HEAL','attack',28,11,10000,300,2000,'no','friend','friendhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1959,'Thorn of Recovery@AL_HEAL','idle',28,11,10000,300,4000,'no','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1959,'Thorn of Recovery@NPC_DEFENDER','idle',205,5,10000,0,180000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1959,'Thorn of Recovery@NPC_DEFENDER','attack',205,5,10000,0,180000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@MG_THUNDERSTORM','attack',21,5,2000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@MG_FROSTDIVER','attack',15,9,10000,500,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@MG_LIGHTNINGBOLT','attack',20,7,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@MG_FIREBOLT','attack',19,7,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@MG_COLDBOLT','attack',14,7,10000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@MG_SOULSTRIKE','attack',13,9,5000,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@WZ_HEAVENDRIVE','attack',91,3,3000,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@NPC_DARKTHUNDER','attack',341,5,500,1500,15000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@WZ_STORMGUST','attack',89,5,500,1500,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@NPC_DEFENDER','idle',205,5,10000,0,180000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1960,'Thorn of Magic@NPC_DEFENDER','attack',205,5,10000,0,180000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1961,'Thorn of Purification@NPC_SLOWCAST','chase',672,5,10000,500,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1961,'Thorn of Purification@NPC_SLOWCAST','attack',672,5,10000,500,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1961,'Thorn of Purification@SA_DISPELL','chase',289,5,500,2000,40000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1961,'Thorn of Purification@SA_DISPELL','attack',289,5,500,2000,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1961,'Thorn of Purification@NPC_DEFENDER','idle',205,5,10000,0,180000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1961,'Thorn of Purification@NPC_DEFENDER','attack',205,5,10000,0,180000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);

# Guild Dungeon SE (13.1)
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_CURSEATTACK','chase',181,1,1000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_WIDECURSE','attack',677,1,500,800,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_CRITICALWOUND','attack',673,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_DARKSTRIKE','chase',340,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_DARKSTRIKE','attack',340,9,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_VAMPIRE_GIFT','attack',679,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_DARKNESSATTACK','attack',190,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_EVILLAND','attack',670,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_EMOTION','chase',197,1,1000,0,5000,'yes','self','always','0',7,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',NULL,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1974,'Banshee Master@NPC_SUMMONSLAVE','idle',196,2,10000,0,0,'no','self','onspawn','0',1868,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1975,'Beholder Master@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1975,'Beholder Master@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'52',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1975,'Beholder Master@WZ_JUPITEL','chase',84,4,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1975,'Beholder Master@NPC_MENTALBREAKER','attack',159,3,200,800,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'39',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1975,'Beholder Master@NPC_MENTALBREAKER','chase',159,3,200,800,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'39',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1975,'Beholder Master@NPC_PETRIFYATTACK','attack',180,3,200,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1975,'Beholder Master@NPC_PETRIFYATTACK','chase',180,3,200,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1975,'Beholder Master@SA_DISPELL','attack',289,1,100,1000,100000,'yes','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1975,'Beholder Master@NPC_SUMMONSLAVE','idle',196,2,10000,0,0,'no','self','onspawn','0',1774,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1976,'Cobalt Mineral@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1976,'Cobalt Mineral@CR_REFLECTSHIELD','attack',252,2,1000,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1976,'Cobalt Mineral@NPC_RANDOMATTACK','attack',183,2,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1976,'Cobalt Mineral@NPC_BARRIER','attack',204,1,500,3000,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1976,'Cobalt Mineral@NPC_SPLASHATTACK','attack',174,1,500,0,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1976,'Cobalt Mineral@TF_HIDING','attack',51,1,500,500,50000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1976,'Cobalt Mineral@TF_HIDING','idle',51,1,500,500,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1977,'Heavy Metaling@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1977,'Heavy Metaling@CR_REFLECTSHIELD','attack',252,3,1000,0,200000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1977,'Heavy Metaling@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1977,'Heavy Metaling@CR_AUTOGUARD','chase',249,5,500,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1977,'Heavy Metaling@RG_STRIPWEAPON','attack',215,3,500,0,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1977,'Heavy Metaling@RG_STRIPARMOR','attack',217,3,500,0,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1977,'Heavy Metaling@MC_MAMMONITE','attack',42,5,1000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1978,'Hell Apocalips@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1978,'Hell Apocalips@KN_BRANDISHSPEAR','attack',57,5,1000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1978,'Hell Apocalips@NPC_DARKTHUNDER','attack',341,4,1000,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1978,'Hell Apocalips@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1978,'Hell Apocalips@NPC_SELFDESTRUCTION','attack',173,1,1000,2000,5000,'no','self','myhpltmaxrate','10',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1978,'Hell Apocalips@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1978,'Hell Apocalips@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1978,'Hell Apocalips@NPC_SUMMONSLAVE','idle',196,2,10000,0,0,'no','self','onspawn','0',1365,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1979,'Zukadam@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1979,'Zukadam@NPC_PIERCINGATT','attack',158,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1979,'Zukadam@NPC_GUIDEDATTACK','attack',172,2,500,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1979,'Zukadam@KN_SPEARSTAB','attack',58,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1979,'Zukadam@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1979,'Zukadam@NPC_RANDOMATTACK','attack',183,5,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1979,'Zukadam@NPC_SUMMONSLAVE','idle',196,2,10000,0,0,'no','self','onspawn','0',1668,NULL,NULL,NULL,NULL,NULL,NULL);

# Memory of Orc Dungeon (13.1)
REPLACE INTO `mob_skill_db_re` VALUES (1981,'Safeguard Chief@SM_BASH','attack',5,10,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1981,'Safeguard Chief@SM_BASH','chase',5,10,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1981,'Safeguard Chief@NPC_DARKNESSATTACK','attack',190,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1981,'Safeguard Chief@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',0,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1981,'Safeguard Chief@SM_MAGNUM','attack',7,7,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1981,'Safeguard Chief@CR_AUTOGUARD','chase',249,5,500,0,300000,'yes','self','longrangeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1981,'Safeguard Chief@NPC_PULSESTRIKE','chase',661,2,2000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1981,'Safeguard Chief@NPC_PULSESTRIKE','attack',661,2,500,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1982,'Orc Sniper@NPC_EMOTION','attack',197,1,100,0,60000,'yes','self','myhpltmaxrate','60',6,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1982,'Orc Sniper@AC_SHOWER','attack',47,5,2000,1000,5000,'no','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1982,'Orc Sniper@AC_DOUBLE','attack',46,1,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1983,'Depraved Orc Spirit@NPC_CURSEATTACK','chase',181,1,1000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1983,'Depraved Orc Spirit@NPC_WIDECURSE','attack',677,1,500,800,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1983,'Depraved Orc Spirit@NPC_CRITICALWOUND','attack',673,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1984,'Shaman Cargalache@WZ_QUAGMIRE','chase',92,5,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1984,'Shaman Cargalache@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',3,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1984,'Shaman Cargalache@NPC_EVILLAND','attack',670,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

# New World (13.1)
REPLACE INTO `mob_skill_db_re` VALUES (1985,'Dandelion@NPC_CHANGEUNDEAD','attack',348,1,3000,500,600000,'no','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1985,'Dandelion@NPC_CHANGEUNDEAD','chase',348,1,3000,500,600000,'no','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1985,'Dandelion@NPC_COMBOATTACK','attack',171,1,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1986,'Tatacho@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1986,'Tatacho@BS_HAMMERFALL','attack',110,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1986,'Tatacho@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1986,'Tatacho@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1986,'Tatacho@NPC_STUNATTACK','attack',179,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1986,'Tatacho@HW_GANBANTEIN','attack',483,1,2000,0,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1987,'Centipede@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1987,'Centipede@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1987,'Centipede@AS_VENOMDUST','attack',140,1,500,1500,5000,'no','around1','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1987,'Centipede@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1987,'Centipede@NPC_POISONATTACK','attack',188,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1987,'Centipede@NPC_COMBOATTACK','attack',171,1,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1987,'Centipede@WZ_QUAGMIRE','chase',92,5,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1987,'Centipede@HW_GANBANTEIN','attack',483,1,3000,0,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1987,'Centipede@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1987,'Centipede@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1988,'Nepenthes@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1988,'Nepenthes@NPC_ENERGYDRAIN','attack',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1988,'Nepenthes@NPC_ENERGYDRAIN','chase',200,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1988,'Nepenthes@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1988,'Nepenthes@NPC_POISONATTACK','attack',188,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1989,'Hillsrion@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1989,'Hillsrion@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1989,'Hillsrion@SM_PROVOKE','chase',6,3,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1989,'Hillsrion@SM_PROVOKE','attack',6,3,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1989,'Hillsrion@NPC_CRITICALWOUND','chase',673,2,2000,500,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1989,'Hillsrion@NPC_CRITICALWOUND','attack',673,2,2000,700,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1989,'Hillsrion@NPC_CRITICALSLASH','chase',170,1,500,300,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1989,'Hillsrion@NPC_CRITICALSLASH','attack',170,1,500,800,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1989,'Hillsrion@NPC_COMBOATTACK','attack',171,3,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_STONESKIN','idle',675,3,10000,0,30000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_STONESKIN','chase',675,3,10000,0,30000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_STONESKIN','attack',675,3,10000,0,30000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_SUMMONSLAVE','idle',196,3,10000,0,30000,'yes','self','slavele','0',1997,1997,1997,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_SUMMONSLAVE','chase',196,3,10000,0,30000,'yes','self','slavele','0',1997,1997,1997,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_SUMMONSLAVE','attack',196,3,10000,0,30000,'yes','self','slavele','0',1997,1997,1997,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','always','0',7,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_EMOTION','attack',197,1,1000,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@WZ_WATERBALL','attack',86,10,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@LK_SPIRALPIERCE','attack',397,1,500,3000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@KN_TWOHANDQUICKEN','attack',60,30,10000,0,120000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_WIDESTUN','chase',678,1,500,300,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_WIDESTUN','attack',678,1,500,800,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@SM_PROVOKE','chase',6,10,500,600,120000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@SM_PROVOKE','attack',6,10,500,600,120000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_CRITICALWOUND','chase',673,2,2000,500,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_CRITICALWOUND','attack',673,2,2000,700,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@WZ_EARTHSPIKE','attack',90,3,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_DRAGONFEAR','attack',659,2,500,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_EARTHQUAKE','chase',653,2,10000,2000,30000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_EARTHQUAKE','attack',653,2,10000,2000,30000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@HW_GANBANTEIN','attack',483,1,3000,0,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1990,'Hardrock Mammoth@NPC_ALLHEAL','idle',687,1,10000,30000,30000,'yes','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@SM_PROVOKE','chase',6,10,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@SM_PROVOKE','attack',6,10,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_EMOTION','chase',197,1,10000,0,5000,'yes','self','always','0',7,0x3695,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_EMOTION','attack',197,1,1000,0,10000,'yes','self','always','0',19,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_CRITICALWOUND','chase',673,2,2000,500,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_CRITICALWOUND','attack',673,2,2000,700,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@MO_BODYRELOCATION','chase',264,1,2000,200,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_WIDESLEEP','chase',668,1,500,300,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_WIDESLEEP','attack',668,1,500,800,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_WIDEBLEEDING','attack',665,1,10000,500,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_WIDEBLEEDING','chase',665,1,10000,500,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@SM_MAGNUM','attack',7,5,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@WZ_EARTHSPIKE','attack',90,3,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_CRITICALSLASH','chase',170,1,500,300,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_CRITICALSLASH','attack',170,1,500,800,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_COMBOATTACK','attack',171,3,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@HW_GANBANTEIN','attack',483,1,3000,0,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@AS_SONICBLOW','attack',136,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_DRAGONFEAR','attack',659,2,500,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_GROUNDATTACK','attack',185,4,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'21',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@PF_SPIDERWEB','attack',405,1,3000,0,10000,'yes','target','always','0',NULL,0x38A5,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1991,'Tendrilion@NPC_ALLHEAL','idle',687,1,10000,30000,30000,'yes','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@CR_REFLECTSHIELD','idle',252,5,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@CR_REFLECTSHIELD','chase',252,5,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@CR_REFLECTSHIELD','attack',252,5,10000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@SM_PROVOKE','chase',6,3,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@SM_PROVOKE','attack',6,3,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@NPC_CRITICALWOUND','chase',673,2,2000,500,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@NPC_CRITICALWOUND','attack',673,2,2000,700,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@NPC_CRITICALSLASH','chase',170,1,500,300,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@NPC_CRITICALSLASH','attack',170,1,500,800,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@NPC_COMBOATTACK','attack',171,3,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@NPC_PULSESTRIKE','attack',661,3,1000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@NPC_ALLHEAL','idle',687,1,10000,1500,5000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@NPC_ALLHEAL','chase',687,1,10000,1500,5000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1992,'Cornus@NPC_ALLHEAL','attack',687,1,10000,1500,5000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1993,'Naga@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1993,'Naga@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1993,'Naga@KN_SPEARBOOMERANG','chase',59,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1993,'Naga@KN_PIERCE','attack',56,10,1000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1993,'Naga@KN_BRANDISHSPEAR','attack',57,5,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1993,'Naga@SM_PROVOKE','chase',6,3,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1993,'Naga@SM_PROVOKE','attack',6,3,2000,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1993,'Naga@WZ_WATERBALL','attack',86,9,1000,0,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1994,'Luciola Vespa@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1994,'Luciola Vespa@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1994,'Luciola Vespa@NPC_PIERCINGATT','attack',158,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1994,'Luciola Vespa@NPC_POISONATTACK','attack',188,2,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1994,'Luciola Vespa@NPC_PULSESTRIKE','attack',661,2,1000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1994,'Luciola Vespa@NPC_COMBOATTACK','attack',171,1,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1995,'Pinguicula@AL_HEAL','idle',28,9,10000,3000,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1995,'Pinguicula@AL_HEAL','idle',28,9,5000,500,5000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1995,'Pinguicula@NPC_SPLASHATTACK','attack',174,1,3000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1995,'Pinguicula@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1995,'Pinguicula@NPC_STUNATTACK','attack',179,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1995,'Pinguicula@NPC_SLEEPATTACK','attack',182,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1995,'Pinguicula@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1995,'Pinguicula@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1995,'Pinguicula@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@NPC_INVISIBLE','chase',353,1,2000,1000,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@PR_SANCTUARY','attack',70,10,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@HP_ASSUMPTIO','idle',361,5,10000,500,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@HP_ASSUMPTIO','chase',361,5,10000,500,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@HP_ASSUMPTIO','attack',361,5,10000,500,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@WZ_WATERBALL','chase',86,3,2000,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@WZ_WATERBALL','attack',86,5,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@NPC_STOP','attack',342,1,2000,500,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@AL_TELEPORT','idle',26,1,1000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@NPC_SUMMONSLAVE','idle',196,1,10000,0,5000,'yes','self','slavele','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@NPC_SUMMONSLAVE','attack',196,1,10000,0,5000,'yes','self','slavele','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (1996,'Bacsojin@NPC_SUMMONSLAVE','chase',196,1,10000,0,5000,'yes','self','slavele','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1997,'Tatacho@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1997,'Tatacho@BS_HAMMERFALL','attack',110,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1997,'Tatacho@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1997,'Tatacho@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1997,'Tatacho@NPC_STUNATTACK','attack',179,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1997,'Tatacho@HW_GANBANTEIN','attack',483,1,2000,0,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1998,'Hillsrion@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1998,'Hillsrion@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1998,'Hillsrion@SM_PROVOKE','chase',6,3,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1998,'Hillsrion@SM_PROVOKE','attack',6,3,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1998,'Hillsrion@NPC_CRITICALWOUND','chase',673,2,2000,500,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1998,'Hillsrion@NPC_CRITICALWOUND','attack',673,2,2000,700,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1998,'Hillsrion@NPC_CRITICALSLASH','chase',170,1,500,300,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1998,'Hillsrion@NPC_CRITICALSLASH','attack',170,1,500,800,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1998,'Hillsrion@NPC_COMBOATTACK','attack',171,3,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1999,'Centipede Larva@AS_VENOMDUST','attack',140,1,500,1500,5000,'no','around1','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1999,'Centipede Larva@NPC_POISON','attack',176,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1999,'Centipede Larva@NPC_POISONATTACK','attack',188,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (1999,'Centipede Larva@NPC_COMBOATTACK','attack',171,1,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
#
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@AL_TELEPORT','chase',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@AL_HEAL','idle',28,9,10000,0,2000,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_CALLSLAVE','attack',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_CALLSLAVE','chase',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_CALLSLAVE','idle',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_SUMMONSLAVE','attack',196,1,10000,0,10000,'yes','self','slavele','5',2010,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_SUMMONSLAVE','chase',196,1,10000,0,10000,'yes','self','slavele','5',2010,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_SUMMONSLAVE','idle',196,6,10000,0,10000,'yes','self','slavele','5',2010,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_METAMORPHOSIS','chase',193,6,10000,5000,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_METAMORPHOSIS','attack',193,6,10000,5000,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_SHIELDBRAKE','attack',346,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@LK_SPIRALPIERCE','attack',397,5,2000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_CRITICALWOUND','attack',673,3,2000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_PULSESTRIKE','attack',661,5,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_WIDESLEEP','attack',668,5,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_WIDESILENCE','attack',663,5,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_HELLJUDGEMENT','attack',662,5,10000,700,15000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_HELLJUDGEMENT','chase',662,5,10000,700,15000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_EXPULSION','attack',674,1,100,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_VAMPIRE_GIFT','attack',679,10,10000,1000,10000,'no','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2008,'Woomawang@NPC_AGIUP','chase',350,5,10000,0,30000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@AL_TELEPORT','chase',26,1,5000,0,5000,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_RUN','attack',354,10,10000,0,0,'yes','self','myhpltmaxrate','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_RUN','chase',354,10,10000,0,0,'yes','self','myhpltmaxrate','1',NULL,NULL,NULL,NULL,NULL,'26',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@AL_HEAL','idle',28,9,10000,0,2000,'yes','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_CALLSLAVE','attack',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_CALLSLAVE','chase',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_CALLSLAVE','idle',352,1,10000,0,15000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_SUMMONSLAVE','attack',196,6,10000,0,10000,'yes','self','slavele','5',2010,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_SUMMONSLAVE','chase',196,6,10000,0,10000,'yes','self','slavele','5',2010,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_SUMMONSLAVE','idle',196,6,10000,0,10000,'yes','self','slavele','5',2010,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_STONESKIN','chase',675,4,10000,1000,30000,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_STONESKIN','attack',675,4,10000,1000,30000,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_EVILLAND','attack',670,10,10000,0,15000,'yes','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@SA_LANDPROTECTOR','attack',288,5,10000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_CRITICALWOUND','attack',673,3,2000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_SHIELDBRAKE','attack',346,10,2000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_SLOWCAST','attack',672,5,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_MAGICMIRROR','attack',671,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_EXPULSION','attack',674,1,50,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_WIDESTONE','attack',666,5,10000,500,15000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_WIDESTONE','chase',666,5,10000,500,15000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@LK_SPIRALPIERCE','attack',397,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_PULSESTRIKE','attack',661,5,10000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_HELLJUDGEMENT','chase',662,2,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_HELLJUDGEMENT','attack',662,2,2000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_ACIDBREATH','attack',657,1,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_ACIDBREATH','chase',657,1,2000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_VAMPIRE_GIFT','attack',679,1,1000,500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'47',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2009,'Woomawang@NPC_WIDESOULDRAIN','attack',680,7,1000,500,5000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'42',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2010,'Majoruros@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2010,'Majoruros@BS_HAMMERFALL','attack',110,5,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2010,'Majoruros@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2010,'Majoruros@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2010,'Majoruros@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2010,'Majoruros@NPC_SUMMONSLAVE','idle',196,1,10000,2000,60000,'no','self','slavele','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2010,'Majoruros@WZ_HEAVENDRIVE','attack',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2010,'Majoruros@WZ_HEAVENDRIVE','chase',91,5,500,1200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);

# Into the Unknown (13.2)
REPLACE INTO `mob_skill_db_re` VALUES (2013,'Draco@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',32,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2013,'Draco@SM_PROVOKE','chase',6,10,2000,600,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'44',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2013,'Draco@TF_THROWSTONE','chase',152,1,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2013,'Draco@NPC_GROUNDATTACK','attack',185,5,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2013,'Draco@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2013,'Draco@NPC_PIERCINGATT','attack',158,5,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2013,'Draco@NPC_FIREBREATH','attack',654,3,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2014,'Draco Egg@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',19,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2014,'Draco Egg@NPC_METAMORPHOSIS','idle',193,1,10,2000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2015,'Dark Pinguicula@AL_HEAL','idle',28,9,10000,3000,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2015,'Dark Pinguicula@AL_HEAL','idle',28,9,5000,500,5000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2015,'Dark Pinguicula@NPC_BLOODDRAIN','attack',199,1,5000,500,5000,'yes','target','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2015,'Dark Pinguicula@NPC_SPLASHATTACK','attack',174,1,3000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2015,'Dark Pinguicula@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2015,'Dark Pinguicula@NPC_STUNATTACK','attack',179,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2015,'Dark Pinguicula@NPC_SLEEPATTACK','attack',182,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2015,'Dark Pinguicula@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2015,'Dark Pinguicula@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2015,'Dark Pinguicula@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2016,'Aqua Elemental@MG_FROSTDIVER','chase',15,9,10000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2016,'Aqua Elemental@WZ_WATERBALL','attack',86,4,2000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2016,'Aqua Elemental@NPC_SLEEPATTACK','attack',182,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2016,'Aqua Elemental@MG_COLDBOLT','attack',14,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2016,'Aqua Elemental@NPC_SLOWCAST','attack',672,2,1000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2016,'Aqua Elemental@WZ_FROSTNOVA','attack',88,10,10000,1500,20000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@KN_AUTOCOUNTER','attack',61,5,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@WZ_JUPITEL','chase',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@TF_THROWSTONE','chase',152,1,5000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@MO_BODYRELOCATION','chase',264,1,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@NPC_DARKSTRIKE','chase',340,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@NPC_DARKSTRIKE','attack',340,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@NPC_ARMORBRAKE','attack',344,3,2000,0,5000,'yes','target','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@WZ_EARTHSPIKE','attack',90,5,3000,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@NPC_PIERCINGATT','attack',158,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@SM_MAGNUM','attack',7,25,500,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@NPC_CURSEATTACK','attack',181,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'24',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2017,'Rata@ASC_METEORASSAULT','attack',406,2,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@NPC_CURSEATTACK','chase',181,1,1000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@NPC_CRITICALWOUND','attack',673,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@NPC_DARKSTRIKE','chase',340,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@NPC_DARKSTRIKE','attack',340,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@PF_SPIDERWEB','chase',405,1,3000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@NPC_BLINDATTACK','chase',177,3,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@NPC_MAGICALATTACK','attack',192,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@NPC_UNDEADATTACK','attack',347,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@KN_TWOHANDQUICKEN','attack',60,5,500,0,300000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@WZ_JUPITEL','attack',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@WZ_JUPITEL','chase',84,3,500,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@MG_THUNDERSTORM','attack',21,5,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@MG_THUNDERSTORM','chase',21,5,1000,1500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@AL_HEAL','attack',28,5,5000,500,5000,'yes','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@AL_HEAL','idle',28,5,10000,500,5000,'yes','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@AL_HEAL','chase',28,5,10000,500,5000,'yes','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2018,'Duneyrr@AS_SONICBLOW','attack',136,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2019,'Ancient Tree@AL_HEAL','idle',28,1,2000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2019,'Ancient Tree@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2019,'Ancient Tree@NPC_STUNATTACK','attack',179,2,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2019,'Ancient Tree@NPC_PIERCINGATT','attack',158,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);

REPLACE INTO `mob_skill_db_re` VALUES (2024,'Bradium Golem@NPC_STUNATTACK','attack',179,4,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2024,'Bradium Golem@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2024,'Bradium Golem@NPC_EMOTION_ON','attack',474,1,10000,0,30000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2024,'Bradium Golem@NPC_EMOTION','idle',197,1,200,0,30000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2024,'Bradium Golem@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2024,'Bradium Golem@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2020,'Rhyncho@MO_BODYRELOCATION','chase',264,1,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2020,'Rhyncho@NPC_STUNATTACK','attack',179,5,500,1000,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2020,'Rhyncho@NPC_CRITICALSLASH','attack',170,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2020,'Rhyncho@NPC_HALLUCINATION','chase',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2020,'Rhyncho@NPC_HALLUCINATION','attack',207,1,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2021,'Phylla@PR_LEXDIVINA','chase',76,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2021,'Phylla@MG_COLDBOLT','attack',14,3,3000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2021,'Phylla@NPC_WATERATTACK','attack',184,1,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2021,'Phylla@WZ_WATERBALL','attack',86,3,2000,100,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_ALLHEAL','idle',687,1,3000,10000,10000,'no','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_ALLHEAL','walk',687,1,3000,10000,10000,'no','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',2027,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',2027,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','onspawn','0',2027,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_MAGICMIRROR','idle',671,3,10000,0,120000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_MAGICMIRROR','chase',671,3,10000,0,120000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_MAGICMIRROR','attack',671,3,10000,0,120000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_STONESKIN','chase',675,3,10000,2500,300000,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,'34');
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_STONESKIN','attack',675,3,10000,2500,300000,'no','self','myhpltmaxrate','3',NULL,NULL,NULL,NULL,NULL,NULL,'34');
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_POWERUP','attack',349,5,6000,0,60000,'yes','self','myhpltmaxrate','15',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_EVILLAND','attack',670,4,500,0,25000,'yes','target','myhpltmaxrate','15',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@WZ_QUAGMIRE','chase',92,5,10000,700,5000,'no','target','myhpltmaxrate','28',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@WZ_QUAGMIRE','attack',92,5,10000,700,120000,'no','target','myhpltmaxrate','28',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_EARTHQUAKE','chase',653,2,10000,10000,180000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_EARTHQUAKE','attack',653,2,10000,10000,180000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_INVISIBLE','idle',353,1,2000,200,5000,'no','target','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_INVISIBLE','chase',353,1,2000,200,5000,'no','target','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_WIDESTONE','chase',666,5,10000,0,60000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_WIDESTONE','attack',666,5,10000,0,60000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_EVILLAND','idle',670,10,500,0,120000,'yes','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_EVILLAND','chase',670,10,500,0,120000,'yes','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_HELLJUDGEMENT','chase',662,2,10000,7000,25000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,'32');
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_HELLJUDGEMENT','attack',662,2,10000,7000,25000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,'32');
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_DARKNESSBREATH','attack',658,10,10000,800,35000,'no','target','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_SLOWCAST','attack',672,5,10000,0,60000,'yes','self','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_CRITICALWOUND','attack',673,3,2000,0,30000,'yes','target','myhpltmaxrate','70',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_WIDECURSE','chase',677,5,10000,1000,25000,'no','self','myhpltmaxrate','75',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_WIDECURSE','attack',677,5,10000,1000,25000,'no','self','myhpltmaxrate','75',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_FIREBREATH','attack',654,5,10000,800,15000,'no','target','myhpltmaxrate','75',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_WIDESLEEP','chase',668,5,10000,3000,20000,'no','self','myhpltmaxrate','95',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_WIDESLEEP','attack',668,5,30000,1000,20000,'no','self','myhpltmaxrate','95',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_CRITICALSLASH','attack',170,1,1000,0,5000,'yes','target','myhpltmaxrate','95',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@MG_FIREBALL','chase',17,5,10000,0,30000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_DRAGONFEAR','chase',659,5,10000,0,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_DRAGONFEAR','attack',659,5,2000,1000,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@WZ_METEOR','attack',83,11,2000,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@SA_DISPELL','attack',289,5,10000,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_PULSESTRIKE','attack',661,5,2000,10000,40000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'31');
REPLACE INTO `mob_skill_db_re` VALUES (2022,'Nidhoggr\'s Shadow@NPC_ALLHEAL','idle',687,1,10000,120000,30000,'yes','self','myhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'20',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2023,'Dark Shadow@NPC_DARKSTRIKE','chase',340,2,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2023,'Dark Shadow@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2023,'Dark Shadow@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2023,'Dark Shadow@NPC_DARKNESSBREATH','attack',658,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

REPLACE INTO `mob_skill_db_re` VALUES (2026,'Dandelion@NPC_BLINDATTACK','attack',177,2,1000,0,6000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,'29');
REPLACE INTO `mob_skill_db_re` VALUES (2026,'Dandelion@NPC_POISON','attack',176,3,1000,500,60000,'no','target','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2026,'Dandelion@NPC_COMBOATTACK','attack',171,1,3000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'27');
REPLACE INTO `mob_skill_db_re` VALUES (2026,'Dandelion@TF_SPRINKLESAND','attack',149,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,'28');

REPLACE INTO `mob_skill_db_re` VALUES (2027,'Dark Shadow@NPC_DARKSTRIKE','chase',340,2,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2027,'Dark Shadow@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2027,'Dark Shadow@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2027,'Dark Shadow@NPC_DARKNESSBREATH','attack',658,1,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

#****
# NC Mechanic Summons
REPLACE INTO `mob_skill_db_re` VALUES (2042,'Silver Sniper@AL_HEAL','chase',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2042,'Silver Sniper@AL_HEAL','idle',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2042,'Silver Sniper@AL_HEAL','attack',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2042,'Silver Sniper@NPC_REVENGE','idle',333,1,10000,0,0,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2043,'Magic Decoy Fire@MG_FIREBOLT','attack',19,10,10000,800,3500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2043,'Magic Decoy Fire@MG_FIREBOLT','chase',19,10,10000,800,3500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2043,'Magic Decoy Fire@AL_HEAL','chase',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2043,'Magic Decoy Fire@AL_HEAL','idle',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2043,'Magic Decoy Fire@AL_HEAL','attack',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2044,'Magic Decoy Water@MG_COLDBOLT','attack',14,10,10000,800,3500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2044,'Magic Decoy Water@MG_COLDBOLT','chase',14,10,10000,800,3500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2044,'Magic Decoy Water@AL_HEAL','chase',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2044,'Magic Decoy Water@AL_HEAL','idle',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2044,'Magic Decoy Water@AL_HEAL','attack',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2045,'Magic Decoy Earth@WZ_EARTHSPIKE','attack',90,10,10000,800,3500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2045,'Magic Decoy Earth@WZ_EARTHSPIKE','chase',90,10,10000,800,3500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2045,'Magic Decoy Earth@AL_HEAL','chase',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2045,'Magic Decoy Earth@AL_HEAL','idle',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2045,'Magic Decoy Earth@AL_HEAL','attack',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2046,'Magic Decoy Wind@MG_LIGHTNINGBOLT','attack',20,10,10000,800,3500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2046,'Magic Decoy Wind@MG_LIGHTNINGBOLT','chase',20,10,10000,800,3500,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2046,'Magic Decoy Wind@AL_HEAL','chase',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2046,'Magic Decoy Wind@AL_HEAL','idle',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2046,'Magic Decoy Wind@AL_HEAL','attack',28,10,10000,0,1000,'no','self','myhpltmaxrate','99',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

#REPLACE INTO `mob_skill_db_re` VALUES (2053,'Dimik@NPC_ATTRICHANGE','idle',161,1,500,2000,50000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'10',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (2053,'Dimik@NPC_EMOTION_ON','idle',474,1,100,0,60000,'yes','self','always','0',20,0x81,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (2053,'Dimik@NPC_EMOTION','idle',197,1,100,0,60000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (2053,'Dimik@NPC_EMOTION','attack',197,1,10000,0,60000,'yes','self','always','0',6,NULL,NULL,NULL,NULL,NULL,NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (2053,'Dimik@NPC_EMOTION_ON','idle',474,1,100,0,60000,'yes','self','always','0',22,0xC3,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2048,'Dark Pinguicula@AL_HEAL','idle',28,9,10000,3000,5000,'yes','friend','friendhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2048,'Dark Pinguicula@AL_HEAL','idle',28,9,5000,500,5000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2048,'Dark Pinguicula@NPC_BLOODDRAIN','attack',199,1,5000,500,5000,'yes','target','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2048,'Dark Pinguicula@NPC_SPLASHATTACK','attack',174,1,3000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2048,'Dark Pinguicula@NPC_GROUNDATTACK','attack',185,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2048,'Dark Pinguicula@NPC_STUNATTACK','attack',179,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2048,'Dark Pinguicula@NPC_SLEEPATTACK','attack',182,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2048,'Dark Pinguicula@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2048,'Dark Pinguicula@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2048,'Dark Pinguicula@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2050,'Aqua Elemental@MG_FROSTDIVER','chase',15,9,10000,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2050,'Aqua Elemental@WZ_WATERBALL','attack',86,4,2000,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2050,'Aqua Elemental@NPC_SLEEPATTACK','attack',182,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2050,'Aqua Elemental@MG_COLDBOLT','attack',14,3,1000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2050,'Aqua Elemental@NPC_SLOWCAST','attack',672,2,1000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2050,'Aqua Elemental@WZ_FROSTNOVA','attack',88,10,10000,1500,20000,'no','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2049,'Bradium Golem@NPC_STUNATTACK','attack',179,4,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2049,'Bradium Golem@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2049,'Bradium Golem@NPC_EMOTION_ON','attack',474,1,10000,0,30000,'yes','self','always','0',6,0x3885,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2049,'Bradium Golem@NPC_EMOTION','idle',197,1,200,0,30000,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2049,'Bradium Golem@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2049,'Bradium Golem@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2047,'Naga@KN_SPEARBOOMERANG','chase',59,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2047,'Naga@KN_BRANDISHSPEAR','attack',57,5,500,1000,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2047,'Naga@SM_PROVOKE','chase',6,3,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2047,'Naga@SM_PROVOKE','attack',6,3,500,600,5000,'yes','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2047,'Naga@HW_GANBANTEIN','attack',483,1,2000,0,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@MG_FIREWALL','chase',18,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@NPC_HELLJUDGEMENT','chase',662,5,10000,800,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@NPC_HELLJUDGEMENT','attack',662,5,10000,800,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@NPC_DARKBLESSING','attack',203,1,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@NPC_HELMBRAKE','attack',345,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@NPC_SUMMONSLAVE','attack',196,2,10000,700,10000,'no','self','slavele','3',1605,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@NPC_SUMMONSLAVE','idle',196,2,10000,700,10000,'no','self','slavele','3',1605,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@WZ_METEOR','attack',83,11,5000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@WZ_METEOR','chase',83,11,5000,500,2000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2052,'Dark Lord@WZ_METEOR','chase',83,11,5000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

# Brasilis
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@MG_FIREBALL','idle',17,5,10000,0,5000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@MG_FIREBALL','chase',17,5,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@CR_REFLECTSHIELD','idle',252,3,1000,0,200000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@CR_REFLECTSHIELD','attack',252,3,1000,0,200000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@NPC_FIREATTACK','attack',186,5,2000,1000,200000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@NPC_BLEEDING','attack',660,3,500,500,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@AS_SONICBLOW','attack',136,10,1000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@SM_MAGNUM','attack',7,7,1000,0,10000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@KN_TWOHANDQUICKEN','attack',60,30,2000,0,300000,'yes','self','myhpltmaxrate','40',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@NPC_CRITICALSLASH','attack',170,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@NPC_WIDEBLEEDING','attack',665,2,10000,500,100000,'no','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','20',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@NPC_SUMMONSLAVE','attack',196,5,10000,1000,30000,'no','self','slavele','1',2082,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@NPC_SUMMONSLAVE','idle',196,5,10000,1000,30000,'no','self','slavele','1',2082,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@NPC_SUMMONSLAVE','chase',196,5,10000,1000,30000,'no','self','slavele','1',2082,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2068,'Boitata@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2069,'Iara@NPC_WATERATTACK','attack',184,3,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2069,'Iara@PR_LEXDIVINA','attack',76,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2069,'Iara@PR_LEXDIVINA','chase',76,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2069,'Iara@NPC_EMOTION','chase',197,1,2000,0,5000,'yes','self','always','0',3,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2069,'Iara@WZ_WATERBALL','attack',86,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2069,'Iara@SM_BASH','attack',5,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2069,'Iara@NPC_STOP','attack',342,1,500,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2069,'Iara@MG_FROSTDIVER','attack',15,5,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2069,'Iara@MG_FROSTDIVER','chase',15,40,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2070,'Piranha@NPC_WATERATTACK','attack',184,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2070,'Piranha@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2070,'Piranha@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2070,'Piranha@NPC_CRITICALWOUND','attack',673,1,50,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2070,'Piranha@NPC_BLEEDING','attack',660,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2070,'Piranha@MG_COLDBOLT','attack',14,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2070,'Piranha@MG_COLDBOLT','chase',14,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2070,'Piranha@WZ_WATERBALL','attack',86,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2070,'Piranha@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2071,'Headless Mule@NPC_CURSEATTACK','attack',181,1,1000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2071,'Headless Mule@NPC_CURSEATTACK','chase',181,1,1000,800,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2071,'Headless Mule@NPC_FIREATTACK','attack',186,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2071,'Headless Mule@MG_FIREBOLT','attack',19,5,2000,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2071,'Headless Mule@MG_FIREBOLT','chase',19,5,2000,1500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2071,'Headless Mule@NPC_BLEEDING','attack',660,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2071,'Headless Mule@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2071,'Headless Mule@MG_FIREWALL','chase',18,5,500,500,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2071,'Headless Mule@SM_BASH','attack',5,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2072,'Jaguar@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2072,'Jaguar@NPC_COMBOATTACK','attack',171,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2072,'Jaguar@AS_SONICBLOW','attack',136,3,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'0',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2072,'Jaguar@NPC_DARKNESSATTACK','attack',190,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2072,'Jaguar@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2072,'Jaguar@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2073,'Toucan@NPC_EMOTION','walk',197,1,2000,0,5000,'yes','self','always','0',2,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2073,'Toucan@NPC_EMOTION','chase',197,1,200,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2073,'Toucan@NPC_EMOTION','idle',197,1,2000,0,5000,'yes','self','always','0',7,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2073,'Toucan@NPC_TELEKINESISATTACK','chase',191,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2073,'Toucan@NPC_WINDATTACK','attack',187,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2073,'Toucan@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'30',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2073,'Toucan@NPC_SILENCEATTACK','attack',178,3,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2074,'Curupira@NPC_GROUNDATTACK','attack',185,2,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2074,'Curupira@SA_REVERSEORCISH','attack',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2074,'Curupira@SA_REVERSEORCISH','chase',294,1,50,0,30000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2074,'Curupira@NPC_BLINDATTACK','attack',177,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2074,'Curupira@MG_STONECURSE','idle',16,5,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2074,'Curupira@MG_STONECURSE','attack',16,5,10000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'11',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2074,'Curupira@AL_INCAGI','chase',29,1,500,700,60000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (2080,'Crystal@AL_TELEPORT','attack',26,1,3000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
#REPLACE INTO `mob_skill_db_re` VALUES (2080,'Crystal@AL_TELEPORT','idle',26,1,4000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2082,'Piranha@NPC_WATERATTACK','attack',184,2,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2082,'Piranha@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2082,'Piranha@NPC_CRITICALSLASH','angry',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2082,'Piranha@NPC_CRITICALWOUND','attack',673,1,50,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2082,'Piranha@NPC_BLEEDING','attack',660,3,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2082,'Piranha@MG_COLDBOLT','attack',14,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2082,'Piranha@MG_COLDBOLT','chase',14,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2082,'Piranha@WZ_WATERBALL','attack',86,3,500,1000,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2082,'Piranha@NPC_BLOODDRAIN','attack',199,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

# El Dicastes (13.3)
REPLACE INTO `mob_skill_db_re` VALUES (2083,'Scaraba@NPC_PIERCINGATT','attack',158,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2083,'Scaraba@CR_AUTOGUARD','chase',249,5,2000,0,300000,'yes','self','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2083,'Scaraba@CR_AUTOGUARD','attack',249,5,500,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2083,'Scaraba@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2083,'Scaraba@NPC_COMBOATTACK','chase',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2083,'Scaraba@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2083,'Scaraba@NPC_EMOTION','chase',197,1,1000,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2083,'Scaraba@NPC_EMOTION','idle',197,1,3000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2084,'Scaraba@NPC_COMBOATTACK','attack',171,1,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2084,'Scaraba@NPC_CRITICALSLASH','attack',170,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2084,'Scaraba@NPC_COMBOATTACK','attack',171,2,500,700,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2084,'Scaraba@SM_BASH','attack',5,5,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2084,'Scaraba@NPC_STOP','attack',342,1,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2084,'Scaraba@NPC_EMOTION','chase',197,1,1000,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2084,'Scaraba@NPC_EMOTION','idle',197,1,3000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2085,'Antler Scaraba@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2085,'Antler Scaraba@BS_ADRENALINE','attack',111,10,500,1500,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2085,'Antler Scaraba@BS_ADRENALINE','chase',111,10,500,1500,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2085,'Antler Scaraba@NPC_SPLASHATTACK','attack',174,1,2000,0,5000,'yes','target','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2085,'Antler Scaraba@NPC_STONESKIN','attack',675,3,10000,1000,30000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2085,'Antler Scaraba@NPC_STONESKIN','chase',675,3,10000,1000,30000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2085,'Antler Scaraba@NPC_STUNATTACK','attack',179,3,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2085,'Antler Scaraba@NPC_PIERCINGATT','attack',158,3,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2085,'Antler Scaraba@NPC_BLEEDING','attack',660,3,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2085,'Antler Scaraba@PF_SPIDERWEB','chase',405,1,300,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2086,'Rake Scaraba@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2086,'Rake Scaraba@BS_HAMMERFALL','attack',110,5,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2086,'Rake Scaraba@NPC_GROUNDATTACK','attack',185,3,500,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2086,'Rake Scaraba@MC_MAMMONITE','attack',42,5,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'8',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2086,'Rake Scaraba@NPC_STONESKIN','attack',675,3,10000,1000,30000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2086,'Rake Scaraba@NPC_STONESKIN','chase',675,3,10000,1000,30000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2086,'Rake Scaraba@PF_SPIDERWEB','chase',405,1,300,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'7',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2086,'Rake Scaraba@NPC_EMOTION','chase',197,1,1000,0,5000,'yes','self','always','0',19,0x81,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2086,'Rake Scaraba@NPC_EMOTION','idle',197,1,3000,0,5000,'yes','self','always','0',6,0x3095,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@AL_HEAL','attack',28,11,10000,0,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@AL_HEAL','attack',28,11,10000,0,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@AL_HEAL','chase',28,11,10000,0,5000,'no','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@AL_HEAL','chase',28,11,10000,0,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'3',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@AL_TELEPORT','idle',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@AL_TELEPORT','walk',26,1,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_POWERUP','attack',349,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_STONESKIN','attack',675,3,10000,1000,30000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_STONESKIN','chase',675,3,10000,1000,30000,'no','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_WIDESILENCE','chase',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_WIDESILENCE','attack',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@KN_BRANDISHSPEAR','attack',57,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@CR_AUTOGUARD','attack',249,10,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',2145,2144,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',2145,2144,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@WZ_HEAVENDRIVE','attack',91,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@WZ_HEAVENDRIVE','chase',91,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2087,'Queen Scaraba@WZ_HEAVENDRIVE','chase',91,5,10000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2088,'Scaraba Egg@NPC_METAMORPHOSIS','idle',193,1,100,2000,5000,'no','self','myhpltmaxrate','99',2083,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2089,'Scaraba Egg@NPC_METAMORPHOSIS','idle',193,1,100,2000,5000,'no','self','myhpltmaxrate','99',2084,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2090,'Antler Scaraba Egg@NPC_METAMORPHOSIS','idle',193,1,100,2000,5000,'no','self','myhpltmaxrate','99',2085,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2091,'Rake Scaraba Egg@NPC_METAMORPHOSIS','idle',193,1,100,2000,5000,'no','self','myhpltmaxrate','99',2086,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2092,'Dolomedes@NPC_POISON','attack',176,2,500,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2092,'Dolomedes@PF_SPIDERWEB','idle',405,1,3000,0,10000,'yes','randomtarget','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2092,'Dolomedes@PF_SPIDERWEB','attack',405,1,2000,0,10000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2092,'Dolomedes@NPC_POISONATTACK','attack',188,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2092,'Dolomedes@AS_VENOMDUST','angry',140,1,500,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2092,'Dolomedes@WZ_QUAGMIRE','chase',92,5,500,700,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'12',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2092,'Dolomedes@NPC_BLEEDING','attack',660,2,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);

REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@AL_DECAGI','chase',30,48,2000,0,300000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@NPC_ARMORBRAKE','attack',344,10,2000,500,300000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@NPC_ARMORBRAKE','chase',344,10,2000,500,300000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@NPC_POWERUP','attack',349,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@LK_SPIRALPIERCE','attack',397,5,1500,1000,10000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@KN_TWOHANDQUICKEN','attack',60,30,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@MG_THUNDERSTORM','attack',21,20,2000,1500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@MG_THUNDERSTORM','chase',21,20,10000,1500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@NPC_GROUNDATTACK','attack',185,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@CR_AUTOGUARD','attack',249,10,2000,0,300000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@NPC_SUMMONSLAVE','attack',196,8,10000,700,10000,'no','self','slavele','3',1439,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@NPC_SUMMONSLAVE','idle',196,8,10000,700,10000,'no','self','slavele','3',1439,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2094,'Orc Hero@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@MG_FIREBALL','chase',17,44,4000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@MG_FIREBALL','chase',17,44,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@NPC_BLEEDING','attack',660,5,2000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@AM_DEMONSTRATION','attack',229,5,2000,0,2000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@AM_DEMONSTRATION','chase',229,5,2000,0,2000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@NPC_SUMMONSLAVE','attack',196,8,10000,700,10000,'no','self','slavele','3',1603,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@NPC_SUMMONSLAVE','idle',196,8,10000,700,10000,'no','self','slavele','3',1603,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@NPC_SUMMONSLAVE','idle',196,5,10000,0,0,'no','self','onspawn','0',1060,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@SM_MAGNUM','attack',7,25,3000,0,2000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2095,'Eddga@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_POWERUP','attack',349,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@AS_VENOMDUST','attack',140,5,2000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@AS_VENOMDUST','attack',140,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@MG_STONECURSE','attack',16,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@ASC_METEORASSAULT','attack',406,10,10000,500,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_CURSEATTACK','attack',181,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_CURSEATTACK','chase',181,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_DARKBREATH','attack',202,5,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_DARKBREATH','chase',202,5,500,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_POISONATTACK','attack',188,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1522,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1522,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_SUMMONSLAVE','idle',196,7,10000,0,0,'no','self','onspawn','0',1029,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_SUMMONSLAVE','idle',196,7,10000,0,0,'no','self','onspawn','0',1029,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@SM_BASH','attack',5,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_DARKTHUNDER','chase',341,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@NPC_DARKTHUNDER','chase',341,10,10000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2096,'Osiris@WZ_QUAGMIRE','chase',92,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@AL_DECAGI','chase',30,48,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_HELLJUDGEMENT','chase',662,10,10000,500,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_HELLJUDGEMENT','attack',662,10,10000,500,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@AS_GRIMTOOTH','chase',137,5,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_BLOODDRAIN','attack',199,1,3000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_ENERGYDRAIN','chase',200,1,3000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@MO_BODYRELOCATION','chase',264,1,2000,200,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_CHANGEUNDEAD','attack',348,1,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'9',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_INVISIBLE','attack',353,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_INVISIBLE','idle',353,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_INVISIBLE','chase',353,1,2000,200,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_SILENCEATTACK','attack',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_SILENCEATTACK','chase',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_SUMMONSLAVE','attack',196,16,10000,700,5000,'no','self','slavele','5',1419,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_SUMMONSLAVE','idle',196,16,10000,700,5000,'no','self','slavele','5',1419,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2097,'Dracula@NPC_ENERGYDRAIN','chase',200,1,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@AL_HEAL','attack',28,11,10000,0,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@AL_HEAL','attack',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@AL_HEAL','chase',28,11,10000,0,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@AL_HEAL','chase',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@LK_SPIRALPIERCE','attack',397,5,10000,1000,10000,'no','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@KN_TWOHANDQUICKEN','attack',60,30,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@BS_HAMMERFALL','attack',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@BS_HAMMERFALL','chase',110,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@NPC_CRITICALSLASH','attack',170,1,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@CR_AUTOGUARD','attack',249,10,2000,500,300000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@CR_AUTOGUARD','chase',249,10,2000,500,300000,'no','self','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@AL_DECAGI','attack',30,48,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@AL_DECAGI','chase',30,48,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'5',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@NPC_SUMMONSLAVE','attack',196,1,10000,700,10000,'no','self','slavele','3',1427,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@NPC_SUMMONSLAVE','idle',196,1,10000,700,10000,'no','self','slavele','3',1427,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2098,'Doppelganger@BS_HAMMERFALL','chase',110,10,10000,0,5000,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@AL_HEAL','attack',28,11,10000,0,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@AL_HEAL','attack',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@AL_HEAL','chase',28,11,10000,0,5000,'yes','friend','friendhpltmaxrate','60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@AL_HEAL','chase',28,11,10000,0,5000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@AL_PNEUMA','attack',25,1,2000,0,5000,'yes','target','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@AL_PNEUMA','chase',25,1,2000,0,5000,'yes','target','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@AL_TELEPORT','idle',26,1,5000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_AGIUP','attack',350,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_WIDESILENCE','chase',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_WIDESILENCE','attack',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_GUIDEDATTACK','chase',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_SILENCEATTACK','attack',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_SILENCEATTACK','chase',178,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_SILENCEATTACK','chase',178,5,10000,0,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1604,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1604,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_SUMMONSLAVE','idle',196,4,10000,0,0,'no','self','onspawn','0',1156,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@NPC_STOP','attack',342,1,2000,0,15000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@WZ_JUPITEL','attack',84,28,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2099,'Mistress@WZ_JUPITEL','chase',84,28,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@MO_BODYRELOCATION','chase',264,1,2000,200,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_DARKSTRIKE','chase',340,10,2000,0,1000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@KN_BRANDISHSPEAR','attack',57,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_EARTHQUAKE','chase',653,5,10000,2000,30000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_EARTHQUAKE','attack',653,5,10000,2000,30000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_HELLJUDGEMENT','chase',662,5,10000,800,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_HELLJUDGEMENT','attack',662,5,10000,800,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_DARKBREATH','attack',202,5,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_GUIDEDATTACK','attack',172,5,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_SUMMONSLAVE','attack',196,6,10000,700,10000,'no','self','slavele','3',1431,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_SUMMONSLAVE','idle',196,6,10000,700,10000,'no','self','slavele','3',1431,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@NPC_SUMMONSLAVE','idle',196,4,10000,0,0,'no','self','onspawn','0',1101,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@WZ_VERMILION','attack',85,21,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@WZ_VERMILION','chase',85,21,5000,500,2000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@WZ_VERMILION','chase',85,21,2000,500,2000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2100,'Baphomet@AL_HEAL','idle',28,11,10000,0,5000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@AL_DECAGI','chase',30,48,2000,0,60000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_HELLJUDGEMENT','chase',662,10,10000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_HELLJUDGEMENT','attack',662,10,10000,1000,10000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@KN_BRANDISHSPEAR','attack',57,10,2000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_DARKSTRIKE','chase',340,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_CHANGEUNDEAD','attack',348,1,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_AGIUP','attack',350,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_GRANDDARKNESS','attack',339,10,1000,700,5000,'no','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_STUNATTACK','attack',179,5,2000,0,0,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_SUMMONSLAVE','idle',196,6,10000,700,10000,'no','self','slavele','3',1490,1490,1509,1508,1179,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_SUMMONSLAVE','attack',196,6,10000,700,10000,'no','self','slavele','3',1490,1490,1509,1508,1179,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2101,'Lord of Death@NPC_DARKSTRIKE','chase',340,10,10000,0,5000,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_WATERATTACK','attack',184,10,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_RANDOMATTACK','attack',183,8,1000,500,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_SUMMONSLAVE','attack',196,6,10000,700,30000,'no','self','slavele','3',1788,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_SUMMONSLAVE','idle',196,6,10000,700,30000,'no','self','slavele','3',1788,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_WIDEFREEZE','chase',664,5,10000,0,20000,'yes','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_WIDEFREEZE','attack',664,5,10000,0,20000,'yes','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@SA_DISPELL','attack',289,5,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@SA_DISPELL','chase',289,5,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_ARMORBRAKE','attack',344,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@MG_FROSTDIVER','idle',15,40,5000,1000,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@MG_FROSTDIVER','chase',15,40,5000,1000,7000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@WZ_STORMGUST','chase',89,10,5000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@WZ_STORMGUST','attack',89,11,5000,1000,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@WZ_WATERBALL','chase',86,10,5000,0,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@WZ_WATERBALL','attack',86,10,5000,0,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@WZ_FROSTNOVA','chase',88,10,5000,0,20000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@WZ_FROSTNOVA','attack',88,10,5000,0,20000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_POWERUP','attack',349,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_POWERUP','attack',349,5,10000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_AGIUP','attack',350,5,2000,0,100000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@NPC_AGIUP','attack',350,5,10000,0,25000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2103,'Ktullanux@AL_HEAL','idle',28,11,10000,0,10000,'yes','self','myhpltmaxrate','50',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_POWERUP','attack',349,5,10000,0,30000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_DRAGONFEAR','chase',659,5,10000,0,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_DRAGONFEAR','attack',659,5,2000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_WIDESILENCE','chase',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_WIDESILENCE','attack',663,5,10000,1000,20000,'no','self','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,'32',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@MG_FROSTDIVER','attack',15,40,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@MG_FROSTDIVER','chase',15,40,2000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_SHIELDBRAKE','attack',346,10,2000,0,0,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_DARKBREATH','attack',202,5,2000,800,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_STOP','attack',342,1,10000,0,15000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'2',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','2',1531,1531,1564,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','2',1531,1531,1564,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@SM_MAGNUM','attack',7,25,2000,0,5000,'yes','self','attackpcge','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2104,'Dark Snake Lord@MG_FROSTDIVER','chase',15,40,10000,0,0,'yes','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@AS_SONICBLOW','attack',136,10,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@BS_MAXIMIZE','attack',114,5,500,0,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@BS_MAXIMIZE','chase',114,5,500,0,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@WZ_WATERBALL','chase',86,10,10000,500,5000,'no','target','skillused','18',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@NPC_AGIUP','attack',350,5,10000,0,120000,'yes','self','myhpltmaxrate','30',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@NPC_CALLSLAVE','attack',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@NPC_CALLSLAVE','idle',352,1,10000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@NPC_GROUNDATTACK','attack',185,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@NPC_WEAPONBRAKER','attack',343,10,500,0,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@NPC_STUNATTACK','attack',179,5,2000,0,5000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@NPC_SUMMONSLAVE','attack',196,6,10000,700,10000,'no','self','slavele','3',1364,1594,1600,1601,1602,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@NPC_SUMMONSLAVE','idle',196,6,10000,700,10000,'no','self','slavele','3',1364,1594,1600,1601,1602,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@SM_ENDURE','chase',8,1,5000,0,10000,'yes','self','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,'6',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2105,'Turtle General@WZ_WATERBALL','attack',86,5,2000,500,20000,'no','target','always','0',NULL,NULL,NULL,NULL,NULL,'18',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2106,'Vesper@NPC_SUMMONSLAVE','attack',196,3,10000,2000,5000,'no','self','slavele','15',1669,1675,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2106,'Vesper@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2106,'Vesper@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2106,'Vesper@NPC_CALLSLAVE','attack',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2106,'Vesper@NPC_CALLSLAVE','idle',352,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2106,'Vesper@NPC_POWERUP','attack',349,5,5000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2106,'Vesper@NPC_CRITICALSLASH','attack',170,1,5000,0,3000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2106,'Vesper@WZ_METEOR','attack',83,11,500,10000,20000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2106,'Vesper@NPC_EMOTION','idle',197,1,1000,0,0,'yes','self','always','0',9,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2106,'Vesper@NPC_SUMMONSLAVE','idle',196,2,10000,0,0,'no','self','onspawn','0',1365,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@AL_TELEPORT','idle',26,1,10000,0,0,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@AL_TELEPORT','walk',26,1,5000,0,5000,'yes','self','rudeattacked','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_CALLSLAVE','attack',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_CALLSLAVE','idle',352,1,10000,0,10000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_SUMMONSLAVE','attack',196,5,10000,700,10000,'no','self','slavele','3',1868,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_SUMMONSLAVE','idle',196,5,10000,700,10000,'no','self','slavele','3',1868,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_WIDECURSE','attack',677,5,2000,800,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_CRITICALWOUND','attack',673,2,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_DARKSTRIKE','chase',340,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_DARKSTRIKE','attack',340,10,2000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_DARKCROSS','attack',338,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@CR_HOLYCROSS','attack',253,10,1000,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_GRANDDARKNESS','chase',339,10,500,1300,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_GRANDDARKNESS','attack',339,10,500,1300,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@CR_GRANDCROSS','chase',254,10,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@CR_GRANDCROSS','attack',254,10,500,1000,5000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_VAMPIRE_GIFT','attack',679,2,500,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_SLOWCAST','chase',672,5,2000,300,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_SLOWCAST','attack',672,5,2000,800,30000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_EVILLAND','attack',670,10,10000,1000,600000,'no','target','myhpltmaxrate','44',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_EVILLAND','attack',670,7,500,500,5000,'no','target','myhpltmaxrate','80',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_MAGICMIRROR','attack',671,1,10000,0,60000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_HELLJUDGEMENT','chase',662,4,10000,800,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_HELLJUDGEMENT','attack',662,4,10000,800,20000,'no','self','always','0',NULL,NULL,NULL,NULL,NULL,'36',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_WIDESILENCE','chase',663,5,5000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@NPC_WIDESILENCE','attack',663,5,5000,0,30000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@MG_SAFETYWALL','attack',12,10,1000,0,5000,'yes','self','always','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@AL_PNEUMA','attack',25,1,5000,0,10000,'yes','self','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@AL_PNEUMA','chase',25,1,5000,0,10000,'yes','self','longrangeattacked','0',NULL,NULL,NULL,NULL,NULL,'19',NULL);
REPLACE INTO `mob_skill_db_re` VALUES (2107,'Fallen Bishop@PR_LEXAETERNA','attack',78,1,500,0,5000,'yes','target','always','0',NULL,NULL,NULL,NULL,NULL,'29',NULL);
REPLACE INTO `mob_skill_db_r