package errorReachableAnalyzer;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class MultiConcurrentSystmeModelMaker {
	static List<String> controllableAction=new ArrayList<String>();
	static List<Transition> updatePart=new ArrayList<Transition>();
	static int updateNumber=0;

	public static MultiConcurrentModel makeConcurrentSystem(ModelInterface env,List<Model> req,List<String>controllableActions){
		Stack<Current> currentStack=new Stack<Current>();
		Current cu;
		controllableAction=controllableActions;
		List<State> initReq=new ArrayList<State>();
		for(int i=0;i<req.size();i++){
			initReq.add(req.get(i).getInitState());
		}

		MultiConcurrentModel mcm=new MultiConcurrentModel(new MultiConcurrentState(env.getInitState(),initReq));
		mcm.addMultiConcurrentState(new MultiConcurrentState(env.getInitState(), initReq));

		return concurrent(new Current(env.getInitState(),initReq,mcm.getConcurrentState(env.getInitState(), initReq)),mcm);
	}

	private static MultiConcurrentModel concurrent(Current c,MultiConcurrentModel mcm){
		Stack<Current> currentStack=new Stack<Current>();
		Current cu;
		currentStack.push(c);
		int i=0;
		while(!currentStack.isEmpty()){
			cu=currentStack.pop(); 
			//System.out.println(cu.env+"'s hasNext is"+cu.env.hasNext());
			if(cu.env.hasNext()){
//				System.out.print("a");
				currentStack.push(cu);
				if((cu=addConcurrentState(cu,mcm))!=null)currentStack.push(cu);
			}
			i++;
//		System.out.println("stackSize:"+currentStack.size()+":current:"+i);	
		}	
		return mcm;
		
	}
	
	private static Current addConcurrentState(Current c,MultiConcurrentModel mcm){
		Transition t=(Transition)c.env.next();
		MultiConcurrentState mcs;
		if(t.getTo().isDead){
			connection(c.mcs,t,mcm.getErrorState("STOP",1));
			return null;
		}else{
			List<State> newReqMoni=getNewReqMoni(c,t,mcm);
			if(newReqMoni==null){
				return null;
			}else if(!mcm.existsConcurrentState(t.getTo(), newReqMoni)){
				mcs=new MultiConcurrentState(t.getTo(),newReqMoni);			
				connection(c.mcs, t, mcs);
				mcm.addMultiConcurrentState(mcs);
//				System.out.println(c.mcs+","+t+","+mcs);//debug
				return new Current(t.getTo().getClone(),newReqMoni,mcs);
			}else{
				mcs=mcm.getConcurrentState(t.getTo(),newReqMoni);
				connection(c.mcs,t,mcs);
				return null;

			}			
		}
	}
	private static List<State> getNewReqMoni(Current c,Transition t,MultiConcurrentModel mcm){
		List<State> newReqMoni=new ArrayList<State>();
		String e="";		
		for(int i=0;i<c.reqMoni.size();i++){
			State m=c.reqMoni.get(i);
			State nextM;
			if(m.containsToTransition(t.toString())){
				nextM=m.getToStateByTransition(t.toString());
				if(nextM.toString().equals("ERROR")){
					e=e.concat("ERROR"+i);
				}
				newReqMoni.add(nextM);
			}else{
				newReqMoni.add(m);
			}
		}
		if(!e.equals("")){
			connection(c.mcs,t,mcm.getErrorState(e,c.reqMoni.size()));
			return null;
		}		
		return newReqMoni;
	}
	
	public static void connection(State from,Transition t,State to){
		Transition newT=new Transition(t.toString());
		if(controllableAction.contains(newT.toString()))newT.setIsControllable();
		from.addToTransition(newT);
		newT.setFrom(from);
		newT.setTo(to);
		to.addFromTransition(newT);
	}	
	public static Model attachTransition(Model e,String from,String t,String to){
		Transition tr= new Transition(t,e.getState(from),e.getState(to));
		e.getState(from).addToTransition(tr);
		e.getState(to).addFromTransition(tr);
		return e;
	}
	public static MultiConcurrentModel modelUpdate(MultiConcurrentModel cm,Model e,List<Model> moni,String from,String t,String to){
		updateNumber++;
		updatePart=new ArrayList<Transition>();
		e=attachTransition(e,from,t,to);
		
		Transition target=e.getState(from).getToTransition(t);
		
		List<MultiConcurrentState> lcs=getCandidate(target,cm);
		System.out.println(lcs.size());
		for(int i=0;i<lcs.size();i++){
			List<State> reqMoniStates=new ArrayList<State>();
			List<String> moniStatesNames=lcs.get(i).getReqMoniList();
			System.out.println(lcs.get(i));
			if(lcs.get(i).getReqMoniList().size()!=0){
				for(int j=0;j<moni.size();j++)reqMoniStates.add(moni.get(j).getState(moniStatesNames.get(j)));
				cm=concurrent(new Current(target.getFrom().getClone(),reqMoniStates,lcs.get(i)),cm);				
			}
		}		
		return cm;		
	}
	private static List<MultiConcurrentState> getCandidate(Transition tr,MultiConcurrentModel mcm){
		List<MultiConcurrentState> l=new ArrayList<MultiConcurrentState>();
		for(int i=2;i<mcm.getSize();i++){
			MultiConcurrentState cs=mcm.getState(i);
			if(cs.getEnv().equals(tr.getFrom().toString())){
				l.add(cs);
			}
		}
		return l;
	}


}

class Current{
	State env;
	List<State> reqMoni;
	MultiConcurrentState mcs;
	Current(State env,List<State> initReq,MultiConcurrentState mcs){
		this.env=env;
		this.reqMoni=initReq;
		this.mcs=mcs;
	}
	State env(){
		return env;
	}
	List<State> reqMoni(){
		return reqMoni;
	}
}
