/*
 * Copyright (C) 2011 Kouichi Machida (k01-dev@live.jp)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.gr.java_conf.k01.android.widgetpack.widget;

import android.graphics.Color;

/**
 * 
 * 
 * @author Kouichi Machida
 */
public abstract class ColorUtils {

	/**
	 * FvfɉčF܂B
	 * 
	 * @param from
	 *            ̐FB
	 * @param to
	 *            ωFB
	 * @param unit
	 *            ω̊B
	 * @return ʂ̐FB
	 */
	public static int ave(int from, int to, float unit) {
		return from + Math.round(unit * (to - from));
	}

	/**
	 * F H vf擾܂B
	 * 
	 * @param color
	 *            H vf擾FB
	 * @return 擾ꂽ H vfB
	 */
	public static float getHue(int color) {
		float hsv[] = new float[3];

		Color.colorToHSV(color, hsv);

		return hsv[0];
	}

	/**
	 * HSV Fɕϊ܂B
	 * 
	 * @param hue
	 *            H vfB
	 * @param saturation
	 *            S vfB
	 * @param value
	 *            V vfB
	 * @return J[lB
	 */
	public static int HSVToColor(float hue, float saturation, float value) {
		float[] hsv = new float[3];

		if (hue >= 360) {
			hue = 359;
		} else if (hue < 0) {
			hue = 0;
		}

		if (saturation > 1) {
			saturation = 1;
		} else if (saturation < 0) {
			saturation = 0;
		}

		if (value > 1) {
			value = 1;
		} else if (value < 0) {
			value = 0;
		}

		hsv[0] = hue;
		hsv[1] = saturation;
		hsv[2] = value;

		return Color.HSVToColor(hsv);
	}

	/**
	 * FɉčF܂B
	 * 
	 * @param from
	 *            ̐FB
	 * @param to
	 *            ωFB
	 * @param unit
	 *            ω̊B
	 * @return ʂ̐FB
	 */
	public static int interp(int from, int to, float unit) {
		int a = ColorUtils.ave(Color.alpha(from), Color.alpha(to), unit);
		int r = ColorUtils.ave(Color.red(from), Color.red(to), unit);
		int g = ColorUtils.ave(Color.green(from), Color.green(to), unit);
		int b = ColorUtils.ave(Color.blue(from), Color.blue(to), unit);

		return Color.argb(a, r, g, b);
	}

	/**
	 * 
	 * 
	 * @param colors
	 * @param unit
	 * @return
	 */
	public static int interpColor(int colors[], float unit) {
		if (unit <= 0) {
			return colors[0];
		}

		if (1 <= unit) {
			return colors[colors.length - 1];
		}

		float p = unit * (colors.length - 1);
		int i = (int) p;

		p -= i;

		// now p is just the fractional part [0...1) and i is the index
		return ColorUtils.interp(colors[i], colors[i + 1], p);
	}

}
