/*
 * Copyright (C) 2011 Kouichi Machida (k01-dev@live.jp)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.gr.java_conf.k01.android.widgetpack.preference;

import jp.gr.java_conf.k01.android.widgetpack.R;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.preference.Preference;
import android.util.AttributeSet;
import android.util.Log;

/**
 * ON\邾 Preference IuWFNgB
 * 
 * @author Kouichi Machida
 */
public class LinkPreference extends Preference {

	/**
	 * ^O\܂B
	 */
	private static final String TAG = "LinkDialogPreference";

	/**
	 * URI ێ܂B
	 */
	private String uri;

	/**
	 * LinkDialogPreference NX̐VCX^X܂B
	 * 
	 * @param context
	 */
	public LinkPreference(Context context) {
		super(context);
	}

	/**
	 * LinkDialogPreference NX̐VCX^X܂B
	 * 
	 * @param context
	 * @param attrs
	 */
	public LinkPreference(Context context, AttributeSet attrs) {
		super(context, attrs);

		this.init(context, attrs);
	}

	/**
	 * LinkDialogPreference NX̐VCX^X܂B
	 * 
	 * @param context
	 * @param attrs
	 * @param defStyle
	 */
	public LinkPreference(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);

		this.init(context, attrs);
	}

	/**
	 * CX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 * @param attrs
	 *            AttributeSet IuWFNgB
	 */
	private void init(Context context, AttributeSet attrs) {
		// TypedArray ܂B
		TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LinkPreference);

		this.uri = typedArray.getString(R.styleable.LinkPreference_url);

		typedArray.recycle();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.preference.Preference#onClick()
	 */
	@Override
	protected void onClick() {
		super.onClick();

		// LOG:
		Log.v(LinkPreference.TAG, "void onClick()");
		Log.v(LinkPreference.TAG, String.format("URI: %s", this.uri));

		Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(this.uri));

		intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);

		this.getContext().startActivity(intent);
	}

}
