package pcc.chemicraft.util;

import java.util.ArrayList;

import pcc.chemicraft.ChemiCraftData;

/**
 * 化学式から元素と数を取り出してArrayListに格納します。
 * @author ponkotate
 */
public class Formula {

	private ArrayList<String> atoms = new ArrayList<String>();
	private ArrayList<Integer> amonts = new ArrayList<Integer>();

	public Formula(String par1) {
		this.run(par1);
	}

	public Formula(String[] par1, Integer[] par2) {
		this.setAtoms(par1, par2);
	}

	public Formula(ArrayList<String> par1, ArrayList<Integer> par2) {
		this.atoms = par1;
		this.amonts = par2;
	}

	// 今後ソースの整頓をする予定 -WIP-
	public void run(String par1) {
		char[] var2 = par1.toCharArray(); // par1のchar配列
		String var3 = null; // setAtomの第一引数に送る
		int var4 = 0; // setAtomの第二引数に送る
		int var5 = 1; // 倍率
		Formula var6 = null; // Formula格納用

		for (int i = 0; i < var2.length; i++) {
			if (Character.isLetter(var2[i])) {
				if (Character.isUpperCase(var2[i])) {
					if (var4 < 0) {
						var4 = 1;
					}
					if (var3 != null) {
						this.setAtom(var3,  var4 * var5);
					} else if (var6 != null) {
						this.setAtoms(var6.getAtoms(), var6.getAmonts(), var4 * var5);
						var6 = null;
					}
					var3 = Character.toString(var2[i]);
				} else {
					var3 = var3.concat(Character.toString(var2[i]));
				}
				var4 = 0;
			} else if (Character.isDigit(var2[i])) {
				if (var3 != null || var6 != null) {
					var4 = var4 * 10 + Integer.valueOf(Character.toString(var2[i]));
				} else {
					var5 = Integer.valueOf(Character.toString(var2[i]));
				}
			} else if (var2[i] == '・') {
				if (var3 != null) {
					this.setAtom(var3,  var4 * var5);
				} else if (var6 != null) {
					this.setAtoms(var6.getAtoms(), var6.getAmonts(), var4 * var5);
				}
				var3 = null;
				var4 = 0;
				var5 = 1;
				var6 = null;
			} else if (var2[i] == '(') {
				if (var3 != null) {
					this.setAtom(var3,  var4 * var5);
					var3 = null;
					var4 = 1;
				}
				int var7 = par1.indexOf(')');
				String var8 = par1.substring(i + 1, var7);
				var6 = new Formula(var8);
				i = var7;
			} else {
				throw new IllegalArgumentException();
			}
		}
		if (var3 != null) {
			if (var4 < 0) {
				var4 = 1;
			}
			this.setAtom(var3,  var4 * var5);
		}
	}

	public boolean isAtom(String par1) {
		for (String var2:ChemiCraftData.ATOMSLIST) {
			if (par1.equalsIgnoreCase(var2)) {
				return true;
			}
		}
		return false;
	}

	public void setAtom(String par1,  int par2) {
		if (isAtom(par1)) {
			int var3 = this.atoms.indexOf(par1);
			if (var3 == -1) {
				this.atoms.add(par1);
				this.amonts.add(par2);
			} else {
				this.amonts.set(var3, this.amonts.get(var3) + par2);
			}
		} else {
			throw new IllegalArgumentException();
		}
	}

	public void setAtom(String par1,  char par2) {
		setAtom(par1, Integer.valueOf(Character.toString(par2)));
	}

	public void setAtoms(String[] par1, Integer[] par2) {
		setAtoms(par1, par2, 1);
	}
	public void setAtoms(String[] par1, Integer[] par2, int par3) {
		if (par1.length != par2.length) {
			throw new IndexOutOfBoundsException();
		}
		for (int i = 0; i < par1.length; i++) {
			this.setAtom(par1[i], par2[i] * par3);
		}
	}

	public String[] getAtoms() {
		return atoms.toArray(new String[atoms.size()]);
	}

	public Integer[] getAmonts() {
		return amonts.toArray(new Integer[amonts.size()]);
	}

}
