package pcc.chemicraft.core.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import pcc.chemicraft.core.ChemiCraftAPI;
import pcc.chemicraft.core.ChemiCraftCore;

public class ItemCompounds extends Item {

	public ItemCompounds(int par1){
		super(par1);
		this.setHasSubtypes(true);
		this.setMaxDamage(0);
		this.setCreativeTab(ChemiCraftCore.instance.creativeTabChemiCraft);
	}

	@Override
	public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
		try {
			for(int i=0;i < ChemiCraftAPI.instance().getCompoundHandlerItemName().size();i++){
				if(ChemiCraftAPI.instance().getCompoundsName().getKeyList(par1ItemStack.getItemDamage()).equals(ChemiCraftAPI.instance().getCompoundHandlerItemName().get(i))){
					return ChemiCraftAPI.instance().getCompoundHandler().get(i).onItemUseHandler(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
				}
			}
		} catch (IndexOutOfBoundsException e) {
			par1ItemStack.stackSize = 0;
		}
		return false;
	}


	@Override
	public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer)
	{
		try {
			for(int i=0;i < ChemiCraftAPI.instance().getCompoundHandlerItemName().size();i++){
				if(ChemiCraftAPI.instance().getCompoundsName().getKeyList(par1ItemStack.getItemDamage()).equals(ChemiCraftAPI.instance().getCompoundHandlerItemName().get(i))){
					ChemiCraftAPI.instance().getCompoundHandler().get(i).onItemRightClickHandler(par1ItemStack, par2World, par3EntityPlayer);
				}
			}
		} catch (IndexOutOfBoundsException e) {
			par1ItemStack.stackSize = 0;
		}
		return par1ItemStack;
	}



	@Override
	public void onUpdate(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5){
		try {
			for(int i=0;i < ChemiCraftAPI.instance().getCompoundHandlerItemName().size();i++){
				if(ChemiCraftAPI.instance().getCompoundsName().getKeyList(par1ItemStack.getItemDamage()).equals(ChemiCraftAPI.instance().getCompoundHandlerItemName().get(i))){
					ChemiCraftAPI.instance().getCompoundHandler().get(i).onUpdateHandler(par1ItemStack, par2World, par3Entity, par4, par5);
				}
			}
		} catch (IndexOutOfBoundsException e) {
			par1ItemStack.stackSize = 0;
			par1ItemStack = null;
		}
	}



	/*めんどくさいから発案者やって(´・ω・`) --WIP--
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@SideOnly(Side.CLIENT)
	@Override
	public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List){
		for(int type = 0; type < ChemiCraftAPI.instance().getCompoundsName().get("en_US").size(); type++) {
			par3List.add(new ItemStack(par1, 1, type));
			this.setIconIndex(type);
		}
	}



	@Override
	public String getItemNameIS(ItemStack par1ItemStack){
		try {
			return super.getItemName() + "." + ChemiCraftAPI.instance().getCompoundsName().get("en_US", par1ItemStack.getItemDamage());
		} catch (ArrayIndexOutOfBoundsException e) {
			par1ItemStack.stackSize = 0;
		}
		return null;
	}



	@Override
	public String getTextureFile(){
		return ChemiCraft.ITEM_COMPOUNDS_TEXTURE;
	}



	@SideOnly(Side.CLIENT)
	@Override
	public int getIconFromDamage(int par1){
		try {
			for(int i=0;i < ChemiCraftAPI.instance().getCompoundHandlerItemName().size();i++){
				if(ChemiCraftAPI.instance().getCompoundsName().getKeyList(par1).equals(ChemiCraftAPI.instance().getCompoundHandlerItemName().get(i))){
					return ChemiCraftAPI.instance().getCompoundHandler().get(i).getIconIndexHandler();
				}
			}
		} catch (IndexOutOfBoundsException e) {
			return 0;
		}
		return 0;
	}
	*/

}
