﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace VMwPlayerTaskTray
{
    static class Program
    {
        // グローバル変数
        public static string vmxFilePath = "";
        public static string startMode = "";
        public static bool moveWindow = false;
        public static int moveWindow_left;
        public static int moveWindow_top;

        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            // 分けて処理をして最初にフォームを表示しないようにする
            // Application.Run(new Form1());
            
            string[] cmds = System.Environment.GetCommandLineArgs();
            for(int i=0; i < cmds.Length; i++)
            {
                if ((0 <= cmds[i].IndexOf(":\\")) && (0 <= cmds[i].IndexOf(".vmx")))
                {
                    vmxFilePath = cmds[i];
                }
                else if ((0 <= cmds[i].IndexOf("/gui") || (0 <= cmds[i].IndexOf("/nogui"))))
                {
                    startMode = cmds[i];
                }
                else if (0 <= cmds[i].IndexOf("/pos"))
                {
                    int x, y;

                    if (int.TryParse(cmds[i+1], out x) && int.TryParse(cmds[i+2], out y))
                    {
                        moveWindow_left = x;
                        moveWindow_top = y;
                        moveWindow = true;
                        i += 2;
                    }
                }
            }
            new MainForm();

            if (vmxFilePath != "")
            {
                Application.Run();
            }
        }
    }
}
