﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using CtrlVix;              // Add
using System.Reflection;    // Add
using System.Management;    // Add
using System.Diagnostics;   // Add
using System.IO;            // Add


namespace VMwPlayerTaskTray
{
    public partial class MainForm
    {
        // Messages
        private const string MSG_ABOUT = "Thanks to VMware,Inc and Microsoft Corporation.\r\n" +
                                         "\r\n" +
                                         "This program has been developed on\r\n" +
                                         "   VMware Workstation Player 12.0.0 and VMware VIX 1.15.0\r\n" +   // Ver.12
                                         "   Visual Studio Community 2015\r\n" +
                                         "   Windows10 Professional 64bit.\r\n" +
                                         "\r\n" +
                                         MSG_USAGE;
        private const string MSG_VIX_ERR = "A fatal error has occured inside VIX.\r\n" +
                                           "Exiting " + PROGRAM_NAME + "...";
        private const string MSG_CONFIRM = "Are you sure?\r\n" +
                                           "It might be cause of crushing your guest OS...";
        private const string MSG_BALN_WARN = "GUI/NoGUI couldn't be determined when guest OS started by \"VMware Player\".  " +
                                             "It might be cause of loosing control.";
        private const string MSG_BALN_NO_VMX_FILE = ".vmx\" file not found. Check your VM path.";

        // クラス内のグローバル変数
        private enum VMSTATE : int  // ChangeMenuItem()
        {
            UNDEFINED = 0,
            POWERED_ON,
            PROCESSING,
            POWERED_OFF,
            NO_VMXFILE,
            ERROR = 0xffff
        };
        private enum VMCTRL : int   // VMControl()
        {
            GO_GUI = 1,
            GO_NOGUI,
            GO_SUSPEND,
            GO_ACPI_RESET,
            GO_ACPI_POWER_OFF,
            GO_RESET,
            GO_POWER_OFF
        };
        private enum MENU_MODE : int    // SetMenuItem()
        {
            UNDEFINED = 0,
            RUNNING_GUI,
            RUNNING_NOGUI,
            PROCESSING,
            SUSPENDED,
            POWERED_OFF,
            CANNOT_DEFINE_RUNNING_MODE,
            NO_VMXFILE,
            //NOT_RUNNING_VMTOOLS,
            ERROR = 0xffff
        };
        private bool inprocess = false;                         // 非同期処理中かどうかのフラグ

        private async void VMControl(VMCTRL mode)
        {
            bool ret = true; ;

            this.timer_MainForm.Enabled = false;                // Timerを無効にする
            SetMenuItem(MENU_MODE.PROCESSING);                  // MenuItemの表示を処理中にセット
            inprocess = true;                                   // 非同期処理中フラグ
#if DEBUG
            Debug.WriteLine("Start VMControl Thread");
#endif
            ret = await Task.Run(() =>
            {
                return subVMControl(mode);           // VM Control
            });
#if DEBUG
            Debug.WriteLine("Finish VMControl Thread");
#endif
            inprocess = false;                                   // 非同期処理中フラグ
            if (!ret)
            {
                SetMenuItem(MENU_MODE.ERROR);               // Exit
                this.notifyIcon_MainForm.Visible = false;   // タスクトレイからアイコンを取り除く
                Application.Exit();                         // アプリケーション終了
                return;
            }
            vmState = VMSTATE.UNDEFINED;                        // vmState をリセットする
            ChangeMenuItem(vmxFilePath);                        // VMwareの動作状態をチェックしMenuItemの表示を切り替える
            if (vmState == VMSTATE.ERROR)
            {
                // Exit
                this.notifyIcon_MainForm.Visible = false;   // タスクトレイからアイコンを取り除く
                Application.Exit();                         // アプリケーション終了
            }
            this.timer_MainForm.Enabled = true;             // Timerを有効にする
        }

        private bool subVMControl(VMCTRL mode)
        {
            Constants.VMSTATE state;
            Constants.POWER_OFF_MODE pwOff;
            CtrlVIX Vix = new CtrlVIX();

            switch (mode)
            {
                case VMCTRL.GO_GUI:
                    if ((vmState == VMSTATE.POWERED_ON) && (Vix.CheckRunningMode(vmxFilePath) == Constants.RUNNING_MODE.NOGUI))
                    {
                        // Go to Suspend mode
                        if (!Vix.VMOperation(vmxFilePath, CtrlVix.Constants.POWEROP.SUSPEND)) return false;
                        System.Threading.Thread.Sleep(3000);
                        if (((state = Vix.GetVMState(vmxFilePath)) != CtrlVix.Constants.VMSTATE.POWERED_OFF)
                                && ((pwOff = Vix.CheckPowerOffMode(vmxFilePath))
                                                    != CtrlVix.Constants.POWER_OFF_MODE.SUSPENDED))
                        {
                            if (state == CtrlVix.Constants.VMSTATE.ERROR) return false;
                            if (pwOff == CtrlVix.Constants.POWER_OFF_MODE.ERROR) return false;
                        }
                    }
                    // Go to GUI mode
                    if (mode == VMCTRL.GO_GUI && Program.moveWindow == true)  // GO_GUIの時だけPlayer Windowを移動する
                    {
                        movePlayerWindowAsync(Program.moveWindow_left, Program.moveWindow_top);     // Player Windowを移動する
                    }
                    if (!Vix.VMOperation(vmxFilePath, CtrlVix.Constants.POWEROP.POWER_ON_GUI)) return false;
                    break;
                case VMCTRL.GO_NOGUI:
                    if ((vmState == VMSTATE.POWERED_ON) && (Vix.CheckRunningMode(vmxFilePath) == Constants.RUNNING_MODE.GUI))
                    {
                        // get & save current window pos
                        Vix.GetPlayerWindowPos(vmxFilePath, out Program.moveWindow_left, out Program.moveWindow_top);

                        // Go to Suspend mode
                        if (!Vix.VMOperation(vmxFilePath, CtrlVix.Constants.POWEROP.SUSPEND)) return false;
                        System.Threading.Thread.Sleep(3000);
                        if (((state = Vix.GetVMState(vmxFilePath)) != CtrlVix.Constants.VMSTATE.POWERED_OFF)
                                && ((pwOff = Vix.CheckPowerOffMode(vmxFilePath))
                                                    != CtrlVix.Constants.POWER_OFF_MODE.SUSPENDED))
                        {
                            if (state == CtrlVix.Constants.VMSTATE.ERROR) return false;
                            if (pwOff == CtrlVix.Constants.POWER_OFF_MODE.ERROR) return false;
                        }
                    }
                    // Go to No GUI mode
                    if (!Vix.VMOperation(vmxFilePath, CtrlVix.Constants.POWEROP.POWER_ON_NOGUI)) return false;
                    break;
                case VMCTRL.GO_SUSPEND:
                    if ((vmState == VMSTATE.POWERED_ON) && (Vix.CheckRunningMode(vmxFilePath) == Constants.RUNNING_MODE.GUI))
                    {
                        // get & save current window pos
                        Vix.GetPlayerWindowPos(vmxFilePath, out Program.moveWindow_left, out Program.moveWindow_top);
                    }
                    // Go to Suspend mode
                    if (!Vix.VMOperation(vmxFilePath, CtrlVix.Constants.POWEROP.SUSPEND)) return false;
                    break;
                case VMCTRL.GO_ACPI_RESET:
                    // ACPI reset
                    if (!Vix.VMOperation(vmxFilePath, CtrlVix.Constants.POWEROP.ACPI_RESET)) return false;
                    break;
                case VMCTRL.GO_ACPI_POWER_OFF:
                    if ((vmState == VMSTATE.POWERED_ON) && (Vix.CheckRunningMode(vmxFilePath) == Constants.RUNNING_MODE.GUI))
                    {
                        // get & save current window pos
                        Vix.GetPlayerWindowPos(vmxFilePath, out Program.moveWindow_left, out Program.moveWindow_top);
                    }
                    // ACPI shutdown
                    if (!Vix.VMOperation(vmxFilePath, CtrlVix.Constants.POWEROP.ACPI_POWER_OFF)) return false;
                    break;
                case VMCTRL.GO_RESET:
                    if ((vmState == VMSTATE.POWERED_ON) && (Vix.CheckRunningMode(vmxFilePath) == Constants.RUNNING_MODE.GUI))
                    {
                        // get & save current window pos
                        Vix.GetPlayerWindowPos(vmxFilePath, out Program.moveWindow_left, out Program.moveWindow_top);
                    }
                    // Harware reset
                    if (!Vix.VMOperation(vmxFilePath, CtrlVix.Constants.POWEROP.HW_RESET)) return false;
                    break;
                case VMCTRL.GO_POWER_OFF:
                    // Harware shutdown
                    if (!Vix.VMOperation(vmxFilePath, CtrlVix.Constants.POWEROP.HW_POWER_OFF)) return false;
                    break;
            }
            switch (mode)
            {
                case VMCTRL.GO_GUI:
                case VMCTRL.GO_NOGUI:
                    //@@@for(int i = 0; i < 10; i++)
                    {
                        System.Threading.Thread.Sleep(3000);
                        if ((state = Vix.GetVMState(vmxFilePath)) != CtrlVix.Constants.VMSTATE.POWERED_ON)
                        {
                            if (state == CtrlVix.Constants.VMSTATE.ERROR) return false;
                        }
                        else
                        {
                            //@@@break;
                        }
                    }
                    /***
                    if (mode == VMCTRL.GO_GUI && Program.moveWindow == true)  // GO_GUIの時だけPlayer Windowを移動する
                    {
                        movePlayerWindow(Program.moveWindow_left, Program.moveWindow_top);     // Player Windowを移動する
                    }
                    ***/
                    break;
                case VMCTRL.GO_ACPI_RESET:
                case VMCTRL.GO_RESET:
                    System.Threading.Thread.Sleep(3000);
                    break;
                case VMCTRL.GO_SUSPEND:
                    //@@@for (int i = 0; i < 10; i++)
                    {
                        System.Threading.Thread.Sleep(3000);
                        if (((state = Vix.GetVMState(vmxFilePath)) != CtrlVix.Constants.VMSTATE.POWERED_OFF)
                                && ((pwOff = Vix.CheckPowerOffMode(vmxFilePath))
                                                != CtrlVix.Constants.POWER_OFF_MODE.SUSPENDED))
                        {
                            if (state == CtrlVix.Constants.VMSTATE.ERROR) return false;
                            if (pwOff == CtrlVix.Constants.POWER_OFF_MODE.ERROR) return false;
                        }
                        else
                        {
                            //@@@break;
                        }
                    }
                    break;
                case VMCTRL.GO_ACPI_POWER_OFF:
                case VMCTRL.GO_POWER_OFF:
                    //@@@for (int i = 0; i < 10; i++)
                    {
                        System.Threading.Thread.Sleep(3000);
                        if ((state = Vix.GetVMState(vmxFilePath)) != CtrlVix.Constants.VMSTATE.POWERED_OFF)
                        {
                            if (state == CtrlVix.Constants.VMSTATE.ERROR) return false;
                        }
                        else
                        {
                            //@@@break;
                        }
                    }
                    break;
            }
            return true;
        }

        private bool isToolsRunning(string vmxFilePath)
        {
            CtrlVIX Vix = new CtrlVIX();
            if (Vix.CheckToolsRunning(vmxFilePath) == CtrlVix.Constants.TOOLS_RUNNING.RUNNING)
            {
                return true;
            }
            return false;
        }

        private void ChangeMenuItem(string vmxFilePath)
        {
            VMSTATE oldVMstate;
            CtrlVIX Vix = new CtrlVIX();

            if (inprocess) return;                      // 非同期処理中は処理しない
            oldVMstate = vmState;                       // vmStateを保存

            if (File.Exists(vmxFilePath))               // vmxファイルがあるかチェック
            {
                switch (Vix.GetVMState(vmxFilePath))    // VMwareの動作状態をチェックしMenuItemの表示を切り替える
                {
                    case CtrlVix.Constants.VMSTATE.POWERED_ON:
                        vmState = VMSTATE.POWERED_ON;
                        break;
                    case CtrlVix.Constants.VMSTATE.POWERED_OFF:
                        vmState = VMSTATE.POWERED_OFF;
                        break;
                    case CtrlVix.Constants.VMSTATE.PROCESSING:
                        vmState = VMSTATE.PROCESSING;
                        break;
                    case CtrlVix.Constants.VMSTATE.ERROR:
                        vmState = VMSTATE.ERROR;
                        SetMenuItem(MENU_MODE.ERROR);
                        return;     // errorの時は戻る
                }
            }
            else
            {
                vmState = VMSTATE.NO_VMXFILE;
            }
            if (oldVMstate != VMSTATE.UNDEFINED)
            {
                // oldVMstateがUNDEFINEDではないとき
                if (oldVMstate == vmState)
                {
                    // VMstateとoldVMstateの状態が同じであれば処理をパスする
                    return;
                }
            }
            if (vmState == VMSTATE.PROCESSING)
            {
#if DEBUG
                Debug.WriteLine("PROCESSING");
#endif
                SetMenuItem(MENU_MODE.PROCESSING);
            }
            else if (vmState == VMSTATE.POWERED_ON)
            {
                switch (Vix.CheckRunningMode(vmxFilePath))
                {
                    case CtrlVix.Constants.RUNNING_MODE.GUI:
                        // GUI mode
                        SetMenuItem(MENU_MODE.RUNNING_GUI);
#if DEBUG
                        Debug.WriteLine("RUNNING_GUI");
#endif
                        break;
                    case CtrlVix.Constants.RUNNING_MODE.NOGUI:
                        // No GUI mode
                        SetMenuItem(MENU_MODE.RUNNING_NOGUI);
#if DEBUG
                        Debug.WriteLine("RUNNING_NOGUI");
#endif
                        break;
                    case CtrlVix.Constants.RUNNING_MODE.CANNOT_DETERMINE:
                        // Guest OS started by VMware Player - can't determine GUI/NGUI
                        SetMenuItem(MENU_MODE.CANNOT_DEFINE_RUNNING_MODE);
#if DEBUG
                        Debug.WriteLine("CANNOT_DEFINE_RUNNING_MODE");
#endif
                        break;
                }
            }
            else if (vmState == VMSTATE.NO_VMXFILE)
            {
                SetMenuItem(MENU_MODE.NO_VMXFILE);
#if DEBUG
                Debug.WriteLine("NO_VMXFILE");
#endif
            }
            else
            {
                switch (Vix.CheckPowerOffMode(vmxFilePath))
                {
                    case Constants.POWER_OFF_MODE.SUSPENDED:
                        // Suspended
                        SetMenuItem(MENU_MODE.SUSPENDED);
#if DEBUG
                        Debug.WriteLine("SUSPENDED");
#endif
                        break;
                    case Constants.POWER_OFF_MODE.POWERED_OFF:
                        // Powered OFF
                        SetMenuItem(MENU_MODE.POWERED_OFF);
#if DEBUG
                        Debug.WriteLine("POWERED_OFF");
#endif
                        break;
                    case Constants.POWER_OFF_MODE.ERROR:
                        SetMenuItem(MENU_MODE.ERROR);
                        break;
                }
            }
        }

        private void SetMenuItem(MENU_MODE mode)
        {
            string vmxName = Path.GetFileNameWithoutExtension(vmxFilePath);  // vmx 名を作成

            aboutToolStripMenuItem.Enabled = true;          // Aboutは常に表示
            exitToolStripMenuItem.Enabled = true;           // Exitは常に表示
            switch (mode)
            {
                case MENU_MODE.RUNNING_GUI:
                    ToolStripMenuItem_GoGUI.Enabled = false;
                    ToolStripMenuItem_GoNoGUI.Enabled = true;
                    ToolStripMenuItem_GoSuspend.Enabled = true;
                    ToolStripMenuItem_OtherCommand.Enabled = true;
                    this.notifyIcon_MainForm.Text = "Running as GUI - " + vmxName;
                    this.notifyIcon_MainForm.BalloonTipText = this.notifyIcon_MainForm.Text;
                    this.notifyIcon_MainForm.Icon = Properties.Resources.VMwPlayerTaskTray_run;
                    break;
                case MENU_MODE.RUNNING_NOGUI:
                    ToolStripMenuItem_GoGUI.Enabled = true;
                    ToolStripMenuItem_GoNoGUI.Enabled = false;
                    ToolStripMenuItem_GoSuspend.Enabled = true;
                    ToolStripMenuItem_OtherCommand.Enabled = true;
                    this.notifyIcon_MainForm.Text = "Running as NoGUI - " + vmxName;
                    this.notifyIcon_MainForm.BalloonTipText = this.notifyIcon_MainForm.Text;
                    this.notifyIcon_MainForm.Icon = Properties.Resources.VMwPlayerTaskTray_run;
                    break;
                case MENU_MODE.PROCESSING:
                    ToolStripMenuItem_GoGUI.Enabled = false;
                    ToolStripMenuItem_GoNoGUI.Enabled = false;
                    ToolStripMenuItem_GoSuspend.Enabled = false;
                    ToolStripMenuItem_OtherCommand.Enabled = false;
                    this.notifyIcon_MainForm.Text = "Processing - " + vmxName;
                    this.notifyIcon_MainForm.BalloonTipText = this.notifyIcon_MainForm.Text;
                    this.notifyIcon_MainForm.Icon = Properties.Resources.VMwPlayerTaskTray_proc;
                    break;
                case MENU_MODE.SUSPENDED:
                    ToolStripMenuItem_GoGUI.Enabled = true;
                    ToolStripMenuItem_GoNoGUI.Enabled = true;
                    ToolStripMenuItem_GoSuspend.Enabled = false;
                    ToolStripMenuItem_OtherCommand.Enabled = false;
                    this.notifyIcon_MainForm.Text = "Suspended - " + vmxName;
                    this.notifyIcon_MainForm.BalloonTipText = this.notifyIcon_MainForm.Text;
                    this.notifyIcon_MainForm.Icon = Properties.Resources.VMwPlayerTaskTray_suspend;
                    break;
                case MENU_MODE.POWERED_OFF:
                    ToolStripMenuItem_GoGUI.Enabled = true;
                    ToolStripMenuItem_GoNoGUI.Enabled = true;
                    ToolStripMenuItem_GoSuspend.Enabled = false;
                    ToolStripMenuItem_OtherCommand.Enabled = false;
                    this.notifyIcon_MainForm.Text = "Powered OFF - " + vmxName;
                    this.notifyIcon_MainForm.BalloonTipText = this.notifyIcon_MainForm.Text;
                    this.notifyIcon_MainForm.Icon = Properties.Resources.VMwPlayerTaskTray_stop;
                    break;
                case MENU_MODE.CANNOT_DEFINE_RUNNING_MODE:
                    ToolStripMenuItem_GoGUI.Enabled = false;
                    ToolStripMenuItem_GoNoGUI.Enabled = false;
                    ToolStripMenuItem_GoSuspend.Enabled = true;
                    ToolStripMenuItem_OtherCommand.Enabled = true;
                    this.notifyIcon_MainForm.Text = "Running as ether GUI/NoGUI - " + vmxName;
                    this.notifyIcon_MainForm.BalloonTipText = MSG_BALN_WARN;
                    this.notifyIcon_MainForm.Icon = Properties.Resources.VMwPlayerTaskTray_run;
                    this.notifyIcon_MainForm.ShowBalloonTip(500);   // バルーンTip表示
                    break;
                case MENU_MODE.NO_VMXFILE:
                    ToolStripMenuItem_GoGUI.Enabled = false;
                    ToolStripMenuItem_GoNoGUI.Enabled = false;
                    ToolStripMenuItem_GoSuspend.Enabled = false;
                    ToolStripMenuItem_OtherCommand.Enabled = false;
                    this.notifyIcon_MainForm.Text = "Can't find vmx file - " + vmxName;
                    this.notifyIcon_MainForm.BalloonTipText = "\"" + vmxName + MSG_BALN_NO_VMX_FILE;
                    this.notifyIcon_MainForm.Icon = Properties.Resources.VMwPlayerTaskTray_err;
                    this.notifyIcon_MainForm.ShowBalloonTip(500);   // バルーンTip表示
                    break;
                case MENU_MODE.ERROR:
                default:
                    ToolStripMenuItem_GoGUI.Enabled = false;
                    ToolStripMenuItem_GoNoGUI.Enabled = false;
                    ToolStripMenuItem_GoSuspend.Enabled = false;
                    ToolStripMenuItem_OtherCommand.Enabled = false;
                    this.notifyIcon_MainForm.Text = "Error - " + vmxName;
                    this.notifyIcon_MainForm.BalloonTipText = this.notifyIcon_MainForm.Text;
                    this.notifyIcon_MainForm.Icon = Properties.Resources.VMwPlayerTaskTray_err;
                    // Exit
                    MessageBox.Show(MSG_VIX_ERR, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    this.notifyIcon_MainForm.Visible = false;   // タスクトレイからアイコンを取り除く
                    Application.Exit();                         // アプリケーション終了
                    break;
            }
        }

        private bool confirmDialog()
        {
            DialogResult result = MessageBox.Show(MSG_CONFIRM, PROGRAM_NAME, MessageBoxButtons.OKCancel, MessageBoxIcon.Warning);
            switch (result)
            {
                case DialogResult.Cancel:
                    return false;
                case DialogResult.OK:
                default:
                    return true;
            }
        }

        private int CountProcess(string processName, string distinctinArgument)
        {
            int count = 0;
            ManagementPath mngmntPath = new ManagementPath("Win32_Process");
            ManagementClass mngmntClass = new ManagementClass(mngmntPath);

            ManagementObjectCollection mngmntObjClctn = mngmntClass.GetInstances();
            foreach (ManagementObject obj in mngmntObjClctn)
            {
                object commandLineObj = obj["CommandLine"];
                if (commandLineObj != null)
                {
                    string commandLine = commandLineObj.ToString();
                    if ((0 <= commandLine.IndexOf(processName)) && (0 <= commandLine.IndexOf(distinctinArgument)))
                    {
                        count += 1;    // runnning
                    }
                }
            }
            return count;
        }

        private void AboutDialog()
        {
            string message;

            //AssemblyTitleの取得
            AssemblyTitleAttribute asmTitle = (AssemblyTitleAttribute)Attribute.GetCustomAttribute(
                                                    Assembly.GetExecutingAssembly(), typeof(AssemblyTitleAttribute));
            //AssemblyDescriptionの取得
            AssemblyDescriptionAttribute asmDesc = (AssemblyDescriptionAttribute)Attribute.GetCustomAttribute(
                                                    Assembly.GetExecutingAssembly(), typeof(AssemblyDescriptionAttribute));
            //AssemblyCompanyの取得
            AssemblyCompanyAttribute asmCompany = (AssemblyCompanyAttribute)Attribute.GetCustomAttribute(
                                                    Assembly.GetExecutingAssembly(), typeof(AssemblyCompanyAttribute));
            //AssemblyProductの取得
            AssemblyProductAttribute asmPrdct = (AssemblyProductAttribute)Attribute.GetCustomAttribute(
                                                    Assembly.GetExecutingAssembly(), typeof(AssemblyProductAttribute));
            //AssemblyCopyrightの取得
            AssemblyCopyrightAttribute asmCpyrght = (AssemblyCopyrightAttribute)Attribute.GetCustomAttribute(
                                                    Assembly.GetExecutingAssembly(), typeof(AssemblyCopyrightAttribute));
            //AssemblyTrademarkの取得
            AssemblyTrademarkAttribute asmTM = (AssemblyTrademarkAttribute)Attribute.GetCustomAttribute(
                                                    Assembly.GetExecutingAssembly(), typeof(AssemblyTrademarkAttribute));
            //バージョンの取得
            Assembly asm = Assembly.GetExecutingAssembly();
            Version ver = asm.GetName().Version;

            message = asmTitle.Title + "\r\n" +
                      "\r\n" +
                      asmDesc.Description + "\r\n" +
                      "\r\n" +
                      MSG_ABOUT + "\r\n" +
                      "\r\n" +
                      asmCompany.Company + "\r\n" +
                      asmPrdct.Product + "  Rev. " + ver + "\r\n" +
                      asmCpyrght.Copyright + "\r\n";
            MessageBox.Show(message, PROGRAM_NAME, MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private async void movePlayerWindowAsync(int left, int top)
        {
            CtrlVIX Vix = new CtrlVIX();

#if DEBUG
            Debug.WriteLine("Start moveWindow Thread");
#endif
            await Task.Run(() =>
            {
                for (int i = 0; i < 10; i++)
                {
                    System.Threading.Thread.Sleep(3000);
                    if (Vix.MovePlayerWindow(vmxFilePath, left, top))              // Windowを移動する
                    {
                            return;
                    }
                }
            });
#if DEBUG
            Debug.WriteLine("Finish moveWindow Thread");
#endif
        }
    }
}
