﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Reflection;    // Add
using System.Management;    // Add
using System.Diagnostics;   // Add
using System.IO;            // Add

namespace VMwPlayerTaskTray
{
    public partial class MainForm : Form
    {
        // This Program Name
        private const string PROGRAM_NAME = "VMwPlayerTaskTray";

        // Messages
        private const string MSG_ARG_ERR = "Gust OS's vmx file not be in argument.\r\n" +
                                         "\r\n";
        private const string MSG_USAGE = " Usage: \r\n" +
                                         "  " + PROGRAM_NAME + ".exe [opt] \"FullPath.vmx\"\r\n" +
                                         "\r\n" +
                                         " Option:\r\n" +
                                         "   /gui | /nogui | (none)\r\n" +
                                         "   /pos num_left num_top | (none)";
        private const string MSG_RUN_DUP = PROGRAM_NAME + " has been already running with \r\n" + 
                                          "same guest OS.\r\n" +
                                          "\r\n" +
                                          "Extiting...";
                                                  
        // クラス内のグローバル変数
        private string vmxFilePath = "";
        private VMSTATE vmState = VMSTATE.UNDEFINED;

        public MainForm()
        {
            string vmxName;
            
            // Messageはここで出さないと終了処理がうまくいかない(プロセスが残る)
            if (Program.vmxFilePath == "")
            {
                MessageBox.Show(MSG_ARG_ERR + MSG_USAGE, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                Program.vmxFilePath = "";           // Program.vmxFilePathを消してしまう(flag代わり)
            }
            else if (Program.vmxFilePath != "")     // vmxFilePathが指定されていないときは初期化せず終了
            {
                vmxFilePath = Program.vmxFilePath;  // Mainで設定されたvmxFilePathをコピー
                vmxName = Path.GetFileNameWithoutExtension(vmxFilePath);  // vmx 名を作成

                if (CountProcess(PROGRAM_NAME, vmxName) > 1)     //　二重起動のチェック
                {
                    MessageBox.Show(MSG_RUN_DUP, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    Program.vmxFilePath = "";       // Program.vmxFilePathを消してしまう(flag代わり)
                    return;
                }
                InitializeComponent();
                this.ToolStripMenuItem_VMwPlayerTaskTray.Text = vmxName;  // メニューの1行目のタイトルセット
                this.timer_MainForm.Interval = 3000;            // Timer 時間セット
                this.timer_MainForm.Enabled = false;            // Timerを無効にする
                vmState = VMSTATE.UNDEFINED;                    // vmState をリセットする
                ChangeMenuItem(vmxFilePath);                    // VMwareの動作状態をチェックしMenuItemの表示を切り替える
                if (vmState == VMSTATE.ERROR)
                {
                    Program.vmxFilePath = "";                   // Program.vmxFilePathを消してしまう(flag代わり)
                    return;
                }
                // start option がついていたらVMwareを起動する
                if (vmState != VMSTATE.NO_VMXFILE)
                {
                    if (Program.startMode == "/gui")
                    {
                        VMControl(VMCTRL.GO_GUI);
                    }
                    else if (Program.startMode == "/nogui")
                    {
                        VMControl(VMCTRL.GO_NOGUI);
                    }
                    else
                    {
                        this.timer_MainForm.Enabled = true;     // Timerを有効にする
                    }
                }
                else
                {
                    this.timer_MainForm.Enabled = true;         // Timerを有効にする
                }
                // うるさいのでやめるthis.notifyIcon1.ShowBalloonTip(500);   // バルーンTip表示
            }
        }

        private void timer_MainForm_Tick(object sender, EventArgs e)
        {
            this.timer_MainForm.Enabled = false;            // Timerを無効にする
#if DEBUG
            //Debug.WriteLine("Timer Thread : Start");
#endif
            ChangeMenuItem(vmxFilePath);                    // VMwareの動作状態をチェックしMenuItemの表示を切り替える
            if (vmState == VMSTATE.ERROR)
            {
                // Exit
                this.notifyIcon_MainForm.Visible = false;   // タスクトレイからアイコンを取り除く
                Application.Exit();                         // アプリケーション終了
            }
#if DEBUG
            //Debug.WriteLine("Timer Thread : Finish");
#endif
            this.timer_MainForm.Enabled = true;             // Timerを有効にする
        }

        private void notifyIcon_MainForm_MouseUp(object sender, MouseEventArgs e)
        {
            switch (e.Button)
            {
                case MouseButtons.Left:
                    // 何もしない
                    break;
                case MouseButtons.Middle:
                    // 何もしない
                    break;
                case MouseButtons.Right:
                    // 何もしない
                    break;
            }
            // どのボタンでもメニューを出す
            //this.timer1.Enabled = false;            // Timerを無効にする
            this.notifyIcon_MainForm.ContextMenuStrip = this.contextMenuStrip_MainForm;
            MethodInfo mi = typeof(NotifyIcon).GetMethod("ShowContextMenu", BindingFlags.Instance | BindingFlags.NonPublic);
            mi.Invoke(this.notifyIcon_MainForm, null);
            this.notifyIcon_MainForm.ContextMenuStrip = null;
            this.contextMenuStrip_MainForm.Show(this, PointToClient(Cursor.Position));
            //this.timer1.Enabled = true;             // Timerを有効にする
        }

        private void ToolStripMenuItem_VMwPlayerTaskTray_Click(object sender, EventArgs e)
        {
            // this.timer1.Enabled = false;             // Timerを無効にする
            vmState = VMSTATE.UNDEFINED;                // vmState をリセットする
            ChangeMenuItem(vmxFilePath);                // VMwareの動作状態をチェックしMenuItemの表示を切り替える
            if (vmState == VMSTATE.ERROR)
            {
                // Exit
                this.notifyIcon_MainForm.Visible = false;   // タスクトレイからアイコンを取り除く
                Application.Exit();                         // アプリケーション終了
            }
            // this.timer1.Enabled = true;             // Timerを有効にする
        }

        private void ToolStripMenuItem_GoGUI_Click(object sender, EventArgs e)
        {
            VMControl(VMCTRL.GO_GUI);
        }

        private void ToolStripMenuItem_GoNoGUI_Click(object sender, EventArgs e)
        {
            VMControl(VMCTRL.GO_NOGUI);
        }

        private void ToolStripMenuItem_GoSuspend_Click(object sender, EventArgs e)
        {
            VMControl(VMCTRL.GO_SUSPEND);
        }

        private void ToolStripMenuItem_OtherCommand_DropDownOpening(object sender, EventArgs e)
        {
            // Check & Set Items Enable/Disable
            if (isToolsRunning(vmxFilePath))
            {
                ToolStripMenuItem_ACPIReset.Enabled = true;
                ToolStripMenuItem_ACPIPowerOff.Enabled = true;
            }
            else
            {
                ToolStripMenuItem_ACPIReset.Enabled = false;
                ToolStripMenuItem_ACPIPowerOff.Enabled = false;
            }
            ToolStripMenuItem_Reset.Enabled = true;
            ToolStripMenuItem_PowerOff.Enabled = true;
        }

        private void ToolStripMenuItem_ACPIReset_Click(object sender, EventArgs e)
        {
            VMControl(VMCTRL.GO_ACPI_RESET);
        }

        private void ToolStripMenuItem_ACPIPowerOff_Click(object sender, EventArgs e)
        {
            VMControl(VMCTRL.GO_ACPI_POWER_OFF);
        }

        private void ToolStripMenuItem_Reset_Click(object sender, EventArgs e)
        {
            // open dialog
            notifyIcon_MainForm.Visible = false;
            if (confirmDialog())
            {
                VMControl(VMCTRL.GO_RESET);
            }
            notifyIcon_MainForm.Visible = true;
        }

        private void ToolStripMenuItem_PowerOff_Click(object sender, EventArgs e)
        {
            // open dialog
            notifyIcon_MainForm.Visible = false;
            if (confirmDialog())
            {
                VMControl(VMCTRL.GO_POWER_OFF);
            }
            notifyIcon_MainForm.Visible = true;
        }

        private void ToolStripMenuItem_About_Click(object sender, EventArgs e)
        {
            // About dialog
            notifyIcon_MainForm.Visible = false;
            AboutDialog();
            notifyIcon_MainForm.Visible = true;
        }

        private void ToolStripMenuItem_Exit_Click(object sender, EventArgs e)
        {
            // Exit
            this.notifyIcon_MainForm.Visible = false;   // タスクトレイからアイコンを取り除く
            Application.Exit();                         // アプリケーション終了
        }
    }
}
