# -*- mode: perl; coding: utf-8 -*-
# $Id: 02_ClientInfo.t,v 1.3 2008-08-05 14:08:25 morimoto Exp $
# $Source: /home/ishikawa/work/keitairc/tmp/keitairc/t/02_ClientInfo.t,v $
# Copyright (c) 2003-2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2
use strict;
use warnings;
use Test::More 'no_plan';
use FindBin;
use lib "$FindBin::Bin/../lib";

use HTTP::Headers;
use HTTP::Request;

BEGIN {
	use_ok('Keitairc::ClientInfo');
}

can_ok('Keitairc::ClientInfo',
       qw/new user_agent is_ezweb is_docomo is_ipod is_softbank
	is_emobile is_emobile_mobilebrowser is_emobile_openbrowser
	is_mobile softbank_serial docomo_foma_icc docomo_imodeid
	au_subscriber_id emobile_userid serial_key cookie_available/);

# au
{
	my $header = new HTTP::Headers;
	my $subscriber_id = '05098765432101_gd.ezweb.ne.jp';
	$header->header(
		'user-agent' => 'KDDI-SN3B UP.Browser/6.2.0.13.1.5 (GUI) MMP/2.0',
		'x-up-subno' => $subscriber_id,
		'x-up-devcap-cc' => '1',
		'x-up-devcap-qvga' => '1',
		'accept' => 'application/x-kddi-ezmusic,application/x-kddi-playlist,application/x-kmcs-form-data,application/x-kddi-karrange,application/x-pobox,application/x-tar,application/x-up-download,application/x-www-form-urlencoded,application/x-kcf-license,application/x-kddi-htmlmail,application/x-kddi-drm,application/vnd.KDDI-vpimlist,application/vnd.KDDI-setsynctime,application/vnd.KDDI-verror,application/vnd.syncml+wbxml,text/x-vmessage,image/bci,text/x-vcalendar,text/vcard,application/x-kddi-kcf,application/x-kddi-auc,text/x-vnote,application/x-kddi-mcx,text/x-vcard, application/octet-stream,application/vnd.phonecom.mmc-xml,application/vnd.uplanet.bearer-choice-wbxml,application/vnd.wap.wmlc;type=4365,application/vnd.wap.xhtml+xml,application/xhtml+xml;profile="http://www.wapforum.org/xhtml",image/bmp,image/gif,image/jpeg,image/png,image/vnd.wap.wbmp,image/x-up-wpng,multipart/mixed,multipart/related,text/css,text/html,text/plain,text/vnd.wap.wml;type=4365,application/x-shockwave-flash,audio/vnd.qcelp,application/x-smaf,application/vnd.yamaha.hv-script,application/x-mpeg,video/3gpp2,audio/3gpp2,video/3gpp,audio/3gpp,text/x-hdml,*/*',
		'x-up-devcap-max-pdu' => '131072',
		'x-up-devcap-screenpixels' => '240,368',
		'accept-language' => 'ja-jp',
		'x-up-devcap-iscolor' => '1',
		'x-up-devcap-screendepth' => '16,RGB565',
		'accept-charset' => 'shift_jis,*',
		'x-up-devcap-multimedia' => 'A300961123302120',
		'via' => '1.1 wb48proxy03.ezweb.ne.jp',
		'x-up-devcap-screenchars' => '28,20',
		'x-up-devcap-softkeysize' => '6',
		'x-up-devcap-titlebar' => '0'
		);

	my $request = new HTTP::Request('GET', 'http://example.com', $header);
	my $ci = new Keitairc::ClientInfo($request);
	ok($ci, 'new Keitairc::ClientInfo (au)');
	ok($ci->user_agent(), 'au user_agent()');
	ok($ci->is_mobile(), 'au is_mobile()');
	ok($ci->is_ezweb(), 'au is_ezweb()');
	ok(!$ci->is_docomo(), 'au is_docomo()');
	ok(!$ci->is_ipod(), 'au is_ipod()');
	ok(!$ci->is_softbank(), 'au is_softbank()');
	ok(!$ci->is_emobile(), 'au is_emobile()');
	ok(!$ci->is_emobile_mobilebrowser(), 'au is_emobile_mobilebrowser()');
	ok(!$ci->is_emobile_openbrowser(), 'au is_emobile_openbrowser()');
	ok(!$ci->softbank_serial(), 'au softbank_serial()');
	ok(!$ci->docomo_foma_icc(), 'au docomo_foma_icc()');
	ok(!$ci->docomo_imodeid(), 'au docomo_imodeid()');
	is($ci->au_subscriber_id(), $subscriber_id, 'au au_subscriber_id()');
	ok(!$ci->emobile_userid(), 'au emobile_userid()');
	is($ci->serial_key(), $subscriber_id, 'au serial_key()');
	ok($ci->cookie_available(), 'au cookie_available()');
}

# NTT DoCoMo FOMA
{
	my $icc = 'icc9876543210234567890F';
	my $ua = 'DoCoMo/2.0 P703imyu(c100;TB;W30H15;ser123498761234567;icc9876543210234567890F)';
	my $imodeid = '1234567';
	my $header = new HTTP::Headers;
	$header->header(
		'user-agent' => $ua,
		'x_dcmguid' => $imodeid,
		);

	my $request = new HTTP::Request('GET', 'http://example.com', $header);
	my $ci = new Keitairc::ClientInfo($request);
	ok($ci, 'new Keitairc::ClientInfo (NTT DoCoMo FOMA)');
	ok($ci->user_agent(), 'NTT DoCoMo FOMA user_agent()');
	ok($ci->is_mobile(), 'NTT DoCoMo FOMA is_mobile()');
	ok(!$ci->is_ezweb(), 'NTT DoCoMo FOMA is_ezweb()');
	ok($ci->is_docomo(), 'NTT DoCoMo FOMA is_docomo()');
	ok(!$ci->is_ipod(), 'NTT DoCoMo FOMA is_ipod()');
	ok(!$ci->is_softbank(), 'NTT DoCoMo FOMA is_softbank()');
	ok(!$ci->is_emobile(), 'NTT DoCoMo FOMA is_emobile()');
	ok(!$ci->is_emobile_mobilebrowser(), 'NTT DoCoMo FOMA is_emobile_mobilebrowser()');
	ok(!$ci->is_emobile_openbrowser(), 'NTT DoCoMo FOMA is_emobile_openbrowser()');
	ok(!$ci->softbank_serial(), 'NTT DoCoMo FOMA softbank_serial()');
	is($ci->docomo_foma_icc(), $icc, 'NTT DoCoMo FOMA docomo_foma_icc()');
	is($ci->docomo_imodeid(), $imodeid, 'NTT DoCoMo FOMA docomo_imodeid()');
	ok(!$ci->au_subscriber_id(), 'NTT DoCoMo FOMA au_subscriber_id()');
	ok(!$ci->emobile_userid(), 'NTT DoCoMo FOMA emobile_userid()');
	ok(!$ci->serial_key(), 'NTT DoCoMo FOMA serial_key()');
	ok(!$ci->cookie_available(), 'NTT DoCoMo FOMA cookie_available()');
}

# Softbank
{
	my $ua = 'SoftBank/1.0/913SH/SHJ001/SN123456789012345 Browser/NetFront/3.4 Profile/MIDP-2.0 Configuration/CLDC-1.1';
	my $serial = 'SN123456789012345';
	my $header = new HTTP::Headers;
	$header->header(
		'user-agent' => $ua,
		);

	my $request = new HTTP::Request('GET', 'http://example.com', $header);
	my $ci = new Keitairc::ClientInfo($request);
	ok($ci, 'new Keitairc::ClientInfo (SoftBank)');
	ok($ci->user_agent(), 'SoftBank user_agent()');
	ok($ci->is_mobile(), 'SoftBank is_mobile()');
	ok(!$ci->is_ezweb(), 'SoftBank is_ezweb()');
	ok(!$ci->is_docomo(), 'SoftBank is_docomo()');
	ok(!$ci->is_ipod(), 'SoftBank is_ipod()');
	ok($ci->is_softbank(), 'SoftBank is_softbank()');
	ok(!$ci->is_emobile(), 'SoftBank is_emobile()');
	ok(!$ci->is_emobile_mobilebrowser(), 'SoftBank is_emobile_mobilebrowser()');
	ok(!$ci->is_emobile_openbrowser(), 'SoftBank is_emobile_openbrowser()');
	is($ci->softbank_serial(), $serial, 'SoftBank softbank_serial()');
	ok(!$ci->docomo_foma_icc(), 'SoftBank docomo_foma_icc()');
	ok(!$ci->docomo_imodeid(), 'SoftBank docomo_imodeid()');
	ok(!$ci->au_subscriber_id(), 'SoftBank au_subscriber_id()');
	ok(!$ci->emobile_userid(), 'SoftBank emobile_userid()');
	is($ci->serial_key(), $serial, 'SoftBank serial_key()');
	ok($ci->cookie_available(), 'SoftBank cookie_available()');
}

# TODO: test emobile
