# -*-perl-*-

use 5.8.0;
use ExtUtils::MakeMaker;

my $data = join(' ', map ({s!^data/!!g ; $_} glob('data/templates/*/*.html data/plugins/[0-9]* data/public/*.{ico,js,css,txt,gif} data/public/*/*.{css,js,png,gif}')));

my $docs = join(' ', map ({s!^doc/!!g ; $_} glob('doc/*.{gif,psd,png,html,css,jpg} doc/iui/*.txt doc/COPYING.*')));

WriteMakefile(
	NAME => 'keitairc',
	AUTHOR => 'Jun Morimoto <morimoto@mrmt.net>',
	LICENSE => 'GPL2',
	PREREQ_PM => {
		'POE' => 0,
		'POE::Component::Server::TCP' => 0,
		'POE::Filter::HTTPD' => 0,
		'POE::Component::IRC' => 0,
		'URI::Escape' => 0,
		'HTTP::Response' => 0,
		'HTML::Template' => 0,
		'Net::HTTP' => 0,
		'Net::SMTP' => 0,
		'XML::Simple' => 0,
		'AppConfig' => 0,
		'File::Path' => 0,
		'Encode' => 0,
	},
	EXE_FILES => ['keitairc'],
	PM_FILTER => "sed -e 's!__KEITAIRC_DATA_DIR__!\$(KEITAIRC_DATADIR)!g'",
	'macro' => {
		KEITAIRC_DATADIR => '$(PREFIX)/share/keitairc',
		KEITAIRC_DATA => $data,
		KEITAIRC_DOCSDIR => '$(PREFIX)/share/doc/keitairc',
		KEITAIRC_DOCS => $docs,
	}
);

sub MY::postamble {
	my $self = shift;
	return <<MAKE_FRAG
install ::
	for i in \$(KEITAIRC_DATA) ; do [ -d \$(DESTDIR)/\$(KEITAIRC_DATADIR)/\$\$(dirname \$\$i) ] || mkdir -p \$(DESTDIR)/\$(KEITAIRC_DATADIR)/\$\$(dirname \$\$i) ; install -m 644 data/\$\$i \$(DESTDIR)/\$(KEITAIRC_DATADIR)/\$\$i ; done

install_doc ::
	for i in \$(KEITAIRC_DOCS) ; do [ -d \$(DESTDIR)/\$(KEITAIRC_DOCSDIR)/\$\$(dirname \$\$i) ] || mkdir -p \$(DESTDIR)/\$(KEITAIRC_DOCSDIR)/\$\$(dirname \$\$i) ; install -m 644 doc/\$\$i \$(DESTDIR)/\$(KEITAIRC_DOCSDIR)/\$\$i ; done
	install -m 644 etc/dot.keitairc \$(DESTDIR)/\$(KEITAIRC_DOCSDIR)/
MAKE_FRAG
}
