#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
sys.path.append('/usr/lib/python2.6/')
import rrdtool

from rrd_const import RRD_DIR_VIRT, START_TIME, END_TIME

data = rrdtool.graph('virt_cpu_total_graph.gif',
                     "--font", "DEFAULT:0:IPAexGothic",
                     "--title", "virt CPUの情報",
                     "--vertical-label", "second",
                     "--width", "500",
                     "--height", "200",
                     "--start", START_TIME,
                     "--end",  END_TIME,
#                     "--legend-direction", "bottomup",
                     "DEF:ns=" + RRD_DIR_VIRT + "libvirt/virt_cpu_total.rrd:ns:AVERAGE",
                     "CDEF:s=ns,1000,1000,1000,*,*,/",
                     "AREA:s#9999FF:Second",
                     "GPRINT:s:MIN:%6.2lf min",
                     "GPRINT:s:MAX:%6.2lf max",
                     "GPRINT:s:AVERAGE:%6.2lf ave",
                     "GPRINT:s:LAST:%6.2lf last\\n",
                     "LINE1:s#0000FF",
                     )

data = rrdtool.graph('virt_cpu-0_graph.gif',
                     "--font", "DEFAULT:0:IPAexGothic",
                     "--title", "virt CPU-0の情報",
                     "--vertical-label", "second",
                     "--width", "500",
                     "--height", "200",
                     "--start", START_TIME,
                     "--end",  END_TIME,
#                     "--legend-direction", "bottomup",
                     "DEF:ns=" + RRD_DIR_VIRT + "libvirt/virt_vcpu-0.rrd:ns:AVERAGE",
                     "CDEF:s=ns,1000,1000,1000,*,*,/",
                     "AREA:s#9999FF:Second",
                     "GPRINT:s:MIN:%6.2lf min",
                     "GPRINT:s:MAX:%6.2lf max",
                     "GPRINT:s:AVERAGE:%6.2lf ave",
                     "GPRINT:s:LAST:%6.2lf last\\n",
                     "LINE1:s#0000FF",
                     )


data = rrdtool.graph('virt_disk_octets_graph.gif',
                     "--font", "DEFAULT:0:IPAexGothic",
                     "--title", "virt disk octetsの情報",
                     "--vertical-label", "Octets",
                     "--width", "500",
                     "--height", "200",
                     "--start", START_TIME,
                     "--end",  END_TIME,
#                     "--legend-direction", "bottomup",
                     "DEF:read=" + RRD_DIR_VIRT + "libvirt/disk_octets-hda.rrd:read:AVERAGE",
                     "DEF:write=" + RRD_DIR_VIRT + "libvirt/disk_octets-hda.rrd:write:AVERAGE",
                     "AREA:read#44FF44:Read",
                     "GPRINT:read:MIN:%6.2lf%s Min, ",
                     "GPRINT:read:MAX:%6.2lf%s Max, ",
                     "GPRINT:read:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:read:LAST:%6.2lf%s Last\\n",
                     "STACK:write#4444FF:Write",
                     "GPRINT:write:MIN:%6.2lf%s Min, ",
                     "GPRINT:write:MAX:%6.2lf%s Max, ",
                     "GPRINT:write:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:write:LAST:%6.2lf%s Last\\n",
                     "LINE1:read#00FF",
                     "STACK:write#0000FF",
                     )

data = rrdtool.graph('virt_disk_ops_graph.gif',
                     "--font", "DEFAULT:0:IPAexGothic",
                     "--title", "virt disk opsの情報",
                     "--vertical-label", "Octets / sec",
                     "--width", "500",
                     "--height", "200",
                     "--start", START_TIME,
                     "--end",  END_TIME,
#                     "--legend-direction", "bottomup",
                     "DEF:read=" + RRD_DIR_VIRT + "libvirt/disk_ops-hda.rrd:read:AVERAGE",
                     "DEF:write=" + RRD_DIR_VIRT + "libvirt/disk_ops-hda.rrd:write:AVERAGE",
                     "AREA:read#44FF44:Read",
                     "GPRINT:read:MIN:%6.2lf%s Min, ",
                     "GPRINT:read:MAX:%6.2lf%s Max, ",
                     "GPRINT:read:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:read:LAST:%6.2lf%s Last\\n",
                     "STACK:write#4444FF:Write",
                     "GPRINT:write:MIN:%6.2lf%s Min, ",
                     "GPRINT:write:MAX:%6.2lf%s Max, ",
                     "GPRINT:write:AVERAGE:%6.2lf%s Ave, ",
                     "GPRINT:write:LAST:%6.2lf%s Last\\n",
                     "LINE1:read#00FF",
                     "STACK:write#0000FF",
                     )
