#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
sys.path.append('/usr/lib/python2.6/')
import rrdtool

from rrd_const import RRD_DIR, START_TIME, END_TIME

data = rrdtool.graph('cpu_graph.gif',
#                     "--font", "DEFAULT:0:IPAexMincho",
                     "--font", "DEFAULT:0:IPAexGothic",
                     "--title", "CPU",
                     "--vertical-label", "jiffies",
                     "--upper-limit", "100",
                     "--rigid",
                     "--width", "500",
                     "--height", "200",
                     "--start", START_TIME,
                     "--end",  END_TIME,
                     "--legend-direction", "bottomup",
                     "DEF:idle=" + RRD_DIR + "cpu-0/cpu-idle.rrd:value:AVERAGE",
                     "DEF:interrupt=" + RRD_DIR + "cpu-0/cpu-interrupt.rrd:value:AVERAGE",
                     "DEF:nice=" + RRD_DIR + "cpu-0/cpu-nice.rrd:value:AVERAGE",
                     "DEF:user=" + RRD_DIR + "cpu-0/cpu-user.rrd:value:AVERAGE",
                     "DEF:wait=" + RRD_DIR + "cpu-0/cpu-wait.rrd:value:AVERAGE",
                     "DEF:system=" + RRD_DIR + "cpu-0/cpu-system.rrd:value:AVERAGE",
                     "DEF:softirq=" + RRD_DIR + "cpu-0/cpu-softirq.rrd:value:AVERAGE",
                     "DEF:steal=" + RRD_DIR + "cpu-0/cpu-steal.rrd:value:AVERAGE",
#                     "CDEF:un=idle,UNKN,UNKN,IF",
                     "AREA:steal#000000:Steal      ",
                     "GPRINT:steal:MIN:%8.2lf",
                     "GPRINT:steal:MAX:%8.2lf",
                     "GPRINT:steal:AVERAGE:%8.2lf",
                     "GPRINT:steal:LAST:%8.2lf\\n",
                     "STACK:interrupt#FF00FF:Interrupt",
                     "GPRINT:interrupt:MIN:%8.2lf",
                     "GPRINT:interrupt:MAX:%8.2lf",
                     "GPRINT:interrupt:AVERAGE:%8.2lf",
                     "GPRINT:interrupt:LAST:%8.2lf\\n",
                     "STACK:softirq#FF22DD:SoftIRQ  ",
                     "GPRINT:softirq:MIN:%8.2lf",
                     "GPRINT:softirq:MAX:%8.2lf",
                     "GPRINT:softirq:AVERAGE:%8.2lf",
                     "GPRINT:softirq:LAST:%8.2lf\\n",
                     "STACK:system#FF0000:System   ",
                     "GPRINT:system:MIN:%8.2lf",
                     "GPRINT:system:MAX:%8.2lf",
                     "GPRINT:system:AVERAGE:%8.2lf",
                     "GPRINT:system:LAST:%8.2lf\\n",
                     "STACK:wait#FFDD00:Wait - IO",
                     "GPRINT:wait:MIN:%8.2lf",
                     "GPRINT:wait:MAX:%8.2lf",
                     "GPRINT:wait:AVERAGE:%8.2lf",
                     "GPRINT:wait:LAST:%8.2lf\\n",
                     "STACK:user#0000FF:User        ",
                     "GPRINT:user:MIN:%8.2lf",
                     "GPRINT:user:MAX:%8.2lf",
                     "GPRINT:user:AVERAGE:%8.2lf",
                     "GPRINT:user:LAST:%8.2lf\\n",
                     "STACK:nice#00FF00:Nice        ",
                     "GPRINT:nice:MIN:%8.2lf",
                     "GPRINT:nice:MAX:%8.2lf",
                     "GPRINT:nice:AVERAGE:%8.2lf",
                     "GPRINT:nice:LAST:%8.2lf\\n",
                     "STACK:idle#EEEEEE:Idle       ",
#                     "STACK:un#FFFFFF:Idle       ",
                     "GPRINT:idle:MIN:%8.2lf",
                     "GPRINT:idle:MAX:%8.2lf",
                     "GPRINT:idle:AVERAGE:%8.2lf",
                     "GPRINT:idle:LAST:%8.2lf\\n",
                     "COMMENT:色                          最小         最大         平均          最新\\n",
                     "COMMENT: \\n",
                     )
