package com.example.sample;

import android.content.Context;
import android.graphics.Canvas;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;

import com.torn.player.PlayerManager;

public class SampleTouchView2 extends View implements View.OnTouchListener, Runnable {
	public SampleTouchView2(Context context) {
		super(context);
		setOnTouchListener(this);
	}

	/********/
	/* ` */
	/********/
	@Override
	public void onDraw(Canvas canvas) {
		// ^b`_ɉ~`
		PlayerManager.getInstance().paint(canvas);
	}

	/* vC[ */
	public boolean onTouch(View v, MotionEvent event) {
		if (0 == event.getAction()) {
			PlayerManager.getInstance().addAtom(event.getX(), event.getY());
			Log.v("touch", "p:" + event.getX() + "," + event.getY());
		}
		
		return true;
	}
	
	
	/*************/
	/* game loop */
	/*************/
	private int time = 0;
	
	public void run() {
		while (true) {
			Log.v("run", "main thread start : " + time);

			PlayerManager.getInstance().update();

			try {
				Thread.sleep(1000 / 40);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}

			/* CXbhȊOUIXV */
			this.post(new Runnable() {
				public void run() {
					invalidate();
					Log.v("run", "ui update : " + time);
				}			
			});
			Log.v("run", "main thread end : " + time);
			time++;
		}
	}
}