package game.player1.one;

import static game.constant.GameConstant.FPS;

import com.haru.component.GameField;
import com.haru.component.NextNextField;
import com.haru.component.gui.MainPanel;

public abstract class GameThread extends Thread {

	private MainPanel mainPanel;

	protected MainPanel getMainPanel() {
		return mainPanel;
	}


	private boolean isEnd = false;

	public void setEnd(boolean flag) {
		isEnd = flag;
	}




	public GameThread(MainPanel mainPanel) {
		this.mainPanel = mainPanel;
	}


	final public void run() {

		gameinit();

		for (int loop = 0; !isEnd; loop ++) {

			gameloop(loop);

			try {
				Thread.sleep(1000 / FPS);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}

		gameend();
	}

	// ftHg̎
	protected void gameinit() {

		// tB[h̏
		GameField gameField = new GameField();
		NextNextField nextField = new NextNextField();
		mainPanel.init(gameField, nextField);

	}

	abstract protected boolean gameloop(int loop);

	abstract protected void gameend();

}