package game.player1;


import static game.constant.GameConstant.CONTINUOUS_ROTATE;
import static game.constant.GameConstant.DOWN_CNT;
import static game.constant.GameConstant.FPS;
import static game.constant.GameConstant.NEXT_MAX;
import static java.awt.event.KeyEvent.VK_DOWN;
import static java.awt.event.KeyEvent.VK_LEFT;
import static java.awt.event.KeyEvent.VK_RIGHT;
import static java.awt.event.KeyEvent.VK_UP;
import static java.awt.event.KeyEvent.VK_X;
import static java.awt.event.KeyEvent.VK_Z;

import com.haru.component.GameField;
import com.haru.component.Mino;
import com.haru.component.NextNextField;
import com.haru.component.TetraMino;
import com.haru.component.gui.MainPanel;
import com.haru.input.KeyBind;
import com.haru.input.KeyBuffer;
import com.haru.player.Player;
import com.haru.util.ArrayRandom;

public class GameThreadOne extends Thread {

	private MainPanel mainPanel;
//	private BoardPanel boardPanel;
//	private FieldPanel nextPanel;

	private KeyBuffer buffer;

	public GameThreadOne(MainPanel mainPanel) {
		this.mainPanel = mainPanel;
//		this.boardPanel = boardPanel;
//		this.nextPanel = nextPanel;

		KeyBind keyBind = new KeyBind(VK_UP, VK_DOWN, VK_LEFT, VK_RIGHT, VK_Z, VK_X);
		buffer = new KeyBuffer(keyBind, CONTINUOUS_ROTATE);

		mainPanel.getBoardPanel().addKeyListener(buffer);
		mainPanel.getBoardPanel().requestFocus();

	}

	public GameThreadOne(MainPanel mainPanel, KeyBuffer buffer) {
		this.mainPanel = mainPanel;
		this.buffer = buffer;
	}




	private boolean isEnd = false;
	public void setEnd(boolean flag) {
		isEnd = flag;
	}




	//--------------------------------------------------------------------------//
	// lNXgp
	//--------------------------------------------------------------------------//
	private ArrayRandom r =new ArrayRandom( new int[] {
				Mino.T_I,
				Mino.T_O,
				Mino.T_S,
				Mino.T_Z,
				Mino.T_L,
				Mino.T_J,
				Mino.T_T
			}
		);
	private int next[] = new int[NEXT_MAX];
	private void next(NextNextField nextField) {

		// Omap̏
		for (int i = 0; i < next.length; i++)
			nextField.putBlock(i, Mino.T_EMPTY, TetraMino.getBlock(next[i]));


		// lNXgVɎ擾
		for (int i = 0; i < next.length - 1; i++)
			next[i] = next[i+1];
		next[next.length - 1] = r.getNext();

		// \
//		for (int x : next)
//			System.out.print(x + " ");
//		System.out.println();


		for (int i = 0; i < next.length; i++)
			nextField.putBlock(i, next[i], TetraMino.getBlock(next[i]));
	}


	//---------------------------------------------------------------------------//

	// Q[Jn
	public void run() {

		// tB[h̏
		GameField gameField = new GameField();
		NextNextField nextField = new NextNextField();
		mainPanel.init(gameField, nextField);

		// vC[̒`
		Player player = new Player(gameField);


		// lNXg̏
		for (int i = 0; i < next.length; i++) {
			next[i] = r.getNext();
		}
		// ubN̏o
		player.setCur( TetraMino.getBlock(next[0]) );
		next(nextField);


		// Q[[v
		int loop = 0;
		while (!isEnd) {

			// vC[̓͂ǂݎ
			int ret[] = buffer.read();

			// ubN̈ʒuXV
			boolean isUpdate = player.update(ret, (loop % DOWN_CNT == 0));

			// ʒum肵ꍇ
			if (!isUpdate) {

				// ̃ubN
				player.setCur( TetraMino.getBlock( next[0] ) );
				next(nextField);
				loop = 0;
			}


			// DRAW
			mainPanel.repaint();

			// WAIT
			try {
				Thread.sleep(1000 / FPS);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}

			loop ++;


			// fobOp
			if (buffer.f_enter) {
				buffer.f_enter = false;	// ȂƂ낢
				next(nextField);
				mainPanel.repaint();
			}
		}
	}


	//--------------------------------------------------------------------------//
	// infȍԊmF
	public void disp(int[][] info) {
		int[][] masu = new int[5][5];
		// S
		masu[2][2] = 1;
		for (int i = 0; i < 3; i++) {
			int x = info[i][0] + 2;
			int y = info[i][1] + 2;
			masu[y][x] = 1;
		}
		for (int i = 0; i < 5; i++) {
			for (int j = 0; j < 5; j++) {
				System.out.printf("%2d", masu[i][j]);
			}
			System.out.println();
		}
		System.out.println();
	}




}
