package game.net.player2;


import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;



// NCAgl܂Ƃ߂\
class Session implements Runnable {
	private GameServer server;
	private ServerSocket svsock;
	private Socket sock;

	public Session(GameServer server, ServerSocket svsock) {
		this.server = server;
		this.svsock = svsock;
	}

	// listen
	public void run() {
		System.out.println("ڑҋ@(" + svsock.getLocalPort()+")");
		sock = server.listen(svsock);
	}


	public void close() throws IOException {
		if (sock != null) {
			sock.close();
		}
	}



	public GameServer getServer() {
		return server;
	}


	// N[Yo͓
	// http://axe1lyze.blogspot.com/2011/08/java.html
	public boolean isAvailable() {
		return sock != null;
	}


}



public class GameServerManager2 implements Runnable {
//	private ServerSocket svsocket1;//	private ServerSocket svsocket2;

	private Session s1;
	private Session s2;

	public GameServerManager2(GameServer server1, int port,
							  GameServer server2, int port2) {
		ServerSocket svsock = server1.create(port);
		ServerSocket svsock2 = server2.create(port2);
		s1 = new Session(server1, svsock);
		s2 = new Session(server2, svsock2);
	}

	//--------------------------------------------------------------------------//
	// ڑҋ@ (l)
	//--------------------------------------------------------------------------//
	public boolean listen() {


		Thread t1 = new Thread(s1);
		Thread t2 = new Thread(s2);
		t1.start();
		t2.start();


		try {
			t1.join();
			t2.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
			System.out.println("ǂH");
			return false;
		}


		System.out.println("ڑ");
		s1.getServer().setOther( s2.getServer() );
		s2.getServer().setOther( s1.getServer() );

		return true;
	}


	//--------------------------------------------------------------------------//
	// Jn}
	//--------------------------------------------------------------------------//

	// falaseȂXg[ُ
	public boolean isReady() {
		return s1.getServer().ready()
			&& s2.getServer().ready();
	}


	//--------------------------------------------------------------------------//
	//--------------------------------------------------------------------------//
	//--------------------------------------------------------------------------//
	// Q[Jn
	//--------------------------------------------------------------------------//
	//--------------------------------------------------------------------------//
	//--------------------------------------------------------------------------//


	private boolean isEnd = false;
	public void setEnd(boolean flag) {
		isEnd = flag;
	}

	//--------------------------------------------------------------------------//
	// Q[[v
	//--------------------------------------------------------------------------//
	final public void run() {

		gameinit();

		boolean flag = true;

		while (!isEnd && flag) {

			flag =  gameloop();

			try {
				Thread.sleep(1000 / game.constant.GameConstant.FPS);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}

		gameend();
	}

	//--------------------------------------------------------------------------//

	protected void gameinit() {
		s1.getServer().gameinit();
		s2.getServer().gameinit();
	}

	private static int loop1 = 0;
	private static int loop2 = 0;
	protected boolean gameloop() {


		boolean flag1 = s1.getServer().gameloop(loop1 ++);
		boolean flag2 = s2.getServer().gameloop(loop2 ++);


//		try {
//			if (!flag1) {
//				s1.close();
//
//			}
//
//			if (!flag2) {
//				s2.close();
//			}
//
//		} catch (IOException e) {
//			e.printStackTrace();
//			System.out.println("N[Ys(Socket̃N[Y)");
//		}

		return flag1 && flag2;
	}


	//--------------------------------------------------------------------------//
	// I}
	//--------------------------------------------------------------------------//
	private void gameend() {
		s1.getServer().gameend();
		s2.getServer().gameend();
	}


}