package com.haru.player;


import game.constant.GameConstant;

import java.awt.Point;


import com.haru.component.GameField;
import com.haru.component.Mino;
import com.haru.component.TetraMino;

import static com.haru.input.InputBuffer.*;

/**
 * Player]B
 * Xg[Ƃ͐؂藣B
 *
 */
public class Player {



	// tB[h̏
	private GameField field;

	// ݂̑쒆̃~m̏
	private BlockState cur;

	private int landingCount;

	public Player(GameField field) {
		this.field = field;
		cur = new BlockState();
		landingCount = 0;
	}


	/**
	 * ubN̏ꏊ̍XV
	 * @param input ͂ꂽ
	 * @param isDown true̎s
	 * @return 	// falseȂ玟̃ubNo
	 */
	public boolean update(int[] input, boolean isDown) {

		int dx = input[0];
		int dy = input[1];
		int d_t = input[2];
		int isDrop = input[3];


		//---------------------------------------------------------------------------//
		// ړE]
		//---------------------------------------------------------------------------//
//		move(ret);
		move(dx, dy, d_t);


		//---------------------------------------------------------------------------//
		// n[hhbv
		//---------------------------------------------------------------------------//
		if (isDrop == TRUE) {
			drop();
			return false;
		}

		//---------------------------------------------------------------------------//
		// VюԂ҂Đݒu
		//---------------------------------------------------------------------------//
		if (landingCount > 0) {

			// ꂽm
			if (input[1] == 1) {
				putGround();
				return false;
			}


	// Ƃ肠-------------------------------

			// ړ]ȂAVюԂ̃Zbg
			if (input[0] != 0 || input[2] != 0) {
				landingCount = GameConstant.LAND_MAX;

				// returnȂH
			}
	//-------------------------------------------

			if (--landingCount == 0) {

				putGround();
				return false;
			}

			// nʂ痣ꂽ
			if (isPutBlockDown(cur) ) {
				landingCount = 0;
			}

			return true;
		}


		//---------------------------------------------------------------------------//
		// 
		//---------------------------------------------------------------------------//
		if (isDown) {
			// nʂɂ
			if (!down() ) {
				landingCount = GameConstant.LAND_MAX;
//				System.out.println("l:" + landingCount + "\tloop:" + loop);
			}
		}

		return true;

	}




	//--------------------------------------------------------------------------//
	// o, ړEd, ݒu
	//--------------------------------------------------------------------------//
	// o
	public void setCur(TetraMino b) {
		cur.setDefault(b);
		field.putBlock(cur.getType(), cur);
	}

	// ړ (͂𔽉f)
	public boolean move(int dx, int dy, int d_t) {

		// 
		if (dx == 0 && dy == 0 && d_t == 0)
			return false;

		// ݂̃ubN폜
		field.putBlock(TetraMino.T_EMPTY, cur);

		// ubN̎̈ʒu
		Point pos = new Point(cur.getX() + dx, cur.getY() + dy);

		// ubNuȂꍇ
		if ( !isPutBlockSRS(cur.getBlock(), pos, cur.getTurn(), d_t)) {  // pos̒l͓ŕύX

			// ݂̃ubNĔzu
			field.putBlock(cur.getType(), cur);

			return false;
		}


		// ݂̃ubN̏̍XV
		cur.setPos(pos);
		cur.setTurn( (4 + cur.getTurn() + d_t) % 4 );


		// ݂̃ubN̔zu
		field.putBlock(cur.getType(), cur);

		return true;
	}

	// ړ (d)
	public boolean down() {

		if (isPutBlockDown(cur)) {

			// ɈړĔzu
			field.putBlock(Mino.T_EMPTY, cur);
			cur.setY( cur.getY() + 1 );
			field.putBlock(cur.getType(), cur);
			return true;
		}

		return false;
	}



	//nʂɐݒu
	private void putGround() {

		// ݂̃ubNʒuŒ
		field.putBlock(cur.getType(), cur);

		// ubN񑵂mF
		// rm_flag߂
		boolean flag = false;
		int[] rm_flag = new int[field.getHeight()]; // ysڂ邩
		int[][] p = cur.getInfo(cur.getTurn());

		if (isFullLine(cur.getY())) {
			flag = true;
			rm_flag[cur.getY()] = 1;
		}
		for (int i = 0; i < 3; i++) {
			if (isFullLine(cur.getY() + p[i][1]) ) {
				flag = true;
				rm_flag[cur.getY() + p[i][1]] = 1;
			}
		}

		// sΏ
		if (flag) {
			removeLine(rm_flag);
		}


		landingCount = 0; // KvȂ񂾂
	}

	// nʂ܂ňړĐݒu
	private void drop() {
		// ̂߂ɁAɌ݂̃ubN폜
		field.putBlock(Mino.T_EMPTY, cur);


		for (int i = 1 ; cur.getY() + i < field.getHeight(); i++ ) {
			if (!isPutBlock(cur.getInfo(cur.getTurn()), cur.getX(), cur.getY() + i)) {


				// (i-1)ɒu
				cur.setY( cur.getY() + i - 1  );
				putGround();		// Ȃ蔻ɎĂ
				break;
			}
		}

	}



	//--------------------------------------------------------------------------//
	// ֐Q(down)
	//--------------------------------------------------------------------------//

	// Ɉړł邩
	// ubN̏ω
	private boolean isPutBlockDown(BlockState cur) {
		// ̂߂ɁAɌ݂̃ubN폜
		field.putBlock(Mino.T_EMPTY, cur);

		if ( isPutBlock(cur.getInfo(cur.getTurn()), cur.getX(), cur.getY() + 1)) {
			// ݂̃ubNɖ߂
			field.putBlock(cur.getType(), cur);
			return true;
		}

		// ݂̃ubNɖ߂
		field.putBlock(cur.getType(), cur);
		return false;
	}




	// m肵Ă
	private boolean isFullLine(int y) {

		for (int x = 0; x < field.getWidth(); x++) {

			if (field.getType(x, y) == TetraMino.T_EMPTY) {
				return false;
			}
		}
		return true;
	}



	public void removeLine(int[] down) {
		// sAdown̒lɂ炷
		for (int i = 1; i < down.length; i++) {
			if (down[i] == 1) {
	//				field.putLine(i, Block.T_EMPTY);
				down[i - 1] = down[i];
				down[i] = 0;
			}
		}

		// ysڂ鐔߂
		for (int i = 1; i < down.length; i++) {
			if (down[i] > 0) {
				for (int j = i - 1; j >= 0; j --) {
					down[j] += 1;
				}
			}
		}

		// downɊÂĉ珇ɂ炷
		for (int i = down.length - 1; i >= 1; i--) {
			if (down[i] > 0) {

				// down[i]ɒu
				field.putLine(i + down[i], field.getLine(i));
			}
		}
	}







	//--------------------------------------------------------------------------//
	// ֐Q (move)
	//--------------------------------------------------------------------------//
	//----------------------------------------------------------------------------//

	// ubNu邩ǂ
	// uȂꏊ̈ʒudv肷
	private boolean isPutBlock(int[][] info , int x, int y) {
//		if (field.getType(x, y) != Block.T_EMPTY)
//			return false;
//		for (int i = 0; i < 3; i++) {
//
//			if ((x + info[i][0] < 0 || x + info[i][0] > GameField.WIDTH)
//			  || (y + info[i][1] < 0 || y + info[i][1] > GameField.HEIGHT))
//				return false;
//
//
//			if (field.getType(x + info[i][0], y + info[i][1]) != Block.T_EMPTY)
//				return false;
//		}
//		return true;

		// debugp

		if (field.getType(x, y) != TetraMino.T_EMPTY && field.getType(x, y) != TetraMino.T_CURRENT)
			return false;
		for (int i = 0; i < 3; i++) {
			if ((x + info[i][0] < 0 || x + info[i][0] > GameField.WIDTH)
			  || (y + info[i][1] < 0 || y + info[i][1] > GameField.HEIGHT))
				return false;

			if (field.getType(x + info[i][0], y + info[i][1]) != TetraMino.T_EMPTY &&
				field.getType(x + info[i][0], y + info[i][1]) != TetraMino.T_CURRENT)
				return false;
		}
		return true;
	}




	// p[^ curBlock, curPos, curTurn(lωȂAƂĎ)
	// pos : curPos + d  ړ\ʒuij
	private boolean isPutBlockSRS(TetraMino block, Point pos, int turn, int dir) {

		int[][] info = block.getInfo((4 + turn + dir)%4);

			// IubN̈ʒu␳(info̒덇킹)
			if (block.getType() == TetraMino.T_I) {

				Point c = correctI(turn, dir);

				pos.x += c.x;
				pos.y += c.y;
			}



		for (int i = 1; i <= 5; i++) {
			Point p = moveDirection(i, block.getType(), turn, dir);

			// ͈͊OȂfalseԂ
			if (pos.x  + p.x < 0 || pos.x + p.x >= field.getWidth()
			  || pos.y + p.y < 0 || pos.y + p.y >= field.getHeight()) {
				  return false;
			}


			if (isPutBlock(info, pos.x + p.x, pos.y + p.y)) {

				if (i != 1) {
					System.out.println("turn:" + turn + " dir:" + dir);
					System.out.println(""+i+": " + p.x + ","+ p.y);
					disp(info);
				}

				// ]␳
				pos.x += p.x;
				pos.y += p.y;

				return true;
			}
		}

		return false;
	}



	// IubN͉]̂тɈʒu̕␳Kv
	// ݂̃ubNɓK
	public Point correctI(int turn, int dir) {

		Point p = new Point(0, 0);
		if (dir == R_RIGHT) {
			switch (turn) {
			case 0: // 
				p.x = 1;
				break;
			case 1: // 
				p.y = 1;
				break;
			case 2: // 
				p.x = -1;
				break;
			case 3: // 
				p.y = -1;
				break;
			}
		} else if (dir == R_LEFT) {
			switch (turn) {
			case 0: // 
				p.y = 1;
				break;
			case 1: // 
				p.x = -1;
				break;
			case 2: // 
				p.y = -1;
				break;
			case 3: // 
				p.x = 1;
				break;
			}
		}

		return p;
	}





	private Point moveDirection(int i, int type, int turn, int dir) {

		Point p = new Point(0, 0);

		if (type == TetraMino.T_I) {
			p = moveDirI(i, turn, dir);
		} else {
			p = moveDirOther(i, type, turn, dir);
		}

		return p;
	}

	public Point moveDirOther(int i, int type, int turn, int dir) {

		Point p = new Point(0, 0);
//					 2	 		3	 4	 	5
//		
//		E]	 {]	 1	 11	 2	 12
//		]	 {]	 E1	 E11	 2	 E12
//		E90x]
//		E]	 {]	 E1	 E11	 2	 E12
//		]	 {]	 E1	 E11	 2	 E12
//		180x]
//		E]	 {]	 E1	 E11	 2	 E12
//		]	 {]	 1	 11	 2	 12
//		90x]
//		E]	 {]	 1	 11	 2	 12
//		]	 {]	 1	 11	 2	 12
		switch(i) {
		// 
		case 1:
			break;


		// Q
		case 2:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.x = -1;
				} else if (dir == R_LEFT) {
					p.x = 1;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = 1;
				} else if (dir == R_LEFT) {
					p.x = 1;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.x = 1;
				} else if (dir == R_LEFT) {
					p.x = -1;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = -1;
				} else if (dir == R_LEFT) {
					p.x = -1;
				}
				break;
			}
			break;
		// R
		case 3:
			switch (turn) {
			case 0:
				if (type == TetraMino.T_T)
					return p;	// pX

				if (dir == R_RIGHT) {
					p.x = -1;
					p.y = -1;
				} else if (dir == R_LEFT) {
					p.x = 1;
					p.y = -1;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = 1;
					p.y = 1;
				} else if (dir == R_LEFT) {
					p.x = 1;
					p.y = 1;
				}
				break;
			case 2:
				if (type == TetraMino.T_T)
					return p;	// pX

				if (dir == R_RIGHT) {
					p.x = 1;
					p.y = -1;
				} else if (dir == R_LEFT) {
					p.x = -1;
					p.y = -1;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = -1;
					p.y = 1;
				} else if (dir == R_LEFT) {
					p.x = -1;
					p.y = 1;
				}
				break;
			}
			break;
		// S
		case 4:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.y = 2;
				} else if (dir == R_LEFT) {
					p.y = 2;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.y = -2;
				} else if (dir == R_LEFT) {
					p.y = -2;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.y = 2;
				} else if (dir == R_LEFT) {
					p.y = 2;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.y = -2;
				} else if (dir == R_LEFT) {
					p.y = -2;
				}
				break;
			}
			break;
		// T
		case 5:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.x = -1;
					p.y = 2;
				} else if (dir == R_LEFT) {
					p.x = 1;
					p.y = 2;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = 1;
					p.y = -2;
				} else if (dir == R_LEFT) {
					p.x = 1;
					p.y = -2;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.x = 1;
					p.y = 2;
				} else if (dir == R_LEFT) {
					p.x = -1;
					p.y = 2;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = -1;
					p.y = -2;
				} else if (dir == R_LEFT) {
					p.x = -1;
					p.y = -2;
				}
				break;
			}
			break;
		default:
			break;
		}

		return p;
	}

	private Point moveDirI(int i, int turn, int dir) {
//		
//		E]	 {]	 2	 E1	 21	 E12
//		]	 {]	 1	 E2	 12	 E21
//		E90x]
//		E]	 {]	 1	 E2	 12	 E21
//		]	 {]	 E2	 1	 E21	 12
//		180x]
//		E]	 {]	 E1	 2	 E12	 21
//		]	 {]	 E2	 1	 E21	 12
//		90x]
//		E]	 {]	 E1	 2	 E12	 21
//		]	 {]	 2	 E1	 21	 E12

		Point p = new Point(0, 0);

		switch(i) {
		// 
		case 1:
			break;

		// Q
		case 2:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.x = -2;
				} else if (dir == R_LEFT) {
					p.x = -1;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = -1;
				} else if (dir == R_LEFT) {
					p.x = 2;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.x = 1;
				} else if (dir == R_LEFT) {
					p.x = 2;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = 1;
				} else if (dir == R_LEFT) {
					p.x = -2;
				}
				break;
			}
			break;
		// R
		case 3:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.x = 1;
				} else if (dir == R_LEFT) {
					p.x = 2;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = 2;
				} else if (dir == R_LEFT) {
					p.x = -1;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.x = -2;
				} else if (dir == R_LEFT) {
					p.x = -1;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = -2;
				} else if (dir == R_LEFT) {
					p.x = 1;
				}
				break;
			}
			break;
		// S
		case 4:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.x = -2;
					p.y = 1;
				} else if (dir == R_LEFT) {
					p.x = -1;
					p.y = -2;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = -1;
					p.y = -2;
				} else if (dir == R_LEFT) {
					p.x = -2;
					p.y = -1;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.x = 1;
					p.y = 2;
				} else if (dir == R_LEFT) {
					p.x = 2;
					p.y = -1;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = 1;
					p.y = 2;
				} else if (dir == R_LEFT) {
					p.x = -2;
					p.y = 1;
				}
				break;
			}
			break;
		// T
		case 5:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.x = 1;
					p.y = -2;
				} else if (dir == R_LEFT) {
					p.x = 2;
					p.y = 1;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = 2;
					p.y = 1;
				} else if (dir == R_LEFT) {
					p.x = -1;
					p.y = 2;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.x = -2;
					p.y = -1;
				} else if (dir == R_LEFT) {
					p.x = -1;
					p.y = 2;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = -2;
					p.y = -1;
				} else if (dir == R_LEFT) {
					p.x = 1;
					p.y = -2;
				}
				break;
			}
			break;
		default:
			break;
		}

		return p;



	}

	private Point moveDirI_TGM(int i, int turn, int dir) {
//		eg~m̏	 ]	 	 	 O	 l	 ܌
//		
//		E]	 {]	 2	 E1	 21	 E12
//		]	 {]	 1	 E2	 12	 E21
//		E90x]
//		E]	 {]	 1	 E2	 12	 E21
//		]	 {]	 E2	 1	 E21	 12
//		180x]
//		E]	 {]	 E1	 2	 E12	 21
//		]	 {]	 E2	 1	 E21	 12
//		90x]
//		E]	 {]	 E1	 2	 E12	 21
//		]	 {]	 2	 E1	 21	 E12

		Point p = new Point(0, 0);

		switch(i) {
		// 
		case 1:
			break;

		// Q
		case 2:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.x = -2;
				} else if (dir == R_LEFT) {
					p.x = 1;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = -1;
				} else if (dir == R_LEFT) {
					p.x = 2;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.x = -2;
				} else if (dir == R_LEFT) {
					p.x = 2;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = -2;
				} else if (dir == R_LEFT) {
					p.x = 1;
				}
				break;
			}
			break;
		// R
		case 3:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.x = 1;
				} else if (dir == R_LEFT) {
					p.x = -1;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = 2;
				} else if (dir == R_LEFT) {
					p.x = -1;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.x = 1;
				} else if (dir == R_LEFT) {
					p.x = -1;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = 1;
				} else if (dir == R_LEFT) {
					p.x = -2;
				}
				break;
			}
			break;
		// S
		case 4:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.x = 1;
					p.y = -1;
				} else if (dir == R_LEFT) {
					p.x = -1;
					p.y = -2;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = -1;
					p.y = -2;
				} else if (dir == R_LEFT) {
					p.x = -2;
					p.y = -1;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.x = -2;
					p.y = -1;
				} else if (dir == R_LEFT) {
					p.x = 2;
					p.y = -1;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = -2;
					p.y = -1;
				} else if (dir == R_LEFT) {
					p.x = 1;
					p.y = -2;
				}
				break;
			}
			break;
		// T
		case 5:
			switch (turn) {
			case 0:
				if (dir == R_RIGHT) {
					p.x = -1;
					p.y = 1;
				} else if (dir == R_LEFT) {
					p.x = 2;
					p.y = 1;
				}
				break;
			case 1:
				if (dir == R_RIGHT) {
					p.x = 2;
					p.y = 1;
				} else if (dir == R_LEFT) {
					p.x = -1;
					p.y = 2;
				}
				break;
			case 2:
				if (dir == R_RIGHT) {
					p.x = 1;
					p.y = 1;
				} else if (dir == R_LEFT) {
					p.x = -1;
					p.y = 2;
				}
				break;
			case 3:
				if (dir == R_RIGHT) {
					p.x = 1;
					p.y = 2;
				} else if (dir == R_LEFT) {
					p.x = -2;
					p.y = 1;
				}
				break;
			}
			break;
		default:
			break;
		}

		return p;



	}



	//--------------------------------------------------------------------------//

	// infȍԊmF
	public void disp(int[][] info) {
		int[][] masu = new int[5][5];
		// S
		masu[2][2] = 1;
		for (int i = 0; i < 3; i++) {
			int x = info[i][0] + 2;
			int y = info[i][1] + 2;
			masu[y][x] = 1;
		}
		for (int i = 0; i < 5; i++) {
			for (int j = 0; j < 5; j++) {
				System.out.printf("%2d", masu[i][j]);
			}
			System.out.println();
		}
		System.out.println();
	}
}
