package com.torn.player;

import java.awt.Color;
import java.awt.Point;
import java.util.LinkedList;
import java.util.Queue;

import com.torn.enemy.AtomMoveManager;
import com.torn.tools.MyGraphics2D;

public class PlayerManager {
	private static PlayerManager playerManager = new PlayerManager();
	private Queue<Atom> atoms = new LinkedList<>();
	private static final int LIMIT_SIZE = 10;

	private PlayerManager() {

	}
	public static PlayerManager getInstance() {
		return playerManager;
	}

	public synchronized boolean addAtom(double x, double y) {
		if (atoms.size() > LIMIT_SIZE) {
			/*  */
			atoms.poll();
			if (atoms.size() > LIMIT_SIZE) {
				System.err.println("ĂȂ");
			}
		}
		atoms.offer(new Atom(x, y));
		return true;
	}

	/********/
	/* ` */
	/********/
	public void paint() {
		if (null == atoms) {
			return;
		}
		MyGraphics2D g2 = MyGraphics2D.getInstance();
		
		/* ` */
		for (int i = 0; i < atoms.size(); i++) {
			Atom[] array = atoms.toArray(new Atom[0]);
			Point p = new Point((int)(array[i].x + 0.5), (int)(array[i].y + 0.5));
			g2.setColor(Color.GREEN);
			g2.fillOval(p.x, p.y, 6, 6);
		}
	}
	
	/******************/
	/* ʂ̈ړEXV */
	/******************/
	public void update() {
		if (atoms.isEmpty()) {
			return;
		}

		/* ړ */
		move();
		
		/* 蔻 */
		hitCheck();
		
		/* S~ */
		Atom atom = atoms.peek();
		if (atom.y <  -250) { // 
			atoms.poll();
		}
	}

	private static final int VEROCITY_Y = -2;
	public  void move() {
		if (atoms.isEmpty()) {
			return;
		}
		
		/* ړ */
		Atom[] array = atoms.toArray(new Atom[0]);
		for (int i = 0; i < atoms.size(); i++) {
			
			array[i].y = array[i].y + VEROCITY_Y;
		}
	}
	
	
	private boolean hitCheck() {
		Atom[] array = atoms.toArray(new Atom[0]);		
		boolean hitFlg = false;
		
		// G0ԖڂĂȂ(̏)
		Point enemyPt = AtomMoveManager.getInstance().getAtomPoint(0);
		if (null == enemyPt) {
			return false;
		}
		
		// ʂ͈_
		for (int i = 0; i < array.length; i++) {
			Atom playerPt = array[i];
			int enemySize = 12;
			
			if (enemyPt.x <= playerPt.x  && playerPt.x <= enemyPt.x + enemySize &&
				enemyPt.y <= playerPt.y  && playerPt.y <= enemyPt.y + enemySize) {
				AtomMoveManager.getInstance().removeAtom(0);
				hitFlg = true;
			}
		}
		
		return hitFlg;
	}
}
