package com.torn.enemy;

import java.awt.image.BufferedImage;
import java.util.ArrayList;

import com.torn.tools.MyImageManager;


public class MyEnemy {
	private static final int ATOM_WIDTH = 12;
	private static final int ATOM_HEIGHT = 12;


	private BufferedImage[][] imgArray;
	private int columns;
	private int rows;
	private ArrayList<MovableAtom> atoms;

	public MyEnemy() {
		init();
	}

	private int canvas_size = 600; // ǂĂ邩H

	private void init() {
		imgArray = MyImageManager.loadAllSubImage();
		columns = imgArray.length;
		rows = imgArray[0].length;
		atoms = new ArrayList<>();
		
		for (int x = 0; x < columns; x++) {
			for (int y = 0; y < rows; y++) {
				if (MyImageManager.isBlackImage(imgArray[x][y])) {
					atoms.add(new MovableAtom(new Atom(
							x * ATOM_WIDTH  - canvas_size / 2 + 100,
							y * ATOM_HEIGHT - canvas_size / 2
					)));
				}
			}
		}
	}

	public ArrayList<MovableAtom> getAtoms() {
		return atoms;
	}
}
