
var oauth = require('oauth');
var commander = require('commander');
var Twitter = require('ntwitter');
var fs = require('fs');
var configFile = '.account';

// OAuth parameters
var consumerKey = 'd3MqFro8tVXtlEzz5hVrZA';
var consumerSecret = 'RSWIniHQldyhhmLBj2PpP6V4gOnxf3vEEFUEZXT1Q';
var requestUrl = 'https://api.twitter.com/oauth/request_token';
var accessUrl = 'https://api.twitter.com/oauth/access_token';
var authUrl = 'https://api.twitter.com/oauth/authenticate';

/*
 * OAuth認証を行う
 * @param {Function(err, token, secret)} callback
 *  結果を受け取るコールバック関数。
 *  err引数にはエラーオブジェクトが、token引数にはアクセストークンが、
 *  secret引数にはsecret文字列が格納される
 */
function authenticate(callback) {
  var self = this;
  // Create authenticate client
  var client = new oauth.OAuth(
    requestUrl,
    accessUrl,
    consumerKey,
    consumerSecret,
    '1.0',
    'oob',
    "HMAC-SHA1"
  );

  client.getOAuthRequestToken(getAccessToken);

  // リクエストトークンからアクセストークンを取得する
  function getAccessToken(err, token, secret, results) {
    if (err) {
      console.log('oauth request failed.');
      process.exit(1);
    }
    var url = authUrl + '?oauth_token=' + token;
    console.log('Open URL printed below, and input displayed PIN code.');
    console.log(url);
    commander.prompt('Input PIN: ', function (pin) {
      client.getOAuthAccessToken(token, secret, pin, receiveToken);
    });
  }

  // アクセストークンを受け取る
  function receiveToken(err, token, secret, results) {
    if (err) {
      callback(err);
      return;
    }
    callback(err, token, secret);
  }
}

/*
 * 認証を行ってntwitter.Twitterクラスのインスタンスを返す
 * @param {Function(err, twitter)} callback コールバック関数
 *  err引数にはエラーオブジェクトが、
 *  twitter引数には作成されたインスタンスが格納される
 */
exports.getClient = function (callback) {
  var keys = {
    consumer_key: consumerKey,
    consumer_secret: consumerSecret
  };
  // ファイルに保存しておいたアクセストークンを読み出す
  fs.readFile(configFile, 'utf8', function (err, data) {
    // 読み出しに失敗したら認証を実行する
    if (err) {
      authenticate(function (err, token, secret) {
        if (err) {
          callback(err);
          return;
        }

        // クライアントを作成する
        keys.access_token_key = token;
        keys.access_token_secret = secret;
        var twitter = new Twitter(keys);

        // アクセストークンをファイルに保存しておく
        var tokens = {
          access_token_key: keys.access_token_key,
          access_token_secret: keys.access_token_secret
        };
        var jsonString = JSON.stringify(tokens, null, 2);
        fs.writeFile(configFile, jsonString, 'utf8', function (err) {
          // 処理完了
          callback(err, twitter);
        });
      });
      return;
    }
    // 読み出しに成功したらその値からクライアントを作成する
    var token = JSON.parse(data);
    keys.access_token_key = token.access_token_key;
    keys.access_token_secret = token.access_token_secret;
    var twitter = new Twitter(keys);

    // 処理完了
    callback(null, twitter);
  });
};

