#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys
import os.path
import tensorflow as tf
import time

INPUT_WIDTH = 100
INPUT_HEIGHT = 100
INPUT_CHANNELS = 3

INPUT_SIZE = INPUT_WIDTH * INPUT_HEIGHT * INPUT_CHANNELS
W1_SIZE = 100
W2_SIZE = 100
OUTPUT_SIZE = 3
LABEL_SIZE = OUTPUT_SIZE

TEACH_FILES = ["../data2/teach_cat.tfrecord",
               "../data2/teach_dog.tfrecord",
               "../data2/teach_monkey.tfrecord"]
TEST_FILES = ["../data2/test_cat.tfrecord",
              "../data2/test_dog.tfrecord",
              "../data2/test_monkey.tfrecord"]

MODEL_NAME = "./deep_model"

# 結果をそろえるために乱数の種を指定
tf.set_random_seed(1111)

## 入力と計算グラフを定義
with tf.variable_scope('model') as scope:
    x1 = tf.placeholder(dtype=tf.float32)
    y = tf.placeholder(dtype=tf.float32)

    # 第2層
    W1 = tf.get_variable("W1",
                         shape=[INPUT_SIZE, W1_SIZE],
                         dtype=tf.float32,
                         initializer=tf.random_normal_initializer(stddev=0.01))
    b1 = tf.get_variable("b1",
                         shape=[W1_SIZE],
                         dtype=tf.float32,
                         initializer=tf.random_normal_initializer(stddev=0.01))
    x2 = tf.nn.relu(tf.matmul(x1, W1) + b1, name="x2")

    # 第3層
    W2 = tf.get_variable("W2",
                         shape=[W1_SIZE, W2_SIZE],
                         dtype=tf.float32,
                         initializer=tf.random_normal_initializer(stddev=0.01))
    b2 = tf.get_variable("b2",
                         shape=[W2_SIZE],
                         dtype=tf.float32,
                         initializer=tf.random_normal_initializer(stddev=0.01))
    x3 = tf.nn.relu(tf.matmul(x2, W2) + b2, name="x3")

    # 第4層
    W3 = tf.get_variable("W3",
                         shape=[W2_SIZE, OUTPUT_SIZE],
                         dtype=tf.float32,
                         initializer=tf.random_normal_initializer(stddev=0.01))
    b3 = tf.get_variable("b3",
                         shape=[OUTPUT_SIZE],
                         dtype=tf.float32,
                         initializer=tf.random_normal_initializer(stddev=0.01))
    x4 = tf.nn.softmax(tf.matmul(x3, W3) + b3, name="x4")

    # コスト関数
    cross_entropy = -tf.reduce_sum(y * tf.log(x4), name="cross_entropy")
    tf.summary.scalar('cross_entropy', cross_entropy)

    # 正答率
    # 出力テンソルの中でもっとも値が大きいもののインデックスが
    # 正答と等しいかどうかを計算する
    correct = tf.equal(tf.argmax(x4,1), tf.argmax(y, 1), name="correct")
    accuracy = tf.reduce_mean(tf.cast(correct, "float"), name="accuracy")
    tf.summary.scalar('accuracy', accuracy)

    # 最適化アルゴリズムを定義
    global_step = tf.Variable(0, name='global_step', trainable=False)
    optimizer = tf.train.GradientDescentOptimizer(1e-6, name="optimizer")
    minimize = optimizer.minimize(cross_entropy, global_step=global_step, name="minimize")

    # 学習結果を保存するためのオブジェクトを用意
    saver = tf.train.Saver()


# 読み込んだデータの変換用関数
def map_dataset(serialized):
    features = {
        'label':     tf.FixedLenFeature([], tf.int64),
        'height':    tf.FixedLenFeature([], tf.int64),
        'width':     tf.FixedLenFeature([], tf.int64),
        'raw_image': tf.FixedLenFeature([INPUT_SIZE], tf.float32),
    }
    parsed = tf.parse_single_example(serialized, features)

    # 読み込んだデータを変換する
    raw_label = tf.cast(parsed['label'], tf.int32)
    label = tf.reshape(tf.slice(tf.eye(LABEL_SIZE),
                                [raw_label, 0],
                                [1, LABEL_SIZE]),
                       [LABEL_SIZE])

    #image = tf.reshape(parsed['raw_image'], tf.stack([parsed['height'], parsed['width'], 3]))
    image = parsed['raw_image']
    return (image, label, raw_label)

## データセットの読み込み
# 読み出すデータは各データ200件ずつ×3で計600件
dataset = tf.data.TFRecordDataset(TEACH_FILES)\
                 .map(map_dataset)\
                 .batch(600)
 
# データにアクセスするためのイテレータを作成
iterator = dataset.make_one_shot_iterator()
item = iterator.get_next()

# セッションの作成
sess = tf.Session()

# 変数の初期化を実行する
sess.run(tf.global_variables_initializer())

 # 学習結果を保存したファイルが存在するかを確認し、
 # 存在していればそれを読み出す
latest_filename = tf.train.latest_checkpoint("./")
if latest_filename:
    print("load saved model {}".format(latest_filename))
    saver.restore(sess, latest_filename)

# サマリを取得するための処理
summary_op = tf.summary.merge_all()
summary_writer = tf.summary.FileWriter('data', graph=sess.graph)

# 学習用データを読み出す
(dataset_x, dataset_y, values_y) = sess.run(item)
steps = tf.train.global_step(sess, global_step)

## テスト用データセットを読み出す
# テストデータは50×3＝150件
dataset2 = tf.data.TFRecordDataset(TEST_FILES)\
                  .map(map_dataset)\
                  .batch(150)
iterator2 = dataset2.make_one_shot_iterator()
item2 = iterator2.get_next()
(testdataset_x, testdataset_y, testvalues_y) = sess.run(item2)

test_summary = tf.summary.scalar('test_result', accuracy)

if steps == 0:
    # 初期状態を記録
    xe, acc, summary = sess.run([cross_entropy, accuracy, summary_op], {x1: dataset_x, y: dataset_y})
    print("CROSS ENTROPY({}): {}".format(0, xe))
    print("     ACCURACY({}): {}".format(0, acc))
    summary_writer.add_summary(summary, global_step=0)

# 学習を開始
start_time = time.time()
for i in range(30):
    for j in range(100):
        sess.run(minimize, {x1: dataset_x, y: dataset_y})

    # 途中経過を取得・保存
    xe, acc, summary = sess.run([cross_entropy, accuracy, summary_op], {x1: dataset_x, y: dataset_y})
    acc2, summary2 = sess.run([accuracy, test_summary], {x1: testdataset_x, y: testdataset_y})
    print("CROSS ENTROPY({}): {}".format(steps + 100 * (i+1), xe))
    print("     ACCURACY({}): {}".format(steps + 100 * (i+1), acc))
    print("  TEST RESULT({}): {}".format(steps + 100 * (i+1), acc2))
    summary_writer.add_summary(summary, global_step=tf.train.global_step(sess, global_step))
    summary_writer.add_summary(summary2, global_step=tf.train.global_step(sess, global_step))

# 学習終了
print ("time: {} sec".format(time.time() - start_time))

save_path = saver.save(sess, MODEL_NAME, global_step=tf.train.global_step(sess, global_step))
print("Model saved to {}".format(save_path))

## 結果の出力
 
# 学習に使用したデータを入力した場合の
# 正答率を計算する
print("----result with teaching data----")
 
print("assumed label:")
print(sess.run(tf.argmax(x4, 1), feed_dict={x1: dataset_x}))
print("real label:")
print(sess.run(tf.argmax(y, 1), feed_dict={y: dataset_y}))
print("accuracy:", sess.run(accuracy, feed_dict={x1: dataset_x, y: dataset_y}))
 
 
# テスト用データを入力した場合の
# 正答率を計算する
print("----result with test data----")
 
 
# 正答率を出力
print("assumed label:")
print(sess.run(tf.argmax(x4, 1), feed_dict={x1: testdataset_x}))
print("real label:")
print(sess.run(tf.argmax(y, 1), feed_dict={y: testdataset_y}))
print("accuracy:", sess.run(accuracy, feed_dict={x1: testdataset_x, y: testdataset_y}))    

