#!/usr/bin/python

import sys
import os
import os.path
import json
import re

import web
import tweepy
from mako.template import Template
from mako.lookup import TemplateLookup
from mako.exceptions import RichTraceback
from tweetdb import TweetDB, Tweet
from followerdb import FollowerDB
from updaterequest import update_request

def cgidebugerror():
    """
    """
    _wrappedstdout = sys.stdout
    sys.stdout = web._oldstdout
    cgitb.handler()
    sys.stdout = _wrappedstdout
web.internalerror = cgidebugerror


class BaseController(object):
    template_path = "./template"
    def __init__(self):
        if os.environ.has_key('SERVER_SOFTWARE'):
            # run as cgi
            self.APP_ROOT = os.environ.get("SCRIPT_NAME", "")
            self.ROOT_DIR = ""
        else:
            # run as built-in server
            self.APP_ROOT = ""
            self.ROOT_DIR = ""
        
    def _get_template(self, template_name):
        tl = TemplateLookup(directories=[self.template_path],
                            input_encoding="utf-8",
                            output_encoding="utf-8",
                            default_filters=['decode.utf8'],
                            format_exceptions=True)
        return tl.get_template(template_name)

    def render(self, template, **kwargs):
        kwargs["APP_ROOT"] = self.APP_ROOT
        kwargs["ROOT_DIR"] = self.ROOT_DIR
        t = self._get_template(template)
        try:
            html = t.render(**kwargs)
        except:
            traceback = RichTraceback()
            for (filename, lineno, function, line) in traceback.traceback:
                print "File %s, line %s, in %s" % (filename, lineno, function)
                print line, "\n"
            print "%s: %s" % (str(traceback.error.__class__.__name__), traceback.error)
            sys.exit(-1)
        return html


class Thumbnails(BaseController):
    def GET(self):
        tdb = TweetDB.from_cache()
        tdb.sort_localcache()
        tweets = tdb.get_subtweets(0, 30)

        html = self.render("thumbnails.html", tweets=tweets)
        web.header('Content-Type', 'text/html')
        return html

class Index(BaseController):
    def GET(self):
        i = web.input(page=1,view="thumbnail")
        page = int(i.page)
        if page < 1:
            page = 1

        tdb = TweetDB.from_cache()
        tdb.sort_localcache()

        if i.view == "timeline":
            tweets = tdb.get_subtweets((page-1)*10, 10)
            html = self.render("index.html", tweets=tweets, page=page)
        else:
            tweets = tdb.get_subtweets((page-1)*30, 30)
            html = self.render("thumbnails.html", tweets=tweets, page=page)

        web.header('Content-Type', 'text/html')
        return html


class GetFollowingsList(BaseController):
    def GET(self):
        f_db = FollowerDB()
        f_db.load_from_db()
        data = dict(followings=[x for x in f_db])
        web.header('Content-Type', 'application/json')
        return json.dumps(data)

class Follow(BaseController):
    def POST(self):
        i = web.input()
        f_db = FollowerDB()
        f_db.load_from_db()
        screen_name = i["screen_name"]
        error = ""
        is_succeed = True
        if not re.match(r"^[A-Za-z0-9_]+$", screen_name):
            error = "invalid screen name"
            is_succeed = False
        elif f_db.is_following(screen_name):
            if f_db.is_enabled(screen_name):
                error = "already followed"
                is_succeed = False
            else:
                f_db.set_enabled(screen_name, True)
        else:
            try:
                u = tweepy.api.lookup_users(screen_names=(screen_name,))
                f_db.append_user(screen_name)
                # send update request
                update_request(screen_name)
            except tweepy.error.TweepError:
                error = "no user found"
                is_succeed = False

        data = dict(succeed=is_succeed,
                    errorMessage=error,
                    screenName=screen_name)
        web.header('Content-Type', 'application/json')
        return json.dumps(data)


urls = (
    'index.py/followings', 'GetFollowingsList',
    '/index.py/followings', 'GetFollowingsList',
    '/followings', 'GetFollowingsList',
    'index.py/follow', 'Follow',
    '/index.py/follow', 'Follow',
    '/follow', 'Follow',
    '.*', 'Index',
)
app = web.application(urls, globals())

if __name__ == "__main__":
    app.run()
