#!/usr/bin/python
# -*- coding: utf-8 -*-

from winazurestorage import CLOUD_TABLE_HOST
import wazs
from config import config
import tweepy
import datetime

class FollowerDB(list):
    def __init__(self):
        self._last_id_of = {}
        self._is_enabled = {}
        self._is_dirty = {}
        self._ts = None
        pass

    def append_user(self, screen_name, last_id=0, enabled=True, is_dirty=True):
        if len(self) >= 100:
            self._remove_oldest_user()
        self.append(screen_name)
        screen_name = screen_name.lower()
        self._last_id_of[screen_name] = last_id
        self._is_enabled[screen_name] = enabled
        self._is_dirty[screen_name] = is_dirty
        self.update_db()

    def _remove_oldest_user(self):
        ts = self._get_ts()
        entities = ts.get_all(config["follower_db"])
        tm = datetime.datetime.now()
        oldest = ""
        for e in entities:
            if e.Timestamp < tm:
                tm = e.Timestamp
                oldest = e.RowKey
        if oldest is not "":
            self.remove_user(oldest)

    def remove_user(self, screen_name):
        print "remove " + screen_name
        try:
            i = self.index(screen_name)
        except ValueError:
            return
        k = screen_name.lower()
        del self[i]
        del self._last_id_of[k]
        del self._is_enabled[k]
        del self._is_dirty[k]
        self._delete_user(screen_name)

    def set_enabled(self, screen_name, enabled):
        screen_name = screen_name.lower()
        self._is_enabled[screen_name] = enabled
        self._is_dirty[screen_name] = True
        self.update_db()

    def is_following(self, screen_name):
        return screen_name.lower() in self._is_enabled

    def is_enabled(self, screen_name):
        return self._is_enabled.get(screen_name.lower(), False)

    def update(self, screen_name, last_id):
        screen_name = screen_name.lower()
        if self._last_id_of.has_key(screen_name):
            self._last_id_of[screen_name] = last_id
            self._is_dirty[screen_name] = True
            self.update_db()

    def get_last_id(self, screen_name):
        screen_name = screen_name.lower()
        if self._last_id_of.has_key(screen_name):
            return self._last_id_of[screen_name]
        else:
            return 0
        
    def load_from_db(self):
        ts = self._get_ts()
        entities = ts.get_all(config["follower_db"])
        for e in entities:
            uid = e.RowKey
            _is_enabled = e.Enabled
            last_tid = e.LastTID
            self.append_user(uid, last_tid, _is_enabled, False)

    def update_db(self):
        ent = wazs.TableEntity("", "", {})
        for sname in self:
            if self._is_dirty[sname.lower()]:
                ent.partition_key = "follower"
                ent.row_key = sname
                ent.add_property("LastTID", long(self._last_id_of[sname.lower()]))
                ent.add_property("Enabled", self._is_enabled[sname.lower()])
                self._update_table(ent)
                self._is_dirty[sname.lower()] = False

    def update_db_all(self):
        e = wazs.TableEntity()
        for sname in self:
            e.partition_key = "follower"
            e.row_key = sname
            e.add_property("LastTID", long(self._last_id_of[sname.lower()]))
            e.add_property("Enabled", self._is_enabled[sname.lower()])
            self._update_table(e)
            self._is_dirty[sname.lower()] = False

    def _get_ts(self):
        if self._ts == None:
            self._ts = wazs.TableStorage(CLOUD_TABLE_HOST,
                                         config["storage_account"],
                                         config["storage_key"])
        return self._ts

    def _update_table(self, entity):
        ts = self._get_ts()
        err = ts.update_entity(config["follower_db"],
                               entity.partition_key,
                               entity.row_key,
                               entity)
        if err == 400:
            print "error in followerdb:", entity.__repr__()

    def _delete_user(self, screen_name):
        ts = self._get_ts()
        err = ts.delete_entity(config["follower_db"],
                               "follower",
                               screen_name)
        
